/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.ColumnPrunerProcFactory;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteCanApplyCtx;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteParseContextGenerator;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RewriteQueryUsingAggregateIndexCtx
implements NodeProcessorCtx {
    private static final Logger LOG = LoggerFactory.getLogger((String)RewriteQueryUsingAggregateIndexCtx.class.getName());
    private final Hive hiveDb;
    private final ParseContext parseContext;
    private RewriteCanApplyCtx canApplyCtx;
    private GenericUDAFEvaluator eval = null;
    private final String indexTableName;
    private final String alias;
    private final String aggregateFunction;
    private ExprNodeColumnDesc aggrExprNode = null;
    private String indexKey;

    private RewriteQueryUsingAggregateIndexCtx(ParseContext parseContext, Hive hiveDb, RewriteCanApplyCtx canApplyCtx) {
        this.parseContext = parseContext;
        this.hiveDb = hiveDb;
        this.canApplyCtx = canApplyCtx;
        this.indexTableName = canApplyCtx.getIndexTableName();
        this.alias = canApplyCtx.getAlias();
        this.aggregateFunction = canApplyCtx.getAggFunction();
        this.indexKey = canApplyCtx.getIndexKey();
    }

    public static RewriteQueryUsingAggregateIndexCtx getInstance(ParseContext parseContext, Hive hiveDb, RewriteCanApplyCtx canApplyCtx) {
        return new RewriteQueryUsingAggregateIndexCtx(parseContext, hiveDb, canApplyCtx);
    }

    public ParseContext getParseContext() {
        return this.parseContext;
    }

    public Hive getHiveDb() {
        return this.hiveDb;
    }

    public String getIndexName() {
        return this.indexTableName;
    }

    public GenericUDAFEvaluator getEval() {
        return this.eval;
    }

    public void setEval(GenericUDAFEvaluator eval) {
        this.eval = eval;
    }

    public void setAggrExprNode(ExprNodeColumnDesc aggrExprNode) {
        this.aggrExprNode = aggrExprNode;
    }

    public ExprNodeColumnDesc getAggrExprNode() {
        return this.aggrExprNode;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAggregateFunction() {
        return this.aggregateFunction;
    }

    public String getIndexKey() {
        return this.indexKey;
    }

    public void setIndexKey(String indexKey) {
        this.indexKey = indexKey;
    }

    public void invokeRewriteQueryProc() throws SemanticException {
        this.replaceTableScanProcess(this.canApplyCtx.getTableScanOperator());
        for (int index = 0; index < this.canApplyCtx.getGroupByOperators().size(); ++index) {
            this.replaceGroupByOperatorProcess(this.canApplyCtx.getGroupByOperators().get(index), index);
        }
        for (SelectOperator selectperator : this.canApplyCtx.getSelectOperators()) {
            this.replaceSelectOperatorProcess(selectperator);
        }
    }

    private void replaceTableScanProcess(TableScanOperator scanOperator) throws SemanticException {
        RewriteQueryUsingAggregateIndexCtx rewriteQueryCtx = this;
        String alias = rewriteQueryCtx.getAlias();
        HashMap<String, Operator<? extends OperatorDesc>> topOps = rewriteQueryCtx.getParseContext().getTopOps();
        topOps.remove(alias);
        String indexTableName = rewriteQueryCtx.getIndexName();
        Table indexTableHandle = null;
        try {
            indexTableHandle = rewriteQueryCtx.getHiveDb().getTable(indexTableName);
        }
        catch (HiveException e) {
            LOG.error("Error while getting the table handle for index table.");
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        TableScanDesc indexTableScanDesc = new TableScanDesc(indexTableHandle);
        indexTableScanDesc.setGatherStats(false);
        String k = MetaStoreUtils.encodeTableName(indexTableName) + "/";
        indexTableScanDesc.setStatsAggPrefix(k);
        scanOperator.setConf(indexTableScanDesc);
        ArrayList<ColumnInfo> sigRS = new ArrayList<ColumnInfo>();
        try {
            StructObjectInspector rowObjectInspector = (StructObjectInspector)indexTableHandle.getDeserializer().getObjectInspector();
            StructField field = rowObjectInspector.getStructFieldRef(rewriteQueryCtx.getIndexKey());
            sigRS.add(new ColumnInfo(field.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(field.getFieldObjectInspector()), indexTableName, false));
        }
        catch (SerDeException e) {
            LOG.error("Error while creating the RowResolver for new TableScanOperator.");
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        RowSchema rs = new RowSchema(sigRS);
        String newAlias = indexTableName;
        int index = alias.lastIndexOf(":");
        if (index >= 0) {
            newAlias = alias.substring(0, index) + ":" + indexTableName;
        }
        ((TableScanDesc)scanOperator.getConf()).setAlias(newAlias);
        scanOperator.setAlias(indexTableName);
        topOps.put(newAlias, scanOperator);
        rewriteQueryCtx.getParseContext().setTopOps(topOps);
        ColumnPrunerProcFactory.setupNeededColumns(scanOperator, rs, Arrays.asList(rewriteQueryCtx.getIndexKey()));
    }

    private void replaceSelectOperatorProcess(SelectOperator operator) throws SemanticException {
        RewriteQueryUsingAggregateIndexCtx rewriteQueryCtx = this;
        List<ExprNodeDesc> selColList = ((SelectDesc)operator.getConf()).getColList();
        selColList.add(rewriteQueryCtx.getAggrExprNode());
        List<String> selOutputColNames = ((SelectDesc)operator.getConf()).getOutputColumnNames();
        selOutputColNames.add(rewriteQueryCtx.getAggrExprNode().getColumn());
        operator.getColumnExprMap().put(rewriteQueryCtx.getAggrExprNode().getColumn(), rewriteQueryCtx.getAggrExprNode());
        RowSchema selRS = operator.getSchema();
        ArrayList<ColumnInfo> selRSSignature = selRS.getSignature();
        PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo("bigint");
        pti.setTypeName("bigint");
        ColumnInfo newCI = new ColumnInfo(rewriteQueryCtx.getAggregateFunction(), pti, "", false);
        selRSSignature.add(newCI);
        selRS.setSignature(selRSSignature);
        operator.setSchema(selRS);
    }

    private void replaceGroupByOperatorProcess(GroupByOperator operator, int index) throws SemanticException {
        RewriteQueryUsingAggregateIndexCtx rewriteQueryCtx = this;
        if (index == 0) {
            String selReplacementCommand = "select sum(`" + rewriteQueryCtx.getAggregateFunction() + "`)" + " from `" + rewriteQueryCtx.getIndexName() + "` group by " + rewriteQueryCtx.getIndexKey() + " ";
            Operator<? extends OperatorDesc> newOperatorTree = RewriteParseContextGenerator.generateOperatorTree(rewriteQueryCtx.getParseContext().getConf(), selReplacementCommand);
            GroupByOperator newGbyOperator = OperatorUtils.findLastOperatorUpstream(newOperatorTree, GroupByOperator.class);
            if (newGbyOperator == null) {
                throw new SemanticException("Error replacing GroupBy operator.");
            }
            ExprNodeColumnDesc aggrExprNode = null;
            GroupByDesc newConf = (GroupByDesc)newGbyOperator.getConf();
            ArrayList<AggregationDesc> newAggrList = newConf.getAggregators();
            if (newAggrList != null && newAggrList.size() > 0) {
                for (AggregationDesc aggregationDesc : newAggrList) {
                    rewriteQueryCtx.setEval(aggregationDesc.getGenericUDAFEvaluator());
                    aggrExprNode = (ExprNodeColumnDesc)aggregationDesc.getParameters().get(0);
                    rewriteQueryCtx.setAggrExprNode(aggrExprNode);
                }
            }
            GroupByDesc oldConf = (GroupByDesc)operator.getConf();
            oldConf.setAggregators(newAggrList);
            operator.setConf(oldConf);
        } else {
            GroupByDesc childConf = (GroupByDesc)operator.getConf();
            ArrayList<AggregationDesc> childAggrList = childConf.getAggregators();
            if (childAggrList != null && childAggrList.size() > 0) {
                for (AggregationDesc aggregationDesc : childAggrList) {
                    ArrayList<ExprNodeDesc> paraList = aggregationDesc.getParameters();
                    ArrayList<ObjectInspector> parametersOIList = new ArrayList<ObjectInspector>();
                    for (ExprNodeDesc expr : paraList) {
                        parametersOIList.add(expr.getWritableObjectInspector());
                    }
                    GenericUDAFEvaluator evaluator = FunctionRegistry.getGenericUDAFEvaluator("sum", parametersOIList, false, false);
                    aggregationDesc.setGenericUDAFEvaluator(evaluator);
                    aggregationDesc.setGenericUDAFName("sum");
                }
            }
        }
    }
}

