/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;

public class ExplainWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Path resFile;
    private ArrayList<Task<? extends Serializable>> rootTasks;
    private Task<? extends Serializable> fetchTask;
    private ASTNode astTree;
    private String astStringTree;
    private HashSet<ReadEntity> inputs;
    private ParseContext pCtx;
    boolean extended;
    boolean formatted;
    boolean dependency;
    boolean logical;
    boolean appendTaskType;
    boolean authorize;
    boolean userLevelExplain;
    String cboInfo;
    private transient BaseSemanticAnalyzer analyzer;

    public ExplainWork() {
    }

    public ExplainWork(Path resFile, ParseContext pCtx, List<Task<? extends Serializable>> rootTasks, Task<? extends Serializable> fetchTask, ASTNode astTree, BaseSemanticAnalyzer analyzer, boolean extended, boolean formatted, boolean dependency, boolean logical, boolean authorize, boolean userLevelExplain, String cboInfo) {
        this.resFile = resFile;
        this.rootTasks = new ArrayList<Task<? extends Serializable>>(rootTasks);
        this.fetchTask = fetchTask;
        this.astTree = astTree;
        this.analyzer = analyzer;
        if (analyzer != null) {
            this.inputs = analyzer.getInputs();
        }
        this.extended = extended;
        this.formatted = formatted;
        this.dependency = dependency;
        this.logical = logical;
        this.pCtx = pCtx;
        this.authorize = authorize;
        this.userLevelExplain = userLevelExplain;
        this.cboInfo = cboInfo;
    }

    public Path getResFile() {
        return this.resFile;
    }

    public void setResFile(Path resFile) {
        this.resFile = resFile;
    }

    public ArrayList<Task<? extends Serializable>> getRootTasks() {
        return this.rootTasks;
    }

    public void setRootTasks(ArrayList<Task<? extends Serializable>> rootTasks) {
        this.rootTasks = rootTasks;
    }

    public Task<? extends Serializable> getFetchTask() {
        return this.fetchTask;
    }

    public void setFetchTask(Task<? extends Serializable> fetchTask) {
        this.fetchTask = fetchTask;
    }

    public ASTNode getAstTree() {
        return this.astTree;
    }

    public String getAstStringTree() {
        if (this.astStringTree == null) {
            this.astStringTree = this.astTree.dump();
        }
        return this.astStringTree;
    }

    public HashSet<ReadEntity> getInputs() {
        return this.inputs;
    }

    public void setInputs(HashSet<ReadEntity> inputs) {
        this.inputs = inputs;
    }

    public boolean getExtended() {
        return this.extended;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public boolean getDependency() {
        return this.dependency;
    }

    public void setDependency(boolean dependency) {
        this.dependency = dependency;
    }

    public boolean isFormatted() {
        return this.formatted;
    }

    public void setFormatted(boolean formatted) {
        this.formatted = formatted;
    }

    public ParseContext getParseContext() {
        return this.pCtx;
    }

    public void setParseContext(ParseContext pCtx) {
        this.pCtx = pCtx;
    }

    public boolean isLogical() {
        return this.logical;
    }

    public void setLogical(boolean logical) {
        this.logical = logical;
    }

    public boolean isAppendTaskType() {
        return this.appendTaskType;
    }

    public void setAppendTaskType(boolean appendTaskType) {
        this.appendTaskType = appendTaskType;
    }

    public boolean isAuthorize() {
        return this.authorize;
    }

    public void setAuthorize(boolean authorize) {
        this.authorize = authorize;
    }

    public BaseSemanticAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public boolean isUserLevelExplain() {
        return this.userLevelExplain;
    }

    public void setUserLevelExplain(boolean userLevelExplain) {
        this.userLevelExplain = userLevelExplain;
    }

    public String getCboInfo() {
        return this.cboInfo;
    }

    public void setCboInfo(String cboInfo) {
        this.cboInfo = cboInfo;
    }
}

