/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveAuthorizationProviderBase
implements HiveAuthorizationProvider {
    protected HiveProxy hive_db;
    protected HiveAuthenticationProvider authenticator;
    private Configuration conf;
    public static final Logger LOG = LoggerFactory.getLogger(HiveAuthorizationProvider.class);

    public void setConf(Configuration conf) {
        this.conf = conf;
        try {
            this.init(conf);
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public HiveAuthenticationProvider getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void setAuthenticator(HiveAuthenticationProvider authenticator) {
        this.authenticator = authenticator;
    }

    protected class HiveProxy {
        private final Hive hiveClient;
        private HiveMetaStore.HMSHandler handler;

        public HiveProxy(Hive hive) {
            this.hiveClient = hive;
            this.handler = null;
        }

        public HiveProxy() {
            this.hiveClient = null;
            this.handler = null;
        }

        public void setHandler(HiveMetaStore.HMSHandler handler) {
            this.handler = handler;
        }

        public boolean isRunFromMetaStore() {
            return this.hiveClient == null;
        }

        public PrincipalPrivilegeSet get_privilege_set(HiveObjectType column, String dbName, String tableName, List<String> partValues, String col, String userName, List<String> groupNames) throws HiveException {
            if (!this.isRunFromMetaStore()) {
                return this.hiveClient.get_privilege_set(column, dbName, tableName, partValues, col, userName, groupNames);
            }
            HiveObjectRef hiveObj = new HiveObjectRef(column, dbName, tableName, partValues, col);
            try {
                return this.handler.get_privilege_set(hiveObj, userName, groupNames);
            }
            catch (MetaException e) {
                throw new HiveException(e);
            }
            catch (TException e) {
                throw new HiveException(e);
            }
        }

        public Database getDatabase(String dbName) throws HiveException {
            if (!this.isRunFromMetaStore()) {
                return this.hiveClient.getDatabase(dbName);
            }
            try {
                return this.handler.get_database_core(dbName);
            }
            catch (NoSuchObjectException e) {
                throw new HiveException(e);
            }
            catch (MetaException e) {
                throw new HiveException(e);
            }
        }
    }
}

