/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.util.TimestampUtils;

public class CastDoubleToTimestamp
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;

    public CastDoubleToTimestamp(int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
    }

    public CastDoubleToTimestamp() {
    }

    private void setDouble(TimestampColumnVector timestampColVector, double[] vector, int elementNum) {
        timestampColVector.set(elementNum, TimestampUtils.doubleToTimestamp(vector[elementNum]));
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        DoubleColumnVector inputColVector = (DoubleColumnVector)batch.cols[this.colNum];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        int n = batch.size;
        double[] vector = inputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.isRepeating) {
            this.setDouble(outputColVector, vector, 0);
            outputIsNull[0] = inputIsNull[0];
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.setDouble(outputColVector, vector, i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.setDouble(outputColVector, vector, i);
                }
            }
            outputColVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.setDouble(outputColVector, vector, i);
                    outputIsNull[i] = inputIsNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.setDouble(outputColVector, vector, i);
                }
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            }
            outputColVector.isRepeating = false;
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "timestamp";
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

