/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.orc.Reader;
import org.apache.orc.impl.AcidStats;
import org.apache.orc.impl.OrcAcidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedOrcAcidRowBatchReader
implements org.apache.hadoop.mapred.RecordReader<NullWritable, VectorizedRowBatch> {
    private static final Logger LOG = LoggerFactory.getLogger(VectorizedOrcAcidRowBatchReader.class);
    private RecordReader baseReader;
    private VectorizedRowBatchCtx rbCtx;
    private VectorizedRowBatch vectorizedRowBatchBase;
    private long offset;
    private long length;
    private float progress = 0.0f;
    private Object[] partitionValues;
    private boolean addPartitionCols = true;
    private ValidTxnList validTxnList;
    private DeleteEventRegistry deleteEventRegistry;

    public VectorizedOrcAcidRowBatchReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        int partitionColumnCount;
        boolean isReadNotAllowed;
        boolean isAcidRead = HiveConf.getBoolVar((Configuration)conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN);
        AcidUtils.AcidOperationalProperties acidOperationalProperties = AcidUtils.getAcidOperationalProperties((Configuration)conf);
        boolean bl = isReadNotAllowed = !isAcidRead || !acidOperationalProperties.isSplitUpdate() || !(inputSplit instanceof OrcSplit);
        if (isReadNotAllowed) {
            OrcInputFormat.raiseAcidTablesMustBeReadWithAcidReaderException((Configuration)conf);
        }
        OrcSplit orcSplit = (OrcSplit)inputSplit;
        this.rbCtx = Utilities.getVectorizedRowBatchCtx((Configuration)conf);
        reporter.setStatus(orcSplit.toString());
        Reader reader = OrcInputFormat.createOrcReaderForSplit((Configuration)conf, orcSplit);
        Reader.Options readerOptions = OrcInputFormat.createOptionsForReader((Configuration)conf);
        readerOptions = OrcRawRecordMerger.createEventOptions(readerOptions);
        this.offset = orcSplit.getStart();
        this.length = orcSplit.getLength();
        this.baseReader = reader.rowsOptions(readerOptions.range(this.offset, this.length));
        if (!(this.baseReader instanceof RecordReaderImpl)) {
            throw new IOException("Failed to create vectorized row batch for the reader of type " + this.baseReader.getClass().getName());
        }
        this.vectorizedRowBatchBase = ((RecordReaderImpl)this.baseReader).createRowBatch();
        int n = partitionColumnCount = this.rbCtx != null ? this.rbCtx.getPartitionColumnCount() : 0;
        if (partitionColumnCount > 0) {
            this.partitionValues = new Object[partitionColumnCount];
            VectorizedRowBatchCtx.getPartitionValues(this.rbCtx, (Configuration)conf, (FileSplit)orcSplit, this.partitionValues);
        } else {
            this.partitionValues = null;
        }
        String txnString = conf.get("hive.txn.valid.txns");
        this.validTxnList = txnString == null ? new ValidReadTxnList() : new ValidReadTxnList(txnString);
        Reader.Options deleteEventReaderOptions = readerOptions.clone();
        deleteEventReaderOptions.range(0L, Long.MAX_VALUE);
        deleteEventReaderOptions.searchArgument(null, null);
        try {
            this.deleteEventRegistry = new ColumnizedDeleteEventRegistry(conf, orcSplit, deleteEventReaderOptions);
        }
        catch (DeleteEventsOverflowMemoryException e) {
            this.deleteEventRegistry = new SortMergedDeleteEventRegistry(conf, orcSplit, deleteEventReaderOptions);
        }
    }

    public static boolean canCreateVectorizedAcidRowBatchReaderOnSplit(JobConf conf, InputSplit inputSplit) {
        if (!(inputSplit instanceof OrcSplit)) {
            return false;
        }
        OrcSplit split = (OrcSplit)inputSplit;
        return AcidUtils.getAcidOperationalProperties((Configuration)conf).isSplitUpdate() && !split.isOriginal();
    }

    private static Path[] getDeleteDeltaDirsFromSplit(OrcSplit orcSplit) throws IOException {
        Path path = orcSplit.getPath();
        Path root = orcSplit.hasBase() ? (orcSplit.isOriginal() ? path.getParent() : path.getParent().getParent()) : path;
        return AcidUtils.deserializeDeleteDeltas(root, orcSplit.getDeltas());
    }

    public boolean next(NullWritable key, VectorizedRowBatch value) throws IOException {
        try {
            if (this.addPartitionCols) {
                if (this.partitionValues != null) {
                    this.rbCtx.addPartitionColsToBatch(value, this.partitionValues);
                }
                this.addPartitionCols = false;
            }
            if (!this.baseReader.nextBatch(this.vectorizedRowBatchBase)) {
                return false;
            }
        }
        catch (Exception e) {
            throw new IOException("error iterating", e);
        }
        BitSet selectedBitSet = new BitSet(this.vectorizedRowBatchBase.size);
        if (this.vectorizedRowBatchBase.selectedInUse) {
            selectedBitSet.set(0, this.vectorizedRowBatchBase.size, false);
            for (int j = 0; j < this.vectorizedRowBatchBase.size; ++j) {
                int i = this.vectorizedRowBatchBase.selected[j];
                selectedBitSet.set(i);
            }
        } else {
            selectedBitSet.set(0, this.vectorizedRowBatchBase.size, true);
        }
        this.findRecordsWithInvalidTransactionIds(this.vectorizedRowBatchBase, selectedBitSet);
        this.deleteEventRegistry.findDeletedRecords(this.vectorizedRowBatchBase, selectedBitSet);
        if (selectedBitSet.cardinality() == this.vectorizedRowBatchBase.size) {
            value.size = this.vectorizedRowBatchBase.size;
            value.selected = this.vectorizedRowBatchBase.selected;
            value.selectedInUse = this.vectorizedRowBatchBase.selectedInUse;
        } else {
            value.size = selectedBitSet.cardinality();
            value.selectedInUse = true;
            value.selected = new int[selectedBitSet.cardinality()];
            int setBitIndex = selectedBitSet.nextSetBit(0);
            int selectedItr = 0;
            while (setBitIndex >= 0) {
                value.selected[selectedItr] = setBitIndex;
                setBitIndex = selectedBitSet.nextSetBit(setBitIndex + 1);
                ++selectedItr;
            }
        }
        StructColumnVector payloadStruct = (StructColumnVector)this.vectorizedRowBatchBase.cols[5];
        System.arraycopy(payloadStruct.fields, 0, value.cols, 0, value.getDataColumnCount());
        this.progress = this.baseReader.getProgress();
        return true;
    }

    private void findRecordsWithInvalidTransactionIds(VectorizedRowBatch batch, BitSet selectedBitSet) {
        if (batch.cols[4].isRepeating) {
            long currentTransactionIdForBatch = ((LongColumnVector)batch.cols[4]).vector[0];
            if (!this.validTxnList.isTxnValid(currentTransactionIdForBatch)) {
                selectedBitSet.clear(0, batch.size);
            }
            return;
        }
        long[] currentTransactionVector = ((LongColumnVector)batch.cols[4]).vector;
        int setBitIndex = selectedBitSet.nextSetBit(0);
        while (setBitIndex >= 0) {
            if (!this.validTxnList.isTxnValid(currentTransactionVector[setBitIndex])) {
                selectedBitSet.clear(setBitIndex);
            }
            setBitIndex = selectedBitSet.nextSetBit(setBitIndex + 1);
        }
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public VectorizedRowBatch createValue() {
        return this.rbCtx.createVectorizedRowBatch();
    }

    public long getPos() throws IOException {
        return this.offset + (long)(this.progress * (float)this.length);
    }

    public void close() throws IOException {
        try {
            this.baseReader.close();
        }
        finally {
            this.deleteEventRegistry.close();
        }
    }

    public float getProgress() throws IOException {
        return this.progress;
    }

    @VisibleForTesting
    DeleteEventRegistry getDeleteEventRegistry() {
        return this.deleteEventRegistry;
    }

    static class DeleteEventsOverflowMemoryException
    extends Exception {
        private static final long serialVersionUID = 1L;

        DeleteEventsOverflowMemoryException() {
        }
    }

    static class ColumnizedDeleteEventRegistry
    implements DeleteEventRegistry {
        private TreeMap<DeleteRecordKey, DeleteReaderValue> sortMerger;
        private long[] rowIds;
        private CompressedOtid[] compressedOtids;
        private ValidTxnList validTxnList;

        public ColumnizedDeleteEventRegistry(JobConf conf, OrcSplit orcSplit, Reader.Options readerOptions) throws IOException, DeleteEventsOverflowMemoryException {
            int bucket = AcidUtils.parseBaseOrDeltaBucketFilename(orcSplit.getPath(), (Configuration)conf).getBucket();
            String txnString = conf.get("hive.txn.valid.txns");
            this.validTxnList = txnString == null ? new ValidReadTxnList() : new ValidReadTxnList(txnString);
            this.sortMerger = new TreeMap();
            this.rowIds = null;
            this.compressedOtids = null;
            int maxEventsInMemory = HiveConf.getIntVar((Configuration)conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY);
            try {
                Path[] deleteDeltaDirs = VectorizedOrcAcidRowBatchReader.getDeleteDeltaDirsFromSplit(orcSplit);
                if (deleteDeltaDirs.length > 0) {
                    int totalDeleteEventCount = 0;
                    for (Path deleteDeltaDir : deleteDeltaDirs) {
                        Path deleteDeltaFile = AcidUtils.createBucketFile(deleteDeltaDir, bucket);
                        FileSystem fs = deleteDeltaFile.getFileSystem((Configuration)conf);
                        long length = OrcAcidUtils.getLastFlushLength(fs, deleteDeltaFile);
                        if (length == -1L || !fs.exists(deleteDeltaFile)) continue;
                        Reader deleteDeltaReader = OrcFile.createReader(deleteDeltaFile, OrcFile.readerOptions((Configuration)conf).maxLength(length));
                        AcidStats acidStats = OrcAcidUtils.parseAcidStats(deleteDeltaReader);
                        if (acidStats.deletes == 0L) continue;
                        if ((totalDeleteEventCount = (int)((long)totalDeleteEventCount + acidStats.deletes)) > maxEventsInMemory) {
                            LOG.info("Total number of delete events exceeds the maximum number of delete events that can be loaded into memory for the delete deltas in the directory at : " + deleteDeltaDirs.toString() + ". The max limit is currently set at " + maxEventsInMemory + " and can be changed by setting the Hive config variable " + HiveConf.ConfVars.HIVE_TRANSACTIONAL_NUM_EVENTS_IN_MEMORY.varname);
                            throw new DeleteEventsOverflowMemoryException();
                        }
                        DeleteReaderValue deleteReaderValue = new DeleteReaderValue(deleteDeltaReader, readerOptions, bucket, this.validTxnList);
                        DeleteRecordKey deleteRecordKey = new DeleteRecordKey();
                        if (deleteReaderValue.next(deleteRecordKey)) {
                            this.sortMerger.put(deleteRecordKey, deleteReaderValue);
                            continue;
                        }
                        deleteReaderValue.close();
                    }
                    if (totalDeleteEventCount > 0) {
                        this.rowIds = new long[totalDeleteEventCount];
                        this.readAllDeleteEventsFromDeleteDeltas();
                    }
                }
            }
            catch (IOException | DeleteEventsOverflowMemoryException e) {
                this.close();
                throw e;
            }
        }

        private void readAllDeleteEventsFromDeleteDeltas() throws IOException {
            if (this.sortMerger == null || this.sortMerger.isEmpty()) {
                return;
            }
            int distinctOtids = 0;
            long lastSeenOtid = -1L;
            long[] otids = new long[this.rowIds.length];
            int index = 0;
            while (!this.sortMerger.isEmpty()) {
                Map.Entry<DeleteRecordKey, DeleteReaderValue> entry = this.sortMerger.pollFirstEntry();
                DeleteRecordKey deleteRecordKey = entry.getKey();
                DeleteReaderValue deleteReaderValue = entry.getValue();
                otids[index] = deleteRecordKey.originalTransactionId;
                this.rowIds[index] = deleteRecordKey.rowId;
                ++index;
                if (lastSeenOtid != deleteRecordKey.originalTransactionId) {
                    ++distinctOtids;
                    lastSeenOtid = deleteRecordKey.originalTransactionId;
                }
                if (deleteReaderValue.next(deleteRecordKey)) {
                    this.sortMerger.put(deleteRecordKey, deleteReaderValue);
                    continue;
                }
                deleteReaderValue.close();
            }
            this.compressedOtids = new CompressedOtid[distinctOtids];
            lastSeenOtid = otids[0];
            int fromIndex = 0;
            int pos = 0;
            for (int i = 1; i < otids.length; ++i) {
                if (otids[i] == lastSeenOtid) continue;
                this.compressedOtids[pos] = new CompressedOtid(lastSeenOtid, fromIndex, i);
                lastSeenOtid = otids[i];
                fromIndex = i;
                ++pos;
            }
            this.compressedOtids[pos] = new CompressedOtid(lastSeenOtid, fromIndex, otids.length);
        }

        private boolean isDeleted(long otid, long rowId) {
            if (this.compressedOtids == null || this.rowIds == null) {
                return false;
            }
            if (otid < this.compressedOtids[0].originalTransactionId || otid > this.compressedOtids[this.compressedOtids.length - 1].originalTransactionId) {
                return false;
            }
            CompressedOtid key = new CompressedOtid(otid, -1, -1);
            int pos = Arrays.binarySearch(this.compressedOtids, key);
            if (pos >= 0) {
                key = this.compressedOtids[pos];
                if (rowId < this.rowIds[key.fromIndex] || rowId > this.rowIds[key.toIndex - 1]) {
                    return false;
                }
                if (Arrays.binarySearch(this.rowIds, key.fromIndex, key.toIndex, rowId) >= 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void findDeletedRecords(VectorizedRowBatch batch, BitSet selectedBitSet) throws IOException {
            if (this.rowIds == null || this.compressedOtids == null) {
                return;
            }
            long[] originalTransactionVector = batch.cols[1].isRepeating ? null : ((LongColumnVector)batch.cols[1]).vector;
            long repeatedOriginalTransaction = originalTransactionVector != null ? -1L : ((LongColumnVector)batch.cols[1]).vector[0];
            long[] rowIdVector = ((LongColumnVector)batch.cols[3]).vector;
            int setBitIndex = selectedBitSet.nextSetBit(0);
            while (setBitIndex >= 0) {
                long rowId;
                long otid = originalTransactionVector != null ? originalTransactionVector[setBitIndex] : repeatedOriginalTransaction;
                if (this.isDeleted(otid, rowId = rowIdVector[setBitIndex])) {
                    selectedBitSet.clear(setBitIndex);
                }
                setBitIndex = selectedBitSet.nextSetBit(setBitIndex + 1);
            }
        }

        @Override
        public void close() throws IOException {
            while (!this.sortMerger.isEmpty()) {
                Map.Entry<DeleteRecordKey, DeleteReaderValue> entry = this.sortMerger.pollFirstEntry();
                entry.getValue().close();
            }
        }

        private class CompressedOtid
        implements Comparable<CompressedOtid> {
            long originalTransactionId;
            int fromIndex;
            int toIndex;

            public CompressedOtid(long otid, int fromIndex, int toIndex) {
                this.originalTransactionId = otid;
                this.fromIndex = fromIndex;
                this.toIndex = toIndex;
            }

            @Override
            public int compareTo(CompressedOtid other) {
                if (this.originalTransactionId != other.originalTransactionId) {
                    return this.originalTransactionId < other.originalTransactionId ? -1 : 1;
                }
                return 0;
            }
        }

        static class DeleteReaderValue {
            private VectorizedRowBatch batch;
            private final RecordReader recordReader;
            private int indexPtrInBatch;
            private final int bucketForSplit;
            private final ValidTxnList validTxnList;

            public DeleteReaderValue(Reader deleteDeltaReader, Reader.Options readerOptions, int bucket, ValidTxnList validTxnList) throws IOException {
                this.recordReader = deleteDeltaReader.rowsOptions(readerOptions);
                this.bucketForSplit = bucket;
                this.batch = deleteDeltaReader.getSchema().createRowBatch();
                if (!this.recordReader.nextBatch(this.batch)) {
                    this.batch = null;
                }
                this.indexPtrInBatch = 0;
                this.validTxnList = validTxnList;
            }

            public boolean next(DeleteRecordKey deleteRecordKey) throws IOException {
                if (this.batch == null) {
                    return false;
                }
                boolean isValidNext = false;
                while (!isValidNext) {
                    if (this.indexPtrInBatch >= this.batch.size) {
                        if (this.recordReader.nextBatch(this.batch)) {
                            long bucketForRecord = ((LongColumnVector)this.batch.cols[2]).vector[0];
                            if (this.batch.size > 1 && !this.batch.cols[2].isRepeating || bucketForRecord != (long)this.bucketForSplit) {
                                throw new IOException("Corrupted records with different bucket ids from the containing bucket file found! Expected bucket id " + this.bucketForSplit + ", however found the bucket id " + bucketForRecord);
                            }
                            this.indexPtrInBatch = 0;
                        } else {
                            return false;
                        }
                    }
                    int originalTransactionIndex = this.batch.cols[1].isRepeating ? 0 : this.indexPtrInBatch;
                    long originalTransaction = ((LongColumnVector)this.batch.cols[1]).vector[originalTransactionIndex];
                    long rowId = ((LongColumnVector)this.batch.cols[3]).vector[this.indexPtrInBatch];
                    int currentTransactionIndex = this.batch.cols[4].isRepeating ? 0 : this.indexPtrInBatch;
                    long currentTransaction = ((LongColumnVector)this.batch.cols[4]).vector[currentTransactionIndex];
                    ++this.indexPtrInBatch;
                    if (!this.validTxnList.isTxnValid(currentTransaction)) continue;
                    isValidNext = true;
                    deleteRecordKey.set(originalTransaction, rowId);
                }
                return true;
            }

            public void close() throws IOException {
                this.recordReader.close();
            }
        }

        static class DeleteRecordKey
        implements Comparable<DeleteRecordKey> {
            private long originalTransactionId;
            private long rowId;

            public DeleteRecordKey() {
                this.originalTransactionId = -1L;
                this.rowId = -1L;
            }

            public DeleteRecordKey(long otid, long rowId) {
                this.originalTransactionId = otid;
                this.rowId = rowId;
            }

            public void set(long otid, long rowId) {
                this.originalTransactionId = otid;
                this.rowId = rowId;
            }

            @Override
            public int compareTo(DeleteRecordKey other) {
                if (other == null) {
                    return -1;
                }
                if (this.originalTransactionId != other.originalTransactionId) {
                    return this.originalTransactionId < other.originalTransactionId ? -1 : 1;
                }
                if (this.rowId != other.rowId) {
                    return this.rowId < other.rowId ? -1 : 1;
                }
                return 0;
            }
        }
    }

    static class SortMergedDeleteEventRegistry
    implements DeleteEventRegistry {
        private OrcRawRecordMerger deleteRecords;
        private OrcRawRecordMerger.ReaderKey deleteRecordKey;
        private OrcStruct deleteRecordValue;
        private boolean isDeleteRecordAvailable = true;
        private ValidTxnList validTxnList;

        public SortMergedDeleteEventRegistry(JobConf conf, OrcSplit orcSplit, Reader.Options readerOptions) throws IOException {
            Path[] deleteDeltas = VectorizedOrcAcidRowBatchReader.getDeleteDeltaDirsFromSplit(orcSplit);
            if (deleteDeltas.length > 0) {
                int bucket = AcidUtils.parseBaseOrDeltaBucketFilename(orcSplit.getPath(), (Configuration)conf).getBucket();
                String txnString = conf.get("hive.txn.valid.txns");
                this.validTxnList = txnString == null ? new ValidReadTxnList() : new ValidReadTxnList(txnString);
                this.deleteRecords = new OrcRawRecordMerger((Configuration)conf, true, null, false, bucket, this.validTxnList, readerOptions, deleteDeltas);
                this.deleteRecordKey = new OrcRawRecordMerger.ReaderKey();
                this.deleteRecordValue = this.deleteRecords.createValue();
                this.isDeleteRecordAvailable = this.deleteRecords.next(this.deleteRecordKey, this.deleteRecordValue);
            } else {
                this.isDeleteRecordAvailable = false;
                this.deleteRecordKey = null;
                this.deleteRecordValue = null;
                this.deleteRecords = null;
            }
        }

        @Override
        public void findDeletedRecords(VectorizedRowBatch batch, BitSet selectedBitSet) throws IOException {
            if (!this.isDeleteRecordAvailable) {
                return;
            }
            long[] originalTransaction = batch.cols[1].isRepeating ? null : ((LongColumnVector)batch.cols[1]).vector;
            long[] bucket = batch.cols[2].isRepeating ? null : ((LongColumnVector)batch.cols[2]).vector;
            long[] rowId = batch.cols[3].isRepeating ? null : ((LongColumnVector)batch.cols[3]).vector;
            long repeatedOriginalTransaction = originalTransaction != null ? -1L : ((LongColumnVector)batch.cols[1]).vector[0];
            long repeatedBucket = bucket != null ? -1L : ((LongColumnVector)batch.cols[2]).vector[0];
            long repeatedRowId = rowId != null ? -1L : ((LongColumnVector)batch.cols[3]).vector[0];
            int firstValidIndex = selectedBitSet.nextSetBit(0);
            if (firstValidIndex == -1) {
                return;
            }
            RecordIdentifier firstRecordIdInBatch = new RecordIdentifier(originalTransaction != null ? originalTransaction[firstValidIndex] : repeatedOriginalTransaction, bucket != null ? (int)bucket[firstValidIndex] : (int)repeatedBucket, rowId != null ? (long)((int)rowId[firstValidIndex]) : repeatedRowId);
            int lastValidIndex = selectedBitSet.previousSetBit(batch.size - 1);
            RecordIdentifier lastRecordIdInBatch = new RecordIdentifier(originalTransaction != null ? originalTransaction[lastValidIndex] : repeatedOriginalTransaction, bucket != null ? (int)bucket[lastValidIndex] : (int)repeatedBucket, rowId != null ? (long)((int)rowId[lastValidIndex]) : repeatedRowId);
            while (this.deleteRecordKey.compareRow(firstRecordIdInBatch) == -1) {
                this.isDeleteRecordAvailable = this.deleteRecords.next(this.deleteRecordKey, this.deleteRecordValue);
                if (this.isDeleteRecordAvailable) continue;
                return;
            }
            int currIndex = firstValidIndex;
            RecordIdentifier currRecordIdInBatch = new RecordIdentifier();
            while (this.isDeleteRecordAvailable && currIndex != -1 && currIndex <= lastValidIndex) {
                currRecordIdInBatch.setValues(originalTransaction != null ? originalTransaction[currIndex] : repeatedOriginalTransaction, bucket != null ? (int)bucket[currIndex] : (int)repeatedBucket, rowId != null ? rowId[currIndex] : repeatedRowId);
                if (this.deleteRecordKey.compareRow(currRecordIdInBatch) == 0) {
                    selectedBitSet.clear(currIndex);
                    currIndex = selectedBitSet.nextSetBit(currIndex + 1);
                    continue;
                }
                if (this.deleteRecordKey.compareRow(currRecordIdInBatch) == 1) {
                    if (this.deleteRecordKey.compareRow(lastRecordIdInBatch) == 1) {
                        return;
                    }
                    currIndex = selectedBitSet.nextSetBit(currIndex + 1);
                    continue;
                }
                this.isDeleteRecordAvailable = this.deleteRecords.next(this.deleteRecordKey, this.deleteRecordValue);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.deleteRecords != null) {
                this.deleteRecords.close();
            }
        }
    }

    static interface DeleteEventRegistry {
        public void findDeletedRecords(VectorizedRowBatch var1, BitSet var2) throws IOException;

        public void close() throws IOException;
    }
}

