/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.commons.io.FileUtils;
import org.apache.hive.hplsql.Arguments;
import org.apache.hive.hplsql.Cmp;
import org.apache.hive.hplsql.Conf;
import org.apache.hive.hplsql.Conn;
import org.apache.hive.hplsql.Converter;
import org.apache.hive.hplsql.Copy;
import org.apache.hive.hplsql.Expression;
import org.apache.hive.hplsql.Handler;
import org.apache.hive.hplsql.HplsqlBaseVisitor;
import org.apache.hive.hplsql.HplsqlLexer;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Interval;
import org.apache.hive.hplsql.Meta;
import org.apache.hive.hplsql.Package;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.Row;
import org.apache.hive.hplsql.Scope;
import org.apache.hive.hplsql.Select;
import org.apache.hive.hplsql.Signal;
import org.apache.hive.hplsql.Stmt;
import org.apache.hive.hplsql.StreamGobbler;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.functions.Function;
import org.apache.hive.hplsql.functions.FunctionDatetime;
import org.apache.hive.hplsql.functions.FunctionMisc;
import org.apache.hive.hplsql.functions.FunctionOra;
import org.apache.hive.hplsql.functions.FunctionString;

public class Exec
extends HplsqlBaseVisitor<Integer> {
    public static final String VERSION = "HPL/SQL 0.3.13";
    public static final String SQLCODE = "SQLCODE";
    public static final String SQLSTATE = "SQLSTATE";
    public static final String HOSTCODE = "HOSTCODE";
    Exec exec = null;
    ParseTree tree = null;
    Stack<Scope> scopes = new Stack();
    Scope globalScope;
    Scope currentScope;
    Stack<Var> stack = new Stack();
    Stack<String> labels = new Stack();
    Stack<String> callStack = new Stack();
    Stack<Signal> signals = new Stack();
    Signal currentSignal;
    Scope currentHandlerScope;
    boolean resignal = false;
    HashMap<String, String> managedTables = new HashMap();
    HashMap<String, String> objectMap = new HashMap();
    HashMap<String, String> objectConnMap = new HashMap();
    HashMap<String, ArrayList<Var>> returnCursors = new HashMap();
    HashMap<String, Package> packages = new HashMap();
    Package currentPackageDecl = null;
    public ArrayList<String> stmtConnList = new ArrayList();
    Arguments arguments = new Arguments();
    public Conf conf;
    Expression expr;
    Function function;
    Converter converter;
    Meta meta;
    Select select;
    Stmt stmt;
    Conn conn;
    int rowCount = 0;
    String execString;
    String execFile;
    String execMain;
    StringBuilder localUdf = new StringBuilder();
    boolean initRoutines = false;
    public boolean buildSql = false;
    public boolean inCallStmt = false;
    boolean udfRegistered = false;
    boolean udfRun = false;
    boolean dotHplsqlrcExists = false;
    boolean hplsqlrcExists = false;
    boolean trace = false;
    boolean info = true;
    boolean offline = false;

    Exec() {
        this.exec = this;
    }

    Exec(Exec exec) {
        this.exec = exec;
    }

    public Var setVariable(String name, Var value) {
        if (value == null || value == Var.Empty) {
            if (this.exec.stack.empty()) {
                return Var.Empty;
            }
            value = this.exec.stack.pop();
        }
        if (name.startsWith("hplsql.")) {
            this.exec.conf.setOption(name, value.toString());
            return Var.Empty;
        }
        Var var = this.findVariable(name);
        if (var != null) {
            var.cast(value);
        } else {
            var = new Var(value);
            var.setName(name);
            this.exec.currentScope.addVariable(var);
        }
        return var;
    }

    public Var setVariable(String name) {
        return this.setVariable(name, Var.Empty);
    }

    public Var setVariable(String name, String value) {
        return this.setVariable(name, new Var(value));
    }

    public Var setVariable(String name, int value) {
        return this.setVariable(name, new Var(new Long(value)));
    }

    public Var setVariableToNull(String name) {
        Var var = this.findVariable(name);
        if (var != null) {
            var.removeValue();
        } else {
            var = new Var();
            var.setName(name);
            this.exec.currentScope.addVariable(var);
        }
        return var;
    }

    public void addVariable(Var var) {
        if (this.currentPackageDecl != null) {
            this.currentPackageDecl.addVariable(var);
        } else if (this.exec.currentScope != null) {
            this.exec.currentScope.addVariable(var);
        }
    }

    public void addHandler(Handler handler) {
        if (this.exec.currentScope != null) {
            this.exec.currentScope.addHandler(handler);
        }
    }

    public void addReturnCursor(Var var) {
        String routine = this.callStackPeek();
        ArrayList<Var> cursors = this.returnCursors.get(routine);
        if (cursors == null) {
            cursors = new ArrayList();
            this.returnCursors.put(routine, cursors);
        }
        cursors.add(var);
    }

    public Var consumeReturnCursor(String routine) {
        ArrayList<Var> cursors = this.returnCursors.get(routine.toUpperCase());
        if (cursors == null) {
            return null;
        }
        Var var = cursors.get(0);
        cursors.remove(0);
        return var;
    }

    public void stackPush(Var var) {
        this.exec.stack.push(var);
    }

    public void stackPush(String val) {
        this.exec.stack.push(new Var(val));
    }

    public void stackPush(StringBuilder val) {
        this.stackPush(val.toString());
    }

    public void stackPush(Boolean val) {
        this.exec.stack.push(new Var(val));
    }

    public Var stackPeek() {
        return this.exec.stack.peek();
    }

    public Var stackPop() {
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stack.pop();
        }
        return Var.Empty;
    }

    public void callStackPush(String val) {
        this.exec.callStack.push(val.toUpperCase());
    }

    public String callStackPeek() {
        if (!this.exec.callStack.isEmpty()) {
            return this.exec.callStack.peek();
        }
        return null;
    }

    public String callStackPop() {
        if (!this.exec.callStack.isEmpty()) {
            return this.exec.callStack.pop();
        }
        return null;
    }

    public Var findVariable(String name) {
        Var var = null;
        String name1 = name;
        String name1a = null;
        String name2 = null;
        Scope cur = this.exec.currentScope;
        Package pack = null;
        Package packCallContext = this.exec.getPackageCallContext();
        ArrayList<String> qualified = this.exec.meta.splitIdentifier(name);
        if (qualified != null) {
            name1 = qualified.get(0);
            name2 = qualified.get(1);
            pack = this.findPackage(name1);
            if (pack != null && (var = pack.findVariable(name2)) != null) {
                return var;
            }
        }
        if (name1.startsWith(":")) {
            name1a = name1.substring(1);
        }
        while (cur != null) {
            var = this.findVariable(cur.vars, name1);
            if (var == null && name1a != null) {
                var = this.findVariable(cur.vars, name1a);
            }
            if (var == null && packCallContext != null) {
                var = packCallContext.findVariable(name1);
            }
            if (var != null) {
                if (qualified != null && var.type == Var.Type.ROW && var.value != null) {
                    Row row = (Row)var.value;
                    var = row.getValue(name2);
                }
                return var;
            }
            if (cur.type == Scope.Type.ROUTINE) {
                cur = this.exec.globalScope;
                continue;
            }
            cur = cur.parent;
        }
        return null;
    }

    public Var findVariable(Var name) {
        return this.findVariable(name.getName());
    }

    Var findVariable(ArrayList<Var> vars, String name) {
        for (Var var : vars) {
            if (!name.equalsIgnoreCase(var.getName())) continue;
            return var;
        }
        return null;
    }

    public Var findCursor(String name) {
        Var cursor = this.exec.findVariable(name);
        if (cursor != null && cursor.type == Var.Type.CURSOR) {
            return cursor;
        }
        return null;
    }

    Package findPackage(String name) {
        return this.packages.get(name.toUpperCase());
    }

    public void enterScope(Scope scope) {
        this.exec.scopes.push(scope);
    }

    public void enterScope(Scope.Type type) {
        this.enterScope(type, null);
    }

    public void enterScope(Scope.Type type, Package pack) {
        this.exec.currentScope = new Scope(this.exec.currentScope, type, pack);
        this.enterScope(this.exec.currentScope);
    }

    void enterGlobalScope() {
        this.currentScope = this.globalScope = new Scope(Scope.Type.GLOBAL);
        this.enterScope(this.globalScope);
    }

    public void leaveScope() {
        if (!this.exec.signals.empty()) {
            Scope scope = this.exec.scopes.peek();
            Signal signal = this.exec.signals.peek();
            if (this.exec.conf.onError != OnError.SETERROR) {
                this.runExitHandler();
            }
            if (signal.type == Signal.Type.LEAVE_ROUTINE && scope.type == Scope.Type.ROUTINE) {
                this.exec.signals.pop();
            }
        }
        this.exec.currentScope = this.exec.scopes.pop().getParent();
    }

    public void signal(Signal signal) {
        this.exec.signals.push(signal);
    }

    public void signal(Signal.Type type, String value, Exception exception) {
        this.signal(new Signal(type, value, exception));
    }

    public void signal(Signal.Type type, String value) {
        this.setSqlCode(-1);
        this.signal(type, value, null);
    }

    public void signal(Signal.Type type) {
        this.setSqlCode(-1);
        this.signal(type, null, null);
    }

    public void signal(Query query) {
        this.setSqlCode(query.getException());
        this.signal(Signal.Type.SQLEXCEPTION, query.errorText(), query.getException());
    }

    public void signal(Exception exception) {
        this.setSqlCode(exception);
        this.signal(Signal.Type.SQLEXCEPTION, exception.getMessage(), exception);
    }

    public void resignal() {
        this.resignal(this.exec.currentSignal);
    }

    public void resignal(Signal signal) {
        if (signal != null) {
            this.exec.resignal = true;
            this.signal(signal);
        }
    }

    boolean runContinueHandler() {
        Scope cur = this.exec.currentScope;
        this.exec.currentSignal = this.exec.signals.pop();
        while (cur != null) {
            for (Handler h : cur.handlers) {
                if (h.execType != Handler.ExecType.CONTINUE || (h.type == Signal.Type.USERDEFINED || h.type != this.exec.currentSignal.type) && (h.type != Signal.Type.USERDEFINED || h.type != this.exec.currentSignal.type || !h.value.equalsIgnoreCase(this.exec.currentSignal.value))) continue;
                this.trace(h.ctx, "CONTINUE HANDLER");
                this.enterScope(Scope.Type.HANDLER);
                this.exec.currentHandlerScope = h.scope;
                this.visit((ParseTree)h.ctx.single_block_stmt());
                this.leaveScope();
                this.exec.currentSignal = null;
                return true;
            }
            cur = cur.parent;
        }
        this.exec.signals.push(this.exec.currentSignal);
        this.exec.currentSignal = null;
        return false;
    }

    boolean runExitHandler() {
        this.exec.currentSignal = this.exec.signals.pop();
        for (Handler h : this.currentScope.handlers) {
            if (h.execType != Handler.ExecType.EXIT || (h.type == Signal.Type.USERDEFINED || h.type != this.exec.currentSignal.type) && (h.type != Signal.Type.USERDEFINED || h.type != this.exec.currentSignal.type || !h.value.equalsIgnoreCase(this.currentSignal.value))) continue;
            this.trace(h.ctx, "EXIT HANDLER");
            this.enterScope(Scope.Type.HANDLER);
            this.exec.currentHandlerScope = h.scope;
            this.visit((ParseTree)h.ctx.single_block_stmt());
            this.leaveScope();
            this.exec.currentSignal = null;
            return true;
        }
        this.exec.signals.push(this.exec.currentSignal);
        this.exec.currentSignal = null;
        return false;
    }

    public Signal signalPop() {
        if (!this.exec.signals.empty()) {
            return this.exec.signals.pop();
        }
        return null;
    }

    public Signal signalPeek() {
        if (!this.exec.signals.empty()) {
            return this.exec.signals.peek();
        }
        return null;
    }

    public String labelPop() {
        if (!this.exec.labels.empty()) {
            return this.exec.labels.pop();
        }
        return "";
    }

    public Query executeQuery(ParserRuleContext ctx, Query query, String connProfile) {
        if (!this.exec.offline) {
            this.exec.rowCount = 0;
            this.exec.conn.executeQuery(query, connProfile);
            return query;
        }
        this.setSqlNoData();
        this.info(ctx, "Not executed - offline mode set");
        return query;
    }

    public Query executeQuery(ParserRuleContext ctx, String sql, String connProfile) {
        return this.executeQuery(ctx, new Query(sql), connProfile);
    }

    public Query prepareQuery(ParserRuleContext ctx, Query query, String connProfile) {
        if (!this.exec.offline) {
            this.exec.rowCount = 0;
            this.exec.conn.prepareQuery(query, connProfile);
            return query;
        }
        this.setSqlNoData();
        this.info(ctx, "Not executed - offline mode set");
        return query;
    }

    public Query prepareQuery(ParserRuleContext ctx, String sql, String connProfile) {
        return this.prepareQuery(ctx, new Query(sql), connProfile);
    }

    public Query executeSql(ParserRuleContext ctx, String sql, String connProfile) {
        if (!this.exec.offline) {
            this.exec.rowCount = 0;
            Query query = this.conn.executeSql(sql, connProfile);
            this.exec.rowCount = query.getRowCount();
            return query;
        }
        this.info(ctx, "Not executed - offline mode set");
        return new Query("");
    }

    public void closeQuery(Query query, String conn) {
        if (!this.exec.offline) {
            this.exec.conn.closeQuery(query, conn);
        }
    }

    public void registerUdf() {
        String lu;
        if (this.udfRegistered) {
            return;
        }
        ArrayList<String> sql = new ArrayList<String>();
        String dir = Utils.getExecDir();
        sql.add("ADD JAR " + dir + "hplsql.jar");
        sql.add("ADD JAR " + dir + "antlr-runtime-4.5.jar");
        sql.add("ADD FILE " + dir + "hplsql-site.xml");
        if (this.dotHplsqlrcExists) {
            sql.add("ADD FILE " + dir + ".hplsqlrc");
        }
        if (this.hplsqlrcExists) {
            sql.add("ADD FILE " + dir + "hplsqlrc");
        }
        if ((lu = this.createLocalUdf()) != null) {
            sql.add("ADD FILE " + lu);
        }
        sql.add("CREATE TEMPORARY FUNCTION hplsql AS 'org.apache.hive.hplsql.Udf'");
        this.exec.conn.addPreSql(this.exec.conf.defaultConnection, sql);
        this.udfRegistered = true;
    }

    void initOptions() {
        Iterator i = this.exec.conf.iterator();
        while (i.hasNext()) {
            Map.Entry item = (Map.Entry)i.next();
            String key = (String)item.getKey();
            String value = (String)item.getValue();
            if (key == null || value == null || !key.startsWith("hplsql.")) continue;
            if (key.compareToIgnoreCase("hplsql.conn.default") == 0) {
                this.exec.conf.defaultConnection = value;
                continue;
            }
            if (key.startsWith("hplsql.conn.init.")) {
                this.exec.conn.addConnectionInit(key.substring(17), value);
                continue;
            }
            if (key.startsWith("hplsql.conn.convert.")) {
                this.exec.conf.setConnectionConvert(key.substring(20), value);
                continue;
            }
            if (key.startsWith("hplsql.conn.")) {
                this.exec.conn.addConnection(key.substring(12), value);
                continue;
            }
            if (!key.startsWith("hplsql.")) continue;
            this.exec.conf.setOption(key, value);
        }
    }

    public void setSqlCode(int sqlcode) {
        Var var = this.findVariable(SQLCODE);
        if (var != null) {
            var.setValue(new Long(sqlcode));
        }
    }

    public void setSqlCode(Exception exception) {
        if (exception instanceof SQLException) {
            this.setSqlCode(((SQLException)exception).getErrorCode());
            this.setSqlState(((SQLException)exception).getSQLState());
        } else {
            this.setSqlCode(-1);
            this.setSqlState("02000");
        }
    }

    public void setSqlState(String sqlstate) {
        Var var = this.findVariable(SQLSTATE);
        if (var != null) {
            var.setValue(sqlstate);
        }
    }

    public void setHostCode(int code) {
        Var var = this.findVariable(HOSTCODE);
        if (var != null) {
            var.setValue(new Long(code));
        }
    }

    public void setSqlSuccess() {
        this.setSqlCode(0);
        this.setSqlState("00000");
    }

    public void setSqlNoData() {
        this.setSqlCode(100);
        this.setSqlState("01000");
    }

    public Integer run(String[] args) throws Exception {
        this.enterGlobalScope();
        if (this.init(args) != 0) {
            return 1;
        }
        Var result = this.run();
        if (result != null) {
            System.out.println(result.toString());
        }
        this.leaveScope();
        this.cleanup();
        this.printExceptions();
        return this.getProgramReturnCode();
    }

    public Var run() {
        if (this.tree == null) {
            return null;
        }
        if (this.execMain != null) {
            this.initRoutines = true;
            this.visit(this.tree);
            this.initRoutines = false;
            this.exec.function.execProc(this.execMain);
        } else {
            this.visit(this.tree);
        }
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stackPop();
        }
        return null;
    }

    Integer init(String[] args) throws Exception {
        if (!this.parseArguments(args)) {
            return 1;
        }
        System.setProperty("log4j.configurationFile", "hive-log4j2.properties");
        this.conf = new Conf();
        this.conf.init();
        this.conn = new Conn(this);
        this.meta = new Meta(this);
        this.initOptions();
        this.expr = new Expression(this);
        this.select = new Select(this);
        this.stmt = new Stmt(this);
        this.converter = new Converter(this);
        this.function = new Function(this);
        new FunctionDatetime(this).register(this.function);
        new FunctionMisc(this).register(this.function);
        new FunctionString(this).register(this.function);
        new FunctionOra(this).register(this.function);
        this.addVariable(new Var(SQLCODE, Var.Type.BIGINT, 0L));
        this.addVariable(new Var(SQLSTATE, Var.Type.STRING, "00000"));
        this.addVariable(new Var(HOSTCODE, Var.Type.BIGINT, 0L));
        for (Map.Entry<String, String> v : this.arguments.getVars().entrySet()) {
            this.addVariable(new Var(v.getKey(), Var.Type.STRING, v.getValue()));
        }
        InputStream input = null;
        input = this.execString != null ? new ByteArrayInputStream(this.execString.getBytes("UTF-8")) : new FileInputStream(this.execFile);
        HplsqlLexer lexer = new HplsqlLexer((CharStream)new ANTLRInputStream(input));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        HplsqlParser parser = new HplsqlParser((TokenStream)tokens);
        this.tree = parser.program();
        if (this.trace) {
            System.err.println("Configuration file: " + this.conf.getLocation());
            System.err.println("Parser tree: " + this.tree.toStringTree((Parser)parser));
        }
        this.includeRcFile();
        return 0;
    }

    boolean parseArguments(String[] args) {
        boolean parsed = this.arguments.parse(args);
        if (parsed && this.arguments.hasVersionOption()) {
            System.err.println(VERSION);
            return false;
        }
        if (!parsed || this.arguments.hasHelpOption() || this.arguments.getExecString() == null && this.arguments.getFileName() == null) {
            this.arguments.printHelp();
            return false;
        }
        this.execString = this.arguments.getExecString();
        this.execFile = this.arguments.getFileName();
        this.execMain = this.arguments.getMain();
        if (this.arguments.hasTraceOption()) {
            this.trace = true;
        }
        if (this.arguments.hasOfflineOption()) {
            this.offline = true;
        }
        if (this.execString != null && this.execFile != null) {
            System.err.println("The '-e' and '-f' options cannot be specified simultaneously.");
            return false;
        }
        return true;
    }

    void includeRcFile() {
        if (this.includeFile(".hplsqlrc")) {
            this.dotHplsqlrcExists = true;
        } else if (this.includeFile("hplsqlrc")) {
            this.hplsqlrcExists = true;
        }
        if (this.udfRun) {
            this.includeFile("hplsql_locals.sql");
        }
    }

    boolean includeFile(String file) {
        try {
            String content = FileUtils.readFileToString((File)new File(file), (String)"UTF-8");
            if (content != null && !content.isEmpty()) {
                if (this.trace) {
                    this.trace(null, "INLCUDE CONTENT " + file + " (non-empty)");
                }
                new Exec(this).include(content);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void include(String content) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        HplsqlLexer lexer = new HplsqlLexer((CharStream)new ANTLRInputStream((InputStream)input));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        HplsqlParser parser = new HplsqlParser((TokenStream)tokens);
        HplsqlParser.ProgramContext tree = parser.program();
        this.visit((ParseTree)tree);
    }

    @Override
    public Integer visitProgram(HplsqlParser.ProgramContext ctx) {
        Integer rc = (Integer)this.visitChildren((RuleNode)ctx);
        return rc;
    }

    @Override
    public Integer visitBegin_end_block(HplsqlParser.Begin_end_blockContext ctx) {
        this.enterScope(Scope.Type.BEGIN_END);
        Integer rc = (Integer)this.visitChildren((RuleNode)ctx);
        this.leaveScope();
        return rc;
    }

    void cleanup() {
        for (Map.Entry<String, String> i : this.managedTables.entrySet()) {
            String sql = "DROP TABLE IF EXISTS " + i.getValue();
            Query query = this.executeSql(null, sql, this.exec.conf.defaultConnection);
            this.closeQuery(query, this.exec.conf.defaultConnection);
            if (!this.trace) continue;
            this.trace(null, sql);
        }
    }

    void printExceptions() {
        while (!this.signals.empty()) {
            Signal sig = this.signals.pop();
            if (sig.type == Signal.Type.SQLEXCEPTION) {
                System.err.println("Unhandled exception in HPL/SQL");
            }
            if (sig.exception != null) {
                sig.exception.printStackTrace();
                continue;
            }
            if (sig.value == null) continue;
            System.err.println(sig.value);
        }
    }

    Integer getProgramReturnCode() {
        Integer rc = 0;
        if (!this.signals.empty()) {
            Signal sig = this.signals.pop();
            if (sig.type == Signal.Type.LEAVE_ROUTINE && sig.value != null) {
                try {
                    rc = Integer.parseInt(sig.value);
                }
                catch (NumberFormatException e) {
                    rc = 1;
                }
            }
        }
        return rc;
    }

    @Override
    public Integer visitStmt(HplsqlParser.StmtContext ctx) {
        if (ctx.semicolon_stmt() != null) {
            return 0;
        }
        if (this.initRoutines && ctx.create_procedure_stmt() == null && ctx.create_function_stmt() == null) {
            return 0;
        }
        if (this.exec.resignal) {
            if (this.exec.currentScope != this.exec.currentHandlerScope.parent) {
                return 0;
            }
            this.exec.resignal = false;
        }
        if (!this.exec.signals.empty() && this.exec.conf.onError != OnError.SETERROR && !this.runContinueHandler()) {
            return 0;
        }
        Var prev = this.stackPop();
        if (prev != null && prev.value != null) {
            System.out.println(prev.toString());
        }
        return (Integer)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Integer visitSelect_stmt(HplsqlParser.Select_stmtContext ctx) {
        return this.exec.select.select(ctx);
    }

    @Override
    public Integer visitCte_select_stmt(HplsqlParser.Cte_select_stmtContext ctx) {
        return this.exec.select.cte(ctx);
    }

    @Override
    public Integer visitFullselect_stmt(HplsqlParser.Fullselect_stmtContext ctx) {
        return this.exec.select.fullselect(ctx);
    }

    @Override
    public Integer visitSubselect_stmt(HplsqlParser.Subselect_stmtContext ctx) {
        return this.exec.select.subselect(ctx);
    }

    @Override
    public Integer visitSelect_list(HplsqlParser.Select_listContext ctx) {
        return this.exec.select.selectList(ctx);
    }

    @Override
    public Integer visitFrom_clause(HplsqlParser.From_clauseContext ctx) {
        return this.exec.select.from(ctx);
    }

    @Override
    public Integer visitFrom_table_name_clause(HplsqlParser.From_table_name_clauseContext ctx) {
        return this.exec.select.fromTable(ctx);
    }

    @Override
    public Integer visitFrom_subselect_clause(HplsqlParser.From_subselect_clauseContext ctx) {
        return this.exec.select.fromSubselect(ctx);
    }

    @Override
    public Integer visitFrom_join_clause(HplsqlParser.From_join_clauseContext ctx) {
        return this.exec.select.fromJoin(ctx);
    }

    @Override
    public Integer visitFrom_table_values_clause(HplsqlParser.From_table_values_clauseContext ctx) {
        return this.exec.select.fromTableValues(ctx);
    }

    @Override
    public Integer visitWhere_clause(HplsqlParser.Where_clauseContext ctx) {
        return this.exec.select.where(ctx);
    }

    @Override
    public Integer visitSelect_options_item(HplsqlParser.Select_options_itemContext ctx) {
        return this.exec.select.option(ctx);
    }

    @Override
    public Integer visitColumn_name(HplsqlParser.Column_nameContext ctx) {
        this.stackPush(this.meta.normalizeIdentifierPart(ctx.getText()));
        return 0;
    }

    @Override
    public Integer visitTable_name(HplsqlParser.Table_nameContext ctx) {
        String name = ctx.getText();
        String nameUp = name.toUpperCase();
        String nameNorm = this.meta.normalizeIdentifier(name);
        String actualName = this.exec.managedTables.get(nameUp);
        String conn = this.exec.objectConnMap.get(nameUp);
        if (conn == null) {
            conn = this.conf.defaultConnection;
        }
        this.stmtConnList.add(conn);
        if (actualName != null) {
            this.stackPush(actualName);
            return 0;
        }
        actualName = this.exec.objectMap.get(nameUp);
        if (actualName != null) {
            this.stackPush(actualName);
            return 0;
        }
        this.stackPush(nameNorm);
        return 0;
    }

    @Override
    public Integer visitInsert_stmt(HplsqlParser.Insert_stmtContext ctx) {
        return this.exec.stmt.insert(ctx);
    }

    @Override
    public Integer visitException_block_item(HplsqlParser.Exception_block_itemContext ctx) {
        if (this.exec.signals.empty()) {
            return 0;
        }
        if (this.exec.conf.onError == OnError.SETERROR || this.exec.conf.onError == OnError.STOP) {
            this.exec.signals.pop();
            return 0;
        }
        if (ctx.L_ID().toString().equalsIgnoreCase("OTHERS")) {
            this.trace(ctx, "EXCEPTION HANDLER");
            this.exec.signals.pop();
            this.enterScope(Scope.Type.HANDLER);
            this.visit((ParseTree)ctx.block());
            this.leaveScope();
        }
        return 0;
    }

    @Override
    public Integer visitDeclare_var_item(HplsqlParser.Declare_var_itemContext ctx) {
        String type = null;
        Row row = null;
        String len = null;
        String scale = null;
        Var default_ = null;
        if (ctx.dtype().T_ROWTYPE() != null) {
            row = this.meta.getRowDataType(ctx, this.exec.conf.defaultConnection, ctx.dtype().L_ID().getText());
            if (row == null) {
                type = "DERIVED%ROWTYPE";
            }
        } else {
            type = this.getDataType(ctx);
            if (ctx.dtype_len() != null) {
                len = ctx.dtype_len().L_INT(0).getText();
                if (ctx.dtype_len().L_INT(1) != null) {
                    scale = ctx.dtype_len().L_INT(1).getText();
                }
            }
            if (ctx.dtype_default() != null) {
                default_ = this.evalPop(ctx.dtype_default());
            }
        }
        int cnt = ctx.ident().size();
        for (int i = 0; i < cnt; ++i) {
            String name = ctx.ident(i).getText();
            if (row == null) {
                Var var = new Var(name, type, len, scale, default_);
                this.exec.addVariable(var);
                if (ctx.T_CONSTANT() != null) {
                    var.setConstant(true);
                }
                if (!this.trace) continue;
                if (default_ != null) {
                    this.trace(ctx, "DECLARE " + name + " " + type + " = " + var.toSqlString());
                    continue;
                }
                this.trace(ctx, "DECLARE " + name + " " + type);
                continue;
            }
            this.exec.addVariable(new Var(name, row));
            if (!this.trace) continue;
            this.trace(ctx, "DECLARE " + name + " " + ctx.dtype().getText());
        }
        return 0;
    }

    String getDataType(HplsqlParser.Declare_var_itemContext ctx) {
        String type = null;
        if (ctx.dtype().T_TYPE() != null) {
            type = this.meta.getDataType(ctx, this.exec.conf.defaultConnection, ctx.dtype().L_ID().getText());
            if (type == null) {
                type = "DERIVED%TYPE";
            }
        } else {
            type = this.getFormattedText(ctx.dtype());
        }
        return type;
    }

    @Override
    public Integer visitAllocate_cursor_stmt(HplsqlParser.Allocate_cursor_stmtContext ctx) {
        return this.exec.stmt.allocateCursor(ctx);
    }

    @Override
    public Integer visitAssociate_locator_stmt(HplsqlParser.Associate_locator_stmtContext ctx) {
        return this.exec.stmt.associateLocator(ctx);
    }

    @Override
    public Integer visitDeclare_cursor_item(HplsqlParser.Declare_cursor_itemContext ctx) {
        return this.exec.stmt.declareCursor(ctx);
    }

    @Override
    public Integer visitDrop_stmt(HplsqlParser.Drop_stmtContext ctx) {
        return this.exec.stmt.drop(ctx);
    }

    @Override
    public Integer visitOpen_stmt(HplsqlParser.Open_stmtContext ctx) {
        return this.exec.stmt.open(ctx);
    }

    @Override
    public Integer visitFetch_stmt(HplsqlParser.Fetch_stmtContext ctx) {
        return this.exec.stmt.fetch(ctx);
    }

    @Override
    public Integer visitClose_stmt(HplsqlParser.Close_stmtContext ctx) {
        return this.exec.stmt.close(ctx);
    }

    @Override
    public Integer visitCmp_stmt(HplsqlParser.Cmp_stmtContext ctx) {
        return new Cmp(this.exec).run(ctx);
    }

    @Override
    public Integer visitCopy_stmt(HplsqlParser.Copy_stmtContext ctx) {
        return new Copy(this.exec).run(ctx);
    }

    @Override
    public Integer visitCopy_from_local_stmt(HplsqlParser.Copy_from_local_stmtContext ctx) {
        return new Copy(this.exec).runFromLocal(ctx);
    }

    @Override
    public Integer visitDeclare_handler_item(HplsqlParser.Declare_handler_itemContext ctx) {
        this.trace(ctx, "DECLARE HANDLER");
        Handler.ExecType execType = Handler.ExecType.EXIT;
        Signal.Type type = Signal.Type.SQLEXCEPTION;
        String value = null;
        if (ctx.T_CONTINUE() != null) {
            execType = Handler.ExecType.CONTINUE;
        }
        if (ctx.ident() != null) {
            type = Signal.Type.USERDEFINED;
            value = ctx.ident().getText();
        } else if (ctx.T_NOT() != null && ctx.T_FOUND() != null) {
            type = Signal.Type.NOTFOUND;
        }
        this.addHandler(new Handler(execType, type, value, this.exec.currentScope, ctx));
        return 0;
    }

    @Override
    public Integer visitDeclare_condition_item(HplsqlParser.Declare_condition_itemContext ctx) {
        return 0;
    }

    @Override
    public Integer visitDeclare_temporary_table_item(HplsqlParser.Declare_temporary_table_itemContext ctx) {
        return this.exec.stmt.declareTemporaryTable(ctx);
    }

    @Override
    public Integer visitCreate_table_stmt(HplsqlParser.Create_table_stmtContext ctx) {
        return this.exec.stmt.createTable(ctx);
    }

    @Override
    public Integer visitCreate_table_options_hive_item(HplsqlParser.Create_table_options_hive_itemContext ctx) {
        return this.exec.stmt.createTableHiveOptions(ctx);
    }

    @Override
    public Integer visitCreate_table_options_ora_item(HplsqlParser.Create_table_options_ora_itemContext ctx) {
        return 0;
    }

    @Override
    public Integer visitCreate_table_options_mssql_item(HplsqlParser.Create_table_options_mssql_itemContext ctx) {
        return 0;
    }

    @Override
    public Integer visitCreate_local_temp_table_stmt(HplsqlParser.Create_local_temp_table_stmtContext ctx) {
        return this.exec.stmt.createLocalTemporaryTable(ctx);
    }

    @Override
    public Integer visitCreate_function_stmt(HplsqlParser.Create_function_stmtContext ctx) {
        this.exec.function.addUserFunction(ctx);
        this.addLocalUdf(ctx);
        return 0;
    }

    @Override
    public Integer visitCreate_package_stmt(HplsqlParser.Create_package_stmtContext ctx) {
        String name = ctx.ident(0).getText().toUpperCase();
        this.currentPackageDecl = new Package(name, this.exec);
        this.packages.put(name, this.currentPackageDecl);
        this.trace(ctx, "CREATE PACKAGE");
        this.currentPackageDecl.createSpecification(ctx);
        this.currentPackageDecl = null;
        return 0;
    }

    @Override
    public Integer visitCreate_package_body_stmt(HplsqlParser.Create_package_body_stmtContext ctx) {
        String name = ctx.ident(0).getText().toUpperCase();
        this.currentPackageDecl = this.packages.get(name);
        if (this.currentPackageDecl == null) {
            this.currentPackageDecl = new Package(name, this.exec);
            this.currentPackageDecl.setAllMembersPublic(true);
            this.packages.put(name, this.currentPackageDecl);
        }
        this.trace(ctx, "CREATE PACKAGE BODY");
        this.currentPackageDecl.createBody(ctx);
        this.currentPackageDecl = null;
        return 0;
    }

    @Override
    public Integer visitCreate_procedure_stmt(HplsqlParser.Create_procedure_stmtContext ctx) {
        this.exec.function.addUserProcedure(ctx);
        this.addLocalUdf(ctx);
        return 0;
    }

    @Override
    public Integer visitCreate_index_stmt(HplsqlParser.Create_index_stmtContext ctx) {
        return 0;
    }

    void addLocalUdf(ParserRuleContext ctx) {
        if (this.exec == this) {
            this.localUdf.append(this.exec.getFormattedText(ctx));
            this.localUdf.append("\n");
        }
    }

    String createLocalUdf() {
        if (this.localUdf.length() == 0) {
            return null;
        }
        try {
            String file = System.getProperty("user.dir") + "/" + "hplsql_locals.sql";
            PrintWriter writer = new PrintWriter(file, "UTF-8");
            writer.print(this.localUdf);
            writer.close();
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Integer visitAssignment_stmt_single_item(HplsqlParser.Assignment_stmt_single_itemContext ctx) {
        String name = ctx.ident().getText();
        this.visit((ParseTree)ctx.expr());
        Var var = this.setVariable(name);
        if (this.trace) {
            this.trace(ctx, "SET " + name + " = " + var.toSqlString());
        }
        return 0;
    }

    @Override
    public Integer visitAssignment_stmt_multiple_item(HplsqlParser.Assignment_stmt_multiple_itemContext ctx) {
        int cnt = ctx.ident().size();
        int ecnt = ctx.expr().size();
        for (int i = 0; i < cnt; ++i) {
            String name = ctx.ident(i).getText();
            if (i >= ecnt) continue;
            this.visit((ParseTree)ctx.expr(i));
            Var var = this.setVariable(name);
            if (!this.trace) continue;
            this.trace(ctx, "SET " + name + " = " + var.toString());
        }
        return 0;
    }

    @Override
    public Integer visitAssignment_stmt_select_item(HplsqlParser.Assignment_stmt_select_itemContext ctx) {
        return this.stmt.assignFromSelect(ctx);
    }

    @Override
    public Integer visitExpr(HplsqlParser.ExprContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execSql(ctx);
        } else {
            this.exec.expr.exec(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitBool_expr(HplsqlParser.Bool_exprContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execBoolSql(ctx);
        } else {
            this.exec.expr.execBool(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitBool_expr_binary(HplsqlParser.Bool_expr_binaryContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execBoolBinarySql(ctx);
        } else {
            this.exec.expr.execBoolBinary(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitBool_expr_unary(HplsqlParser.Bool_expr_unaryContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execBoolUnarySql(ctx);
        } else {
            this.exec.expr.execBoolUnary(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitExpr_cursor_attribute(HplsqlParser.Expr_cursor_attributeContext ctx) {
        this.exec.expr.execCursorAttribute(ctx);
        return 0;
    }

    @Override
    public Integer visitExpr_func(HplsqlParser.Expr_funcContext ctx) {
        String name = ctx.ident().getText();
        if (this.exec.buildSql) {
            this.exec.function.execSql(name, ctx.expr_func_params());
        } else {
            Package pack;
            Package packCallContext = this.exec.getPackageCallContext();
            ArrayList<String> qualified = this.exec.meta.splitIdentifier(name);
            boolean executed = false;
            if (qualified != null && (pack = this.findPackage(qualified.get(0))) != null) {
                executed = pack.execFunc(qualified.get(1), ctx.expr_func_params());
            }
            if (!executed && packCallContext != null) {
                executed = packCallContext.execFunc(name, ctx.expr_func_params());
            }
            if (!executed) {
                this.exec.function.exec(name, ctx.expr_func_params());
            }
        }
        return 0;
    }

    @Override
    public Integer visitExpr_agg_window_func(HplsqlParser.Expr_agg_window_funcContext ctx) {
        this.exec.function.execAggWindowSql(ctx);
        return 0;
    }

    @Override
    public Integer visitExpr_spec_func(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.exec.buildSql) {
            this.exec.function.specExecSql(ctx);
        } else {
            this.exec.function.specExec(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitInclude_stmt(@NotNull HplsqlParser.Include_stmtContext ctx) {
        return this.exec.stmt.include(ctx);
    }

    @Override
    public Integer visitIf_plsql_stmt(HplsqlParser.If_plsql_stmtContext ctx) {
        return this.exec.stmt.ifPlsql(ctx);
    }

    @Override
    public Integer visitIf_tsql_stmt(HplsqlParser.If_tsql_stmtContext ctx) {
        return this.exec.stmt.ifTsql(ctx);
    }

    @Override
    public Integer visitUse_stmt(HplsqlParser.Use_stmtContext ctx) {
        return this.exec.stmt.use(ctx);
    }

    @Override
    public Integer visitValues_into_stmt(HplsqlParser.Values_into_stmtContext ctx) {
        return this.exec.stmt.values(ctx);
    }

    @Override
    public Integer visitWhile_stmt(HplsqlParser.While_stmtContext ctx) {
        return this.exec.stmt.while_(ctx);
    }

    @Override
    public Integer visitFor_cursor_stmt(HplsqlParser.For_cursor_stmtContext ctx) {
        return this.exec.stmt.forCursor(ctx);
    }

    @Override
    public Integer visitFor_range_stmt(HplsqlParser.For_range_stmtContext ctx) {
        return this.exec.stmt.forRange(ctx);
    }

    @Override
    public Integer visitExec_stmt(HplsqlParser.Exec_stmtContext ctx) {
        this.exec.inCallStmt = true;
        Integer rc = this.exec.stmt.exec(ctx);
        this.exec.inCallStmt = false;
        return rc;
    }

    @Override
    public Integer visitCall_stmt(HplsqlParser.Call_stmtContext ctx) {
        Package pack;
        String name = ctx.ident().getText();
        Package packCallContext = this.exec.getPackageCallContext();
        ArrayList<String> qualified = this.exec.meta.splitIdentifier(name);
        this.exec.inCallStmt = true;
        boolean executed = false;
        if (qualified != null && (pack = this.findPackage(qualified.get(0))) != null) {
            executed = pack.execProc(qualified.get(1), ctx.expr_func_params(), true);
        }
        if (!executed && packCallContext != null) {
            executed = packCallContext.execProc(name, ctx.expr_func_params(), false);
        }
        if (!executed) {
            this.exec.function.execProc(name, ctx.expr_func_params());
        }
        this.exec.inCallStmt = false;
        return 0;
    }

    @Override
    public Integer visitExit_stmt(HplsqlParser.Exit_stmtContext ctx) {
        return this.exec.stmt.exit(ctx);
    }

    @Override
    public Integer visitBreak_stmt(HplsqlParser.Break_stmtContext ctx) {
        return this.exec.stmt.break_(ctx);
    }

    @Override
    public Integer visitLeave_stmt(HplsqlParser.Leave_stmtContext ctx) {
        return this.exec.stmt.leave(ctx);
    }

    @Override
    public Integer visitPrint_stmt(HplsqlParser.Print_stmtContext ctx) {
        return this.exec.stmt.print(ctx);
    }

    @Override
    public Integer visitSignal_stmt(HplsqlParser.Signal_stmtContext ctx) {
        return this.exec.stmt.signal(ctx);
    }

    @Override
    public Integer visitResignal_stmt(HplsqlParser.Resignal_stmtContext ctx) {
        return this.exec.stmt.resignal(ctx);
    }

    @Override
    public Integer visitReturn_stmt(HplsqlParser.Return_stmtContext ctx) {
        return this.exec.stmt.return_(ctx);
    }

    @Override
    public Integer visitSet_current_schema_option(HplsqlParser.Set_current_schema_optionContext ctx) {
        return this.exec.stmt.setCurrentSchema(ctx);
    }

    @Override
    public Integer visitMap_object_stmt(HplsqlParser.Map_object_stmtContext ctx) {
        String source = this.evalPop(ctx.expr(0)).toString();
        String target = null;
        String conn = null;
        if (ctx.T_TO() != null) {
            target = this.evalPop(ctx.expr(1)).toString();
            this.exec.objectMap.put(source.toUpperCase(), target);
        }
        if (ctx.T_AT() != null) {
            conn = ctx.T_TO() == null ? this.evalPop(ctx.expr(1)).toString() : this.evalPop(ctx.expr(2)).toString();
            this.exec.objectConnMap.put(source.toUpperCase(), conn);
        }
        if (this.trace) {
            String log = "MAP OBJECT " + source;
            if (target != null) {
                log = log + " AS " + target;
            }
            if (conn != null) {
                log = log + " AT " + conn;
            }
            this.trace(ctx, log);
        }
        return 0;
    }

    @Override
    public Integer visitUpdate_stmt(HplsqlParser.Update_stmtContext ctx) {
        return this.stmt.update(ctx);
    }

    @Override
    public Integer visitDelete_stmt(HplsqlParser.Delete_stmtContext ctx) {
        return this.stmt.delete(ctx);
    }

    @Override
    public Integer visitMerge_stmt(HplsqlParser.Merge_stmtContext ctx) {
        return this.stmt.merge(ctx);
    }

    @Override
    public Integer visitHive(@NotNull HplsqlParser.HiveContext ctx) {
        this.trace(ctx, "HIVE");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("hive");
        Var params = new Var(Var.Type.STRINGLIST, cmd);
        this.stackPush(params);
        this.visitChildren((RuleNode)ctx);
        this.stackPop();
        try {
            String[] cmdarr = new String[cmd.size()];
            cmd.toArray(cmdarr);
            if (this.trace) {
                this.trace(ctx, "HIVE Parameters: " + Utils.toString(cmdarr, ' '));
            }
            if (!this.offline) {
                Process p = Runtime.getRuntime().exec(cmdarr);
                new StreamGobbler(p.getInputStream()).start();
                new StreamGobbler(p.getErrorStream()).start();
                int rc = p.waitFor();
                if (this.trace) {
                    this.trace(ctx, "HIVE Process exit code: " + rc);
                }
            }
        }
        catch (Exception e) {
            this.setSqlCode(-1);
            this.signal(Signal.Type.SQLEXCEPTION, e.getMessage(), e);
            return -1;
        }
        return 0;
    }

    @Override
    public Integer visitHive_item(HplsqlParser.Hive_itemContext ctx) {
        Var params = this.stackPeek();
        ArrayList a = (ArrayList)params.value;
        if (ctx.P_e() != null) {
            a.add("-e");
            a.add(this.evalPop(ctx.expr()).toString());
        } else if (ctx.P_f() != null) {
            a.add("-f");
            a.add(this.evalPop(ctx.expr()).toString());
        } else if (ctx.P_hiveconf() != null) {
            a.add("-hiveconf");
            a.add(ctx.L_ID().toString() + "=" + this.evalPop(ctx.expr()).toString());
        }
        return 0;
    }

    @Override
    public Integer visitHost_cmd(HplsqlParser.Host_cmdContext ctx) {
        this.trace(ctx, "HOST");
        this.execHost(ctx, ctx.start.getInputStream().getText(new org.antlr.v4.runtime.misc.Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex())));
        return 0;
    }

    @Override
    public Integer visitHost_stmt(HplsqlParser.Host_stmtContext ctx) {
        this.trace(ctx, "HOST");
        this.execHost(ctx, this.evalPop(ctx.expr()).toString());
        return 0;
    }

    public void execHost(ParserRuleContext ctx, String cmd) {
        try {
            if (this.trace) {
                this.trace(ctx, "HOST Command: " + cmd);
            }
            Process p = Runtime.getRuntime().exec(cmd);
            new StreamGobbler(p.getInputStream()).start();
            new StreamGobbler(p.getErrorStream()).start();
            int rc = p.waitFor();
            if (this.trace) {
                this.trace(ctx, "HOST Process exit code: " + rc);
            }
            this.setHostCode(rc);
        }
        catch (Exception e) {
            this.setHostCode(1);
            this.signal(Signal.Type.SQLEXCEPTION);
        }
    }

    @Override
    public Integer visitExpr_stmt(HplsqlParser.Expr_stmtContext ctx) {
        this.visitChildren((RuleNode)ctx);
        return 0;
    }

    @Override
    public Integer visitExpr_concat(HplsqlParser.Expr_concatContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.operatorConcatSql(ctx);
        } else {
            this.exec.expr.operatorConcat(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitExpr_case_simple(HplsqlParser.Expr_case_simpleContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execSimpleCaseSql(ctx);
        } else {
            this.exec.expr.execSimpleCase(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitExpr_case_searched(HplsqlParser.Expr_case_searchedContext ctx) {
        if (this.exec.buildSql) {
            this.exec.expr.execSearchedCaseSql(ctx);
        } else {
            this.exec.expr.execSearchedCase(ctx);
        }
        return 0;
    }

    @Override
    public Integer visitGet_diag_stmt_exception_item(HplsqlParser.Get_diag_stmt_exception_itemContext ctx) {
        return this.exec.stmt.getDiagnosticsException(ctx);
    }

    @Override
    public Integer visitGet_diag_stmt_rowcount_item(HplsqlParser.Get_diag_stmt_rowcount_itemContext ctx) {
        return this.exec.stmt.getDiagnosticsRowCount(ctx);
    }

    @Override
    public Integer visitGrant_stmt(HplsqlParser.Grant_stmtContext ctx) {
        this.trace(ctx, "GRANT");
        return 0;
    }

    @Override
    public Integer visitLabel(HplsqlParser.LabelContext ctx) {
        if (ctx.L_ID() != null) {
            this.exec.labels.push(ctx.L_ID().toString());
        } else {
            String label = ctx.L_LABEL().getText();
            if (label.endsWith(":")) {
                label = label.substring(0, label.length() - 1);
            }
            this.exec.labels.push(label);
        }
        return 0;
    }

    @Override
    public Integer visitIdent(HplsqlParser.IdentContext ctx) {
        String ident = ctx.getText();
        Var var = this.findVariable(ident);
        if (var != null) {
            if (!this.exec.buildSql) {
                this.exec.stackPush(var);
            } else {
                this.exec.stackPush(new Var(ident, Var.Type.STRING, var.toSqlString()));
            }
        } else {
            if (!this.exec.buildSql && !this.exec.inCallStmt && this.exec.function.isProc(ident) && this.exec.function.execProc(ident, null)) {
                return 0;
            }
            this.exec.stackPush(new Var(Var.Type.IDENT, ident));
        }
        return 0;
    }

    @Override
    public Integer visitSingle_quotedString(HplsqlParser.Single_quotedStringContext ctx) {
        if (this.exec.buildSql) {
            this.exec.stackPush(ctx.getText());
        } else {
            this.exec.stackPush(Utils.unquoteString(ctx.getText()));
        }
        return 0;
    }

    @Override
    public Integer visitInt_number(HplsqlParser.Int_numberContext ctx) {
        this.exec.stack.push(new Var(new Long(ctx.getText())));
        return 0;
    }

    @Override
    public Integer visitInterval_number(HplsqlParser.Interval_numberContext ctx) {
        int num = this.evalPop(ctx.int_number()).intValue();
        Interval interval = new Interval().set(num, ctx.interval_item().getText());
        this.stackPush(new Var(interval));
        return 0;
    }

    @Override
    public Integer visitDec_number(HplsqlParser.Dec_numberContext ctx) {
        this.stackPush(new Var(new BigDecimal(ctx.getText())));
        return 0;
    }

    @Override
    public Integer visitBool_literal(HplsqlParser.Bool_literalContext ctx) {
        boolean val = true;
        if (ctx.T_FALSE() != null) {
            val = false;
        }
        this.stackPush(new Var(new Boolean(val)));
        return 0;
    }

    @Override
    public Integer visitNull_const(HplsqlParser.Null_constContext ctx) {
        this.stackPush(new Var());
        return 0;
    }

    @Override
    public Integer visitDate_literal(HplsqlParser.Date_literalContext ctx) {
        if (!this.exec.buildSql) {
            String str = this.evalPop(ctx.string()).toString();
            this.stackPush(new Var(Var.Type.DATE, Utils.toDate(str)));
        } else {
            this.stackPush(this.getFormattedText(ctx));
        }
        return 0;
    }

    @Override
    public Integer visitTimestamp_literal(HplsqlParser.Timestamp_literalContext ctx) {
        if (!this.exec.buildSql) {
            String str = this.evalPop(ctx.string()).toString();
            int len = str.length();
            int precision = 0;
            if (len > 19 && len <= 29 && (precision = len - 20) > 3) {
                precision = 3;
            }
            this.stackPush(new Var(Utils.toTimestamp(str), precision));
        } else {
            this.stackPush(this.getFormattedText(ctx));
        }
        return 0;
    }

    Package getPackageCallContext() {
        Scope cur = this.exec.currentScope;
        while (cur != null) {
            if (cur.type == Scope.Type.ROUTINE) {
                return cur.pack;
            }
            cur = cur.parent;
        }
        return null;
    }

    String getStatementConnection() {
        if (this.exec.stmtConnList.contains(this.exec.conf.defaultConnection)) {
            return this.exec.conf.defaultConnection;
        }
        if (!this.exec.stmtConnList.isEmpty()) {
            return this.exec.stmtConnList.get(0);
        }
        return this.exec.conf.defaultConnection;
    }

    String getObjectConnection(String name) {
        String conn = this.exec.objectConnMap.get(name.toUpperCase());
        if (conn != null) {
            return conn;
        }
        return this.exec.conf.defaultConnection;
    }

    Connection getConnection(String conn) throws Exception {
        if (conn == null || conn.equalsIgnoreCase("default")) {
            conn = this.exec.conf.defaultConnection;
        }
        return this.exec.conn.getConnection(conn);
    }

    void returnConnection(String name, Connection conn) {
        this.exec.conn.returnConnection(name, conn);
    }

    Conn.Type getConnectionType(String conn) {
        return this.exec.conn.getTypeByProfile(conn);
    }

    public Conn.Type getConnectionType() {
        return this.getConnectionType(this.exec.conf.defaultConnection);
    }

    public void addManagedTable(String name, String managedName) {
        this.exec.managedTables.put(name, managedName);
    }

    String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new org.antlr.v4.runtime.misc.Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    String getText(ParserRuleContext ctx, Token start, Token stop) {
        return ctx.start.getInputStream().getText(new org.antlr.v4.runtime.misc.Interval(start.getStartIndex(), stop.getStopIndex()));
    }

    Var evalPop(ParserRuleContext ctx) {
        this.visit((ParseTree)ctx);
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stackPop();
        }
        return Var.Empty;
    }

    Var evalPop(ParserRuleContext ctx, long def) {
        this.visit((ParseTree)ctx);
        if (!this.exec.stack.isEmpty()) {
            return this.stackPop();
        }
        return new Var(def);
    }

    String evalPop(HplsqlParser.DtypeContext type, HplsqlParser.Dtype_lenContext len) {
        if (this.isConvert(this.exec.conf.defaultConnection)) {
            return this.exec.converter.dataType(type, len);
        }
        return this.getText(type, type.getStart(), len.getStop());
    }

    void evalNull() {
        this.stackPush(Var.Null);
    }

    public String getFormattedText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new org.antlr.v4.runtime.misc.Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    void setUdfRun(boolean udfRun) {
        this.udfRun = udfRun;
    }

    boolean isConvert(String connName) {
        return this.exec.conf.getConnectionConvert(connName);
    }

    public int incRowCount() {
        return this.exec.rowCount++;
    }

    public void setRowCount(int rowCount) {
        this.exec.rowCount = rowCount;
    }

    public void trace(ParserRuleContext ctx, String message) {
        if (!this.trace) {
            return;
        }
        if (ctx != null) {
            System.out.println("Ln:" + ctx.getStart().getLine() + " " + message);
        } else {
            System.out.println(message);
        }
    }

    public void trace(ParserRuleContext ctx, Var var, ResultSet rs, ResultSetMetaData rm, int idx) throws SQLException {
        if (var.type != Var.Type.ROW) {
            this.trace(ctx, "COLUMN: " + rm.getColumnName(idx) + ", " + rm.getColumnTypeName(idx));
            this.trace(ctx, "SET " + var.getName() + " = " + var.toString());
        } else {
            Row row = (Row)var.value;
            int cnt = row.size();
            for (int j = 1; j <= cnt; ++j) {
                Var v = row.getValue(j - 1);
                this.trace(ctx, "COLUMN: " + rm.getColumnName(j) + ", " + rm.getColumnTypeName(j));
                this.trace(ctx, "SET " + v.getName() + " = " + v.toString());
            }
        }
    }

    public void info(ParserRuleContext ctx, String message) {
        if (!this.info) {
            return;
        }
        if (ctx != null) {
            System.err.println("Ln:" + ctx.getStart().getLine() + " " + message);
        } else {
            System.err.println(message);
        }
    }

    public Stack<Var> getStack() {
        return this.exec.stack;
    }

    public int getRowCount() {
        return this.exec.rowCount;
    }

    public Conf getConf() {
        return this.exec.conf;
    }

    public Meta getMeta() {
        return this.exec.meta;
    }

    public boolean getTrace() {
        return this.exec.trace;
    }

    public boolean getInfo() {
        return this.exec.info;
    }

    public boolean getOffline() {
        return this.exec.offline;
    }

    public static enum OnError {
        EXCEPTION,
        SETERROR,
        STOP;

    }
}

