/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Stack;
import java.util.UUID;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.hive.hplsql.Conf;
import org.apache.hive.hplsql.Conn;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Meta;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.Row;
import org.apache.hive.hplsql.Scope;
import org.apache.hive.hplsql.Signal;
import org.apache.hive.hplsql.Var;

public class Stmt {
    Exec exec = null;
    Stack<Var> stack = null;
    Conf conf;
    Meta meta;
    boolean trace = false;

    Stmt(Exec e) {
        this.exec = e;
        this.stack = this.exec.getStack();
        this.conf = this.exec.getConf();
        this.meta = this.exec.getMeta();
        this.trace = this.exec.getTrace();
    }

    public Integer allocateCursor(HplsqlParser.Allocate_cursor_stmtContext ctx) {
        this.trace(ctx, "ALLOCATE CURSOR");
        String name = ctx.ident(0).getText();
        Var cur = null;
        if (ctx.T_PROCEDURE() != null) {
            cur = this.exec.consumeReturnCursor(ctx.ident(1).getText());
        } else if (ctx.T_RESULT() != null && (cur = this.exec.findVariable(ctx.ident(1).getText())) != null && cur.type != Var.Type.RS_LOCATOR) {
            cur = null;
        }
        if (cur == null) {
            this.trace(ctx, "Cursor for procedure not found: " + name);
            this.exec.signal(Signal.Type.SQLEXCEPTION);
            return -1;
        }
        this.exec.addVariable(new Var(name, Var.Type.CURSOR, cur.value));
        return 0;
    }

    public Integer associateLocator(HplsqlParser.Associate_locator_stmtContext ctx) {
        this.trace(ctx, "ASSOCIATE LOCATOR");
        int cnt = ctx.ident().size();
        if (cnt < 2) {
            return -1;
        }
        String procedure = ctx.ident(cnt - 1).getText();
        for (int i = 0; i < cnt - 1; ++i) {
            Var cur = this.exec.consumeReturnCursor(procedure);
            if (cur == null) continue;
            String name = ctx.ident(i).getText();
            Var loc = this.exec.findVariable(name);
            if (loc == null) {
                loc = new Var(name, Var.Type.RS_LOCATOR, cur.value);
                this.exec.addVariable(loc);
                continue;
            }
            loc.setValue(cur.value);
        }
        return 0;
    }

    public Integer declareCursor(HplsqlParser.Declare_cursor_itemContext ctx) {
        String name = ctx.ident().getText();
        if (this.trace) {
            this.trace(ctx, "DECLARE CURSOR " + name);
        }
        Query query = new Query();
        if (ctx.expr() != null) {
            query.setExprCtx(ctx.expr());
        } else if (ctx.select_stmt() != null) {
            query.setSelectCtx(ctx.select_stmt());
        }
        if (ctx.cursor_with_return() != null) {
            query.setWithReturn(true);
        }
        Var var = new Var(name, Var.Type.CURSOR, query);
        this.exec.addVariable(var);
        return 0;
    }

    public Integer createTable(HplsqlParser.Create_table_stmtContext ctx) {
        String opt;
        this.trace(ctx, "CREATE TABLE");
        StringBuilder sql = new StringBuilder();
        sql.append(this.exec.getText(ctx, ctx.T_CREATE().getSymbol(), ctx.T_TABLE().getSymbol()));
        sql.append(" " + this.evalPop(ctx.table_name()) + " (");
        int cnt = ctx.create_table_columns().create_table_columns_item().size();
        int cols = 0;
        for (int i = 0; i < cnt; ++i) {
            HplsqlParser.Create_table_columns_itemContext col = ctx.create_table_columns().create_table_columns_item(i);
            if (col.create_table_column_cons() != null) continue;
            if (cols > 0) {
                sql.append(",\n");
            }
            sql.append(this.evalPop(col.column_name()));
            sql.append(" ");
            sql.append(this.exec.evalPop(col.dtype(), col.dtype_len()));
            ++cols;
        }
        sql.append("\n)");
        if (ctx.create_table_options() != null && (opt = this.evalPop(ctx.create_table_options()).toString()) != null) {
            sql.append(" " + opt);
        }
        this.trace(ctx, sql.toString());
        Query query = this.exec.executeSql(ctx, sql.toString(), this.exec.conf.defaultConnection);
        if (query.error()) {
            this.exec.signal(query);
            return 1;
        }
        this.exec.setSqlSuccess();
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        return 0;
    }

    public Integer createTableHiveOptions(HplsqlParser.Create_table_options_hive_itemContext ctx) {
        if (ctx.create_table_hive_row_format() != null) {
            this.createTableHiveRowFormat(ctx.create_table_hive_row_format());
        }
        return 0;
    }

    public Integer createTableHiveRowFormat(HplsqlParser.Create_table_hive_row_formatContext ctx) {
        StringBuilder sql = new StringBuilder();
        sql.append("ROW FORMAT DELIMITED");
        int cnt = ctx.create_table_hive_row_format_fields().size();
        for (int i = 0; i < cnt; ++i) {
            HplsqlParser.Create_table_hive_row_format_fieldsContext c = ctx.create_table_hive_row_format_fields(i);
            if (c.T_FIELDS() != null) {
                sql.append(" FIELDS TERMINATED BY " + this.evalPop(c.expr(0)).toSqlString());
                continue;
            }
            if (c.T_LINES() == null) continue;
            sql.append(" LINES TERMINATED BY " + this.evalPop(c.expr(0)).toSqlString());
        }
        this.evalString(sql);
        return 0;
    }

    public Integer declareTemporaryTable(HplsqlParser.Declare_temporary_table_itemContext ctx) {
        String name = ctx.ident().getText();
        if (this.trace) {
            this.trace(ctx, "DECLARE TEMPORARY TABLE " + name);
        }
        return this.createTemporaryTable(ctx, ctx.create_table_columns(), name);
    }

    public Integer createLocalTemporaryTable(HplsqlParser.Create_local_temp_table_stmtContext ctx) {
        String name = ctx.ident().getText();
        if (this.trace) {
            this.trace(ctx, "CREATE LOCAL TEMPORARY TABLE " + name);
        }
        return this.createTemporaryTable(ctx, ctx.create_table_columns(), name);
    }

    public Integer createTemporaryTable(ParserRuleContext ctx, HplsqlParser.Create_table_columnsContext colCtx, String name) {
        String managedName = null;
        String sql = null;
        String columns = this.exec.getFormattedText(colCtx);
        if (this.conf.tempTables == Conf.TempTables.NATIVE) {
            sql = "CREATE TEMPORARY TABLE " + name + "\n(" + columns + "\n)";
        } else if (this.conf.tempTables == Conf.TempTables.MANAGED) {
            managedName = name + "_" + UUID.randomUUID().toString().replace("-", "");
            if (!this.conf.tempTablesSchema.isEmpty()) {
                managedName = this.conf.tempTablesSchema + "." + managedName;
            }
            sql = "CREATE TABLE " + managedName + "\n(" + columns + "\n)";
            if (!this.conf.tempTablesLocation.isEmpty()) {
                sql = sql + "\nLOCATION '" + this.conf.tempTablesLocation + "/" + managedName + "'";
            }
            if (this.trace) {
                this.trace(ctx, "Managed table name: " + managedName);
            }
        }
        if (sql != null) {
            Query query = this.exec.executeSql(ctx, sql, this.exec.conf.defaultConnection);
            if (query.error()) {
                this.exec.signal(query);
                return 1;
            }
            if (managedName != null) {
                this.exec.addManagedTable(name, managedName);
            }
            this.exec.setSqlSuccess();
            this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        }
        return 0;
    }

    public Integer drop(HplsqlParser.Drop_stmtContext ctx) {
        this.trace(ctx, "DROP");
        String sql = null;
        if (ctx.T_TABLE() != null) {
            sql = "DROP TABLE ";
            if (ctx.T_EXISTS() != null) {
                sql = sql + "IF NOT EXISTS ";
            }
            sql = sql + this.evalPop(ctx.table_name()).toString();
        }
        if (sql != null) {
            this.trace(ctx, sql);
            Query query = this.exec.executeSql(ctx, sql, this.exec.conf.defaultConnection);
            if (query.error()) {
                this.exec.signal(query);
                return 1;
            }
            this.exec.setSqlSuccess();
            this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        }
        return 0;
    }

    public Integer open(HplsqlParser.Open_stmtContext ctx) {
        this.trace(ctx, "OPEN");
        Query query = null;
        Var var = null;
        String cursor = ctx.L_ID().toString();
        String sql = null;
        if (ctx.T_FOR() != null) {
            sql = ctx.expr() != null ? this.evalPop(ctx.expr()).toString() : this.evalPop(ctx.select_stmt()).toString();
            query = new Query(sql);
            var = this.exec.findCursor(cursor);
            if (var == null) {
                var = new Var(cursor, Var.Type.CURSOR, query);
                this.exec.addVariable(var);
            } else {
                var.setValue(query);
            }
        } else {
            var = this.exec.findVariable(cursor);
            if (var != null && var.type == Var.Type.CURSOR) {
                query = (Query)var.value;
                if (query.sqlExpr != null) {
                    sql = this.evalPop(query.sqlExpr).toString();
                    query.setSql(sql);
                } else if (query.sqlSelect != null) {
                    sql = this.evalPop(query.sqlSelect).toString();
                    query.setSql(sql);
                }
            }
        }
        if (query != null) {
            if (this.trace) {
                this.trace(ctx, cursor + ": " + sql);
            }
            this.exec.executeQuery((ParserRuleContext)ctx, query, this.exec.conf.defaultConnection);
            if (query.error()) {
                this.exec.signal(query);
                return 1;
            }
            if (!this.exec.getOffline()) {
                this.exec.setSqlCode(0);
            }
            if (query.getWithReturn()) {
                this.exec.addReturnCursor(var);
            }
        } else {
            this.trace(ctx, "Cursor not found: " + cursor);
            this.exec.setSqlCode(-1);
            this.exec.signal(Signal.Type.SQLEXCEPTION);
            return 1;
        }
        return 0;
    }

    public Integer fetch(HplsqlParser.Fetch_stmtContext ctx) {
        this.trace(ctx, "FETCH");
        String name = ctx.L_ID(0).toString();
        Var cursor = this.exec.findCursor(name);
        if (cursor == null) {
            this.trace(ctx, "Cursor not found: " + name);
            this.exec.setSqlCode(-1);
            this.exec.signal(Signal.Type.SQLEXCEPTION);
            return 1;
        }
        if (cursor.value == null) {
            this.trace(ctx, "Cursor not open: " + name);
            this.exec.setSqlCode(-1);
            this.exec.signal(Signal.Type.SQLEXCEPTION);
            return 1;
        }
        if (this.exec.getOffline()) {
            this.exec.setSqlCode(100);
            this.exec.signal(Signal.Type.NOTFOUND);
            return 0;
        }
        try {
            Query query = (Query)cursor.value;
            ResultSet rs = query.getResultSet();
            ResultSetMetaData rsm = null;
            if (rs != null) {
                rsm = rs.getMetaData();
            }
            if (rs != null && rsm != null) {
                int cols = ctx.L_ID().size() - 1;
                if (rs.next()) {
                    query.setFetch(true);
                    for (int i = 1; i <= cols; ++i) {
                        Var var = this.exec.findVariable(ctx.L_ID(i).getText());
                        if (var != null) {
                            if (var.type != Var.Type.ROW) {
                                var.setValue(rs, rsm, i);
                            } else {
                                var.setValues(rs, rsm);
                            }
                            if (!this.trace) continue;
                            this.trace(ctx, var, rs, rsm, i);
                            continue;
                        }
                        if (!this.trace) continue;
                        this.trace(ctx, "Variable not found: " + ctx.L_ID(i).getText());
                    }
                    this.exec.incRowCount();
                    this.exec.setSqlSuccess();
                } else {
                    query.setFetch(false);
                    this.exec.setSqlCode(100);
                }
            } else {
                this.exec.setSqlCode(-1);
            }
        }
        catch (SQLException e) {
            this.exec.setSqlCode(e);
            this.exec.signal(Signal.Type.SQLEXCEPTION, e.getMessage(), e);
        }
        return 0;
    }

    public Integer close(HplsqlParser.Close_stmtContext ctx) {
        this.trace(ctx, "CLOSE");
        String name = ctx.L_ID().toString();
        Var var = this.exec.findVariable(name);
        if (var != null && var.type == Var.Type.CURSOR) {
            this.exec.closeQuery((Query)var.value, this.exec.conf.defaultConnection);
            this.exec.setSqlCode(0);
        } else if (this.trace) {
            this.trace(ctx, "Cursor not found: " + name);
        }
        return 0;
    }

    public Integer include(HplsqlParser.Include_stmtContext ctx) {
        String file = ctx.file_name() != null ? ctx.file_name().getText() : this.evalPop(ctx.expr()).toString();
        this.trace(ctx, "INCLUDE " + file);
        this.exec.includeFile(file);
        return 0;
    }

    public Integer ifPlsql(HplsqlParser.If_plsql_stmtContext ctx) {
        boolean trueExecuted = false;
        this.trace(ctx, "IF");
        if (this.evalPop(ctx.bool_expr()).isTrue()) {
            this.trace(ctx, "IF TRUE executed");
            this.visit(ctx.block());
            trueExecuted = true;
        } else if (ctx.elseif_block() != null) {
            int cnt = ctx.elseif_block().size();
            for (int i = 0; i < cnt; ++i) {
                if (!this.evalPop(ctx.elseif_block(i).bool_expr()).isTrue()) continue;
                this.trace(ctx, "ELSE IF executed");
                this.visit(ctx.elseif_block(i).block());
                trueExecuted = true;
                break;
            }
        }
        if (!trueExecuted && ctx.else_block() != null) {
            this.trace(ctx, "ELSE executed");
            this.visit(ctx.else_block());
        }
        return 0;
    }

    public Integer ifTsql(HplsqlParser.If_tsql_stmtContext ctx) {
        this.trace(ctx, "IF");
        this.visit(ctx.bool_expr());
        if (this.exec.stackPop().isTrue()) {
            this.trace(ctx, "IF TRUE executed");
            this.visit(ctx.single_block_stmt(0));
        } else if (ctx.T_ELSE() != null) {
            this.trace(ctx, "ELSE executed");
            this.visit(ctx.single_block_stmt(1));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer assignFromSelect(HplsqlParser.Assignment_stmt_select_itemContext ctx) {
        String sql = this.evalPop(ctx.select_stmt()).toString();
        if (this.trace) {
            this.trace(ctx, sql.toString());
        }
        String conn = this.exec.getStatementConnection();
        Query query = this.exec.executeQuery((ParserRuleContext)ctx, sql.toString(), conn);
        if (query.error()) {
            this.exec.signal(query);
            return 1;
        }
        this.exec.setSqlSuccess();
        try {
            ResultSet rs = query.getResultSet();
            ResultSetMetaData rm = null;
            if (rs != null) {
                rm = rs.getMetaData();
                int cnt = ctx.ident().size();
                if (rs.next()) {
                    for (int i = 1; i <= cnt; ++i) {
                        Var var = this.exec.findVariable(ctx.ident(i - 1).getText());
                        if (var != null) {
                            var.setValue(rs, rm, i);
                            if (!this.trace) continue;
                            this.trace(ctx, "COLUMN: " + rm.getColumnName(i) + ", " + rm.getColumnTypeName(i));
                            this.trace(ctx, "SET " + var.getName() + " = " + var.toString());
                            continue;
                        }
                        if (!this.trace) continue;
                        this.trace(ctx, "Variable not found: " + ctx.ident(i - 1).getText());
                    }
                    this.exec.incRowCount();
                    this.exec.setSqlSuccess();
                } else {
                    this.exec.setSqlCode(100);
                    this.exec.signal(Signal.Type.NOTFOUND);
                }
            }
        }
        catch (SQLException e) {
            this.exec.signal(query);
            Integer n = 1;
            return n;
        }
        finally {
            this.exec.closeQuery(query, conn);
        }
        return 0;
    }

    public Integer insert(HplsqlParser.Insert_stmtContext ctx) {
        this.exec.stmtConnList.clear();
        if (ctx.select_stmt() != null) {
            return this.insertSelect(ctx);
        }
        return this.insertValues(ctx);
    }

    public Integer insertSelect(HplsqlParser.Insert_stmtContext ctx) {
        this.trace(ctx, "INSERT SELECT");
        String table = this.evalPop(ctx.table_name()).toString();
        String select = this.evalPop(ctx.select_stmt()).toString();
        String sql = "INSERT INTO TABLE " + table + " " + select;
        this.trace(ctx, sql);
        Query query = this.exec.executeSql(ctx, sql, this.exec.conf.defaultConnection);
        if (query.error()) {
            this.exec.signal(query);
            return 1;
        }
        this.exec.setSqlSuccess();
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        return 0;
    }

    public Integer insertValues(HplsqlParser.Insert_stmtContext ctx) {
        Query query;
        this.trace(ctx, "INSERT VALUES");
        String table = this.evalPop(ctx.table_name()).toString();
        String conn = this.exec.getObjectConnection(ctx.table_name().getText());
        Conn.Type type = this.exec.getConnectionType(conn);
        StringBuilder sql = new StringBuilder();
        if (type == Conn.Type.HIVE) {
            sql.append("INSERT INTO TABLE " + table + " ");
            if (this.conf.insertValues == Conf.InsertValues.NATIVE) {
                sql.append("VALUES\n(");
            }
        } else {
            sql.append("INSERT INTO " + table);
            if (ctx.insert_stmt_cols() != null) {
                sql.append(" " + this.exec.getFormattedText(ctx.insert_stmt_cols()));
            }
            sql.append(" VALUES\n(");
        }
        int rows = ctx.insert_stmt_rows().insert_stmt_row().size();
        for (int i = 0; i < rows; ++i) {
            HplsqlParser.Insert_stmt_rowContext row = ctx.insert_stmt_rows().insert_stmt_row(i);
            int cols = row.expr().size();
            for (int j = 0; j < cols; ++j) {
                String value = this.evalPop(row.expr(j)).toSqlString();
                if (j == 0 && type == Conn.Type.HIVE && this.conf.insertValues == Conf.InsertValues.SELECT) {
                    sql.append("SELECT ");
                }
                sql.append(value);
                if (j + 1 == cols) continue;
                sql.append(", ");
            }
            if (type != Conn.Type.HIVE || this.conf.insertValues == Conf.InsertValues.NATIVE) {
                if (i + 1 == rows) {
                    sql.append(")");
                    continue;
                }
                sql.append("),\n(");
                continue;
            }
            if (type != Conn.Type.HIVE || this.conf.insertValues != Conf.InsertValues.SELECT) continue;
            sql.append(" FROM " + this.conf.dualTable);
            if (i + 1 >= rows) continue;
            sql.append("\nUNION ALL\n");
        }
        if (this.trace) {
            this.trace(ctx, sql.toString());
        }
        if ((query = this.exec.executeSql(ctx, sql.toString(), conn)).error()) {
            this.exec.signal(query);
            return 1;
        }
        this.exec.setSqlSuccess();
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        return 0;
    }

    public Integer getDiagnosticsException(HplsqlParser.Get_diag_stmt_exception_itemContext ctx) {
        this.trace(ctx, "GET DIAGNOSTICS EXCEPTION");
        Signal signal = this.exec.signalPeek();
        if (signal == null || signal != null && signal.type != Signal.Type.SQLEXCEPTION) {
            signal = this.exec.currentSignal;
        }
        if (signal != null) {
            this.exec.setVariable(ctx.ident().getText(), signal.getValue());
        }
        return 0;
    }

    public Integer getDiagnosticsRowCount(HplsqlParser.Get_diag_stmt_rowcount_itemContext ctx) {
        this.trace(ctx, "GET DIAGNOSTICS ROW_COUNT");
        this.exec.setVariable(ctx.ident().getText(), this.exec.getRowCount());
        return 0;
    }

    public Integer use(HplsqlParser.Use_stmtContext ctx) {
        this.trace(ctx, "USE");
        return this.use(ctx, ctx.T_USE().toString() + " " + this.meta.normalizeIdentifierPart(this.evalPop(ctx.expr()).toString()));
    }

    public Integer use(ParserRuleContext ctx, String sql) {
        Query query;
        if (this.trace) {
            this.trace(ctx, "SQL statement: " + sql);
        }
        if ((query = this.exec.executeSql(ctx, sql, this.exec.conf.defaultConnection)).error()) {
            this.exec.signal(query);
            return 1;
        }
        this.exec.setSqlCode(0);
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        return 0;
    }

    public Integer values(HplsqlParser.Values_into_stmtContext ctx) {
        this.trace(ctx, "VALUES statement");
        int cnt = ctx.ident().size();
        int ecnt = ctx.expr().size();
        for (int i = 0; i < cnt; ++i) {
            String name = ctx.ident(i).getText();
            if (i >= ecnt) continue;
            this.visit(ctx.expr(i));
            Var var = this.exec.setVariable(name);
            if (!this.trace) continue;
            this.trace(ctx, "SET " + name + " = " + var.toString());
        }
        return 0;
    }

    public Integer while_(HplsqlParser.While_stmtContext ctx) {
        this.trace(ctx, "WHILE - ENTERED");
        String label = this.exec.labelPop();
        while (this.evalPop(ctx.bool_expr()).isTrue()) {
            this.exec.enterScope(Scope.Type.LOOP);
            this.visit(ctx.block());
            this.exec.leaveScope();
            if (this.canContinue(label)) continue;
        }
        this.trace(ctx, "WHILE - LEFT");
        return 0;
    }

    public Integer forCursor(HplsqlParser.For_cursor_stmtContext ctx) {
        this.trace(ctx, "FOR CURSOR - ENTERED");
        this.exec.enterScope(Scope.Type.LOOP);
        String cursor = ctx.L_ID().getText();
        String sql = this.evalPop(ctx.select_stmt()).toString();
        this.trace(ctx, sql);
        Query query = this.exec.executeQuery((ParserRuleContext)ctx, sql, this.exec.conf.defaultConnection);
        if (query.error()) {
            this.exec.signal(query);
            return 1;
        }
        this.trace(ctx, "SELECT completed successfully");
        this.exec.setSqlSuccess();
        try {
            ResultSet rs = query.getResultSet();
            if (rs != null) {
                ResultSetMetaData rm = rs.getMetaData();
                int cols = rm.getColumnCount();
                Row row = new Row();
                for (int i = 1; i <= cols; ++i) {
                    row.addColumn(rm.getColumnName(i), rm.getColumnTypeName(i));
                }
                Var var = new Var(cursor, row);
                this.exec.addVariable(var);
                while (rs.next()) {
                    var.setValues(rs, rm);
                    if (this.trace) {
                        this.trace(ctx, var, rs, rm, 0);
                    }
                    this.visit(ctx.block());
                    this.exec.incRowCount();
                }
            }
        }
        catch (SQLException e) {
            this.exec.signal(e);
            this.exec.closeQuery(query, this.exec.conf.defaultConnection);
            return 1;
        }
        this.exec.setSqlSuccess();
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        this.exec.leaveScope();
        this.trace(ctx, "FOR CURSOR - LEFT");
        return 0;
    }

    public Integer forRange(HplsqlParser.For_range_stmtContext ctx) {
        this.trace(ctx, "FOR RANGE - ENTERED");
        int start = this.evalPop(ctx.expr(0)).intValue();
        int end = this.evalPop(ctx.expr(1)).intValue();
        int step = this.evalPop(ctx.expr(2), 1L).intValue();
        this.exec.enterScope(Scope.Type.LOOP);
        Var index = new Var(ctx.L_ID().getText(), new Long(start));
        this.exec.addVariable(index);
        if (ctx.T_REVERSE() == null) {
            for (int i = start; i <= end; i += step) {
                this.visit(ctx.block());
                index.increment(new Long(step));
            }
        } else {
            for (int i = start; i >= end; i -= step) {
                this.visit(ctx.block());
                index.decrement(new Long(step));
            }
        }
        this.exec.leaveScope();
        this.trace(ctx, "FOR RANGE - LEFT");
        return 0;
    }

    public Integer exec(HplsqlParser.Exec_stmtContext ctx) {
        Query query;
        if (this.execProc(ctx).booleanValue()) {
            return 0;
        }
        this.trace(ctx, "EXECUTE");
        Var vsql = this.evalPop(ctx.expr());
        String sql = vsql.toString();
        if (this.trace) {
            this.trace(ctx, "SQL statement: " + sql);
        }
        if ((query = this.exec.executeSql(ctx, sql, this.exec.conf.defaultConnection)).error()) {
            this.exec.signal(query);
            return 1;
        }
        ResultSet rs = query.getResultSet();
        if (rs != null) {
            try {
                ResultSetMetaData rm = rs.getMetaData();
                if (ctx.T_INTO() != null) {
                    int cols = ctx.L_ID().size();
                    if (rs.next()) {
                        for (int i = 0; i < cols; ++i) {
                            Var var = this.exec.findVariable(ctx.L_ID(i).getText());
                            if (var != null) {
                                if (var.type != Var.Type.ROW) {
                                    var.setValue(rs, rm, i + 1);
                                } else {
                                    var.setValues(rs, rm);
                                }
                                if (!this.trace) continue;
                                this.trace(ctx, var, rs, rm, i + 1);
                                continue;
                            }
                            if (!this.trace) continue;
                            this.trace(ctx, "Variable not found: " + ctx.L_ID(i).getText());
                        }
                        this.exec.setSqlCode(0);
                    }
                } else {
                    int cols = rm.getColumnCount();
                    while (rs.next()) {
                        for (int i = 1; i <= cols; ++i) {
                            if (i > 1) {
                                System.out.print("\t");
                            }
                            System.out.print(rs.getString(i));
                        }
                        System.out.println("");
                    }
                }
            }
            catch (SQLException e) {
                this.exec.setSqlCode(e);
            }
        }
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        return 0;
    }

    public Boolean execProc(HplsqlParser.Exec_stmtContext ctx) {
        String name = this.evalPop(ctx.expr()).toString();
        if (this.exec.function.isProc(name) && this.exec.function.execProc(name, ctx.expr_func_params())) {
            return true;
        }
        return false;
    }

    public Integer exit(HplsqlParser.Exit_stmtContext ctx) {
        this.trace(ctx, "EXIT");
        String label = "";
        if (ctx.L_ID() != null) {
            label = ctx.L_ID().toString();
        }
        if (ctx.T_WHEN() != null) {
            if (this.evalPop(ctx.bool_expr()).isTrue()) {
                this.leaveLoop(label);
            }
        } else {
            this.leaveLoop(label);
        }
        return 0;
    }

    public Integer break_(HplsqlParser.Break_stmtContext ctx) {
        this.trace(ctx, "BREAK");
        this.leaveLoop("");
        return 0;
    }

    public Integer leave(HplsqlParser.Leave_stmtContext ctx) {
        this.trace(ctx, "LEAVE");
        String label = "";
        if (ctx.L_ID() != null) {
            label = ctx.L_ID().toString();
        }
        this.leaveLoop(label);
        return 0;
    }

    public void leaveLoop(String value) {
        this.exec.signal(Signal.Type.LEAVE_LOOP, value);
    }

    public Integer update(HplsqlParser.Update_stmtContext ctx) {
        this.trace(ctx, "UPDATE");
        String sql = this.exec.getFormattedText(ctx);
        this.trace(ctx, sql);
        Query query = this.exec.executeSql(ctx, sql, this.exec.conf.defaultConnection);
        if (query.error()) {
            this.exec.signal(query);
            return 1;
        }
        this.exec.setSqlSuccess();
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        return 0;
    }

    public Integer delete(HplsqlParser.Delete_stmtContext ctx) {
        this.trace(ctx, "DELETE");
        String table = this.evalPop(ctx.table_name()).toString();
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(table);
        if (ctx.where_clause() != null) {
            boolean oldBuildSql = this.exec.buildSql;
            this.exec.buildSql = true;
            sql.append(" " + this.evalPop(ctx.where_clause()).toString());
            this.exec.buildSql = oldBuildSql;
        }
        this.trace(ctx, sql.toString());
        Query query = this.exec.executeSql(ctx, sql.toString(), this.exec.conf.defaultConnection);
        if (query.error()) {
            this.exec.signal(query);
            return 1;
        }
        this.exec.setSqlSuccess();
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        return 0;
    }

    public Integer merge(HplsqlParser.Merge_stmtContext ctx) {
        this.trace(ctx, "MERGE");
        String sql = this.exec.getFormattedText(ctx);
        this.trace(ctx, sql);
        Query query = this.exec.executeSql(ctx, sql, this.exec.conf.defaultConnection);
        if (query.error()) {
            this.exec.signal(query);
            return 1;
        }
        this.exec.setSqlSuccess();
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
        return 0;
    }

    public Integer print(HplsqlParser.Print_stmtContext ctx) {
        this.trace(ctx, "PRINT");
        if (ctx.expr() != null) {
            this.visit(ctx.expr());
            System.out.println(this.stack.pop().toString());
        }
        return 0;
    }

    public Integer setCurrentSchema(HplsqlParser.Set_current_schema_optionContext ctx) {
        this.trace(ctx, "SET CURRENT SCHEMA");
        return this.use(ctx, "USE " + this.meta.normalizeIdentifierPart(this.evalPop(ctx.expr()).toString()));
    }

    public Integer signal(HplsqlParser.Signal_stmtContext ctx) {
        this.trace(ctx, "SIGNAL");
        Signal signal = new Signal(Signal.Type.USERDEFINED, ctx.ident().getText());
        this.exec.signal(signal);
        return 0;
    }

    public Integer resignal(HplsqlParser.Resignal_stmtContext ctx) {
        this.trace(ctx, "RESIGNAL");
        if (ctx.T_SQLSTATE() != null) {
            String sqlstate = this.evalPop(ctx.expr(0)).toString();
            String text = "";
            if (ctx.T_MESSAGE_TEXT() != null) {
                text = this.evalPop(ctx.expr(1)).toString();
            }
            SQLException exception = new SQLException(text, sqlstate, -1);
            Signal signal = new Signal(Signal.Type.SQLEXCEPTION, text, exception);
            this.exec.setSqlCode(exception);
            this.exec.resignal(signal);
        } else {
            this.exec.resignal();
        }
        return 0;
    }

    public Integer return_(HplsqlParser.Return_stmtContext ctx) {
        this.trace(ctx, "RETURN");
        if (ctx.expr() != null) {
            this.eval(ctx.expr());
        }
        this.exec.signal(Signal.Type.LEAVE_ROUTINE);
        return 0;
    }

    boolean canContinue(String label) {
        Signal signal = this.exec.signalPeek();
        if (signal != null && signal.type == Signal.Type.SQLEXCEPTION) {
            return false;
        }
        signal = this.exec.signalPeek();
        if (signal != null && signal.type == Signal.Type.LEAVE_LOOP) {
            if (signal.value == null || signal.value.isEmpty() || label != null && label.equalsIgnoreCase(signal.value)) {
                this.exec.signalPop();
            }
            return false;
        }
        return true;
    }

    void eval(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
    }

    void evalString(String string) {
        this.exec.stackPush(new Var(string));
    }

    void evalString(StringBuilder string) {
        this.evalString(string.toString());
    }

    Var evalPop(ParserRuleContext ctx) {
        this.visit(ctx);
        if (!this.exec.stack.isEmpty()) {
            return this.exec.stackPop();
        }
        return Var.Empty;
    }

    Var evalPop(ParserRuleContext ctx, long def) {
        if (ctx != null) {
            this.exec.visit((ParseTree)ctx);
            return this.exec.stackPop();
        }
        return new Var(def);
    }

    Integer visit(ParserRuleContext ctx) {
        return (Integer)this.exec.visit((ParseTree)ctx);
    }

    Integer visitChildren(ParserRuleContext ctx) {
        return (Integer)this.exec.visitChildren((RuleNode)ctx);
    }

    void trace(ParserRuleContext ctx, String message) {
        this.exec.trace(ctx, message);
    }

    void trace(ParserRuleContext ctx, Var var, ResultSet rs, ResultSetMetaData rm, int idx) throws SQLException {
        this.exec.trace(ctx, var, rs, rm, idx);
    }
}

