/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.orc.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hive.orc.impl.HadoopShimsCurrent;
import org.apache.hive.orc.impl.HadoopShims_2_2;

public interface HadoopShims {
    public DirectDecompressor getDirectDecompressor(DirectCompressionType var1);

    public ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream var1, ByteBufferPoolShim var2) throws IOException;

    public TextReaderShim getTextReaderShim(InputStream var1) throws IOException;

    public static class Factory {
        private static HadoopShims SHIMS = null;

        public static synchronized HadoopShims get() {
            if (SHIMS == null) {
                String[] versionParts = VersionInfo.getVersion().split("[.]");
                int major = Integer.parseInt(versionParts[0]);
                int minor = Integer.parseInt(versionParts[1]);
                SHIMS = major < 2 || major == 2 && minor < 3 ? new HadoopShims_2_2() : new HadoopShimsCurrent();
            }
            return SHIMS;
        }
    }

    public static interface TextReaderShim {
        public void read(Text var1, int var2) throws IOException;
    }

    public static interface ZeroCopyReaderShim
    extends Closeable {
        public ByteBuffer readBuffer(int var1, boolean var2) throws IOException;

        public void releaseBuffer(ByteBuffer var1);

        @Override
        public void close() throws IOException;
    }

    public static interface ByteBufferPoolShim {
        public ByteBuffer getBuffer(boolean var1, int var2);

        public void putBuffer(ByteBuffer var1);
    }

    public static interface DirectDecompressor {
        public void decompress(ByteBuffer var1, ByteBuffer var2) throws IOException;
    }

    public static enum DirectCompressionType {
        NONE,
        ZLIB_NOHEADER,
        ZLIB,
        SNAPPY;

    }
}

