/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;

public class TcpDiscoveryS3IpFinder
extends TcpDiscoveryIpFinderAdapter {
    public static final String DELIM = "#";
    private static final byte[] ENTRY_CONTENT = new byte[]{1};
    private static final ObjectMetadata ENTRY_METADATA = new ObjectMetadata();
    @LoggerResource
    private IgniteLogger log;
    @GridToStringExclude
    private AmazonS3 s3;
    private String bucketName;
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private ClientConfiguration cfg;
    @GridToStringExclude
    private AWSCredentials cred;

    public TcpDiscoveryS3IpFinder() {
        this.setShared(true);
    }

    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        this.initClient();
        LinkedList<InetSocketAddress> addrs = new LinkedList<InetSocketAddress>();
        try {
            ObjectListing list = this.s3.listObjects(this.bucketName);
            while (true) {
                for (S3ObjectSummary sum : list.getObjectSummaries()) {
                    String key = sum.getKey();
                    StringTokenizer st = new StringTokenizer(key, DELIM);
                    if (st.countTokens() != 2) {
                        U.error((IgniteLogger)this.log, (Object)("Failed to parse S3 entry due to invalid format: " + key));
                        continue;
                    }
                    String addrStr = st.nextToken();
                    String portStr = st.nextToken();
                    int port = -1;
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        U.error((IgniteLogger)this.log, (Object)("Failed to parse port for S3 entry: " + key), (Throwable)e);
                    }
                    if (port == -1) continue;
                    try {
                        addrs.add(new InetSocketAddress(addrStr, port));
                    }
                    catch (IllegalArgumentException e) {
                        U.error((IgniteLogger)this.log, (Object)("Failed to parse port for S3 entry: " + key), (Throwable)e);
                    }
                }
                if (list.isTruncated()) {
                    list = this.s3.listNextBatchOfObjects(list);
                    continue;
                }
                break;
            }
        }
        catch (AmazonClientException e) {
            throw new IgniteSpiException("Failed to list objects in the bucket: " + this.bucketName, (Throwable)e);
        }
        return addrs;
    }

    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        assert (!F.isEmpty(addrs));
        this.initClient();
        for (InetSocketAddress addr : addrs) {
            String key = this.key(addr);
            try {
                this.s3.putObject(this.bucketName, key, (InputStream)new ByteArrayInputStream(ENTRY_CONTENT), ENTRY_METADATA);
            }
            catch (AmazonClientException e) {
                throw new IgniteSpiException("Failed to put entry [bucketName=" + this.bucketName + ", entry=" + key + ']', (Throwable)e);
            }
        }
    }

    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        assert (!F.isEmpty(addrs));
        this.initClient();
        for (InetSocketAddress addr : addrs) {
            String key = this.key(addr);
            try {
                this.s3.deleteObject(this.bucketName, key);
            }
            catch (AmazonClientException e) {
                throw new IgniteSpiException("Failed to delete entry [bucketName=" + this.bucketName + ", entry=" + key + ']', (Throwable)e);
            }
        }
    }

    private String key(InetSocketAddress addr) {
        assert (addr != null);
        SB sb = new SB();
        sb.a(addr.getAddress().getHostAddress()).a(DELIM).a(addr.getPort());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initClient() throws IgniteSpiException {
        if (this.initGuard.compareAndSet(false, true)) {
            try {
                if (this.cred == null) {
                    throw new IgniteSpiException("AWS credentials are not set.");
                }
                if (this.cfg == null) {
                    U.warn((IgniteLogger)this.log, (Object)"Amazon client configuration is not set (will use default).");
                }
                if (F.isEmpty((String)this.bucketName)) {
                    throw new IgniteSpiException("Bucket name is null or empty (provide bucket name and restart).");
                }
                AmazonS3Client amazonS3Client = this.s3 = this.cfg != null ? new AmazonS3Client(this.cred, this.cfg) : new AmazonS3Client(this.cred);
                if (this.s3.doesBucketExist(this.bucketName)) return;
                try {
                    this.s3.createBucket(this.bucketName);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Created S3 bucket: " + this.bucketName);
                    }
                    while (!this.s3.doesBucketExist(this.bucketName)) {
                        try {
                            U.sleep((long)200L);
                        }
                        catch (IgniteInterruptedCheckedException e) {
                            throw new IgniteSpiException("Thread has been interrupted.", (Throwable)e);
                            return;
                        }
                    }
                }
                catch (AmazonClientException e) {
                    if (this.s3.doesBucketExist(this.bucketName)) return;
                    this.s3 = null;
                    throw new IgniteSpiException("Failed to create bucket: " + this.bucketName, (Throwable)e);
                }
            }
            finally {
                this.initLatch.countDown();
            }
        }
        try {
            U.await((CountDownLatch)this.initLatch);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteSpiException("Thread has been interrupted.", (Throwable)e);
        }
        if (this.s3 != null) return;
        throw new IgniteSpiException("Ip finder has not been initialized properly.");
    }

    @IgniteSpiConfiguration(optional=false)
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @IgniteSpiConfiguration(optional=true)
    public void setClientConfiguration(ClientConfiguration cfg) {
        this.cfg = cfg;
    }

    @IgniteSpiConfiguration(optional=false)
    public void setAwsCredentials(AWSCredentials cred) {
        this.cred = cred;
    }

    public String toString() {
        return S.toString(TcpDiscoveryS3IpFinder.class, (Object)((Object)this), (String)"super", (Object)super.toString());
    }

    static {
        ENTRY_METADATA.setContentLength((long)ENTRY_CONTENT.length);
    }
}

