/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryArrayIdentityResolver;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResult;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResultAdapter;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.dml.FastUpdateArguments;
import org.apache.ignite.internal.processors.query.h2.dml.KeyValueSupplier;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.IgniteSingletonIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.command.Prepared;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.table.Column;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class DmlStatementsProcessor {
    private static final int DFLT_DML_RERUN_ATTEMPTS = 4;
    private final IgniteH2Indexing indexing;
    private static final Set<Integer> WARNED_TYPES = Collections.newSetFromMap(new ConcurrentHashMap8());
    private static final int PLAN_CACHE_SIZE = 1024;
    private final ConcurrentMap<String, ConcurrentMap<String, UpdatePlan>> planCache = new ConcurrentHashMap<String, ConcurrentMap<String, UpdatePlan>>();
    private static final List<GridQueryFieldMetadata> UPDATE_RESULT_META = Collections.singletonList(new IgniteH2Indexing.SqlFieldMetadata(null, null, "UPDATED", Long.class.getName()));
    private static IgniteInClosure<MutableEntry<Object, Object>> RMV = new IgniteInClosure<MutableEntry<Object, Object>>(){

        public void apply(MutableEntry<Object, Object> e) {
            e.remove();
        }
    };

    DmlStatementsProcessor(IgniteH2Indexing indexing) {
        this.indexing = indexing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateSqlFields(String spaceName, PreparedStatement stmt, SqlFieldsQuery fieldsQry, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        Object[] errKeys = null;
        long items = 0L;
        UpdatePlan plan = this.getPlanForStatement(spaceName, stmt, null);
        GridCacheContext<?, ?> cctx = plan.tbl.rowDescriptor().context();
        for (int i = 0; i < 4; ++i) {
            UpdateResult r;
            CacheOperationContext opCtx = cctx.operationContextPerCall();
            if (cctx.binaryMarshaller()) {
                CacheOperationContext newOpCtx = null;
                if (opCtx == null) {
                    newOpCtx = new CacheOperationContext(false, null, true, null, false, null);
                } else if (!opCtx.isKeepBinary()) {
                    newOpCtx = opCtx.keepBinary();
                }
                if (newOpCtx != null) {
                    cctx.operationContextPerCall(newOpCtx);
                }
            }
            try {
                r = this.executeUpdateStatement(cctx, stmt, fieldsQry, loc, filters, cancel, errKeys);
            }
            finally {
                cctx.operationContextPerCall(opCtx);
            }
            if (F.isEmpty((Object[])r.errKeys)) {
                return r.cnt + items;
            }
            items += r.cnt;
            errKeys = r.errKeys;
        }
        throw new IgniteSQLException("Failed to update or delete some keys: " + Arrays.deepToString(errKeys), 4002);
    }

    QueryCursorImpl<List<?>> updateSqlFieldsTwoStep(String spaceName, PreparedStatement stmt, SqlFieldsQuery fieldsQry, GridQueryCancel cancel) throws IgniteCheckedException {
        long res = this.updateSqlFields(spaceName, stmt, fieldsQry, false, null, cancel);
        return DmlStatementsProcessor.cursorForUpdateResult(res);
    }

    GridQueryFieldsResult updateLocalSqlFields(String spaceName, PreparedStatement stmt, SqlFieldsQuery fieldsQry, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        long res = this.updateSqlFields(spaceName, stmt, fieldsQry, true, filters, cancel);
        return new GridQueryFieldsResultAdapter(UPDATE_RESULT_META, (GridCloseableIterator)new IgniteSingletonIterator(Collections.singletonList(res)));
    }

    private UpdateResult executeUpdateStatement(final GridCacheContext cctx, PreparedStatement prepStmt, SqlFieldsQuery fieldsQry, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel, Object[] failedKeys) throws IgniteCheckedException {
        QueryCursorImpl cur;
        Integer errKeysPos = null;
        Object[] params = fieldsQry.getArgs();
        if (!F.isEmpty((Object[])failedKeys)) {
            int paramsCnt = F.isEmpty((Object[])params) ? 0 : params.length;
            params = Arrays.copyOf((Object[])U.firstNotNull((Object[])new Object[][]{params, X.EMPTY_OBJECT_ARRAY}), paramsCnt + 1);
            params[paramsCnt] = failedKeys;
            errKeysPos = paramsCnt;
        }
        UpdatePlan plan = this.getPlanForStatement(cctx.name(), prepStmt, errKeysPos);
        if (plan.fastUpdateArgs != null) {
            assert (F.isEmpty((Object[])failedKeys) && errKeysPos == null);
            return new UpdateResult(DmlStatementsProcessor.doSingleUpdate(plan, params), X.EMPTY_OBJECT_ARRAY);
        }
        assert (!F.isEmpty((String)plan.selectQry));
        if (!loc && !plan.isLocSubqry) {
            SqlFieldsQuery newFieldsQry = new SqlFieldsQuery(plan.selectQry, fieldsQry.isCollocated()).setArgs(params).setDistributedJoins(fieldsQry.isDistributedJoins()).setEnforceJoinOrder(fieldsQry.isEnforceJoinOrder()).setLocal(fieldsQry.isLocal()).setPageSize(fieldsQry.getPageSize()).setTimeout(fieldsQry.getTimeout(), TimeUnit.MILLISECONDS);
            cur = (QueryCursorImpl)this.indexing.queryTwoStep(cctx, newFieldsQry, cancel);
        } else {
            final GridQueryFieldsResult res = this.indexing.queryLocalSqlFields(cctx.name(), plan.selectQry, F.asList((Object[])params), filters, fieldsQry.isEnforceJoinOrder(), fieldsQry.getTimeout(), cancel);
            cur = new QueryCursorImpl(new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    try {
                        return new GridQueryCacheObjectsIterator((Iterator)res.iterator(), cctx, cctx.keepBinary());
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                }
            }, cancel);
            cur.fieldsMeta(res.metaData());
        }
        int pageSize = loc ? 0 : fieldsQry.getPageSize();
        switch (plan.mode) {
            case MERGE: {
                return new UpdateResult(this.doMerge(plan, cur, pageSize), X.EMPTY_OBJECT_ARRAY);
            }
            case INSERT: {
                return new UpdateResult(this.doInsert(plan, cur, pageSize), X.EMPTY_OBJECT_ARRAY);
            }
            case UPDATE: {
                return this.doUpdate(plan, cur, pageSize);
            }
            case DELETE: {
                return this.doDelete(cctx, cur, pageSize);
            }
        }
        throw new IgniteSQLException("Unexpected DML operation [mode=" + (Object)((Object)plan.mode) + ']', 2001);
    }

    private UpdatePlan getPlanForStatement(String spaceName, PreparedStatement prepStmt, @Nullable Integer errKeysPos) throws IgniteCheckedException {
        UpdatePlan res;
        Prepared p = GridSqlQueryParser.prepared((JdbcPreparedStatement)prepStmt);
        ConcurrentMap spacePlans = (ConcurrentMap)this.planCache.get(spaceName = F.isEmpty((String)spaceName) ? "default" : spaceName);
        if (spacePlans == null) {
            spacePlans = new GridBoundedConcurrentLinkedHashMap(1024);
            spacePlans = (ConcurrentMap)U.firstNotNull((Object[])new ConcurrentMap[]{this.planCache.putIfAbsent(spaceName, spacePlans), spacePlans});
        }
        UpdatePlan updatePlan = res = errKeysPos == null ? (UpdatePlan)spacePlans.get(p.getSQL()) : null;
        if (res != null) {
            return res;
        }
        res = UpdatePlanBuilder.planForStatement(p, errKeysPos);
        if (errKeysPos == null) {
            return (UpdatePlan)U.firstNotNull((Object[])new UpdatePlan[]{spacePlans.putIfAbsent(p.getSQL(), res), res});
        }
        return res;
    }

    private static long doSingleUpdate(UpdatePlan plan, Object[] params) throws IgniteCheckedException {
        GridCacheContext<?, ?> cctx = plan.tbl.rowDescriptor().context();
        FastUpdateArguments singleUpdate = plan.fastUpdateArgs;
        assert (singleUpdate != null);
        Object key = singleUpdate.key.apply(params);
        Object val = singleUpdate.val.apply(params);
        Object newVal = singleUpdate.newVal.apply(params);
        int res = newVal != null ? (val == null ? (cctx.cache().replace(key, newVal) ? 1 : 0) : (cctx.cache().replace(key, val, newVal) ? 1 : 0)) : (val == null ? (cctx.cache().remove(key) ? 1 : 0) : (cctx.cache().remove(key, val) ? 1 : 0));
        return res;
    }

    private UpdateResult doDelete(GridCacheContext cctx, QueryCursorImpl<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        long res = 0L;
        ArrayList failedKeys = new ArrayList();
        SQLException resEx = null;
        Iterator it = cursor.iterator();
        LinkedHashMap<Object, EntryProcessor<Object, Object, Boolean>> rows = new LinkedHashMap<Object, EntryProcessor<Object, Object, Boolean>>();
        while (it.hasNext()) {
            List e = (List)it.next();
            if (e.size() != 2) {
                U.warn((IgniteLogger)this.indexing.getLogger(), (Object)("Invalid row size on DELETE - expected 2, got " + e.size()));
                continue;
            }
            rows.put(e.get(0), new ModifyingEntryProcessor(e.get(1), RMV));
            if ((pageSize <= 0 || rows.size() != pageSize) && it.hasNext()) continue;
            PageProcessingResult pageRes = DmlStatementsProcessor.processPage(cctx, rows);
            res += pageRes.cnt;
            failedKeys.addAll(F.asList((Object[])pageRes.errKeys));
            if (pageRes.ex != null) {
                if (resEx == null) {
                    resEx = pageRes.ex;
                } else {
                    resEx.setNextException(pageRes.ex);
                }
            }
            if (!it.hasNext()) continue;
            rows.clear();
        }
        if (resEx != null) {
            if (!F.isEmpty(failedKeys)) {
                String msg = "Failed to DELETE some keys because they had been modified concurrently [keys=" + failedKeys + ']';
                SQLException conEx = IgniteQueryErrorCode.createJdbcSqlException((String)msg, (int)4002);
                conEx.setNextException(resEx);
                resEx = conEx;
            }
            throw new IgniteSQLException(resEx);
        }
        return new UpdateResult(res, failedKeys.toArray());
    }

    private UpdateResult doUpdate(UpdatePlan plan, QueryCursorImpl<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        GridH2RowDescriptor desc = plan.tbl.rowDescriptor();
        GridCacheContext<?, ?> cctx = desc.context();
        boolean bin = cctx.binaryMarshaller();
        String[] updatedColNames = plan.colNames;
        int valColIdx = plan.valColIdx;
        boolean hasNewVal = valColIdx != -1;
        boolean hasProps = !hasNewVal || updatedColNames.length > 1;
        long res = 0L;
        LinkedHashMap<Object, EntryProcessor<Object, Object, Boolean>> rows = new LinkedHashMap<Object, EntryProcessor<Object, Object, Boolean>>();
        ArrayList failedKeys = new ArrayList();
        SQLException resEx = null;
        Iterator it = cursor.iterator();
        while (it.hasNext()) {
            int i;
            List e = (List)it.next();
            Object key = e.get(0);
            Object val = hasNewVal ? e.get(valColIdx) : e.get(1);
            HashMap<String, Object> newColVals = new HashMap<String, Object>();
            for (i = 0; i < plan.colNames.length; ++i) {
                if (hasNewVal && i == valColIdx - 2) continue;
                newColVals.put(plan.colNames[i], DmlStatementsProcessor.convert(e.get(i + 2), plan.colNames[i], plan.tbl.rowDescriptor(), plan.colTypes[i]));
            }
            Object newVal = plan.valSupplier.apply(e);
            if (newVal == null) {
                throw new IgniteSQLException("New value for UPDATE must not be null", 4004);
            }
            if (bin && !(val instanceof BinaryObject)) {
                val = cctx.grid().binary().toBinary(val);
            }
            for (i = 0; i < plan.tbl.getColumns().length - 2; ++i) {
                Column c = plan.tbl.getColumn(i + 2);
                GridQueryProperty prop = desc.type().property(c.getName());
                if (prop.key()) continue;
                boolean hasNewColVal = newColVals.containsKey(c.getName());
                if (bin && !hasNewColVal) continue;
                Object colVal = hasNewColVal ? newColVals.get(c.getName()) : prop.value(null, val);
                desc.setColumnValue(null, newVal, colVal, i);
            }
            if (bin && hasProps) {
                assert (newVal instanceof BinaryObjectBuilder);
                newVal = ((BinaryObjectBuilder)newVal).build();
            }
            Object srcVal = e.get(1);
            if (bin && !(srcVal instanceof BinaryObject)) {
                srcVal = cctx.grid().binary().toBinary(srcVal);
            }
            rows.put(key, new ModifyingEntryProcessor(srcVal, new EntryValueUpdater(newVal)));
            if ((pageSize <= 0 || rows.size() != pageSize) && it.hasNext()) continue;
            PageProcessingResult pageRes = DmlStatementsProcessor.processPage(cctx, rows);
            res += pageRes.cnt;
            failedKeys.addAll(F.asList((Object[])pageRes.errKeys));
            if (pageRes.ex != null) {
                if (resEx == null) {
                    resEx = pageRes.ex;
                } else {
                    resEx.setNextException(pageRes.ex);
                }
            }
            if (!it.hasNext()) continue;
            rows.clear();
        }
        if (resEx != null) {
            if (!F.isEmpty(failedKeys)) {
                String msg = "Failed to UPDATE some keys because they had been modified concurrently [keys=" + failedKeys + ']';
                SQLException dupEx = IgniteQueryErrorCode.createJdbcSqlException((String)msg, (int)4002);
                dupEx.setNextException(resEx);
                resEx = dupEx;
            }
            throw new IgniteSQLException(resEx);
        }
        return new UpdateResult(res, failedKeys.toArray());
    }

    private static Object convert(Object val, String colName, GridH2RowDescriptor desc, int type) throws IgniteCheckedException {
        if (val == null) {
            return null;
        }
        GridQueryProperty prop = desc.type().property(colName);
        assert (prop != null);
        Class expCls = prop.type();
        Class<?> currCls = val.getClass();
        if (val instanceof Date && currCls != Date.class && expCls == Date.class) {
            return new Date(((Date)val).getTime());
        }
        if (type == 17 && currCls != expCls) {
            if (currCls != Object[].class) {
                throw new IgniteCheckedException("Unexpected array type - only conversion from Object[] is assumed");
            }
            assert (expCls.isArray());
            Object[] curr = (Object[])val;
            Object newArr = Array.newInstance(expCls.getComponentType(), curr.length);
            System.arraycopy(curr, 0, newArr, 0, curr.length);
            return newArr;
        }
        int objType = DataType.getTypeFromClass(val.getClass());
        if (objType == type) {
            return val;
        }
        Value h2Val = desc.wrap(val, objType);
        return h2Val.convertTo(type).getObject();
    }

    private static PageProcessingErrorResult splitErrors(Map<Object, EntryProcessorResult<Boolean>> res) {
        LinkedHashSet<Object> errKeys = new LinkedHashSet<Object>(res.keySet());
        SQLException currSqlEx = null;
        SQLException firstSqlEx = null;
        int errors = 0;
        for (Map.Entry<Object, EntryProcessorResult<Boolean>> e : res.entrySet()) {
            try {
                e.getValue().get();
            }
            catch (EntryProcessorException ex) {
                SQLException next = IgniteQueryErrorCode.createJdbcSqlException((String)("Failed to process key '" + e.getKey() + '\''), (int)4005);
                next.initCause(ex);
                if (currSqlEx != null) {
                    currSqlEx.setNextException(next);
                } else {
                    firstSqlEx = next;
                }
                currSqlEx = next;
                errKeys.remove(e.getKey());
                ++errors;
            }
        }
        return new PageProcessingErrorResult(errKeys.toArray(), firstSqlEx, errors);
    }

    private long doMerge(UpdatePlan plan, QueryCursorImpl<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        GridH2RowDescriptor desc = plan.tbl.rowDescriptor();
        GridCacheContext<?, ?> cctx = desc.context();
        if (plan.rowsNum == 1) {
            IgniteBiTuple<?, ?> t = this.rowToKeyValue(cctx, ((List)cursor.iterator().next()).toArray(), plan.colNames, plan.colTypes, plan.keySupplier, plan.valSupplier, plan.keyColIdx, plan.valColIdx, desc);
            cctx.cache().put(t.getKey(), t.getValue());
            return 1L;
        }
        int resCnt = 0;
        LinkedHashMap<Object, Object> rows = new LinkedHashMap<Object, Object>();
        Iterator it = cursor.iterator();
        while (it.hasNext()) {
            List row = (List)it.next();
            IgniteBiTuple<?, ?> t = this.rowToKeyValue(cctx, row.toArray(), plan.colNames, plan.colTypes, plan.keySupplier, plan.valSupplier, plan.keyColIdx, plan.valColIdx, desc);
            rows.put(t.getKey(), t.getValue());
            if ((pageSize <= 0 || rows.size() != pageSize) && it.hasNext()) continue;
            cctx.cache().putAll(rows);
            resCnt += rows.size();
            if (!it.hasNext()) continue;
            rows.clear();
        }
        return resCnt;
    }

    private long doInsert(UpdatePlan plan, QueryCursorImpl<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        GridH2RowDescriptor desc = plan.tbl.rowDescriptor();
        GridCacheContext<?, ?> cctx = desc.context();
        if (plan.rowsNum == 1) {
            IgniteBiTuple<?, ?> t = this.rowToKeyValue(cctx, ((List)cursor.iterator().next()).toArray(), plan.colNames, plan.colTypes, plan.keySupplier, plan.valSupplier, plan.keyColIdx, plan.valColIdx, desc);
            if (cctx.cache().putIfAbsent(t.getKey(), t.getValue())) {
                return 1L;
            }
            throw new IgniteSQLException("Duplicate key during INSERT [key=" + t.getKey() + ']', 4001);
        }
        LinkedHashMap<Object, EntryProcessor<Object, Object, Boolean>> rows = plan.isLocSubqry ? new LinkedHashMap<Object, EntryProcessor<Object, Object, Boolean>>(plan.rowsNum) : new LinkedHashMap();
        ArrayList duplicateKeys = new ArrayList();
        int resCnt = 0;
        SQLException resEx = null;
        Iterator it = cursor.iterator();
        while (it.hasNext()) {
            List row = (List)it.next();
            IgniteBiTuple<?, ?> t = this.rowToKeyValue(cctx, row.toArray(), plan.colNames, plan.colTypes, plan.keySupplier, plan.valSupplier, plan.keyColIdx, plan.valColIdx, desc);
            rows.put(t.getKey(), new InsertEntryProcessor(t.getValue()));
            if (it.hasNext() && (pageSize <= 0 || rows.size() != pageSize)) continue;
            PageProcessingResult pageRes = DmlStatementsProcessor.processPage(cctx, rows);
            resCnt = (int)((long)resCnt + pageRes.cnt);
            duplicateKeys.addAll(F.asList((Object[])pageRes.errKeys));
            if (pageRes.ex != null) {
                if (resEx == null) {
                    resEx = pageRes.ex;
                } else {
                    resEx.setNextException(pageRes.ex);
                }
            }
            rows.clear();
        }
        if (!F.isEmpty(duplicateKeys)) {
            String msg = "Failed to INSERT some keys because they are already in cache [keys=" + duplicateKeys + ']';
            SQLException dupEx = new SQLException(msg, null, 4001);
            if (resEx == null) {
                resEx = dupEx;
            } else {
                resEx.setNextException(dupEx);
            }
        }
        if (resEx != null) {
            throw new IgniteSQLException(resEx);
        }
        return resCnt;
    }

    private static PageProcessingResult processPage(GridCacheContext cctx, Map<Object, EntryProcessor<Object, Object, Boolean>> rows) throws IgniteCheckedException {
        Map res = cctx.cache().invokeAll(rows, new Object[0]);
        if (F.isEmpty((Map)res)) {
            return new PageProcessingResult(rows.size(), null, null);
        }
        PageProcessingErrorResult splitRes = DmlStatementsProcessor.splitErrors(res);
        int keysCnt = splitRes.errKeys.length;
        return new PageProcessingResult(rows.size() - keysCnt - splitRes.cnt, splitRes.errKeys, splitRes.ex);
    }

    private IgniteBiTuple<?, ?> rowToKeyValue(GridCacheContext cctx, Object[] row, String[] cols, int[] colTypes, KeyValueSupplier keySupplier, KeyValueSupplier valSupplier, int keyColIdx, int valColIdx, GridH2RowDescriptor rowDesc) throws IgniteCheckedException {
        Object key = keySupplier.apply(F.asList((Object[])row));
        Object val = valSupplier.apply(F.asList((Object[])row));
        if (key == null) {
            throw new IgniteSQLException("Key for INSERT or MERGE must not be null", 4003);
        }
        if (val == null) {
            throw new IgniteSQLException("Value for INSERT or MERGE must not be null", 4004);
        }
        GridQueryTypeDescriptor desc = rowDesc.type();
        for (int i = 0; i < cols.length; ++i) {
            if (i == keyColIdx || i == valColIdx) continue;
            desc.setValue(cols[i], key, val, DmlStatementsProcessor.convert(row[i], cols[i], rowDesc, colTypes[i]));
        }
        if (cctx.binaryMarshaller()) {
            if (key instanceof BinaryObjectBuilder) {
                key = ((BinaryObjectBuilder)key).build();
            }
            if (val instanceof BinaryObjectBuilder) {
                val = ((BinaryObjectBuilder)val).build();
            }
            if (key instanceof BinaryObject) {
                key = this.updateHashCodeIfNeeded(cctx, (BinaryObject)key);
            }
            if (val instanceof BinaryObject) {
                val = this.updateHashCodeIfNeeded(cctx, (BinaryObject)val);
            }
        }
        return new IgniteBiTuple(key, val);
    }

    private BinaryObject updateHashCodeIfNeeded(GridCacheContext cctx, BinaryObject binObj) {
        if (U.isHashCodeEmpty((Object)binObj)) {
            if (WARNED_TYPES.add(binObj.type().typeId())) {
                U.warn((IgniteLogger)this.indexing.getLogger(), (Object)("Binary object's type does not have identity resolver explicitly set, therefore BinaryArrayIdentityResolver is used to generate hash codes for its instances, and therefore hash code of this binary object will most likely not match that of its non serialized form. For finer control over identity of this type, please update your BinaryConfiguration accordingly. [typeId=" + binObj.type().typeId() + ", typeName=" + binObj.type().typeName() + ']'));
            }
            int hash = BinaryArrayIdentityResolver.instance().hashCode(binObj);
            return cctx.grid().binary().builder(binObj).hashCode(hash).build();
        }
        return binObj;
    }

    private static QueryCursorImpl<List<?>> cursorForUpdateResult(long itemsCnt) {
        QueryCursorImpl res = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(itemsCnt)), null, false);
        res.fieldsMeta(UPDATE_RESULT_META);
        return res;
    }

    private static final class PageProcessingErrorResult {
        @NotNull
        final Object[] errKeys;
        final int cnt;
        final SQLException ex;

        private PageProcessingErrorResult(@NotNull Object[] errKeys, SQLException ex, int exCnt) {
            errKeys = (Object[])U.firstNotNull((Object[])new Object[][]{errKeys, X.EMPTY_OBJECT_ARRAY});
            assert (exCnt == 0 ^ ex != null);
            this.errKeys = errKeys;
            this.cnt = exCnt;
            this.ex = ex;
        }
    }

    private static final class PageProcessingResult {
        final long cnt;
        @NotNull
        final Object[] errKeys;
        final SQLException ex;

        private PageProcessingResult(long cnt, Object[] errKeys, SQLException ex) {
            this.cnt = cnt;
            this.errKeys = (Object[])U.firstNotNull((Object[])new Object[][]{errKeys, X.EMPTY_OBJECT_ARRAY});
            this.ex = ex;
        }
    }

    private static final class UpdateResult {
        final long cnt;
        @NotNull
        final Object[] errKeys;

        private UpdateResult(long cnt, Object[] errKeys) {
            this.cnt = cnt;
            this.errKeys = (Object[])U.firstNotNull((Object[])new Object[][]{errKeys, X.EMPTY_OBJECT_ARRAY});
        }
    }

    private static final class EntryValueUpdater
    implements IgniteInClosure<MutableEntry<Object, Object>> {
        private final Object val;

        private EntryValueUpdater(Object val) {
            assert (val != null);
            this.val = val;
        }

        public void apply(MutableEntry<Object, Object> e) {
            e.setValue(this.val);
        }
    }

    private static final class ModifyingEntryProcessor
    implements EntryProcessor<Object, Object, Boolean> {
        private final Object val;
        private final IgniteInClosure<MutableEntry<Object, Object>> entryModifier;

        private ModifyingEntryProcessor(Object val, IgniteInClosure<MutableEntry<Object, Object>> entryModifier) {
            assert (val != null);
            this.val = val;
            this.entryModifier = entryModifier;
        }

        public Boolean process(MutableEntry<Object, Object> entry, Object ... arguments) throws EntryProcessorException {
            if (!entry.exists()) {
                return null;
            }
            Object entryVal = entry.getValue();
            if (entryVal == null) {
                return null;
            }
            if (!F.eq((Object)entryVal, (Object)this.val)) {
                return false;
            }
            this.entryModifier.apply(entry);
            return null;
        }
    }

    private static final class InsertEntryProcessor
    implements EntryProcessor<Object, Object, Boolean> {
        private final Object val;

        private InsertEntryProcessor(Object val) {
            this.val = val;
        }

        public Boolean process(MutableEntry<Object, Object> entry, Object ... arguments) throws EntryProcessorException {
            if (entry.exists()) {
                return false;
            }
            entry.setValue(this.val);
            return null;
        }
    }
}

