/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.dml.FastUpdateArguments;
import org.apache.ignite.internal.processors.query.h2.dml.KeyValueSupplier;
import org.apache.ignite.internal.processors.query.h2.dml.UpdateMode;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.DmlAstUtils;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDelete;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlInsert;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlMerge;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUpdate;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.Prepared;
import org.h2.table.Column;
import org.jetbrains.annotations.Nullable;

public final class UpdatePlanBuilder {
    private UpdatePlanBuilder() {
    }

    public static UpdatePlan planForStatement(Prepared prepared, @Nullable Integer errKeysPos) throws IgniteCheckedException {
        assert (!prepared.isQuery());
        GridSqlStatement stmt = new GridSqlQueryParser().parse(prepared);
        if (stmt instanceof GridSqlMerge || stmt instanceof GridSqlInsert) {
            return UpdatePlanBuilder.planForInsert(stmt);
        }
        return UpdatePlanBuilder.planForUpdate(stmt, errKeysPos);
    }

    private static UpdatePlan planForInsert(GridSqlStatement stmt) throws IgniteCheckedException {
        int rowsNum;
        boolean isTwoStepSubqry;
        GridSqlQuery sel;
        GridSqlColumn[] cols;
        GridH2RowDescriptor desc;
        GridSqlTable tbl;
        GridSqlElement target;
        if (stmt instanceof GridSqlInsert) {
            GridSqlInsert ins = (GridSqlInsert)stmt;
            target = ins.into();
            tbl = UpdatePlanBuilder.gridTableForElement(target);
            desc = tbl.dataTable().rowDescriptor();
            cols = ins.columns();
            sel = DmlAstUtils.selectForInsertOrMerge(cols, ins.rows(), ins.query(), desc);
            isTwoStepSubqry = ins.query() != null;
            rowsNum = isTwoStepSubqry ? 0 : ins.rows().size();
        } else if (stmt instanceof GridSqlMerge) {
            GridSqlMerge merge = (GridSqlMerge)stmt;
            target = merge.into();
            tbl = UpdatePlanBuilder.gridTableForElement(target);
            desc = tbl.dataTable().rowDescriptor();
            GridSqlColumn[] keys = merge.keys();
            if (keys.length != 1 || !"_KEY".equals(keys[0].columnName())) {
                throw new CacheException("SQL MERGE does not support arbitrary keys");
            }
            cols = merge.columns();
            sel = DmlAstUtils.selectForInsertOrMerge(cols, merge.rows(), merge.query(), desc);
            isTwoStepSubqry = merge.query() != null;
            rowsNum = isTwoStepSubqry ? 0 : merge.rows().size();
        } else {
            throw new IgniteSQLException("Unexpected DML operation [cls=" + stmt.getClass().getName() + ']', 2001);
        }
        isTwoStepSubqry = isTwoStepSubqry && (sel instanceof GridSqlUnion || sel instanceof GridSqlSelect && ((GridSqlSelect)sel).from() != null);
        int keyColIdx = -1;
        int valColIdx = -1;
        boolean hasKeyProps = false;
        boolean hasValProps = false;
        if (desc == null) {
            throw new IgniteSQLException("Row descriptor undefined for table '" + tbl.dataTable().getName() + "'", 3002);
        }
        GridCacheContext<?, ?> cctx = desc.context();
        String[] colNames = new String[cols.length];
        int[] colTypes = new int[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            String colName;
            GridSqlColumn col = cols[i];
            colNames[i] = colName = col.columnName();
            colTypes[i] = col.resultType().type();
            if ("_KEY".equals(colName)) {
                keyColIdx = i;
                continue;
            }
            if ("_VAL".equals(colName)) {
                valColIdx = i;
                continue;
            }
            GridQueryProperty prop = desc.type().property(colName);
            assert (prop != null) : "Property '" + colName + "' not found.";
            if (prop.key()) {
                hasKeyProps = true;
                continue;
            }
            hasValProps = true;
        }
        KeyValueSupplier keySupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), keyColIdx, hasKeyProps, true);
        KeyValueSupplier valSupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), valColIdx, hasValProps, false);
        if (stmt instanceof GridSqlMerge) {
            return UpdatePlan.forMerge(tbl.dataTable(), colNames, colTypes, keySupplier, valSupplier, keyColIdx, valColIdx, sel.getSQL(), !isTwoStepSubqry, rowsNum);
        }
        return UpdatePlan.forInsert(tbl.dataTable(), colNames, colTypes, keySupplier, valSupplier, keyColIdx, valColIdx, sel.getSQL(), !isTwoStepSubqry, rowsNum);
    }

    private static UpdatePlan planForUpdate(GridSqlStatement stmt, @Nullable Integer errKeysPos) throws IgniteCheckedException {
        UpdateMode mode;
        FastUpdateArguments fastUpdate;
        GridSqlElement target;
        if (stmt instanceof GridSqlUpdate) {
            UpdatePlanBuilder.verifyUpdateColumns(stmt);
            GridSqlUpdate update = (GridSqlUpdate)stmt;
            target = update.target();
            fastUpdate = DmlAstUtils.getFastUpdateArgs(update);
            mode = UpdateMode.UPDATE;
        } else if (stmt instanceof GridSqlDelete) {
            GridSqlDelete del = (GridSqlDelete)stmt;
            target = del.from();
            fastUpdate = DmlAstUtils.getFastDeleteArgs(del);
            mode = UpdateMode.DELETE;
        } else {
            throw new IgniteSQLException("Unexpected DML operation [cls=" + stmt.getClass().getName() + ']', 2001);
        }
        GridSqlTable tbl = UpdatePlanBuilder.gridTableForElement(target);
        GridH2Table gridTbl = tbl.dataTable();
        GridH2RowDescriptor desc = gridTbl.rowDescriptor();
        if (desc == null) {
            throw new IgniteSQLException("Row descriptor undefined for table '" + gridTbl.getName() + "'", 3002);
        }
        if (fastUpdate != null) {
            return UpdatePlan.forFastUpdate(mode, gridTbl, fastUpdate);
        }
        if (stmt instanceof GridSqlUpdate) {
            boolean hasProps;
            boolean bin = desc.context().binaryMarshaller();
            ArrayList<GridSqlColumn> updatedCols = ((GridSqlUpdate)stmt).cols();
            int valColIdx = -1;
            String[] colNames = new String[updatedCols.size()];
            int[] colTypes = new int[updatedCols.size()];
            for (int i = 0; i < updatedCols.size(); ++i) {
                colNames[i] = ((GridSqlColumn)updatedCols.get(i)).columnName();
                colTypes[i] = ((GridSqlColumn)updatedCols.get(i)).resultType().type();
                if (!"_VAL".equals(colNames[i])) continue;
                valColIdx = i;
            }
            boolean hasNewVal = valColIdx != -1;
            boolean bl = hasProps = !hasNewVal || updatedCols.size() > 1;
            if (hasNewVal) {
                valColIdx += 2;
            }
            int newValColIdx = !hasProps ? valColIdx : (bin ? (hasNewVal ? valColIdx : 1) : -1);
            KeyValueSupplier newValSupplier = UpdatePlanBuilder.createSupplier(desc.context(), desc.type(), newValColIdx, hasProps, false);
            GridSqlSelect sel = DmlAstUtils.selectForUpdate((GridSqlUpdate)stmt, errKeysPos);
            return UpdatePlan.forUpdate(gridTbl, colNames, colTypes, newValSupplier, valColIdx, sel.getSQL());
        }
        GridSqlSelect sel = DmlAstUtils.selectForDelete((GridSqlDelete)stmt, errKeysPos);
        return UpdatePlan.forDelete(gridTbl, sel.getSQL());
    }

    private static KeyValueSupplier createSupplier(final GridCacheContext<?, ?> cctx, GridQueryTypeDescriptor desc, final int colIdx, boolean hasProps, final boolean key) throws IgniteCheckedException {
        Constructor ctor;
        final String typeName = key ? desc.keyTypeName() : desc.valueTypeName();
        final Class cls = key ? (Class)U.firstNotNull((Object[])new Class[]{U.classForName((String)desc.keyTypeName(), null), desc.keyClass()}) : desc.valueClass();
        boolean isSqlType = GridQueryProcessor.isSqlType((Class)cls);
        if (isSqlType || !hasProps || !cctx.binaryMarshaller()) {
            if (colIdx != -1) {
                return new KeyValueSupplier(){

                    public Object apply(List<?> arg) throws IgniteCheckedException {
                        return arg.get(colIdx);
                    }
                };
            }
            if (isSqlType) {
                throw new IgniteCheckedException((key ? "Key" : "Value") + " is missing from query");
            }
        }
        if (cctx.binaryMarshaller()) {
            if (colIdx != -1) {
                return new KeyValueSupplier(){

                    public Object apply(List<?> arg) throws IgniteCheckedException {
                        BinaryObject bin = (BinaryObject)cctx.grid().binary().toBinary(arg.get(colIdx));
                        return cctx.grid().binary().builder(bin);
                    }
                };
            }
            return new KeyValueSupplier(){

                public Object apply(List<?> arg) throws IgniteCheckedException {
                    return cctx.grid().binary().builder(typeName);
                }
            };
        }
        try {
            ctor = cls.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException ignored) {
            ctor = null;
        }
        if (ctor != null) {
            final Constructor ctor0 = ctor;
            return new KeyValueSupplier(){

                public Object apply(List<?> arg) throws IgniteCheckedException {
                    try {
                        return ctor0.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IgniteCheckedException("Failed to invoke default ctor for " + (key ? "key" : "value"), (Throwable)e);
                    }
                }
            };
        }
        return new KeyValueSupplier(){

            public Object apply(List<?> arg) throws IgniteCheckedException {
                try {
                    return GridUnsafe.allocateInstance((Class)cls);
                }
                catch (InstantiationException e) {
                    throw new IgniteCheckedException("Failed to invoke default ctor for " + (key ? "key" : "value"), (Throwable)e);
                }
            }
        };
    }

    private static GridSqlTable gridTableForElement(GridSqlElement target) {
        HashSet<GridSqlTable> tbls = new HashSet<GridSqlTable>();
        DmlAstUtils.collectAllGridTablesInTarget(target, tbls);
        if (tbls.size() != 1) {
            throw new IgniteSQLException("Failed to determine target table", 3001);
        }
        return (GridSqlTable)tbls.iterator().next();
    }

    private static void verifyUpdateColumns(GridSqlStatement statement) {
        if (statement == null || !(statement instanceof GridSqlUpdate)) {
            return;
        }
        GridSqlUpdate update = (GridSqlUpdate)statement;
        GridSqlElement updTarget = update.target();
        HashSet<GridSqlTable> tbls = new HashSet<GridSqlTable>();
        DmlAstUtils.collectAllGridTablesInTarget(updTarget, tbls);
        if (tbls.size() != 1) {
            throw new IgniteSQLException("Failed to determine target table for UPDATE", 3001);
        }
        GridSqlTable tbl = (GridSqlTable)tbls.iterator().next();
        GridH2Table gridTbl = tbl.dataTable();
        if (UpdatePlanBuilder.updateAffectsKeyColumns(gridTbl, update.set().keySet())) {
            throw new IgniteSQLException("SQL UPDATE can't modify key or its fields directly", 2003);
        }
    }

    private static boolean updateAffectsKeyColumns(GridH2Table gridTbl, Set<String> affectedColNames) {
        GridH2RowDescriptor desc = gridTbl.rowDescriptor();
        Column[] cols = gridTbl.getColumns();
        if (affectedColNames.contains(cols[0].getName())) {
            return true;
        }
        for (int i = 2; i < cols.length; ++i) {
            if (!affectedColNames.contains(cols[i].getName()) || !desc.isColumnKeyProperty(i - 2)) continue;
            return true;
        }
        return false;
    }
}

