/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.cache.CacheException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectUnion;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.IndexCondition;
import org.h2.index.ViewIndex;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.SubQueryInfo;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableView;

public final class GridH2CollocationModel {
    public static final int MULTIPLIER_COLLOCATED = 1;
    private static final int MULTIPLIER_UNICAST = 50;
    private static final int MULTIPLIER_BROADCAST = 200;
    private static final int MULTIPLIER_REPLICATED_NOT_LAST = 10000;
    private final GridH2CollocationModel upper;
    private final int filter;
    private final boolean view;
    private int multiplier;
    private Type type;
    private GridH2CollocationModel[] children;
    private TableFilter[] childFilters;
    private List<GridH2CollocationModel> unions;
    private Select select;
    private final boolean validate;

    private GridH2CollocationModel(GridH2CollocationModel upper, int filter, boolean view, boolean validate) {
        this.upper = upper;
        this.filter = filter;
        this.view = view;
        this.validate = validate;
    }

    private static GridH2CollocationModel createChildModel(GridH2CollocationModel upper, int filter, List<GridH2CollocationModel> unions, boolean view, boolean validate) {
        GridH2CollocationModel child = new GridH2CollocationModel(upper, filter, view, validate);
        if (unions != null) {
            assert (upper == null || upper.child(filter, false) != null || unions.isEmpty());
            if (upper != null && unions.isEmpty()) {
                assert (upper.child(filter, false) == null);
                upper.children[filter] = child;
            }
            unions.add(child);
            child.unions = unions;
        } else if (upper != null) {
            assert (upper.child(filter, false) == null);
            upper.children[filter] = child;
        }
        return child;
    }

    private boolean childFilters(TableFilter[] childFilters) {
        assert (childFilters != null);
        assert (this.view);
        Select select = childFilters[0].getSelect();
        assert (this.select == null || this.select == select);
        if (this.select == null) {
            this.select = select;
            assert (this.childFilters == null);
        } else if (Arrays.equals(this.childFilters, childFilters)) {
            return false;
        }
        if (this.childFilters == null) {
            this.childFilters = (TableFilter[])childFilters.clone();
            this.children = new GridH2CollocationModel[childFilters.length];
        } else {
            assert (this.childFilters.length == childFilters.length);
            System.arraycopy(childFilters, 0, this.childFilters, 0, childFilters.length);
            Arrays.fill(this.children, null);
        }
        this.type = null;
        this.multiplier = 0;
        return true;
    }

    private boolean isChildTableOrView(int i, TableFilter f) {
        Table t;
        if (f == null) {
            f = this.childFilters[i];
        }
        return (t = f.getTable()).isView() || t instanceof GridH2Table;
    }

    private void calculate() {
        if (this.type != null) {
            return;
        }
        if (this.view) {
            assert (this.childFilters != null);
            boolean collocated = true;
            boolean partitioned = false;
            int maxMultiplier = 1;
            for (int i = 0; i < this.childFilters.length; ++i) {
                GridH2CollocationModel child = this.child(i, true);
                Type t = child.type(true);
                if (child.multiplier == 10000) {
                    maxMultiplier = child.multiplier;
                }
                if (!t.isPartitioned()) continue;
                partitioned = true;
                if (t.isCollocated()) continue;
                collocated = false;
                int m = child.multiplier(true);
                if (m > maxMultiplier && (maxMultiplier = m) == 10000) break;
            }
            this.type = Type.of(partitioned, collocated);
            this.multiplier = maxMultiplier;
        } else {
            assert (this.upper != null);
            assert (this.childFilters == null);
            GridH2Table tbl = (GridH2Table)this.upper.childFilters[this.filter].getTable();
            if (!tbl.isPartitioned()) {
                this.type = Type.REPLICATED;
                this.multiplier = 1;
                return;
            }
            if (!this.upper.findPartitionedTableBefore(this.filter)) {
                this.type = Type.PARTITIONED_COLLOCATED;
                this.multiplier = 1;
            } else {
                switch (this.upper.joinedWithCollocated(this.filter)) {
                    case JOINED_WITH_COLLOCATED: {
                        this.type = Type.PARTITIONED_COLLOCATED;
                        this.multiplier = 1;
                        break;
                    }
                    case HAS_AFFINITY_CONDITION: {
                        this.type = Type.PARTITIONED_NOT_COLLOCATED;
                        this.multiplier = 50;
                        break;
                    }
                    case NONE: {
                        this.type = Type.PARTITIONED_NOT_COLLOCATED;
                        this.multiplier = 200;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (this.upper.previousReplicated(this.filter)) {
                this.multiplier = 10000;
            }
        }
    }

    private boolean findPartitionedTableBefore(int f) {
        for (int i = 0; i < f; ++i) {
            GridH2CollocationModel child = this.child(i, true);
            if (child == null || !child.type(true).isPartitioned()) continue;
            return true;
        }
        return this.upper != null && this.upper.findPartitionedTableBefore(this.filter);
    }

    private boolean previousReplicated(int f) {
        if (f > 0 && this.child(f - 1, true).type(true) == Type.REPLICATED) {
            return true;
        }
        return this.upper != null && this.upper.previousReplicated(this.filter);
    }

    private Affinity joinedWithCollocated(int f) {
        TableFilter tf = this.childFilters[f];
        GridH2Table tbl = (GridH2Table)tf.getTable();
        if (this.validate) {
            if (tbl.rowDescriptor().context().customAffinityMapper()) {
                throw GridH2CollocationModel.customAffinityError(tbl.spaceName());
            }
            if (F.isEmpty((Collection)tf.getIndexConditions())) {
                throw new CacheException("Failed to prepare distributed join query: join condition does not use index [joinedCache=" + tbl.spaceName() + ", plan=" + tf.getSelect().getPlanSQL() + ']');
            }
        }
        IndexColumn affCol = tbl.getAffinityKeyColumn();
        boolean affKeyCondFound = false;
        if (affCol != null) {
            ArrayList idxConditions = tf.getIndexConditions();
            int affColId = affCol.column.getColumnId();
            for (int i = 0; i < idxConditions.size(); ++i) {
                Type t;
                GridH2CollocationModel cm;
                ExpressionColumn expCol;
                TableFilter prevJoin;
                IndexCondition c = (IndexCondition)idxConditions.get(i);
                int cmpType = c.getCompareType();
                if (cmpType != 0 && cmpType != 16 || c.getColumn().getColumnId() != affColId || !c.isEvaluatable()) continue;
                affKeyCondFound = true;
                Expression exp = c.getExpression();
                if (!((exp = exp.getNonAliasExpression()) instanceof ExpressionColumn) || (prevJoin = (expCol = (ExpressionColumn)exp).getTableFilter()) == null || (cm = this.child(this.indexOf(prevJoin), true)) == null || !(t = cm.type(true)).isPartitioned() || !t.isCollocated() || !GridH2CollocationModel.isAffinityColumn(prevJoin, expCol, this.validate)) continue;
                return Affinity.JOINED_WITH_COLLOCATED;
            }
        }
        return affKeyCondFound ? Affinity.HAS_AFFINITY_CONDITION : Affinity.NONE;
    }

    private int indexOf(TableFilter f) {
        for (int i = 0; i < this.childFilters.length; ++i) {
            if (this.childFilters[i] != f) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private static boolean isAffinityColumn(TableFilter f, ExpressionColumn expCol, boolean validate) {
        Column col = expCol.getColumn();
        if (col == null) {
            return false;
        }
        Table t = col.getTable();
        if (t.isView()) {
            Query qry = f.getIndex() != null ? GridH2CollocationModel.getSubQuery(f) : GridSqlQueryParser.VIEW_QUERY.get((TableView)t);
            return GridH2CollocationModel.isAffinityColumn(qry, expCol, validate);
        }
        if (t instanceof GridH2Table) {
            if (validate && ((GridH2Table)t).rowDescriptor().context().customAffinityMapper()) {
                throw GridH2CollocationModel.customAffinityError(((GridH2Table)t).spaceName());
            }
            IndexColumn affCol = ((GridH2Table)t).getAffinityKeyColumn();
            return affCol != null && col.getColumnId() == affCol.column.getColumnId();
        }
        return false;
    }

    private static boolean isAffinityColumn(Query qry, ExpressionColumn expCol, boolean validate) {
        if (qry.isUnion()) {
            SelectUnion union = (SelectUnion)qry;
            return GridH2CollocationModel.isAffinityColumn(union.getLeft(), expCol, validate) && GridH2CollocationModel.isAffinityColumn(union.getRight(), expCol, validate);
        }
        Expression exp = ((Expression)qry.getExpressions().get(expCol.getColumn().getColumnId())).getNonAliasExpression();
        if (exp instanceof ExpressionColumn) {
            expCol = (ExpressionColumn)exp;
            return GridH2CollocationModel.isAffinityColumn(expCol.getTableFilter(), expCol, validate);
        }
        return false;
    }

    public int calculateMultiplier() {
        return this.multiplier(false);
    }

    private int multiplier(boolean withUnion) {
        this.calculate();
        assert (this.multiplier != 0);
        if (withUnion && this.unions != null) {
            int maxMultiplier = 0;
            for (int i = 0; i < this.unions.size(); ++i) {
                int m = this.unions.get(i).multiplier(false);
                if (m <= maxMultiplier) continue;
                maxMultiplier = m;
            }
            return maxMultiplier;
        }
        return this.multiplier;
    }

    private Type type(boolean withUnion) {
        this.calculate();
        assert (this.type != null);
        if (withUnion && this.unions != null) {
            Type left = this.unions.get(0).type(false);
            for (int i = 1; i < this.unions.size(); ++i) {
                Type right = this.unions.get(i).type(false);
                if (!left.isCollocated() || !right.isCollocated()) {
                    left = Type.PARTITIONED_NOT_COLLOCATED;
                    break;
                }
                left = !left.isPartitioned() && !right.isPartitioned() ? Type.REPLICATED : Type.PARTITIONED_COLLOCATED;
            }
            return left;
        }
        return this.type;
    }

    private GridH2CollocationModel child(int i, boolean create) {
        GridH2CollocationModel child = this.children[i];
        if (child == null && create && this.isChildTableOrView(i, null)) {
            TableFilter f = this.childFilters[i];
            child = f.getTable().isView() ? (f.getIndex() == null ? GridH2CollocationModel.createChildModel(this, i, null, true, this.validate) : GridH2CollocationModel.buildCollocationModel(this, i, GridH2CollocationModel.getSubQuery(f), null, this.validate)) : GridH2CollocationModel.createChildModel(this, i, null, false, this.validate);
            assert (child != null);
            assert (this.children[i] == child);
        }
        return child;
    }

    private static Query getSubQuery(TableFilter f) {
        return ((ViewIndex)f.getIndex()).getQuery();
    }

    private List<GridH2CollocationModel> getOrCreateUnions() {
        if (this.unions == null) {
            this.unions = new ArrayList<GridH2CollocationModel>(4);
            this.unions.add(this);
        }
        return this.unions;
    }

    public static GridH2CollocationModel buildCollocationModel(GridH2QueryContext qctx, SubQueryInfo info, TableFilter[] filters, int filter, boolean validate) {
        GridH2CollocationModel cm;
        if (info != null) {
            cm = GridH2CollocationModel.buildCollocationModel(qctx, info.getUpper(), info.getFilters(), info.getFilter(), validate);
        } else {
            cm = qctx.queryCollocationModel();
            if (cm == null) {
                cm = GridH2CollocationModel.createChildModel(null, -1, null, true, validate);
                qctx.queryCollocationModel(cm);
            }
        }
        assert (cm.view);
        Select select = filters[0].getSelect();
        if (cm.select != null && cm.select != select) {
            List<GridH2CollocationModel> unions = cm.getOrCreateUnions();
            for (int i = 1; i < unions.size(); ++i) {
                GridH2CollocationModel u = unions.get(i);
                if (u.select != select) continue;
                cm = u;
                break;
            }
            if (cm.select != select) {
                cm = GridH2CollocationModel.createChildModel(cm.upper, cm.filter, unions, true, validate);
            }
        }
        cm.childFilters(filters);
        return cm.child(filter, true);
    }

    public static boolean isCollocated(Query qry) {
        GridH2CollocationModel mdl = GridH2CollocationModel.buildCollocationModel(null, -1, qry, null, true);
        Type type = mdl.type(true);
        if (!type.isCollocated() && mdl.multiplier == 10000) {
            throw new CacheException("Failed to execute query: for distributed join all REPLICATED caches must be at the end of the joined tables list.");
        }
        return type.isCollocated();
    }

    private static GridH2CollocationModel buildCollocationModel(GridH2CollocationModel upper, int filter, Query qry, List<GridH2CollocationModel> unions, boolean validate) {
        if (qry.isUnion()) {
            if (unions == null) {
                unions = new ArrayList<GridH2CollocationModel>();
            }
            SelectUnion union = (SelectUnion)qry;
            GridH2CollocationModel left = GridH2CollocationModel.buildCollocationModel(upper, filter, union.getLeft(), unions, validate);
            GridH2CollocationModel right = GridH2CollocationModel.buildCollocationModel(upper, filter, union.getRight(), unions, validate);
            assert (left != null);
            assert (right != null);
            return upper != null ? upper : left;
        }
        Select select = (Select)qry;
        ArrayList<TableFilter> list = new ArrayList<TableFilter>();
        for (TableFilter f = select.getTopTableFilter(); f != null; f = f.getJoin()) {
            list.add(f);
        }
        TableFilter[] filters = list.toArray(new TableFilter[list.size()]);
        GridH2CollocationModel cm = GridH2CollocationModel.createChildModel(upper, filter, unions, true, validate);
        cm.childFilters(filters);
        for (int i = 0; i < filters.length; ++i) {
            TableFilter f = filters[i];
            if (f.getTable().isView()) {
                GridH2CollocationModel.buildCollocationModel(cm, i, GridH2CollocationModel.getSubQuery(f), null, validate);
                continue;
            }
            if (!(f.getTable() instanceof GridH2Table)) continue;
            GridH2CollocationModel.createChildModel(cm, i, null, false, validate);
        }
        return upper != null ? upper : cm;
    }

    private static CacheException customAffinityError(String cacheName) {
        return new CacheException("Failed to prepare distributed join query: can not use distributed joins for cache with custom AffinityKeyMapper configured. Please use AffinityKeyMapped annotation instead [cache=" + cacheName + ']');
    }

    private static enum Affinity {
        NONE,
        HAS_AFFINITY_CONDITION,
        JOINED_WITH_COLLOCATED;

    }

    private static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PARTITIONED_COLLOCATED = new Type(true, true);
        public static final /* enum */ Type PARTITIONED_NOT_COLLOCATED = new Type(true, false);
        public static final /* enum */ Type REPLICATED = new Type(false, true);
        private final boolean partitioned;
        private final boolean collocated;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(boolean partitioned, boolean collocated) {
            this.partitioned = partitioned;
            this.collocated = collocated;
        }

        public boolean isPartitioned() {
            return this.partitioned;
        }

        public boolean isCollocated() {
            return this.collocated;
        }

        static Type of(boolean partitioned, boolean collocated) {
            if (collocated) {
                return partitioned ? PARTITIONED_COLLOCATED : REPLICATED;
            }
            assert (partitioned);
            return PARTITIONED_NOT_COLLOCATED;
        }

        static {
            $VALUES = new Type[]{PARTITIONED_COLLOCATED, PARTITIONED_NOT_COLLOCATED, REPLICATED};
        }
    }
}

