/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2AbstractKeyValueRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2CollocationModel;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RetryException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridSearchRowPointer;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRange;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRangeBounds;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.GridFilteredIterator;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.CIX2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexLookupBatch;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.util.DoneFuture;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridH2IndexBase
extends BaseIndex {
    private static final Object EXPLICIT_NULL = new Object();
    private static final AtomicLong idxIdGen = new AtomicLong();
    protected final long idxId = idxIdGen.incrementAndGet();
    private final ThreadLocal<Object> snapshot = new ThreadLocal();
    private Object msgTopic;
    private GridMessageListener msgLsnr;
    private IgniteLogger log;
    private final CIX2<ClusterNode, Message> locNodeHnd = new CIX2<ClusterNode, Message>(){

        public void applyx(ClusterNode clusterNode, Message msg) throws IgniteCheckedException {
            GridH2IndexBase.this.onMessage0(clusterNode.id(), msg);
        }
    };

    protected final void initDistributedJoinMessaging(GridH2Table tbl) {
        final GridH2RowDescriptor desc = tbl.rowDescriptor();
        if (desc != null && desc.context() != null) {
            GridKernalContext ctx = desc.context().kernalContext();
            this.log = ctx.log(((Object)((Object)this)).getClass());
            this.msgTopic = new IgniteBiTuple((Object)GridTopic.TOPIC_QUERY, (Object)(tbl.identifier() + '.' + this.getName()));
            this.msgLsnr = new GridMessageListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(UUID nodeId, Object msg) {
                    GridSpinBusyLock l = desc.indexing().busyLock();
                    if (!l.enterBusy()) {
                        return;
                    }
                    try {
                        GridH2IndexBase.this.onMessage0(nodeId, msg);
                    }
                    finally {
                        l.leaveBusy();
                    }
                }
            };
            ctx.io().addMessageListener(this.msgTopic, this.msgLsnr);
        } else {
            this.msgTopic = null;
            this.msgLsnr = null;
            this.log = new NullLogger();
        }
    }

    public final void close(Session ses) {
    }

    public void destroy() {
        if (this.msgLsnr != null) {
            this.kernalContext().io().removeMessageListener(this.msgTopic, this.msgLsnr);
        }
    }

    public GridH2IndexBase rebuild() throws InterruptedException {
        return this;
    }

    public abstract GridH2Row put(GridH2Row var1);

    public abstract GridH2Row remove(SearchRow var1);

    public final Object takeSnapshot(@Nullable Object s, GridH2QueryContext qctx) {
        assert (this.snapshot.get() == null);
        if (s == null) {
            s = this.doTakeSnapshot();
        }
        if (s != null) {
            if (s instanceof GridReservable && !((GridReservable)s).reserve()) {
                return null;
            }
            this.snapshot.set(s);
            if (qctx != null) {
                qctx.putSnapshot(this.idxId, s);
            }
        }
        return s;
    }

    private static void clearViewIndexCache(Session ses) {
        Map viewIdxCache = ses.getViewIndexCache(true);
        if (!viewIdxCache.isEmpty()) {
            viewIdxCache.clear();
        }
    }

    public int getDistributedMultiplier(Session ses, TableFilter[] filters, int filter) {
        GridH2QueryContext qctx = GridH2QueryContext.get();
        if (qctx == null || qctx.type() != GridH2QueryType.PREPARE || !qctx.distributedJoins() || ses.isPreparingQueryExpression()) {
            return 1;
        }
        GridH2IndexBase.clearViewIndexCache(ses);
        assert (filters != null);
        GridH2CollocationModel c = GridH2CollocationModel.buildCollocationModel(qctx, ses.getSubQueryInfo(), filters, filter, false);
        return c.calculateMultiplier();
    }

    public GridH2Table getTable() {
        return (GridH2Table)super.getTable();
    }

    @Nullable
    protected abstract Object doTakeSnapshot();

    protected <T> T threadLocalSnapshot() {
        return (T)this.snapshot.get();
    }

    public void releaseSnapshot() {
        Object s = this.snapshot.get();
        assert (s != null);
        this.snapshot.remove();
        if (s instanceof GridReservable) {
            ((GridReservable)s).release();
        }
        if (s instanceof AutoCloseable) {
            U.closeQuiet((AutoCloseable)((AutoCloseable)s));
        }
    }

    protected Iterator<GridH2Row> filter(Iterator<GridH2Row> iter, IndexingQueryFilter filter) {
        return new FilteringIterator(iter, U.currentTimeMillis(), filter, this.getTable().spaceName());
    }

    protected static IndexingQueryFilter threadLocalFilter() {
        GridH2QueryContext qctx = GridH2QueryContext.get();
        return qctx != null ? qctx.filter() : null;
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"add");
    }

    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"remove row");
    }

    public void remove(Session ses) {
        throw DbException.getUnsupportedException((String)"remove index");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public boolean needRebuild() {
        return false;
    }

    public IndexLookupBatch createLookupBatch(TableFilter filter) {
        boolean ucast;
        int affColId;
        GridH2QueryContext qctx = GridH2QueryContext.get();
        if (qctx == null || !qctx.distributedJoins() || !this.getTable().isPartitioned()) {
            return null;
        }
        IndexColumn affCol = this.getTable().getAffinityKeyColumn();
        if (affCol != null) {
            affColId = affCol.column.getColumnId();
            int[] masks = filter.getMasks();
            ucast = masks != null && masks[affColId] == 1;
        } else {
            affColId = -1;
            ucast = false;
        }
        GridCacheContext<?, ?> cctx = this.getTable().rowDescriptor().context();
        return new DistributedLookupBatch(cctx, ucast, affColId);
    }

    private void send(Collection<ClusterNode> nodes, Message msg) {
        if (!this.getTable().rowDescriptor().indexing().send(this.msgTopic, -1, nodes, msg, null, (IgniteInClosure2X<ClusterNode, Message>)this.locNodeHnd, (byte)8, false)) {
            throw new GridH2RetryException("Failed to send message to nodes: " + nodes + ".");
        }
    }

    private void onMessage0(UUID nodeId, Object msg) {
        block6: {
            ClusterNode node = this.kernalContext().discovery().node(nodeId);
            if (node == null) {
                return;
            }
            try {
                if (msg instanceof GridH2IndexRangeRequest) {
                    this.onIndexRangeRequest(node, (GridH2IndexRangeRequest)msg);
                } else if (msg instanceof GridH2IndexRangeResponse) {
                    this.onIndexRangeResponse(node, (GridH2IndexRangeResponse)msg);
                }
            }
            catch (Throwable th) {
                U.error((IgniteLogger)this.log, (Object)("Failed to handle message[nodeId=" + nodeId + ", msg=" + msg + "]"), (Throwable)th);
                if (!(th instanceof Error)) break block6;
                throw th;
            }
        }
    }

    private GridKernalContext kernalContext() {
        return this.getTable().rowDescriptor().context().kernalContext();
    }

    private void onIndexRangeRequest(ClusterNode node, GridH2IndexRangeRequest msg) {
        GridH2QueryContext qctx = GridH2QueryContext.get(this.kernalContext().localNodeId(), msg.originNodeId(), msg.queryId(), GridH2QueryType.MAP);
        GridH2IndexRangeResponse res = new GridH2IndexRangeResponse();
        res.originNodeId(msg.originNodeId());
        res.queryId(msg.queryId());
        res.batchLookupId(msg.batchLookupId());
        if (qctx == null) {
            res.status((byte)2);
        } else {
            try {
                GridH2RowRange range;
                RangeSource src;
                if (msg.bounds() != null) {
                    ConcurrentNavigableMap snapshot0 = (ConcurrentNavigableMap)qctx.getSnapshot(this.idxId);
                    assert (!msg.bounds().isEmpty()) : "empty bounds";
                    src = new RangeSource(msg.bounds(), snapshot0, qctx.filter());
                } else {
                    src = (RangeSource)qctx.getSource(node.id(), msg.batchLookupId());
                    assert (src != null);
                }
                ArrayList<GridH2RowRange> ranges = new ArrayList<GridH2RowRange>();
                int maxRows = qctx.pageSize();
                assert (maxRows > 0) : maxRows;
                while (maxRows > 0 && (range = src.next(maxRows)) != null) {
                    ranges.add(range);
                    if (range.rows() == null) continue;
                    maxRows -= range.rows().size();
                }
                if (src.hasMoreRows()) {
                    if (msg.bounds() != null) {
                        qctx.putSource(node.id(), msg.batchLookupId(), src);
                    }
                } else if (msg.bounds() == null) {
                    qctx.putSource(node.id(), msg.batchLookupId(), null);
                }
                assert (!ranges.isEmpty());
                res.ranges(ranges);
                res.status((byte)0);
            }
            catch (Throwable th) {
                U.error((IgniteLogger)this.log, (Object)("Failed to process request: " + msg), (Throwable)th);
                res.error(th.getClass() + ": " + th.getMessage());
                res.status((byte)1);
            }
        }
        this.send(Collections.singletonList(node), res);
    }

    private void onIndexRangeResponse(ClusterNode node, GridH2IndexRangeResponse msg) {
        GridH2QueryContext qctx = GridH2QueryContext.get(this.kernalContext().localNodeId(), msg.originNodeId(), msg.queryId(), GridH2QueryType.MAP);
        if (qctx == null) {
            return;
        }
        Map streams = (Map)qctx.getStreams(msg.batchLookupId());
        if (streams == null) {
            return;
        }
        RangeStream stream = (RangeStream)streams.get(node);
        assert (stream != null);
        stream.onResponse(msg);
    }

    private boolean equal(Value v1, Value v2) {
        return v1 == v2 || v1 != null && v2 != null && v1.compareTypeSafe(v2, this.getDatabase().getCompareMode()) == 0;
    }

    private static GridH2IndexRangeRequest createRequest(GridH2QueryContext qctx, int batchLookupId) {
        GridH2IndexRangeRequest req = new GridH2IndexRangeRequest();
        req.originNodeId(qctx.originNodeId());
        req.queryId(qctx.queryId());
        req.batchLookupId(batchLookupId);
        return req;
    }

    private List<ClusterNode> broadcastNodes(GridH2QueryContext qctx, GridCacheContext<?, ?> cctx) {
        ArrayList<ClusterNode> res;
        Map<UUID, int[]> partMap = qctx.partitionsMap();
        if (partMap == null) {
            res = new ArrayList(CU.affinityNodes(cctx, (AffinityTopologyVersion)qctx.topologyVersion()));
        } else {
            res = new ArrayList<ClusterNode>(partMap.size());
            GridKernalContext ctx = this.kernalContext();
            for (UUID nodeId : partMap.keySet()) {
                ClusterNode node = ctx.discovery().node(nodeId);
                if (node == null) {
                    throw new GridH2RetryException("Failed to find node.");
                }
                res.add(node);
            }
        }
        if (F.isEmpty(res)) {
            throw new GridH2RetryException("Failed to collect affinity nodes.");
        }
        return res;
    }

    private ClusterNode rangeNode(GridCacheContext<?, ?> cctx, GridH2QueryContext qctx, Object affKeyObj) {
        ClusterNode node;
        assert (affKeyObj != null && affKeyObj != EXPLICIT_NULL) : affKeyObj;
        if (qctx.partitionsMap() != null) {
            UUID nodeId = qctx.nodeForPartition(cctx.affinity().partition(affKeyObj), cctx);
            node = cctx.discovery().node(nodeId);
        } else {
            node = cctx.affinity().primary(affKeyObj, qctx.topologyVersion());
        }
        if (node == null) {
            throw new GridH2RetryException("Failed to find node.");
        }
        return node;
    }

    private GridH2RowMessage toRowMessage(Row row) {
        if (row == null) {
            return null;
        }
        int cols = row.getColumnCount();
        assert (cols > 0) : cols;
        ArrayList<GridH2ValueMessage> vals = new ArrayList<GridH2ValueMessage>(cols);
        for (int i = 0; i < cols; ++i) {
            try {
                vals.add(GridH2ValueMessageFactory.toMessage(row.getValue(i)));
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        GridH2RowMessage res = new GridH2RowMessage();
        res.values(vals);
        return res;
    }

    private SearchRow toSearchRow(GridH2RowMessage msg) {
        if (msg == null) {
            return null;
        }
        GridKernalContext ctx = this.kernalContext();
        Value[] vals = new Value[this.getTable().getColumns().length];
        assert (vals.length > 0);
        List<GridH2ValueMessage> msgVals = msg.values();
        for (int i = 0; i < this.indexColumns.length; ++i) {
            if (i >= msgVals.size()) continue;
            try {
                vals[this.indexColumns[i].column.getColumnId()] = msgVals.get(i).value(ctx);
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        return this.database.createRow(vals, -1);
    }

    private GridH2RowMessage toSearchRowMessage(SearchRow row) {
        if (row == null) {
            return null;
        }
        ArrayList<GridH2ValueMessage> vals = new ArrayList<GridH2ValueMessage>(this.indexColumns.length);
        for (IndexColumn idxCol : this.indexColumns) {
            Value val = row.getValue(idxCol.column.getColumnId());
            if (val == null) break;
            try {
                vals.add(GridH2ValueMessageFactory.toMessage(val));
            }
            catch (IgniteCheckedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        GridH2RowMessage res = new GridH2RowMessage();
        res.values(vals);
        return res;
    }

    private Row toRow(GridH2RowMessage msg) {
        if (msg == null) {
            return null;
        }
        GridKernalContext ctx = this.kernalContext();
        List<GridH2ValueMessage> vals = msg.values();
        assert (!F.isEmpty(vals)) : vals;
        Value[] vals0 = new Value[vals.size()];
        for (int i = 0; i < vals0.length; ++i) {
            try {
                vals0[i] = vals.get(i).value(ctx);
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        return this.database.createRow(vals0, -1);
    }

    protected ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> treeForRead() {
        throw new UnsupportedOperationException();
    }

    protected Iterator<GridH2Row> doFind0(ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> t, @Nullable SearchRow first, boolean includeFirst, @Nullable SearchRow last, IndexingQueryFilter filter) {
        throw new UnsupportedOperationException();
    }

    protected static class FilteringIterator
    extends GridFilteredIterator<GridH2Row> {
        private final IgniteBiPredicate<Object, Object> fltr;
        private final long time;
        private final boolean isValRequired;

        protected FilteringIterator(Iterator<GridH2Row> iter, long time, IndexingQueryFilter qryFilter, String spaceName) {
            super(iter);
            this.time = time;
            if (qryFilter != null) {
                this.fltr = qryFilter.forSpace(spaceName);
                this.isValRequired = qryFilter.isValueRequired();
            } else {
                this.fltr = null;
                this.isValRequired = false;
            }
        }

        protected boolean accept(GridH2Row row) {
            Object val;
            if (row instanceof GridH2AbstractKeyValueRow && ((GridH2AbstractKeyValueRow)row).expirationTime() <= this.time) {
                return false;
            }
            if (this.fltr == null) {
                return true;
            }
            Object key = row.getValue(0).getObject();
            Object object = val = this.isValRequired ? row.getValue(1).getObject() : null;
            assert (key != null);
            assert (!this.isValRequired || val != null);
            return this.fltr.apply(key, val);
        }
    }

    private class RangeSource {
        Iterator<GridH2RowRangeBounds> boundsIter;
        int curRangeId = -1;
        Iterator<GridH2Row> curRange = Collections.emptyIterator();
        final ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> tree;
        final IndexingQueryFilter filter;

        RangeSource(Iterable<GridH2RowRangeBounds> bounds, ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> tree, IndexingQueryFilter filter) {
            this.filter = filter;
            this.tree = tree;
            this.boundsIter = bounds.iterator();
        }

        public boolean hasMoreRows() {
            return this.boundsIter.hasNext() || this.curRange.hasNext();
        }

        public GridH2RowRange next(int maxRows) {
            assert (maxRows > 0) : maxRows;
            do {
                if (this.curRange.hasNext()) {
                    ArrayList<GridH2RowMessage> rows = new ArrayList<GridH2RowMessage>();
                    GridH2RowRange nextRange = new GridH2RowRange();
                    nextRange.rangeId(this.curRangeId);
                    nextRange.rows(rows);
                    do {
                        rows.add(GridH2IndexBase.this.toRowMessage(this.curRange.next()));
                    } while (rows.size() < maxRows && this.curRange.hasNext());
                    if (this.curRange.hasNext()) {
                        nextRange.setPartial();
                    } else {
                        this.curRange = Collections.emptyIterator();
                    }
                    return nextRange;
                }
                this.curRange = Collections.emptyIterator();
                if (!this.boundsIter.hasNext()) {
                    this.boundsIter = Collections.emptyIterator();
                    return null;
                }
                GridH2RowRangeBounds bounds = this.boundsIter.next();
                this.curRangeId = bounds.rangeId();
                SearchRow first = GridH2IndexBase.this.toSearchRow(bounds.first());
                SearchRow last = GridH2IndexBase.this.toSearchRow(bounds.last());
                ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> t = this.tree != null ? this.tree : GridH2IndexBase.this.treeForRead();
                this.curRange = GridH2IndexBase.this.doFind0(t, first, true, last, this.filter);
            } while (this.curRange.hasNext());
            GridH2RowRange emptyRange = new GridH2RowRange();
            emptyRange.rangeId(this.curRangeId);
            return emptyRange;
        }
    }

    private class RangeStream {
        final GridH2QueryContext qctx;
        final ClusterNode node;
        GridH2IndexRangeRequest req;
        int remainingRanges;
        final BlockingQueue<GridH2IndexRangeResponse> respQueue = new LinkedBlockingQueue<GridH2IndexRangeResponse>();
        Iterator<GridH2RowRange> ranges = Collections.emptyIterator();
        Cursor cursor = GridH2Cursor.EMPTY;
        int cursorRangeId = -1;

        RangeStream(GridH2QueryContext qctx, ClusterNode node) {
            this.node = node;
            this.qctx = qctx;
        }

        private void start() {
            this.remainingRanges = this.req.bounds().size();
            assert (this.remainingRanges > 0);
            if (GridH2IndexBase.this.log.isDebugEnabled()) {
                GridH2IndexBase.this.log.debug("Starting stream: [node=" + this.node + ", req=" + this.req + "]");
            }
            GridH2IndexBase.this.send(Collections.singletonList(this.node), this.req);
        }

        public void onResponse(GridH2IndexRangeResponse msg) {
            this.respQueue.add(msg);
        }

        private GridH2IndexRangeResponse awaitForResponse() {
            assert (this.remainingRanges > 0);
            long start = U.currentTimeMillis();
            int attempt = 0;
            while (true) {
                GridH2IndexRangeResponse res;
                if (this.qctx.isCleared()) {
                    throw new GridH2RetryException("Query is cancelled.");
                }
                if (GridH2IndexBase.this.kernalContext().isStopping()) {
                    throw new GridH2RetryException("Stopping node.");
                }
                try {
                    res = this.respQueue.poll(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new GridH2RetryException("Interrupted.");
                }
                if (res != null) {
                    switch (res.status()) {
                        case 0: {
                            List<GridH2RowRange> ranges0 = res.ranges();
                            this.remainingRanges -= ranges0.size();
                            if (ranges0.get(ranges0.size() - 1).isPartial()) {
                                ++this.remainingRanges;
                            }
                            if (this.remainingRanges > 0) {
                                if (this.req.bounds() != null) {
                                    this.req = GridH2IndexBase.createRequest(this.qctx, this.req.batchLookupId());
                                }
                                GridH2IndexBase.this.send(Collections.singletonList(this.node), this.req);
                            } else {
                                this.req = null;
                            }
                            return res;
                        }
                        case 2: {
                            if (this.req == null || this.req.bounds() == null) {
                                throw new GridH2RetryException("Failure on remote node.");
                            }
                            if (U.currentTimeMillis() - start > 30000L) {
                                throw new GridH2RetryException("Timeout.");
                            }
                            try {
                                U.sleep((long)(20 * attempt));
                            }
                            catch (IgniteInterruptedCheckedException e) {
                                throw new IgniteInterruptedException(e.getMessage());
                            }
                            GridH2IndexBase.this.send(Collections.singletonList(this.node), this.req);
                            break;
                        }
                        case 1: {
                            throw new CacheException(res.error());
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                if (!GridH2IndexBase.this.kernalContext().discovery().alive(this.node)) {
                    throw new GridH2RetryException("Node left: " + this.node);
                }
                ++attempt;
            }
        }

        private boolean next(int rangeId) {
            while (true) {
                Iterator<GridH2RowMessage> it;
                if (rangeId == this.cursorRangeId) {
                    if (this.cursor.next()) {
                        return true;
                    }
                } else if (rangeId < this.cursorRangeId) {
                    return false;
                }
                this.cursor = GridH2Cursor.EMPTY;
                while (!this.ranges.hasNext()) {
                    if (this.remainingRanges == 0) {
                        this.ranges = Collections.emptyIterator();
                        return false;
                    }
                    this.ranges = this.awaitForResponse().ranges().iterator();
                }
                GridH2RowRange range = this.ranges.next();
                this.cursorRangeId = range.rangeId();
                if (F.isEmpty(range.rows()) || !(it = range.rows().iterator()).hasNext()) continue;
                this.cursor = new GridH2Cursor((Iterator<? extends Row>)new Iterator<Row>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Row next() {
                        return GridH2IndexBase.this.toRow((GridH2RowMessage)it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        }

        private Row get(int rangeId) {
            assert (rangeId == this.cursorRangeId);
            return this.cursor.get();
        }
    }

    private class DistributedLookupBatch
    implements IndexLookupBatch {
        final GridCacheContext<?, ?> cctx;
        final boolean ucast;
        final int affColId;
        GridH2QueryContext qctx;
        int batchLookupId;
        Map<ClusterNode, RangeStream> rangeStreams = Collections.emptyMap();
        List<ClusterNode> broadcastNodes;
        List<Future<Cursor>> res = Collections.emptyList();
        boolean batchFull;
        boolean findCalled;

        private DistributedLookupBatch(GridCacheContext<?, ?> cctx, boolean ucast, int affColId) {
            this.cctx = cctx;
            this.ucast = ucast;
            this.affColId = affColId;
        }

        private Object getAffinityKey(SearchRow firstRow, SearchRow lastRow) {
            if (firstRow == null || lastRow == null) {
                return null;
            }
            Value affKeyFirst = firstRow.getValue(this.affColId);
            Value affKeyLast = lastRow.getValue(this.affColId);
            if (affKeyFirst != null && GridH2IndexBase.this.equal(affKeyFirst, affKeyLast)) {
                return affKeyFirst == ValueNull.INSTANCE ? EXPLICIT_NULL : affKeyFirst.getObject();
            }
            if (this.affColId == 0) {
                return null;
            }
            Value pkFirst = firstRow.getValue(0);
            Value pkLast = lastRow.getValue(0);
            if (pkFirst == ValueNull.INSTANCE || pkLast == ValueNull.INSTANCE) {
                return EXPLICIT_NULL;
            }
            if (pkFirst == null || pkLast == null || !GridH2IndexBase.this.equal(pkFirst, pkLast)) {
                return null;
            }
            Object pkAffKeyFirst = this.cctx.affinity().affinityKey(pkFirst.getObject());
            Object pkAffKeyLast = this.cctx.affinity().affinityKey(pkLast.getObject());
            if (pkAffKeyFirst == null || pkAffKeyLast == null) {
                throw new CacheException("Cache key without affinity key.");
            }
            if (pkAffKeyFirst.equals(pkAffKeyLast)) {
                return pkAffKeyFirst;
            }
            return null;
        }

        public boolean addSearchRows(SearchRow firstRow, SearchRow lastRow) {
            List nodes;
            Object affKey;
            if (this.qctx == null || this.findCalled) {
                if (this.qctx == null) {
                    this.qctx = GridH2QueryContext.get();
                    this.res = new ArrayList<Future<Cursor>>();
                    assert (this.qctx != null);
                    assert (!this.findCalled);
                } else {
                    assert (this.batchLookupId != 0);
                    this.findCalled = false;
                    this.qctx.putStreams(this.batchLookupId, null);
                    this.res.clear();
                }
                this.batchLookupId = this.qctx.nextBatchLookupId();
                this.rangeStreams = new HashMap<ClusterNode, RangeStream>();
            }
            Object object = affKey = this.affColId == -1 ? null : this.getAffinityKey(firstRow, lastRow);
            if (affKey != null) {
                if (affKey == EXPLICIT_NULL) {
                    return false;
                }
                nodes = F.asList((Object)GridH2IndexBase.this.rangeNode(this.cctx, this.qctx, affKey));
            } else {
                if (this.broadcastNodes == null) {
                    this.broadcastNodes = GridH2IndexBase.this.broadcastNodes(this.qctx, this.cctx);
                }
                nodes = this.broadcastNodes;
            }
            assert (!F.isEmpty(nodes)) : nodes;
            int rangeId = this.res.size();
            GridH2RowMessage first = GridH2IndexBase.this.toSearchRowMessage(firstRow);
            GridH2RowMessage last = GridH2IndexBase.this.toSearchRowMessage(lastRow);
            GridH2RowRangeBounds rangeBounds = GridH2RowRangeBounds.rangeBounds(rangeId, first, last);
            for (int i = 0; i < nodes.size(); ++i) {
                List<GridH2RowRangeBounds> bounds;
                ClusterNode node = (ClusterNode)nodes.get(i);
                assert (node != null);
                RangeStream stream = this.rangeStreams.get(node);
                if (stream == null) {
                    stream = new RangeStream(this.qctx, node);
                    stream.req = GridH2IndexBase.createRequest(this.qctx, this.batchLookupId);
                    bounds = new ArrayList<GridH2RowRangeBounds>();
                    stream.req.bounds(bounds);
                    this.rangeStreams.put(node, stream);
                } else {
                    bounds = stream.req.bounds();
                }
                bounds.add(rangeBounds);
                if (bounds.size() < this.qctx.pageSize()) continue;
                this.batchFull = true;
            }
            DoneFuture fut = new DoneFuture(nodes.size() == 1 ? new UnicastCursor(rangeId, nodes, this.rangeStreams) : new BroadcastCursor(rangeId, nodes, this.rangeStreams));
            this.res.add((Future<Cursor>)fut);
            return true;
        }

        public boolean isBatchFull() {
            return this.batchFull;
        }

        private void startStreams() {
            if (this.rangeStreams.isEmpty()) {
                assert (this.res.isEmpty());
                return;
            }
            this.qctx.putStreams(this.batchLookupId, this.rangeStreams);
            for (RangeStream stream : this.rangeStreams.values()) {
                stream.start();
            }
        }

        public List<Future<Cursor>> find() {
            this.batchFull = false;
            this.findCalled = true;
            this.startStreams();
            return this.res;
        }

        public void reset(boolean beforeQry) {
            if (beforeQry || this.qctx == null) {
                return;
            }
            assert (this.batchLookupId != 0);
            this.qctx.putStreams(this.batchLookupId, null);
            this.qctx = null;
            this.batchLookupId = 0;
            this.rangeStreams = Collections.emptyMap();
            this.broadcastNodes = null;
            this.batchFull = false;
            this.findCalled = false;
            this.res = Collections.emptyList();
        }

        public String getPlanSQL() {
            return this.ucast ? "unicast" : "broadcast";
        }
    }

    private class BroadcastCursor
    implements Cursor,
    Comparator<RangeStream> {
        final int rangeId;
        final RangeStream[] streams;
        boolean first = true;
        int off;

        private BroadcastCursor(int rangeId, Collection<ClusterNode> nodes, Map<ClusterNode, RangeStream> rangeStreams) {
            assert (nodes.size() > 1);
            this.rangeId = rangeId;
            this.streams = new RangeStream[nodes.size()];
            int i = 0;
            for (ClusterNode node : nodes) {
                RangeStream stream = rangeStreams.get(node);
                assert (stream != null);
                this.streams[i++] = stream;
            }
        }

        @Override
        public int compare(RangeStream o1, RangeStream o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return GridH2IndexBase.this.compareRows((SearchRow)o1.get(this.rangeId), (SearchRow)o2.get(this.rangeId));
        }

        private boolean goFirst() {
            for (int i = 0; i < this.streams.length; ++i) {
                if (this.streams[i].next(this.rangeId)) continue;
                this.streams[i] = null;
                ++this.off;
            }
            if (this.off == this.streams.length) {
                return false;
            }
            Arrays.sort(this.streams, this);
            return true;
        }

        private boolean goNext() {
            assert (this.off != this.streams.length);
            if (!this.streams[this.off].next(this.rangeId)) {
                this.streams[this.off] = null;
                return ++this.off != this.streams.length;
            }
            int last = this.streams.length - 1;
            for (int i = this.off; i < last && GridH2IndexBase.this.compareRows((SearchRow)this.streams[i].get(this.rangeId), (SearchRow)this.streams[i + 1].get(this.rangeId)) > 0; ++i) {
                U.swap((Object[])this.streams, (int)i, (int)(i + 1));
            }
            return true;
        }

        public boolean next() {
            if (this.first) {
                this.first = false;
                return this.goFirst();
            }
            return this.goNext();
        }

        public Row get() {
            return this.streams[this.off].get(this.rangeId);
        }

        public SearchRow getSearchRow() {
            return this.get();
        }

        public boolean previous() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnicastCursor
    implements Cursor {
        final int rangeId;
        RangeStream stream;

        private UnicastCursor(int rangeId, Collection<ClusterNode> nodes, Map<ClusterNode, RangeStream> rangeStreams) {
            assert (nodes.size() == 1);
            this.rangeId = rangeId;
            this.stream = rangeStreams.get(F.first(nodes));
            assert (this.stream != null);
        }

        public boolean next() {
            return this.stream.next(this.rangeId);
        }

        public Row get() {
            return this.stream.get(this.rangeId);
        }

        public SearchRow getSearchRow() {
            return this.get();
        }

        public boolean previous() {
            throw new UnsupportedOperationException();
        }
    }
}

