/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.Parser;
import org.h2.util.StatementBuilder;
import org.h2.value.ValueString;

public class GridSqlFunction
extends GridSqlElement {
    private static final Map<String, GridSqlFunctionType> TYPE_MAP = new HashMap<String, GridSqlFunctionType>();
    private final String schema;
    private final String name;
    protected final GridSqlFunctionType type;

    public GridSqlFunction(GridSqlFunctionType type) {
        this(null, type, type.functionName());
    }

    private GridSqlFunction(String schema, GridSqlFunctionType type, String name) {
        super(new ArrayList<GridSqlElement>());
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            type = GridSqlFunctionType.UNKNOWN_FUNCTION;
        }
        this.schema = schema;
        this.name = name;
        this.type = type;
    }

    public GridSqlFunction(String schema, String name) {
        this(schema, TYPE_MAP.get(name), name);
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder();
        if (this.schema != null) {
            buff.append(Parser.quoteIdentifier((String)this.schema)).append('.');
        }
        buff.append(this.name);
        if (this.type == GridSqlFunctionType.CASE) {
            buff.append(' ').append(((GridSqlElement)this.child()).getSQL());
            int len = this.children.size() - 1;
            for (int i = 1; i < len; i += 2) {
                buff.append(" WHEN ").append(((GridSqlElement)this.child(i)).getSQL());
                buff.append(" THEN ").append(((GridSqlElement)this.child(i + 1)).getSQL());
            }
            if ((this.children.size() & 1) == 0) {
                buff.append(" ELSE ").append(((GridSqlElement)this.child(this.children.size() - 1)).getSQL());
            }
            return buff.append(" END").toString();
        }
        buff.append('(');
        switch (this.type) {
            case CAST: 
            case CONVERT: {
                assert (this.size() == 1);
                String castType = this.resultType().sql();
                assert (!F.isEmpty((String)castType)) : castType;
                buff.append(((GridSqlElement)this.child()).getSQL());
                buff.append(this.type == GridSqlFunctionType.CAST ? " AS " : ",");
                buff.append(castType);
                break;
            }
            case EXTRACT: {
                ValueString v = (ValueString)((GridSqlConst)this.child(0)).value();
                buff.append(v.getString()).append(" FROM ").append(((GridSqlElement)this.child(1)).getSQL());
                break;
            }
            case TABLE: {
                for (GridSqlElement e : this.children) {
                    buff.appendExceptFirst(", ");
                    buff.append(((GridSqlAlias)e).alias()).append(' ').append(e.resultType().sql()).append('=').append(((GridSqlElement)e.child()).getSQL());
                }
                break;
            }
            default: {
                for (GridSqlElement e : this.children) {
                    buff.appendExceptFirst(", ");
                    buff.append(e.getSQL());
                }
            }
        }
        return buff.append(')').toString();
    }

    public String name() {
        return this.name;
    }

    public GridSqlFunctionType type() {
        return this.type;
    }

    static {
        for (GridSqlFunctionType type : GridSqlFunctionType.values()) {
            TYPE_MAP.put(type.name(), type);
        }
    }
}

