/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.cache.CacheException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAggregateFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlArray;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDelete;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlInsert;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlKeyword;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlMerge;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlPlaceholder;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUpdate;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.Prepared;
import org.h2.command.dml.Delete;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectUnion;
import org.h2.command.dml.Update;
import org.h2.engine.FunctionAlias;
import org.h2.expression.Aggregate;
import org.h2.expression.Alias;
import org.h2.expression.CompareLike;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.ConditionIn;
import org.h2.expression.ConditionInConstantSet;
import org.h2.expression.ConditionInSelect;
import org.h2.expression.ConditionNot;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.Function;
import org.h2.expression.JavaFunction;
import org.h2.expression.Operation;
import org.h2.expression.Parameter;
import org.h2.expression.Subquery;
import org.h2.expression.TableFunction;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.ViewIndex;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.FunctionTable;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.jetbrains.annotations.Nullable;

public class GridSqlQueryParser {
    private static final GridSqlOperationType[] OPERATION_OP_TYPES = new GridSqlOperationType[]{GridSqlOperationType.CONCAT, GridSqlOperationType.PLUS, GridSqlOperationType.MINUS, GridSqlOperationType.MULTIPLY, GridSqlOperationType.DIVIDE, null, GridSqlOperationType.MODULUS};
    private static final GridSqlOperationType[] COMPARISON_TYPES = new GridSqlOperationType[]{GridSqlOperationType.EQUAL, GridSqlOperationType.BIGGER_EQUAL, GridSqlOperationType.BIGGER, GridSqlOperationType.SMALLER_EQUAL, GridSqlOperationType.SMALLER, GridSqlOperationType.NOT_EQUAL, GridSqlOperationType.IS_NULL, GridSqlOperationType.IS_NOT_NULL, null, null, null, GridSqlOperationType.SPATIAL_INTERSECTS, null, null, null, null, GridSqlOperationType.EQUAL_NULL_SAFE, null, null, null, null, GridSqlOperationType.NOT_EQUAL_NULL_SAFE};
    private static final Getter<Select, Expression> CONDITION = GridSqlQueryParser.getter(Select.class, "condition");
    private static final Getter<Select, int[]> GROUP_INDEXES = GridSqlQueryParser.getter(Select.class, "groupIndex");
    private static final Getter<Operation, Integer> OPERATION_TYPE = GridSqlQueryParser.getter(Operation.class, "opType");
    private static final Getter<Operation, Expression> OPERATION_LEFT = GridSqlQueryParser.getter(Operation.class, "left");
    private static final Getter<Operation, Expression> OPERATION_RIGHT = GridSqlQueryParser.getter(Operation.class, "right");
    private static final Getter<Comparison, Integer> COMPARISON_TYPE = GridSqlQueryParser.getter(Comparison.class, "compareType");
    private static final Getter<Comparison, Expression> COMPARISON_LEFT = GridSqlQueryParser.getter(Comparison.class, "left");
    private static final Getter<Comparison, Expression> COMPARISON_RIGHT = GridSqlQueryParser.getter(Comparison.class, "right");
    private static final Getter<ConditionAndOr, Integer> ANDOR_TYPE = GridSqlQueryParser.getter(ConditionAndOr.class, "andOrType");
    private static final Getter<ConditionAndOr, Expression> ANDOR_LEFT = GridSqlQueryParser.getter(ConditionAndOr.class, "left");
    private static final Getter<ConditionAndOr, Expression> ANDOR_RIGHT = GridSqlQueryParser.getter(ConditionAndOr.class, "right");
    public static final Getter<TableView, Query> VIEW_QUERY = GridSqlQueryParser.getter(TableView.class, "viewQuery");
    private static final Getter<TableFilter, String> ALIAS = GridSqlQueryParser.getter(TableFilter.class, "alias");
    private static final Getter<Select, Integer> HAVING_INDEX = GridSqlQueryParser.getter(Select.class, "havingIndex");
    private static final Getter<ConditionIn, Expression> LEFT_CI = GridSqlQueryParser.getter(ConditionIn.class, "left");
    private static final Getter<ConditionIn, List<Expression>> VALUE_LIST_CI = GridSqlQueryParser.getter(ConditionIn.class, "valueList");
    private static final Getter<ConditionInConstantSet, Expression> LEFT_CICS = GridSqlQueryParser.getter(ConditionInConstantSet.class, "left");
    private static final Getter<ConditionInConstantSet, List<Expression>> VALUE_LIST_CICS = GridSqlQueryParser.getter(ConditionInConstantSet.class, "valueList");
    private static final Getter<ExpressionList, Expression[]> EXPR_LIST = GridSqlQueryParser.getter(ExpressionList.class, "list");
    private static final Getter<ConditionInSelect, Expression> LEFT_CIS = GridSqlQueryParser.getter(ConditionInSelect.class, "left");
    private static final Getter<ConditionInSelect, Boolean> ALL = GridSqlQueryParser.getter(ConditionInSelect.class, "all");
    private static final Getter<ConditionInSelect, Integer> COMPARE_TYPE = GridSqlQueryParser.getter(ConditionInSelect.class, "compareType");
    private static final Getter<ConditionInSelect, Query> QUERY = GridSqlQueryParser.getter(ConditionInSelect.class, "query");
    private static final Getter<CompareLike, Expression> LEFT = GridSqlQueryParser.getter(CompareLike.class, "left");
    private static final Getter<CompareLike, Expression> RIGHT = GridSqlQueryParser.getter(CompareLike.class, "right");
    private static final Getter<CompareLike, Expression> ESCAPE = GridSqlQueryParser.getter(CompareLike.class, "escape");
    private static final Getter<CompareLike, Boolean> REGEXP_CL = GridSqlQueryParser.getter(CompareLike.class, "regexp");
    private static final Getter<Aggregate, Boolean> DISTINCT = GridSqlQueryParser.getter(Aggregate.class, "distinct");
    private static final Getter<Aggregate, Integer> TYPE = GridSqlQueryParser.getter(Aggregate.class, "type");
    private static final Getter<Aggregate, Expression> ON = GridSqlQueryParser.getter(Aggregate.class, "on");
    private static final Getter<RangeTable, Expression> RANGE_MIN = GridSqlQueryParser.getter(RangeTable.class, "min");
    private static final Getter<RangeTable, Expression> RANGE_MAX = GridSqlQueryParser.getter(RangeTable.class, "max");
    private static final Getter<FunctionTable, Expression> FUNC_EXPR = GridSqlQueryParser.getter(FunctionTable.class, "functionExpr");
    private static final Getter<TableFunction, Column[]> FUNC_TBL_COLS = GridSqlQueryParser.getter(TableFunction.class, "columnList");
    private static final Getter<JavaFunction, FunctionAlias> FUNC_ALIAS = GridSqlQueryParser.getter(JavaFunction.class, "functionAlias");
    private static final Getter<JdbcPreparedStatement, Command> COMMAND = GridSqlQueryParser.getter(JdbcPreparedStatement.class, "command");
    private static final Getter<SelectUnion, SortOrder> UNION_SORT = GridSqlQueryParser.getter(SelectUnion.class, "sort");
    private static final Getter<Explain, Prepared> EXPLAIN_COMMAND = GridSqlQueryParser.getter(Explain.class, "command");
    private static final Getter<Merge, Table> MERGE_TABLE = GridSqlQueryParser.getter(Merge.class, "table");
    private static final Getter<Merge, Column[]> MERGE_COLUMNS = GridSqlQueryParser.getter(Merge.class, "columns");
    private static final Getter<Merge, Column[]> MERGE_KEYS = GridSqlQueryParser.getter(Merge.class, "keys");
    private static final Getter<Merge, List<Expression[]>> MERGE_ROWS = GridSqlQueryParser.getter(Merge.class, "list");
    private static final Getter<Merge, Query> MERGE_QUERY = GridSqlQueryParser.getter(Merge.class, "query");
    private static final Getter<Insert, Table> INSERT_TABLE = GridSqlQueryParser.getter(Insert.class, "table");
    private static final Getter<Insert, Column[]> INSERT_COLUMNS = GridSqlQueryParser.getter(Insert.class, "columns");
    private static final Getter<Insert, List<Expression[]>> INSERT_ROWS = GridSqlQueryParser.getter(Insert.class, "list");
    private static final Getter<Insert, Query> INSERT_QUERY = GridSqlQueryParser.getter(Insert.class, "query");
    private static final Getter<Insert, Boolean> INSERT_DIRECT = GridSqlQueryParser.getter(Insert.class, "insertFromSelect");
    private static final Getter<Insert, Boolean> INSERT_SORTED = GridSqlQueryParser.getter(Insert.class, "sortedInsertMode");
    private static final Getter<Delete, TableFilter> DELETE_FROM = GridSqlQueryParser.getter(Delete.class, "tableFilter");
    private static final Getter<Delete, Expression> DELETE_WHERE = GridSqlQueryParser.getter(Delete.class, "condition");
    private static final Getter<Delete, Expression> DELETE_LIMIT = GridSqlQueryParser.getter(Delete.class, "limitExpr");
    private static final Getter<Update, TableFilter> UPDATE_TARGET = GridSqlQueryParser.getter(Update.class, "tableFilter");
    private static final Getter<Update, ArrayList<Column>> UPDATE_COLUMNS = GridSqlQueryParser.getter(Update.class, "columns");
    private static final Getter<Update, HashMap<Column, Expression>> UPDATE_SET = GridSqlQueryParser.getter(Update.class, "expressionMap");
    private static final Getter<Update, Expression> UPDATE_WHERE = GridSqlQueryParser.getter(Update.class, "condition");
    private static final Getter<Update, Expression> UPDATE_LIMIT = GridSqlQueryParser.getter(Update.class, "limitExpr");
    private static final Getter<Command, Prepared> PREPARED = GridSqlQueryParser.getter(CommandContainer.class, "prepared");
    private final IdentityHashMap<Object, Object> h2ObjToGridObj = new IdentityHashMap();

    public static Prepared prepared(JdbcPreparedStatement stmt) {
        Command cmd = COMMAND.get(stmt);
        assert (cmd instanceof CommandContainer);
        return PREPARED.get(cmd);
    }

    private GridSqlElement parseTable(TableFilter filter) {
        GridSqlElement res = (GridSqlElement)this.h2ObjToGridObj.get(filter);
        if (res == null) {
            res = this.parseTable(filter.getTable(), filter.getIndex(), filter.getSelect() != null ? filter.getSelect().getSQL() : null);
            String alias = ALIAS.get(filter);
            if (alias != null) {
                res = new GridSqlAlias(alias, res, false);
            }
            this.h2ObjToGridObj.put(filter, res);
        }
        return res;
    }

    private GridSqlElement parseTable(Table tbl, @Nullable Index idx, String sql) {
        GridSqlElement res = (GridSqlElement)this.h2ObjToGridObj.get(tbl);
        if (res == null) {
            if (tbl instanceof TableBase) {
                res = new GridSqlTable(tbl);
            } else if (tbl instanceof TableView) {
                Query qry = VIEW_QUERY.get((TableView)tbl);
                Query idxQry = idx instanceof ViewIndex ? ((ViewIndex)idx).getQuery() : null;
                res = new GridSqlSubquery(this.parse(qry, idxQry));
            } else if (tbl instanceof FunctionTable) {
                res = this.parseExpression(FUNC_EXPR.get((FunctionTable)tbl), false);
            } else if (tbl instanceof RangeTable) {
                res = new GridSqlFunction(GridSqlFunctionType.SYSTEM_RANGE);
                res.addChild(this.parseExpression(RANGE_MIN.get((RangeTable)tbl), false));
                res.addChild(this.parseExpression(RANGE_MAX.get((RangeTable)tbl), false));
            } else {
                GridSqlQueryParser.assert0(false, "Unexpected Table implementation [cls=" + tbl.getClass().getSimpleName() + ", " + "sql=" + sql + ']');
            }
            this.h2ObjToGridObj.put(tbl, res);
        }
        return res;
    }

    public GridSqlSelect parse(Select select, @Nullable Query idxQry) {
        int havingIdx;
        GridSqlSelect res = (GridSqlSelect)this.h2ObjToGridObj.get(select);
        if (res != null) {
            return res;
        }
        res = new GridSqlSelect();
        this.h2ObjToGridObj.put(select, res);
        res.distinct(select.isDistinct());
        Expression where = CONDITION.get(select);
        res.where(this.parseExpression(where, false));
        GridSqlElement from = null;
        TableFilter filter = select.getTopTableFilter();
        if (idxQry instanceof Select) {
            filter = ((Select)idxQry).getTopTableFilter();
        }
        do {
            GridSqlQueryParser.assert0(filter != null, select);
            GridSqlQueryParser.assert0(filter.getNestedJoin() == null, select);
            GridSqlElement gridFilter = this.parseTable(filter);
            GridSqlElement gridSqlElement = from = from == null ? gridFilter : new GridSqlJoin(from, gridFilter, filter.isJoinOuter(), this.parseExpression(filter.getJoinCondition(), false));
        } while ((filter = filter.getJoin()) != null);
        res.from(from);
        ArrayList expressions = select.getExpressions();
        for (int i = 0; i < expressions.size(); ++i) {
            res.addColumn(this.parseExpression((Expression)expressions.get(i), true), i < select.getColumnCount());
        }
        int[] grpIdx = GROUP_INDEXES.get(select);
        if (grpIdx != null) {
            res.groupColumns(grpIdx);
        }
        if ((havingIdx = HAVING_INDEX.get(select).intValue()) >= 0) {
            res.havingColumn(havingIdx);
        }
        this.processSortOrder(select.getSortOrder(), res);
        res.limit(this.parseExpression(select.getLimit(), false));
        res.offset(this.parseExpression(select.getOffset(), false));
        return res;
    }

    private GridSqlMerge parseMerge(Merge merge) {
        GridSqlMerge res = (GridSqlMerge)this.h2ObjToGridObj.get(merge);
        if (res != null) {
            return res;
        }
        res = new GridSqlMerge();
        this.h2ObjToGridObj.put(merge, res);
        Table srcTbl = MERGE_TABLE.get(merge);
        GridSqlElement tbl = this.parseTable(srcTbl, null, merge.getSQL());
        res.into(tbl);
        Column[] srcCols = MERGE_COLUMNS.get(merge);
        GridSqlColumn[] cols = new GridSqlColumn[srcCols.length];
        for (int i = 0; i < srcCols.length; ++i) {
            cols[i] = new GridSqlColumn(srcCols[i], tbl, srcCols[i].getName(), srcCols[i].getSQL());
            cols[i].resultType(GridSqlType.fromColumn(srcCols[i]));
        }
        res.columns(cols);
        Column[] srcKeys = MERGE_KEYS.get(merge);
        GridSqlColumn[] keys = new GridSqlColumn[srcKeys.length];
        for (int i = 0; i < srcKeys.length; ++i) {
            keys[i] = new GridSqlColumn(srcKeys[i], tbl, srcKeys[i].getName(), srcKeys[i].getSQL());
        }
        res.keys(keys);
        List<Expression[]> srcRows = MERGE_ROWS.get(merge);
        if (!srcRows.isEmpty()) {
            ArrayList<GridSqlElement[]> rows = new ArrayList<GridSqlElement[]>(srcRows.size());
            for (Expression[] srcRow : srcRows) {
                GridSqlElement[] row = new GridSqlElement[srcRow.length];
                for (int i = 0; i < srcRow.length; ++i) {
                    row[i] = this.parseExpression(srcRow[i], false);
                }
                rows.add(row);
            }
            res.rows(rows);
        } else {
            res.rows(Collections.emptyList());
            res.query(this.parse(MERGE_QUERY.get(merge), null));
        }
        return res;
    }

    private GridSqlInsert parseInsert(Insert insert) {
        GridSqlInsert res = (GridSqlInsert)this.h2ObjToGridObj.get(insert);
        if (res != null) {
            return res;
        }
        res = new GridSqlInsert();
        this.h2ObjToGridObj.put(insert, res);
        Table srcTbl = INSERT_TABLE.get(insert);
        GridSqlElement tbl = this.parseTable(srcTbl, null, insert.getSQL());
        res.into(tbl).direct(INSERT_DIRECT.get(insert)).sorted(INSERT_SORTED.get(insert));
        Column[] srcCols = INSERT_COLUMNS.get(insert);
        GridSqlColumn[] cols = new GridSqlColumn[srcCols.length];
        for (int i = 0; i < srcCols.length; ++i) {
            cols[i] = new GridSqlColumn(srcCols[i], tbl, srcCols[i].getName(), srcCols[i].getSQL());
            cols[i].resultType(GridSqlType.fromColumn(srcCols[i]));
        }
        res.columns(cols);
        List<Expression[]> srcRows = INSERT_ROWS.get(insert);
        if (!srcRows.isEmpty()) {
            ArrayList<GridSqlElement[]> rows = new ArrayList<GridSqlElement[]>(srcRows.size());
            for (Expression[] srcRow : srcRows) {
                GridSqlElement[] row = new GridSqlElement[srcRow.length];
                for (int i = 0; i < srcRow.length; ++i) {
                    row[i] = this.parseExpression(srcRow[i], false);
                }
                rows.add(row);
            }
            res.rows(rows);
        } else {
            res.rows(Collections.emptyList());
            res.query(this.parse(INSERT_QUERY.get(insert), null));
        }
        return res;
    }

    private GridSqlDelete parseDelete(Delete del) {
        GridSqlDelete res = (GridSqlDelete)this.h2ObjToGridObj.get(del);
        if (res != null) {
            return res;
        }
        res = new GridSqlDelete();
        this.h2ObjToGridObj.put(del, res);
        GridSqlElement tbl = this.parseTable(DELETE_FROM.get(del));
        GridSqlElement where = this.parseExpression(DELETE_WHERE.get(del), true);
        GridSqlElement limit = this.parseExpression(DELETE_LIMIT.get(del), true);
        res.from(tbl).where(where).limit(limit);
        return res;
    }

    private GridSqlUpdate parseUpdate(Update update) {
        GridSqlUpdate res = (GridSqlUpdate)this.h2ObjToGridObj.get(update);
        if (res != null) {
            return res;
        }
        res = new GridSqlUpdate();
        this.h2ObjToGridObj.put(update, res);
        GridSqlElement tbl = this.parseTable(UPDATE_TARGET.get(update));
        List srcCols = UPDATE_COLUMNS.get(update);
        Map srcSet = UPDATE_SET.get(update);
        ArrayList<GridSqlColumn> cols = new ArrayList<GridSqlColumn>(srcCols.size());
        LinkedHashMap<String, GridSqlElement> set = new LinkedHashMap<String, GridSqlElement>(srcSet.size());
        for (Column c : srcCols) {
            GridSqlColumn col = new GridSqlColumn(c, tbl, c.getName(), c.getSQL());
            col.resultType(GridSqlType.fromColumn(c));
            cols.add(col);
            set.put(col.columnName(), this.parseExpression((Expression)srcSet.get(c), true));
        }
        GridSqlElement where = this.parseExpression(UPDATE_WHERE.get(update), true);
        GridSqlElement limit = this.parseExpression(UPDATE_LIMIT.get(update), true);
        res.target(tbl).cols(cols).set(set).where(where).limit(limit);
        return res;
    }

    private void processSortOrder(SortOrder sortOrder, GridSqlQuery qry) {
        if (sortOrder == null) {
            return;
        }
        int[] indexes = sortOrder.getQueryColumnIndexes();
        int[] sortTypes = sortOrder.getSortTypes();
        for (int i = 0; i < indexes.length; ++i) {
            int colIdx = indexes[i];
            int type = sortTypes[i];
            qry.addSort(new GridSqlSortColumn(colIdx, (type & 1) == 0, (type & 2) != 0, (type & 4) != 0));
        }
    }

    public static Query query(Prepared qry) {
        if (qry instanceof Query) {
            return (Query)qry;
        }
        if (qry instanceof Explain) {
            return GridSqlQueryParser.query(EXPLAIN_COMMAND.get((Explain)qry));
        }
        throw new CacheException("Unsupported query: " + qry);
    }

    public GridSqlStatement parse(Prepared qry) {
        return this.parse(qry, null);
    }

    public GridSqlStatement parse(Prepared qry, @Nullable Query idxQry) {
        assert (qry != null);
        if (qry instanceof Query) {
            return this.parse((Query)qry, idxQry);
        }
        if (qry instanceof Merge) {
            return this.parseMerge((Merge)qry);
        }
        if (qry instanceof Insert) {
            return this.parseInsert((Insert)qry);
        }
        if (qry instanceof Delete) {
            return this.parseDelete((Delete)qry);
        }
        if (qry instanceof Update) {
            return this.parseUpdate((Update)qry);
        }
        if (qry instanceof Explain) {
            GridSqlStatement stmt = this.parse(EXPLAIN_COMMAND.get((Explain)qry));
            if (!(stmt instanceof GridSqlQuery)) {
                throw new IgniteSQLException("EXPLAIN is not supported for DML statement: " + qry, 1002);
            }
            return stmt.explain(true);
        }
        throw new IgniteSQLException("Unsupported statement: " + qry, 1002);
    }

    private GridSqlQuery parse(Query qry, @Nullable Query idxQry) {
        if (qry instanceof Select) {
            return this.parse((Select)qry, idxQry);
        }
        if (qry instanceof SelectUnion) {
            return this.parse((SelectUnion)qry);
        }
        throw new UnsupportedOperationException("Unknown query type: " + qry);
    }

    public GridSqlUnion parse(SelectUnion union) {
        GridSqlUnion res = (GridSqlUnion)this.h2ObjToGridObj.get(union);
        if (res != null) {
            return res;
        }
        res = new GridSqlUnion();
        res.right(this.parse(union.getRight(), null));
        res.left(this.parse(union.getLeft(), null));
        res.unionType(union.getUnionType());
        res.limit(this.parseExpression(union.getLimit(), false));
        res.offset(this.parseExpression(union.getOffset(), false));
        this.processSortOrder(UNION_SORT.get(union), res);
        this.h2ObjToGridObj.put(union, res);
        return res;
    }

    private GridSqlElement parseExpression(@Nullable Expression expression, boolean calcTypes) {
        if (expression == null) {
            return null;
        }
        GridSqlElement res = (GridSqlElement)this.h2ObjToGridObj.get(expression);
        if (res == null) {
            res = this.parseExpression0(expression, calcTypes);
            if (calcTypes) {
                res.resultType(GridSqlType.fromExpression(expression));
            }
            this.h2ObjToGridObj.put(expression, res);
        }
        return res;
    }

    private GridSqlElement parseExpression0(Expression expression, boolean calcTypes) {
        int typeId;
        if (expression instanceof ExpressionColumn) {
            ExpressionColumn expCol = (ExpressionColumn)expression;
            return new GridSqlColumn(expCol.getColumn(), this.parseTable(expCol.getTableFilter()), expression.getColumnName(), expression.getSQL());
        }
        if (expression instanceof Alias) {
            return new GridSqlAlias(expression.getAlias(), this.parseExpression(expression.getNonAliasExpression(), calcTypes), true);
        }
        if (expression instanceof ValueExpression) {
            return expression == ValueExpression.getDefault() ? GridSqlKeyword.DEFAULT : new GridSqlConst(expression.getValue(null));
        }
        if (expression instanceof Operation) {
            Operation operation = (Operation)expression;
            Integer type = OPERATION_TYPE.get(operation);
            if (type == 5) {
                assert (OPERATION_RIGHT.get(operation) == null);
                return new GridSqlOperation(GridSqlOperationType.NEGATE, this.parseExpression(OPERATION_LEFT.get(operation), calcTypes));
            }
            return new GridSqlOperation(OPERATION_OP_TYPES[type], this.parseExpression(OPERATION_LEFT.get(operation), calcTypes), this.parseExpression(OPERATION_RIGHT.get(operation), calcTypes));
        }
        if (expression instanceof Comparison) {
            Comparison cmp = (Comparison)expression;
            GridSqlOperationType opType = COMPARISON_TYPES[COMPARISON_TYPE.get(cmp)];
            assert (opType != null) : COMPARISON_TYPE.get(cmp);
            Expression leftExp = COMPARISON_LEFT.get(cmp);
            GridSqlElement left = this.parseExpression(leftExp, calcTypes);
            if (opType.childrenCount() == 1) {
                return new GridSqlOperation(opType, left);
            }
            Expression rightExp = COMPARISON_RIGHT.get(cmp);
            GridSqlElement right = this.parseExpression(rightExp, calcTypes);
            return new GridSqlOperation(opType, left, right);
        }
        if (expression instanceof ConditionNot) {
            return new GridSqlOperation(GridSqlOperationType.NOT, this.parseExpression(expression.getNotIfPossible(null), calcTypes));
        }
        if (expression instanceof ConditionAndOr) {
            ConditionAndOr andOr = (ConditionAndOr)expression;
            int type = ANDOR_TYPE.get(andOr);
            assert (type == 0 || type == 1);
            return new GridSqlOperation(type == 0 ? GridSqlOperationType.AND : GridSqlOperationType.OR, this.parseExpression(ANDOR_LEFT.get(andOr), calcTypes), this.parseExpression(ANDOR_RIGHT.get(andOr), calcTypes));
        }
        if (expression instanceof Subquery) {
            Query qry = ((Subquery)expression).getQuery();
            GridSqlQueryParser.assert0(qry instanceof Select, expression);
            return new GridSqlSubquery(this.parse(qry, null));
        }
        if (expression instanceof ConditionIn) {
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.IN);
            res.addChild(this.parseExpression(LEFT_CI.get((ConditionIn)expression), calcTypes));
            List<Expression> vals = VALUE_LIST_CI.get((ConditionIn)expression);
            for (Expression val : vals) {
                res.addChild(this.parseExpression(val, calcTypes));
            }
            return res;
        }
        if (expression instanceof ConditionInConstantSet) {
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.IN);
            res.addChild(this.parseExpression(LEFT_CICS.get((ConditionInConstantSet)expression), calcTypes));
            List<Expression> vals = VALUE_LIST_CICS.get((ConditionInConstantSet)expression);
            for (Expression val : vals) {
                res.addChild(this.parseExpression(val, calcTypes));
            }
            return res;
        }
        if (expression instanceof ConditionInSelect) {
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.IN);
            boolean all = ALL.get((ConditionInSelect)expression);
            int compareType = COMPARE_TYPE.get((ConditionInSelect)expression);
            GridSqlQueryParser.assert0(!all, expression);
            GridSqlQueryParser.assert0(compareType == 0, expression);
            res.addChild(this.parseExpression(LEFT_CIS.get((ConditionInSelect)expression), calcTypes));
            Query qry = QUERY.get((ConditionInSelect)expression);
            GridSqlQueryParser.assert0(qry instanceof Select, qry);
            res.addChild(new GridSqlSubquery(this.parse(qry, null)));
            return res;
        }
        if (expression instanceof CompareLike) {
            GridSqlQueryParser.assert0(ESCAPE.get((CompareLike)expression) == null, expression);
            boolean regexp = REGEXP_CL.get((CompareLike)expression);
            return new GridSqlOperation(regexp ? GridSqlOperationType.REGEXP : GridSqlOperationType.LIKE, this.parseExpression(LEFT.get((CompareLike)expression), calcTypes), this.parseExpression(RIGHT.get((CompareLike)expression), calcTypes));
        }
        if (expression instanceof Function) {
            Function f = (Function)expression;
            GridSqlFunction res = new GridSqlFunction(null, f.getName());
            if (f.getArgs() != null) {
                if (f.getFunctionType() == 223 || f.getFunctionType() == 224) {
                    Column[] cols = FUNC_TBL_COLS.get((TableFunction)f);
                    Expression[] args = f.getArgs();
                    assert (cols.length == args.length);
                    for (int i = 0; i < cols.length; ++i) {
                        GridSqlElement arg = this.parseExpression(args[i], calcTypes);
                        GridSqlAlias alias = new GridSqlAlias(cols[i].getName(), arg, false);
                        alias.resultType(GridSqlType.fromColumn(cols[i]));
                        res.addChild(alias);
                    }
                } else {
                    for (Expression arg : f.getArgs()) {
                        if (arg == null) {
                            if (f.getFunctionType() != 206) {
                                throw new IllegalStateException("Function type with null arg: " + f.getFunctionType());
                            }
                            res.addChild(GridSqlPlaceholder.EMPTY);
                            continue;
                        }
                        res.addChild(this.parseExpression(arg, calcTypes));
                    }
                }
            }
            if (f.getFunctionType() == 203 || f.getFunctionType() == 202) {
                res.resultType(GridSqlType.fromExpression((Expression)f));
            }
            return res;
        }
        if (expression instanceof JavaFunction) {
            JavaFunction f = (JavaFunction)expression;
            FunctionAlias alias = FUNC_ALIAS.get(f);
            GridSqlFunction res = new GridSqlFunction(alias.getSchema().getName(), f.getName());
            if (f.getArgs() != null) {
                for (Expression arg : f.getArgs()) {
                    res.addChild(this.parseExpression(arg, calcTypes));
                }
            }
            return res;
        }
        if (expression instanceof Parameter) {
            return new GridSqlParameter(((Parameter)expression).getIndex());
        }
        if (expression instanceof Aggregate && GridSqlAggregateFunction.isValidType(typeId = TYPE.get((Aggregate)expression).intValue())) {
            GridSqlAggregateFunction res = new GridSqlAggregateFunction((boolean)DISTINCT.get((Aggregate)expression), typeId);
            Expression on = ON.get((Aggregate)expression);
            if (on != null) {
                res.addChild(this.parseExpression(on, calcTypes));
            }
            return res;
        }
        if (expression instanceof ExpressionList) {
            Expression[] exprs = EXPR_LIST.get((ExpressionList)expression);
            GridSqlArray res = new GridSqlArray(exprs.length);
            for (Expression expr : exprs) {
                res.addChild(this.parseExpression(expr, calcTypes));
            }
            return res;
        }
        throw new IgniteException("Unsupported expression: " + expression + " [type=" + expression.getClass().getSimpleName() + ']');
    }

    private static void assert0(boolean cond, Object o) {
        if (!cond) {
            throw new IgniteException("Unsupported query: " + o);
        }
    }

    private static <T, R> Getter<T, R> getter(Class<? extends T> cls, String fldName) {
        Field field;
        try {
            field = cls.getDeclaredField(fldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        field.setAccessible(true);
        return new Getter(field);
    }

    public static class Getter<T, R> {
        private final Field fld;

        private Getter(Field fld) {
            this.fld = fld;
        }

        public R get(T obj) {
            try {
                return (R)this.fld.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new IgniteException((Throwable)e);
            }
        }
    }
}

