/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.Collections;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.h2.command.Parser;
import org.h2.table.Table;
import org.jetbrains.annotations.Nullable;

public class GridSqlTable
extends GridSqlElement {
    private final String schema;
    private final String tblName;
    private final GridH2Table tbl;
    private boolean affKeyCond;

    public GridSqlTable(@Nullable String schema, String tblName) {
        this(schema, tblName, null);
    }

    public GridSqlTable(Table tbl) {
        this(tbl.getSchema().getName(), tbl.getName(), tbl);
    }

    private GridSqlTable(@Nullable String schema, String tblName, @Nullable Table tbl) {
        super(Collections.emptyList());
        assert (schema != null) : "schema";
        assert (tblName != null) : "tblName";
        this.schema = schema;
        this.tblName = tblName;
        this.tbl = tbl instanceof GridH2Table ? (GridH2Table)tbl : null;
    }

    public void affinityKeyCondition(boolean affKeyCond) {
        this.affKeyCond = affKeyCond;
    }

    public boolean affinityKeyCondition() {
        return this.affKeyCond;
    }

    @Override
    public String getSQL() {
        if (this.schema == null) {
            return Parser.quoteIdentifier((String)this.tblName);
        }
        return Parser.quoteIdentifier((String)this.schema) + '.' + Parser.quoteIdentifier((String)this.tblName);
    }

    public String schema() {
        return this.schema;
    }

    public String tableName() {
        return this.tblName;
    }

    public GridH2Table dataTable() {
        return this.tbl;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GridSqlTable that = (GridSqlTable)o;
        return this.schema.equals(that.schema) && this.tblName.equals(that.tblName);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.schema.hashCode();
        result = 31 * result + this.tblName.hashCode();
        return result;
    }
}

