/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import javax.cache.CacheException;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.h2.util.StatementBuilder;

public class GridSqlUnion
extends GridSqlQuery {
    private int unionType;
    private GridSqlQuery right;
    private GridSqlQuery left;

    @Override
    protected int visibleColumns() {
        return this.left.visibleColumns();
    }

    @Override
    protected GridSqlElement column(int col) {
        throw new IllegalStateException();
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder(this.explain() ? "EXPLAIN \n" : "");
        buff.append('(').append(this.left.getSQL()).append(')');
        switch (this.unionType) {
            case 1: {
                buff.append("\nUNION ALL\n");
                break;
            }
            case 0: {
                buff.append("\nUNION\n");
                break;
            }
            case 3: {
                buff.append("\nINTERSECT\n");
                break;
            }
            case 2: {
                buff.append("\nEXCEPT\n");
                break;
            }
            default: {
                throw new CacheException("type=" + this.unionType);
            }
        }
        buff.append('(').append(this.right.getSQL()).append(')');
        this.getSortLimitSQL(buff);
        return buff.toString();
    }

    public int unionType() {
        return this.unionType;
    }

    public void unionType(int unionType) {
        this.unionType = unionType;
    }

    public GridSqlQuery right() {
        return this.right;
    }

    public void right(GridSqlQuery right) {
        this.right = right;
    }

    public GridSqlQuery left() {
        return this.left;
    }

    public void left(GridSqlQuery left) {
        this.left = left;
    }
}

