/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.CacheQueryReadEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionsReservation;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RetryException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.h2.jdbc.JdbcResultSet;
import org.h2.result.ResultInterface;
import org.h2.value.Value;
import org.jsr166.ConcurrentHashMap8;
import org.jsr166.ConcurrentLinkedHashMap;

public class GridMapQueryExecutor {
    private static final Field RESULT_FIELD;
    private IgniteLogger log;
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private ConcurrentMap<UUID, NodeResults> qryRess = new ConcurrentHashMap8();
    private final GridSpinBusyLock busyLock;
    private final ConcurrentMap<T2<String, AffinityTopologyVersion>, GridReservable> reservations = new ConcurrentHashMap8();

    public GridMapQueryExecutor(GridSpinBusyLock busyLock) {
        this.busyLock = busyLock;
    }

    public void start(final GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.log = ctx.log(GridMapQueryExecutor.class);
        final UUID locNodeId = ctx.localNodeId();
        ctx.event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(Event evt) {
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                GridH2QueryContext.clearAfterDeadNode(locNodeId, nodeId);
                NodeResults nodeRess = (NodeResults)GridMapQueryExecutor.this.qryRess.remove(nodeId);
                if (nodeRess == null) {
                    return;
                }
                for (QueryResults ress : nodeRess.results().values()) {
                    ress.cancel(true);
                }
            }
        }, 12, new int[]{11});
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(UUID nodeId, Object msg) {
                if (!GridMapQueryExecutor.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    if (msg instanceof GridCacheQueryMarshallable) {
                        ((GridCacheQueryMarshallable)msg).unmarshall(ctx.config().getMarshaller(), ctx);
                    }
                    GridMapQueryExecutor.this.onMessage(nodeId, msg);
                }
                finally {
                    GridMapQueryExecutor.this.busyLock.leaveBusy();
                }
            }
        });
    }

    public void onMessage(UUID nodeId, Object msg) {
        try {
            assert (msg != null);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                return;
            }
            boolean processed = true;
            if (msg instanceof GridH2QueryRequest) {
                this.onQueryRequest(node, (GridH2QueryRequest)msg);
            } else if (msg instanceof GridQueryNextPageRequest) {
                this.onNextPageRequest(node, (GridQueryNextPageRequest)msg);
            } else if (msg instanceof GridQueryCancelRequest) {
                this.onCancel(node, (GridQueryCancelRequest)msg);
            } else if (msg instanceof GridQueryRequest) {
                this.onQueryRequest(node, (GridQueryRequest)msg);
            } else {
                processed = false;
            }
            if (processed && this.log.isDebugEnabled()) {
                this.log.debug("Processed request: " + nodeId + "->" + this.ctx.localNodeId() + " " + msg);
            }
        }
        catch (Throwable th) {
            U.error((IgniteLogger)this.log, (Object)("Failed to process message: " + msg), (Throwable)th);
        }
    }

    private void onCancel(ClusterNode node, GridQueryCancelRequest msg) {
        QueryResults results;
        long qryReqId = msg.queryRequestId();
        NodeResults nodeRess = this.resultsForNode(node.id());
        boolean clear = GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), qryReqId, GridH2QueryType.MAP);
        if (!clear) {
            nodeRess.onCancel(qryReqId);
            GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), qryReqId, GridH2QueryType.MAP);
        }
        if ((results = (QueryResults)nodeRess.results().remove(qryReqId)) == null) {
            return;
        }
        results.cancel(true);
    }

    private NodeResults resultsForNode(UUID nodeId) {
        NodeResults old;
        NodeResults nodeRess = (NodeResults)this.qryRess.get(nodeId);
        if (nodeRess == null && (old = this.qryRess.putIfAbsent(nodeId, nodeRess = new NodeResults())) != null) {
            nodeRess = old;
        }
        return nodeRess;
    }

    private GridDhtLocalPartition partition(GridCacheContext<?, ?> cctx, int p) {
        return cctx.topology().localPartition(p, AffinityTopologyVersion.NONE, false);
    }

    private boolean reservePartitions(List<Integer> cacheIds, AffinityTopologyVersion topVer, int[] explicitParts, List<GridReservable> reserved) throws IgniteCheckedException {
        assert (topVer != null);
        Set partIds = GridMapQueryExecutor.wrap(explicitParts);
        for (int i = 0; i < cacheIds.size(); ++i) {
            GridDhtPartitionsReservation grp;
            GridCacheContext cctx = this.ctx.cache().context().cacheContext(cacheIds.get(i).intValue());
            if (cctx == null) {
                return false;
            }
            if (cctx.isLocal() || !cctx.rebalanceEnabled()) continue;
            final T2 grpKey = new T2((Object)cctx.name(), (Object)(cctx.isReplicated() ? null : topVer));
            GridReservable r = (GridReservable)this.reservations.get(grpKey);
            if (explicitParts == null && r != null) {
                if (r == ReplicatedReservation.INSTANCE) continue;
                if (!r.reserve()) {
                    return false;
                }
                reserved.add(r);
                continue;
            }
            int partsCnt = cctx.affinity().partitions();
            if (cctx.isReplicated()) {
                if (r != null) continue;
                for (int p = 0; p < partsCnt; ++p) {
                    GridDhtLocalPartition part = this.partition(cctx, p);
                    if (part != null && part.state() == GridDhtPartitionState.OWNING) continue;
                    return false;
                }
                this.reservations.putIfAbsent((T2<String, AffinityTopologyVersion>)grpKey, ReplicatedReservation.INSTANCE);
                continue;
            }
            if (explicitParts == null) {
                partIds = cctx.affinity().primaryPartitions(this.ctx.localNodeId(), topVer);
            }
            for (int partId : partIds) {
                GridDhtLocalPartition part = this.partition(cctx, partId);
                if (part == null || part.state() != GridDhtPartitionState.OWNING || !part.reserve()) {
                    return false;
                }
                reserved.add((GridReservable)part);
                if (part.state() == GridDhtPartitionState.OWNING) continue;
                return false;
            }
            if (explicitParts != null || !(grp = new GridDhtPartitionsReservation(topVer, cctx, (Object)"SQL")).register(reserved.subList(reserved.size() - partIds.size(), reserved.size()))) continue;
            if (this.reservations.putIfAbsent((T2<String, AffinityTopologyVersion>)grpKey, (GridReservable)grp) != null) {
                throw new IllegalStateException("Reservation already exists.");
            }
            grp.onPublish((CI1)new CI1<GridDhtPartitionsReservation>(){

                public void apply(GridDhtPartitionsReservation r) {
                    GridMapQueryExecutor.this.reservations.remove(grpKey, r);
                }
            });
        }
        return true;
    }

    private static Collection<Integer> wrap(final int[] ints) {
        if (ints == null) {
            return null;
        }
        if (ints.length == 0) {
            return Collections.emptySet();
        }
        return new AbstractCollection<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < ints.length;
                    }

                    @Override
                    public Integer next() {
                        return ints[this.i++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ints.length;
            }
        };
    }

    private void onQueryRequest(ClusterNode node, GridQueryRequest req) {
        List<Integer> cacheIds;
        if (req.extraSpaces() != null) {
            cacheIds = new ArrayList<Integer>(req.extraSpaces().size() + 1);
            cacheIds.add(CU.cacheId((String)req.space()));
            for (String extraSpace : req.extraSpaces()) {
                cacheIds.add(CU.cacheId((String)extraSpace));
            }
        } else {
            cacheIds = Collections.singletonList(CU.cacheId((String)req.space()));
        }
        this.onQueryRequest0(node, req.requestId(), req.queries(), cacheIds, req.topologyVersion(), null, req.partitions(), null, req.pageSize(), false, req.timeout());
    }

    private void onQueryRequest(ClusterNode node, GridH2QueryRequest req) {
        Map<UUID, int[]> partsMap = req.partitions();
        int[] parts = partsMap == null ? null : partsMap.get(this.ctx.localNodeId());
        this.onQueryRequest0(node, req.requestId(), req.queries(), req.caches(), req.topologyVersion(), partsMap, parts, req.tables(), req.pageSize(), req.isFlagSet(GridH2QueryRequest.FLAG_DISTRIBUTED_JOINS), req.timeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQueryRequest0(ClusterNode node, long reqId, Collection<GridCacheSqlQuery> qrys, List<Integer> cacheIds, AffinityTopologyVersion topVer, Map<UUID, int[]> partsMap, int[] parts, Collection<String> tbls, int pageSize, boolean distributedJoins, int timeout) {
        GridCacheContext mainCctx = this.ctx.cache().context().cacheContext(cacheIds.get(0).intValue());
        if (mainCctx == null) {
            throw new CacheException("Failed to find cache.");
        }
        NodeResults nodeRess = this.resultsForNode(node.id());
        QueryResults qr = null;
        ArrayList<GridReservable> reserved = new ArrayList<GridReservable>();
        try {
            if (topVer != null && !this.reservePartitions(cacheIds, topVer, parts, reserved)) {
                this.sendRetry(node, reqId);
                return;
            }
            qr = new QueryResults(reqId, qrys.size(), mainCctx);
            if (nodeRess.results().put(reqId, qr) != null) {
                throw new IllegalStateException();
            }
            GridH2QueryContext qctx = new GridH2QueryContext(this.ctx.localNodeId(), node.id(), reqId, mainCctx.isReplicated() ? GridH2QueryType.REPLICATED : GridH2QueryType.MAP).filter(this.h2.backupFilter(topVer, parts)).partitionsMap(partsMap).distributedJoins(distributedJoins).pageSize(pageSize).topologyVersion(topVer).reservations(reserved);
            ArrayList<GridH2Table> snapshotedTbls = null;
            if (!F.isEmpty(tbls)) {
                snapshotedTbls = new ArrayList<GridH2Table>(tbls.size());
                for (String identifier : tbls) {
                    GridH2Table tbl = this.h2.dataTable(identifier);
                    Objects.requireNonNull(tbl, identifier);
                    tbl.snapshotIndexes(qctx);
                    snapshotedTbls.add(tbl);
                }
            }
            Connection conn = this.h2.connectionForSpace(mainCctx.name());
            this.h2.setupConnection(conn, distributedJoins, true);
            GridH2QueryContext.set(qctx);
            reserved = null;
            try {
                if (nodeRess.cancelled(reqId)) {
                    GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), reqId, qctx.type());
                    nodeRess.results().remove(reqId);
                    throw new QueryCancelledException();
                }
                int i = 0;
                boolean evt = this.ctx.event().isRecordable(96);
                for (GridCacheSqlQuery qry : qrys) {
                    ResultSet rs = this.h2.executeSqlQueryWithTimer(mainCctx.name(), conn, qry.query(), F.asList((Object[])qry.parameters()), true, timeout, qr.cancels[i]);
                    if (evt) {
                        this.ctx.event().record((Event)new CacheQueryExecutedEvent(node, "SQL query executed.", 96, CacheQueryType.SQL.name(), mainCctx.namex(), null, qry.query(), null, null, qry.parameters(), node.id(), null));
                    }
                    assert (rs instanceof JdbcResultSet) : rs.getClass();
                    qr.addResult(i, qry, node.id(), rs);
                    if (qr.canceled) {
                        qr.result(i).close();
                        throw new QueryCancelledException();
                    }
                    this.sendNextPage(nodeRess, node, qr, i, pageSize);
                    ++i;
                }
            }
            finally {
                GridH2QueryContext.clearThreadLocal();
                if (!distributedJoins) {
                    qctx.clearContext(false);
                }
                if (!F.isEmpty(snapshotedTbls)) {
                    for (GridH2Table dataTbl : snapshotedTbls) {
                        dataTbl.releaseSnapshots();
                    }
                }
            }
        }
        catch (Throwable e) {
            if (qr != null) {
                nodeRess.results().remove(reqId, qr);
                qr.cancel(false);
            }
            if (X.hasCause((Throwable)e, (Class[])new Class[]{GridH2RetryException.class})) {
                this.sendRetry(node, reqId);
            }
            U.error((IgniteLogger)this.log, (Object)"Failed to execute local query.", (Throwable)e);
            this.sendError(node, reqId, e);
            if (e instanceof Error) {
                throw (Error)e;
            }
        }
        finally {
            if (reserved != null) {
                for (int i = 0; i < reserved.size(); ++i) {
                    ((GridReservable)reserved.get(i)).release();
                }
            }
        }
    }

    private void sendError(ClusterNode node, long qryReqId, Throwable err) {
        try {
            GridQueryFailResponse msg = new GridQueryFailResponse(qryReqId, err);
            if (node.isLocal()) {
                U.error((IgniteLogger)this.log, (Object)"Failed to run map query on local node.", (Throwable)err);
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().send(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)2);
            }
        }
        catch (Exception e) {
            e.addSuppressed(err);
            U.error((IgniteLogger)this.log, (Object)"Failed to send error message.", (Throwable)e);
        }
    }

    private void onNextPageRequest(ClusterNode node, GridQueryNextPageRequest req) {
        NodeResults nodeRess = (NodeResults)this.qryRess.get(node.id());
        if (nodeRess == null) {
            this.sendError(node, req.queryRequestId(), (Throwable)new CacheException("No node result found for request: " + req));
            return;
        }
        if (nodeRess.cancelled(req.queryRequestId())) {
            this.sendError(node, req.queryRequestId(), (Throwable)new QueryCancelledException());
            return;
        }
        QueryResults qr = (QueryResults)nodeRess.results().get(req.queryRequestId());
        if (qr == null) {
            this.sendError(node, req.queryRequestId(), (Throwable)new CacheException("No query result found for request: " + req));
        } else if (qr.canceled) {
            this.sendError(node, req.queryRequestId(), (Throwable)new QueryCancelledException());
        } else {
            this.sendNextPage(nodeRess, node, qr, req.query(), req.pageSize());
        }
    }

    private void sendNextPage(NodeResults nodeRess, ClusterNode node, QueryResults qr, int qry, int pageSize) {
        QueryResult res = qr.result(qry);
        assert (res != null);
        int page = res.page;
        ArrayList<Value[]> rows = new ArrayList<Value[]>(Math.min(64, pageSize));
        boolean last = res.fetchNextPage(rows, pageSize);
        if (last) {
            res.close();
            if (qr.isAllClosed()) {
                nodeRess.results().remove(qr.qryReqId, qr);
            }
        }
        try {
            boolean loc = node.isLocal();
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(qr.qryReqId, qry, page, page == 0 ? res.rowCnt : -1, res.cols, loc ? null : GridH2ValueMessageFactory.toMessages(rows, new ArrayList<Message>(res.cols)), loc ? rows : null);
            if (loc) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().send(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)2);
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to send message.", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    private void sendRetry(ClusterNode node, long reqId) {
        try {
            boolean loc = node.isLocal();
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(reqId, 0, 0, 0, 1, loc ? null : Collections.emptyList(), loc ? Collections.emptyList() : null);
            msg.retry(this.h2.readyTopologyVersion());
            if (loc) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().send(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)2);
            }
        }
        catch (Exception e) {
            U.warn((IgniteLogger)this.log, (Object)("Failed to send retry message: " + e.getMessage()));
        }
    }

    public void onCacheStop(String cacheName) {
        for (T2 grpKey : this.reservations.keySet()) {
            if (!F.eq((Object)grpKey.get1(), (Object)cacheName)) continue;
            this.reservations.remove(grpKey);
        }
    }

    static {
        try {
            RESULT_FIELD = JdbcResultSet.class.getDeclaredField("result");
            RESULT_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }

    private static class ReplicatedReservation
    implements GridReservable {
        static final ReplicatedReservation INSTANCE = new ReplicatedReservation();

        private ReplicatedReservation() {
        }

        public boolean reserve() {
            throw new IllegalStateException();
        }

        public void release() {
            throw new IllegalStateException();
        }
    }

    private class QueryResult
    implements AutoCloseable {
        private final ResultInterface res;
        private final ResultSet rs;
        private final GridCacheContext<?, ?> cctx;
        private final GridCacheSqlQuery qry;
        private final UUID qrySrcNodeId;
        private final int cols;
        private int page;
        private final int rowCnt;
        private boolean cpNeeded;
        private volatile boolean closed;

        private QueryResult(ResultSet rs, GridCacheContext<?, ?> cctx, UUID qrySrcNodeId, GridCacheSqlQuery qry) {
            this.rs = rs;
            this.cctx = cctx;
            this.qry = qry;
            this.qrySrcNodeId = qrySrcNodeId;
            this.cpNeeded = cctx.isLocalNode(qrySrcNodeId);
            try {
                this.res = (ResultInterface)RESULT_FIELD.get(rs);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            this.rowCnt = this.res.getRowCount();
            this.cols = this.res.getVisibleColumnCount();
        }

        synchronized boolean fetchNextPage(List<Value[]> rows, int pageSize) {
            if (this.closed) {
                return true;
            }
            boolean readEvt = this.cctx.gridEvents().isRecordable(97);
            ++this.page;
            for (int i = 0; i < pageSize; ++i) {
                if (!this.res.next()) {
                    return true;
                }
                Value[] row = this.res.currentRow();
                if (this.cpNeeded) {
                    boolean copied = false;
                    for (int j = 0; j < row.length; ++j) {
                        GridH2ValueCacheObject valCacheObj;
                        GridCacheContext<?, ?> cctx;
                        Value val = row[j];
                        if (!(val instanceof GridH2ValueCacheObject) || (cctx = (valCacheObj = (GridH2ValueCacheObject)val).getCacheContext()) == null || !cctx.needValueCopy()) continue;
                        row[j] = new GridH2ValueCacheObject(valCacheObj.getCacheContext(), valCacheObj.getCacheObject()){

                            @Override
                            public Object getObject() {
                                return this.getObject(true);
                            }
                        };
                        copied = true;
                    }
                    if (i == 0 && !copied) {
                        this.cpNeeded = false;
                    }
                }
                assert (row != null);
                if (readEvt) {
                    this.cctx.gridEvents().record((Event)new CacheQueryReadEvent(this.cctx.localNode(), "SQL fields query result set row read.", 97, CacheQueryType.SQL.name(), this.cctx.namex(), null, this.qry.query(), null, null, this.qry.parameters(), this.qrySrcNodeId, null, null, null, null, this.row(row)));
                }
                rows.add(this.res.currentRow());
            }
            return false;
        }

        private List<?> row(Value[] row) {
            ArrayList<Object> res = new ArrayList<Object>(row.length);
            for (Value v : row) {
                res.add(v.getObject());
            }
            return res;
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            U.close((AutoCloseable)this.rs, (IgniteLogger)GridMapQueryExecutor.this.log);
        }
    }

    private class QueryResults {
        private final long qryReqId;
        private final AtomicReferenceArray<QueryResult> results;
        private final GridQueryCancel[] cancels;
        private final GridCacheContext<?, ?> cctx;
        private volatile boolean canceled;

        private QueryResults(long qryReqId, int qrys, GridCacheContext<?, ?> cctx) {
            this.qryReqId = qryReqId;
            this.cctx = cctx;
            this.results = new AtomicReferenceArray(qrys);
            this.cancels = new GridQueryCancel[qrys];
            for (int i = 0; i < this.cancels.length; ++i) {
                this.cancels[i] = new GridQueryCancel();
            }
        }

        QueryResult result(int qry) {
            return this.results.get(qry);
        }

        void addResult(int qry, GridCacheSqlQuery q, UUID qrySrcNodeId, ResultSet rs) {
            if (!this.results.compareAndSet(qry, null, new QueryResult(rs, this.cctx, qrySrcNodeId, q))) {
                throw new IllegalStateException();
            }
        }

        boolean isAllClosed() {
            for (int i = 0; i < this.results.length(); ++i) {
                QueryResult res = this.results.get(i);
                if (res != null && res.closed) continue;
                return false;
            }
            return true;
        }

        void cancel(boolean forceQryCancel) {
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            for (int i = 0; i < this.results.length(); ++i) {
                GridQueryCancel cancel;
                QueryResult res = this.results.get(i);
                if (res != null) {
                    res.close();
                    continue;
                }
                if (!forceQryCancel || (cancel = this.cancels[i]) == null) continue;
                cancel.cancel();
            }
        }
    }

    private static class NodeResults {
        private final ConcurrentMap<Long, QueryResults> res = new ConcurrentHashMap8();
        private final GridBoundedConcurrentLinkedHashMap<Long, Boolean> qryHist = new GridBoundedConcurrentLinkedHashMap(1024, 1024, 0.75f, 64, ConcurrentLinkedHashMap.QueuePolicy.PER_SEGMENT_Q);

        private NodeResults() {
        }

        ConcurrentMap<Long, QueryResults> results() {
            return this.res;
        }

        boolean cancelled(long qryId) {
            return this.qryHist.get((Object)qryId) != null;
        }

        boolean onCancel(long qryId) {
            Boolean old = (Boolean)this.qryHist.putIfAbsent((Object)qryId, (Object)Boolean.FALSE);
            return old == null;
        }
    }
}

