/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class GridH2Geometry
extends GridH2ValueMessage {
    private static final Method GEOMETRY_FROM_BYTES;
    private byte[] b;

    public GridH2Geometry() {
    }

    public GridH2Geometry(Value val) {
        assert (val.getType() == 22) : val.getType();
        this.b = val.getBytesNoCopy();
    }

    @Override
    public Value value(GridKernalContext ctx) {
        try {
            return (Value)GEOMETRY_FROM_BYTES.invoke(null, new Object[]{this.b});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("b", this.b)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.b = reader.readByteArray("b");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2Geometry.class);
    }

    public byte directType() {
        return -21;
    }

    public byte fieldsCount() {
        return 1;
    }

    public String toString() {
        return "g_" + StringUtils.convertBytesToHex((byte[])this.b);
    }

    static {
        try {
            GEOMETRY_FROM_BYTES = Class.forName("org.h2.value.ValueGeometry").getMethod("get", byte[].class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new IllegalStateException("Check H2 version in classpath.");
        }
    }
}

