/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.io;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.internal.processors.query.h2.database.io.H2InnerIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.h2.result.SearchRow;

public class H2ExtrasInnerIO
extends BPlusInnerIO<SearchRow> {
    private final int payloadSize;

    public static void register() {
        for (short payload = 1; payload <= 2048; payload = (short)(payload + 1)) {
            PageIO.registerH2ExtraInner(H2ExtrasInnerIO.getVersions((short)(20000 + payload - 1), payload));
        }
    }

    public static IOVersions<? extends BPlusInnerIO<SearchRow>> getVersions(int payload) {
        assert (payload >= 0 && payload <= 2048);
        if (payload == 0) {
            return H2InnerIO.VERSIONS;
        }
        return PageIO.getInnerVersions((int)((short)(payload - 1)));
    }

    private static IOVersions<H2ExtrasInnerIO> getVersions(short type, short payload) {
        return new IOVersions((PageIO[])new H2ExtrasInnerIO[]{new H2ExtrasInnerIO(type, 1, payload)});
    }

    private H2ExtrasInnerIO(short type, int ver, int payloadSize) {
        super((int)type, ver, true, 8 + payloadSize);
        this.payloadSize = payloadSize;
    }

    public void storeByOffset(long pageAddr, int off, SearchRow row) {
        InlineIndexHelper idx;
        int size;
        GridH2Row row0 = (GridH2Row)row;
        assert (row0.link != 0L) : row0;
        List<InlineIndexHelper> inlineIdxs = InlineIndexHelper.getCurrentInlineIndexes();
        assert (inlineIdxs != null) : "no inline index helpers";
        int fieldOff = 0;
        for (int i = 0; i < inlineIdxs.size() && (size = (idx = inlineIdxs.get(i)).put(pageAddr, off + fieldOff, row.getValue(idx.columnIndex()), this.payloadSize - fieldOff)) != 0; ++i) {
            fieldOff += size;
        }
        PageUtils.putLong((long)pageAddr, (int)(off + this.payloadSize), (long)row0.link);
    }

    public SearchRow getLookupRow(BPlusTree<SearchRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        long link = this.getLink(pageAddr, idx);
        assert (link != 0L);
        GridH2Row r0 = ((H2Tree)tree).getRowFactory().getRow(link);
        return r0;
    }

    public void store(long dstPageAddr, int dstIdx, BPlusIO<SearchRow> srcIo, long srcPageAddr, int srcIdx) {
        int srcOff = srcIo.offset(srcIdx);
        byte[] payload = PageUtils.getBytes((long)srcPageAddr, (int)srcOff, (int)this.payloadSize);
        long link = PageUtils.getLong((long)srcPageAddr, (int)(srcOff + this.payloadSize));
        assert (link != 0L);
        int dstOff = this.offset(dstIdx);
        PageUtils.putBytes((long)dstPageAddr, (int)dstOff, (byte[])payload);
        PageUtils.putLong((long)dstPageAddr, (int)(dstOff + this.payloadSize), (long)link);
    }

    private long getLink(long pageAddr, int idx) {
        return PageUtils.getLong((long)pageAddr, (int)(this.offset(idx) + this.payloadSize));
    }
}

