/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.util;

import java.math.BigDecimal;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.GridUnsafe;
import org.h2.util.MathUtils;
import org.h2.value.Value;

public class CompareUtils {
    private static final int UTF_8_MIN_2_BYTES = 128;
    private static final int UTF_8_MIN_3_BYTES = 2048;
    private static final int UTF_8_MIN_4_BYTES = 65536;
    private static final int UTF_8_MAX_CODE_POINT = 0x10FFFF;
    private static final BigDecimal MAX_LONG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE);

    public static byte convertToByte(long x) {
        if (x > 127L || x < -128L) {
            throw new IgniteException("Numeric value out of range: " + x);
        }
        return (byte)x;
    }

    public static short convertToShort(long x) {
        if (x > 32767L || x < -32768L) {
            throw new IgniteException("Numeric value out of range: " + x);
        }
        return (short)x;
    }

    public static int convertToInt(long x) {
        if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
            throw new IgniteException("Numeric value out of range: " + x);
        }
        return (int)x;
    }

    public static long convertToLong(double x) {
        if (x > 9.223372036854776E18 || x < -9.223372036854776E18) {
            throw new IgniteException("Numeric value out of range: " + x);
        }
        return Math.round(x);
    }

    public static long convertToLong(BigDecimal x) {
        if (x.compareTo(MAX_LONG_DECIMAL) > 0 || x.compareTo(MIN_LONG_DECIMAL) < 0) {
            throw new IgniteException("Numeric value out of range: " + x);
        }
        return x.setScale(0, 4).longValue();
    }

    public static int compareBoolean(boolean v, Value val) {
        boolean v2 = val.getBoolean();
        return v == v2 ? 0 : (v ? 1 : -1);
    }

    public static int compareByte(byte v, Value val) {
        byte v2 = val.getByte();
        return MathUtils.compareInt((int)v, (int)v2);
    }

    public static int compareUtf8(long val1Addr, int val1Len, byte[] val2Bytes, int val2Off, int val2Len) throws IgniteCheckedException {
        int len = Math.min(val1Len, val2Len);
        for (int i = 0; i < len; ++i) {
            int b2;
            int b1 = GridUnsafe.getByte((long)(val1Addr + (long)i)) & 0xFF;
            if (b1 == (b2 = val2Bytes[val2Off + i] & 0xFF)) continue;
            return b1 > b2 ? 1 : -1;
        }
        return Integer.compare(val1Len, val2Len);
    }

    public static int compareUtf8(long addr, int len, String str) throws IgniteCheckedException {
        char c1;
        char c0;
        int ch;
        int pos;
        int cntr = 0;
        int strLen = str.length();
        for (pos = 0; pos < len && (ch = GridUnsafe.getByte((long)(addr + (long)pos))) >= 0; ++pos) {
            c0 = (char)ch;
            if (cntr < strLen) {
                c1 = str.charAt(cntr);
                if (c0 != c1) {
                    return c0 - c1;
                }
            } else {
                return 1;
            }
            ++cntr;
        }
        while (pos < len) {
            if ((ch = GridUnsafe.getByte((long)(addr + (long)pos++)) & 0xFF) >= 128) {
                if (ch < 192) {
                    throw new IgniteException("Illegal UTF-8 sequence.");
                }
                if (ch < 224) {
                    ch = (ch & 0x1F) << 6;
                    CompareUtils.checkByte(GridUnsafe.getByte((long)(addr + (long)pos)));
                    CompareUtils.checkMinimal(ch |= GridUnsafe.getByte((long)(addr + (long)pos++)) & 0x3F, 128);
                } else if (ch < 240) {
                    ch = (ch & 0xF) << 12;
                    CompareUtils.checkByte(GridUnsafe.getByte((long)(addr + (long)pos)));
                    ch |= (GridUnsafe.getByte((long)(addr + (long)pos++)) & 0x3F) << 6;
                    CompareUtils.checkByte(GridUnsafe.getByte((long)(addr + (long)pos)));
                    CompareUtils.checkMinimal(ch |= GridUnsafe.getByte((long)(addr + (long)pos++)) & 0x3F, 2048);
                } else if (ch < 248) {
                    ch = (ch & 7) << 18;
                    CompareUtils.checkByte(GridUnsafe.getByte((long)(addr + (long)pos)));
                    ch |= (GridUnsafe.getByte((long)(addr + (long)pos++)) & 0x3F) << 12;
                    CompareUtils.checkByte(GridUnsafe.getByte((long)(addr + (long)pos)));
                    ch |= (GridUnsafe.getByte((long)(addr + (long)pos++)) & 0x3F) << 6;
                    CompareUtils.checkByte(GridUnsafe.getByte((long)(addr + (long)pos)));
                    CompareUtils.checkMinimal(ch |= GridUnsafe.getByte((long)(addr + (long)pos++)) & 0x3F, 65536);
                } else {
                    throw new IgniteException("Illegal UTF-8 sequence.");
                }
            }
            if (ch > 0x10FFFF) {
                throw new IgniteException("Illegal UTF-8 sequence.");
            }
            if (ch > 65535) {
                c0 = (char)(55296 + ((ch -= 65536) >> 10));
                if (cntr < strLen) {
                    c1 = str.charAt(cntr);
                    if (c0 != c1) {
                        return c0 - c1;
                    }
                } else {
                    return 1;
                }
                c0 = (char)(56320 + (ch & 0x3FF));
                if (++cntr < strLen) {
                    c1 = str.charAt(cntr);
                    if (c0 != c1) {
                        return c0 - c1;
                    }
                } else {
                    return 1;
                }
                ++cntr;
                continue;
            }
            if (ch >= 55296 && ch < 57344) {
                throw new IgniteException("Illegal UTF-8 sequence.");
            }
            c0 = (char)ch;
            if (cntr < strLen) {
                c1 = str.charAt(cntr);
                if (c0 != c1) {
                    return c0 - c1;
                }
            } else {
                return 1;
            }
            ++cntr;
        }
        if (pos > len) {
            throw new IgniteException("Illegal UTF-8 sequence.");
        }
        return cntr - strLen;
    }

    private static void checkByte(int ch) {
        if ((ch & 0xC0) != 128) {
            throw new IgniteException("Illegal UTF-8 sequence.");
        }
    }

    private static void checkMinimal(int ch, int minVal) {
        if (ch >= minVal) {
            return;
        }
        throw new IgniteException("Illegal UTF-8 sequence.");
    }
}

