/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.SqlQueryExecutionEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.managers.IgniteMBeansManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCachingManager;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.StaticMvccQueryTracker;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResult;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResultAdapter;
import org.apache.ignite.internal.processors.query.GridQueryFinishedInfo;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryStartedInfo;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.RunningQueryManager;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.processors.query.h2.CommandProcessor;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.DistributedSqlConfiguration;
import org.apache.ignite.internal.processors.query.h2.FunctionsManager;
import org.apache.ignite.internal.processors.query.h2.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.query.h2.H2FieldsIterator;
import org.apache.ignite.internal.processors.query.h2.H2JavaObjectSerializer;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.H2SchemaManager;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.LongRunningQueryManager;
import org.apache.ignite.internal.processors.query.h2.QueryDescriptor;
import org.apache.ignite.internal.processors.query.h2.QueryParameters;
import org.apache.ignite.internal.processors.query.h2.QueryParser;
import org.apache.ignite.internal.processors.query.h2.QueryParserResult;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultCommand;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultDml;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultSelect;
import org.apache.ignite.internal.processors.query.h2.RegisteredQueryCursor;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.affinity.H2PartitionResolver;
import org.apache.ignite.internal.processors.query.h2.affinity.PartitionExtractor;
import org.apache.ignite.internal.processors.query.h2.dml.DmlDistributedPlanInfo;
import org.apache.ignite.internal.processors.query.h2.dml.DmlUtils;
import org.apache.ignite.internal.processors.query.h2.dml.UpdateMode;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.mxbean.SqlQueryMXBean;
import org.apache.ignite.internal.processors.query.h2.mxbean.SqlQueryMXBeanImpl;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextRegistry;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservationManager;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.query.schema.AbstractSchemaChangeListener;
import org.apache.ignite.internal.processors.query.schema.SchemaChangeListener;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCommitTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlRollbackTransactionCommand;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.h2.api.JavaObjectSerializer;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.util.JdbcUtils;
import org.h2.value.CompareMode;
import org.jetbrains.annotations.Nullable;

public class IgniteH2Indexing
implements GridQueryIndexing {
    private static final int DFLT_UPDATE_RERUN_ATTEMPTS = 4;
    private final boolean updateInTxAllowed = Boolean.getBoolean("IGNITE_ALLOW_DML_INSIDE_TRANSACTION");
    @LoggerResource
    private IgniteLogger log;
    private UUID nodeId;
    private Marshaller marshaller;
    private GridMapQueryExecutor mapQryExec;
    private GridReduceQueryExecutor rdcQryExec;
    private GridSpinBusyLock busyLock;
    protected volatile GridKernalContext ctx;
    private final QueryContextRegistry qryCtxRegistry = new QueryContextRegistry();
    private CommandProcessor cmdProc;
    private PartitionReservationManager partReservationMgr;
    private PartitionExtractor partExtractor;
    private QueryParser parser;
    private final IgniteInClosure<? super IgniteInternalFuture<?>> logger = new IgniteInClosure<IgniteInternalFuture<?>>(){

        public void apply(IgniteInternalFuture<?> fut) {
            try {
                fut.get();
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)IgniteH2Indexing.this.log, (Object)e.getMessage(), (Throwable)e);
            }
        }
    };
    private ConnectionManager connMgr;
    private H2SchemaManager schemaMgr;
    private LongRunningQueryManager longRunningQryMgr;
    private GridLocalEventListener discoLsnr;
    private GridMessageListener qryLsnr;
    private DistributedSqlConfiguration distrCfg;
    private FunctionsManager funcMgr;

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    public List<JdbcParameterMeta> parameterMetaData(String schemaName, SqlFieldsQuery qry) throws IgniteSQLException {
        assert (qry != null);
        ArrayList<JdbcParameterMeta> metas = new ArrayList<JdbcParameterMeta>();
        SqlFieldsQuery curQry = qry;
        while (curQry != null) {
            QueryParserResult parsed = this.parser.parse(schemaName, curQry, true);
            metas.addAll(parsed.parametersMeta());
            curQry = parsed.remainingQuery();
        }
        return metas;
    }

    public List<GridQueryFieldMetadata> resultMetaData(String schemaName, SqlFieldsQuery qry) throws IgniteSQLException {
        QueryParserResult parsed = this.parser.parse(schemaName, qry, true);
        if (parsed.remainingQuery() != null) {
            return null;
        }
        if (parsed.isSelect()) {
            return parsed.select().meta();
        }
        return null;
    }

    public void store(GridCacheContext cctx, GridQueryTypeDescriptor type, CacheDataRow row, @Nullable CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteCheckedException {
        GridH2Table tbl = this.schemaMgr.dataTable(type.schemaName(), type.tableName());
        if (tbl == null) {
            return;
        }
        if (tbl.tableDescriptor().luceneIndex() != null) {
            long expireTime = row.expireTime();
            if (expireTime == 0L) {
                expireTime = Long.MAX_VALUE;
            }
            tbl.tableDescriptor().luceneIndex().store((CacheObject)row.key(), row.value(), row.version(), expireTime);
        }
        tbl.update(row, prevRow);
    }

    public void remove(GridCacheContext cctx, GridQueryTypeDescriptor type, CacheDataRow row) throws IgniteCheckedException {
        GridH2Table tbl;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing key from cache query index [locId=" + this.nodeId + ", key=" + row.key() + ", val=" + row.value() + ']');
        }
        if ((tbl = this.schemaMgr.dataTable(type.schemaName(), type.tableName())) == null) {
            return;
        }
        if (tbl.tableDescriptor().luceneIndex() != null) {
            tbl.tableDescriptor().luceneIndex().remove((CacheObject)row.key());
        }
        tbl.remove(row);
    }

    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryLocalText(String schemaName, String cacheName, String qry, String typeName, IndexingQueryFilter filters, int limit) throws IgniteCheckedException {
        H2TableDescriptor tbl = this.schemaMgr.tableForType(schemaName, cacheName, typeName);
        if (tbl != null && tbl.luceneIndex() != null) {
            long qryId = this.runningQueryManager().register(qry, GridCacheQueryType.TEXT, schemaName, true, null, null, false, false, false);
            Throwable failReason = null;
            try {
                GridCloseableIterator gridCloseableIterator = tbl.luceneIndex().query(qry.toUpperCase(), filters, limit);
                return gridCloseableIterator;
            }
            catch (Throwable t) {
                failReason = t;
                throw t;
            }
            finally {
                this.runningQueryManager().unregister(qryId, failReason);
            }
        }
        return new GridEmptyCloseableIterator();
    }

    private GridQueryFieldsResult executeSelectLocal(final long qryId, final QueryDescriptor qryDesc, final QueryParameters qryParams, QueryParserResultSelect select, IndexingQueryFilter filter, final MvccQueryTracker mvccTracker, final GridQueryCancel cancel, boolean inTx, final int timeout) {
        assert (!select.mvccEnabled() || mvccTracker != null);
        final String qry = select.forUpdate() ? (inTx ? select.forUpdateQueryTx() : select.forUpdateQueryOutTx()) : qryDesc.sql();
        boolean mvccEnabled = mvccTracker != null;
        try {
            assert (select != null);
            if (this.ctx.security().enabled()) {
                this.checkSecurity(select.cacheIds());
            }
            MvccSnapshot mvccSnapshot = null;
            if (mvccEnabled) {
                mvccSnapshot = mvccTracker.snapshot();
            }
            final QueryContext qctx = new QueryContext(0, filter, null, mvccSnapshot, null, true);
            return new GridQueryFieldsResultAdapter(select.meta(), null){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public GridCloseableIterator<List<?>> iterator() throws IgniteCheckedException {
                    H2PooledConnection conn = IgniteH2Indexing.this.connections().connection(qryDesc.schemaName());
                    try (MTC.TraceSurroundings ignored = MTC.support((Span)IgniteH2Indexing.this.ctx.tracing().create(SpanType.SQL_ITER_OPEN, MTC.span()));){
                        H2Utils.setupConnection(conn, qctx, qryDesc.distributedJoins(), qryDesc.enforceJoinOrder(), qryParams.lazy());
                        PreparedStatement stmt = conn.prepareStatement(qry, H2StatementCache.queryFlags(qryDesc));
                        Marshaller m = IgniteH2Indexing.this.ctx.config().getMarshaller();
                        byte[] paramsBytes = U.marshal((Marshaller)m, (Object)qryParams.arguments());
                        ClassLoader ldr = U.resolveClassLoader((IgniteConfiguration)IgniteH2Indexing.this.ctx.config());
                        Object[] params = m instanceof BinaryMarshaller ? BinaryUtils.rawArrayFromBinary((Object)((BinaryMarshaller)m).binaryMarshaller().unmarshal(paramsBytes, ldr)) : (Object[])U.unmarshal((Marshaller)m, (byte[])paramsBytes, (ClassLoader)ldr);
                        H2Utils.bindParameters(stmt, F.asList((Object[])params));
                        H2QueryInfo qryInfo = new H2QueryInfo(H2QueryInfo.QueryType.LOCAL, stmt, qry, IgniteH2Indexing.this.ctx.localNodeId(), qryId);
                        ResultSet rs = IgniteH2Indexing.this.executeSqlQueryWithTimer(stmt, conn, qry, timeout, cancel, qryParams.dataPageScanEnabled(), qryInfo);
                        H2FieldsIterator h2FieldsIterator = new H2FieldsIterator(rs, mvccTracker, conn, qryParams.pageSize(), IgniteH2Indexing.this.log, IgniteH2Indexing.this, qryInfo, IgniteH2Indexing.this.ctx.tracing());
                        return h2FieldsIterator;
                    }
                    catch (Error | RuntimeException | IgniteCheckedException e) {
                        conn.close();
                        try {
                            if (mvccTracker == null) throw e;
                            mvccTracker.onDone();
                            throw e;
                        }
                        catch (Exception e0) {
                            e.addSuppressed(e0);
                        }
                        throw e;
                    }
                }
            };
        }
        catch (Exception e) {
            GridNearTxLocal tx = null;
            if (mvccEnabled && (tx != null || (tx = MvccUtils.tx((GridKernalContext)this.ctx)) != null)) {
                tx.setRollbackOnly();
            }
            throw e;
        }
    }

    public static int operationTimeout(int qryTimeout, IgniteTxAdapter tx) {
        if (tx != null) {
            int remaining = (int)tx.remainingTime();
            return remaining > 0 && qryTimeout > 0 ? Math.min(remaining, qryTimeout) : Math.max(remaining, qryTimeout);
        }
        return qryTimeout;
    }

    public long streamUpdateQuery(String schemaName, String qry, @Nullable Object[] params, IgniteDataStreamer<?, ?> streamer, String qryInitiatorId) throws IgniteCheckedException {
        QueryParserResultDml dml = this.streamerParse(schemaName, qry);
        return this.streamQuery0(qry, schemaName, streamer, dml, params, qryInitiatorId);
    }

    public List<Long> streamBatchedUpdateQuery(String schemaName, String qry, List<Object[]> params, SqlClientContext cliCtx, String qryInitiatorId) throws IgniteCheckedException {
        if (cliCtx == null || !cliCtx.isStream()) {
            U.warn((IgniteLogger)this.log, (Object)"Connection is not in streaming mode.");
            return IgniteH2Indexing.zeroBatchedStreamedUpdateResult(params.size());
        }
        QueryParserResultDml dml = this.streamerParse(schemaName, qry);
        IgniteDataStreamer streamer = cliCtx.streamerForCache(dml.streamTable().cacheName());
        assert (streamer != null);
        ArrayList<Long> ress = new ArrayList<Long>(params.size());
        for (int i = 0; i < params.size(); ++i) {
            long res = this.streamQuery0(qry, schemaName, streamer, dml, params.get(i), qryInitiatorId);
            ress.add(res);
        }
        return ress;
    }

    private long streamQuery0(String qry, String schemaName, IgniteDataStreamer streamer, QueryParserResultDml dml, Object[] args, String qryInitiatorId) throws IgniteCheckedException {
        long qryId = this.runningQueryManager().register(QueryUtils.INCLUDE_SENSITIVE ? qry : this.sqlWithoutConst(dml.statement()), GridCacheQueryType.SQL_FIELDS, schemaName, true, null, qryInitiatorId, false, false, false);
        Throwable failReason = null;
        try {
            UpdatePlan plan = dml.plan();
            GridQueryCacheObjectsIterator iter = new GridQueryCacheObjectsIterator(this.updateQueryRows(qryId, schemaName, plan, args), this.objectContext(), true);
            if (!iter.hasNext()) {
                long l = 0L;
                return l;
            }
            IgniteBiTuple<?, ?> t = plan.processRow((List)iter.next());
            if (!iter.hasNext()) {
                streamer.addData(t.getKey(), t.getValue());
                long l = 1L;
                return l;
            }
            LinkedHashMap<Object, Object> rows = new LinkedHashMap<Object, Object>(plan.rowCount());
            rows.put(t.getKey(), t.getValue());
            while (iter.hasNext()) {
                List row = (List)iter.next();
                t = plan.processRow(row);
                rows.put(t.getKey(), t.getValue());
            }
            streamer.addData(rows);
            long l = rows.size();
            return l;
        }
        catch (IgniteCheckedException | IgniteException e) {
            failReason = e;
            throw e;
        }
        finally {
            this.runningQueryManager().unregister(qryId, failReason);
        }
    }

    private Iterator<List<?>> updateQueryRows(long qryId, String schemaName, UpdatePlan plan, Object[] args) throws IgniteCheckedException {
        Object[] params;
        Object[] objectArray = params = args != null ? args : X.EMPTY_OBJECT_ARRAY;
        if (!F.isEmpty((String)plan.selectQuery())) {
            SqlFieldsQuery selectQry = new SqlFieldsQuery(plan.selectQuery()).setArgs(params).setLocal(true);
            QueryParserResult selectParseRes = this.parser.parse(schemaName, selectQry, false);
            GridQueryFieldsResult res = this.executeSelectLocal(qryId, selectParseRes.queryDescriptor(), selectParseRes.queryParameters(), selectParseRes.select(), null, null, null, false, 0);
            return res.iterator();
        }
        return plan.createRows(params).iterator();
    }

    private QueryParserResultDml streamerParse(String schemaName, String qry) {
        QueryParserResult parseRes = this.parser.parse(schemaName, new SqlFieldsQuery(qry), false);
        QueryParserResultDml dml = parseRes.dml();
        if (dml == null || !dml.streamable()) {
            throw new IgniteSQLException("Streaming mode supports only INSERT commands without subqueries.", 1002);
        }
        return dml;
    }

    private static List<Long> zeroBatchedStreamedUpdateResult(int size) {
        Object[] res = new Long[size];
        Arrays.fill(res, (Object)0L);
        return Arrays.asList(res);
    }

    private ResultSet executeSqlQuery(H2PooledConnection conn, PreparedStatement stmt, int timeoutMillis, @Nullable GridQueryCancel cancel) throws IgniteCheckedException {
        if (cancel != null) {
            cancel.add(() -> IgniteH2Indexing.cancelStatement(stmt));
        }
        Session ses = H2Utils.session(conn);
        if (timeoutMillis >= 0) {
            ses.setQueryTimeout(timeoutMillis);
        } else {
            ses.setQueryTimeout(this.distrCfg.defaultQueryTimeout());
        }
        try {
            return stmt.executeQuery();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 57014) {
                throw new QueryCancelledException();
            }
            if (e.getCause() instanceof IgniteSQLException) {
                throw (IgniteSQLException)e.getCause();
            }
            throw new IgniteSQLException(e);
        }
    }

    private static void cancelStatement(PreparedStatement stmt) {
        try {
            stmt.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public ResultSet executeSqlQueryWithTimer(H2PooledConnection conn, String sql, @Nullable Collection<Object> params, int timeoutMillis, @Nullable GridQueryCancel cancel, Boolean dataPageScanEnabled, H2QueryInfo qryInfo) throws IgniteCheckedException {
        PreparedStatement stmt = conn.prepareStatementNoCache(sql);
        H2Utils.bindParameters(stmt, params);
        return this.executeSqlQueryWithTimer(stmt, conn, sql, timeoutMillis, cancel, dataPageScanEnabled, qryInfo);
    }

    public void enableDataPageScan(Boolean dataPageScanEnabled) {
        CacheDataTree.setDataPageScanEnabled((boolean)false);
    }

    /*
     * Exception decompiling
     */
    public ResultSet executeSqlQueryWithTimer(PreparedStatement stmt, H2PooledConnection conn, String sql, int timeoutMillis, @Nullable GridQueryCancel cancel, Boolean dataPageScanEnabled, H2QueryInfo qryInfo) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SqlFieldsQuery generateFieldsQuery(String cacheName, SqlQuery qry) {
        String sql;
        String type;
        String schemaName = this.ctx.query().schemaManager().schemaName(cacheName);
        H2TableDescriptor tblDesc = this.schemaMgr.tableForType(schemaName, cacheName, type = qry.getType());
        if (tblDesc == null) {
            throw new IgniteSQLException("Failed to find SQL table for type: " + type, 3001);
        }
        try {
            sql = H2Utils.generateFieldsQueryString(qry.getSql(), qry.getAlias(), tblDesc);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        SqlFieldsQuery res = QueryUtils.withQueryTimeout((SqlFieldsQuery)new SqlFieldsQuery(sql), (int)qry.getTimeout(), (TimeUnit)TimeUnit.MILLISECONDS);
        res.setArgs(qry.getArgs());
        res.setDistributedJoins(qry.isDistributedJoins());
        res.setLocal(qry.isLocal());
        res.setPageSize(qry.getPageSize());
        res.setPartitions(qry.getPartitions());
        res.setReplicatedOnly(qry.isReplicatedOnly());
        res.setSchema(schemaName);
        res.setSql(sql);
        return res;
    }

    /*
     * Exception decompiling
     */
    private FieldsQueryCursor<List<?>> executeCommand(QueryDescriptor qryDesc, QueryParameters qryParams, @Nullable SqlClientContext cliCtx, QueryParserResultCommand cmd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkClusterState(QueryParserResult parseRes) {
        if (!this.ctx.state().publicApiActiveState(true)) {
            if (parseRes.isCommand()) {
                QueryParserResultCommand cmd = parseRes.command();
                assert (cmd != null);
                SqlCommand cmd0 = cmd.commandNative();
                if (cmd0 instanceof SqlCommitTransactionCommand || cmd0 instanceof SqlRollbackTransactionCommand) {
                    return;
                }
            }
            throw new IgniteException("Can not perform the operation because the cluster is inactive. Note, that the cluster is considered inactive by default if Ignite Persistent Store is used to let all the nodes join the cluster. To activate the cluster call Ignite.active(true).");
        }
    }

    public List<FieldsQueryCursor<List<?>>> querySqlFields(String schemaName, SqlFieldsQuery qry, @Nullable SqlClientContext cliCtx, boolean keepBinary, boolean failOnMultipleStmts, GridQueryCancel cancel) {
        try {
            ArrayList res = new ArrayList(1);
            SqlFieldsQuery remainingQry = qry;
            while (remainingQry != null) {
                Span qrySpan = this.ctx.tracing().create(SpanType.SQL_QRY, MTC.span()).addTag("sql.schema", () -> schemaName);
                try {
                    MTC.TraceSurroundings ignored = MTC.supportContinual((Span)qrySpan);
                    Throwable throwable = null;
                    try {
                        QueryParserResult parseRes = this.parser.parse(schemaName, remainingQry, !failOnMultipleStmts);
                        qrySpan.addTag("sql.query.text", () -> parseRes.queryDescriptor().sql());
                        remainingQry = parseRes.remainingQuery();
                        QueryDescriptor newQryDesc = parseRes.queryDescriptor();
                        QueryParameters newQryParams = parseRes.queryParameters();
                        if (!newQryDesc.batched()) {
                            int qryParamsCnt;
                            int n = qryParamsCnt = F.isEmpty((Object[])newQryParams.arguments()) ? 0 : newQryParams.arguments().length;
                            if (qryParamsCnt < parseRes.parametersCount()) {
                                throw new IgniteSQLException("Invalid number of query parameters [expected=" + parseRes.parametersCount() + ", actual=" + qryParamsCnt + ']');
                            }
                        }
                        this.checkClusterState(parseRes);
                        if (parseRes.isCommand()) {
                            QueryParserResultCommand cmd = parseRes.command();
                            assert (cmd != null);
                            FieldsQueryCursor<List<?>> cmdRes = this.executeCommand(newQryDesc, newQryParams, cliCtx, cmd);
                            res.add(cmdRes);
                            continue;
                        }
                        if (parseRes.isDml()) {
                            QueryParserResultDml dml = parseRes.dml();
                            assert (dml != null);
                            List<? extends FieldsQueryCursor<List<?>>> dmlRes = this.executeDml(newQryDesc, newQryParams, dml, cancel);
                            res.addAll(dmlRes);
                            continue;
                        }
                        assert (parseRes.isSelect());
                        QueryParserResultSelect select = parseRes.select();
                        assert (select != null);
                        List<? extends FieldsQueryCursor<List<?>>> qryRes = this.executeSelect(newQryDesc, newQryParams, select, keepBinary, cancel);
                        res.addAll(qryRes);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ignored == null) continue;
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ignored.close();
                    }
                }
                catch (Throwable th) {
                    qrySpan.addTag("error", th::getMessage).end();
                    throw th;
                }
            }
            return res;
        }
        catch (Error | RuntimeException e) {
            GridNearTxLocal tx = (GridNearTxLocal)this.ctx.cache().context().tm().tx();
            if (!(tx == null || tx.mvccSnapshot() == null || e instanceof IgniteSQLException && ((IgniteSQLException)e).sqlState() == "42000")) {
                tx.setRollbackOnly();
            }
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private List<? extends FieldsQueryCursor<List<?>>> executeDml(QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, GridQueryCancel cancel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<? extends FieldsQueryCursor<List<?>>> executeSelect(QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultSelect select, boolean keepBinary, GridQueryCancel cancel) {
        assert (cancel != null);
        long qryId = this.registerRunningQuery(qryDesc, qryParams, cancel, select.statement());
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_CURSOR_OPEN, MTC.span()));){
            GridNearTxLocal tx = null;
            MvccQueryTracker tracker = null;
            GridCacheContext mvccCctx = null;
            boolean inTx = false;
            if (select.mvccEnabled()) {
                boolean autoStartTx;
                mvccCctx = this.ctx.cache().context().cacheContext(select.mvccCacheId().intValue());
                if (mvccCctx == null) {
                    throw new IgniteCheckedException("Cache has been stopped concurrently [cacheId=" + select.mvccCacheId() + ']');
                }
                boolean bl = autoStartTx = !qryParams.autoCommit() && MvccUtils.tx((GridKernalContext)this.ctx) == null;
                if (autoStartTx) {
                    MvccUtils.txStart((GridKernalContext)this.ctx, (long)qryParams.timeout());
                }
                tx = MvccUtils.tx((GridKernalContext)this.ctx);
                MvccUtils.checkActive((GridNearTxLocal)tx);
                inTx = tx != null;
                tracker = MvccUtils.mvccTracker((GridCacheContext)mvccCctx, (GridNearTxLocal)tx);
            }
            int timeout = IgniteH2Indexing.operationTimeout(qryParams.timeout(), tx);
            Iterable<List<?>> iter = this.executeSelect0(qryId, qryDesc, qryParams, select, keepBinary, tracker, cancel, inTx, timeout);
            if (select.forUpdate() && inTx) {
                iter = this.lockSelectedRows(iter, mvccCctx, timeout, qryParams.pageSize());
            }
            RegisteredQueryCursor cursor = new RegisteredQueryCursor(iter, cancel, this.runningQueryManager(), qryParams.lazy(), qryId, this.ctx.tracing());
            cancel.add(cursor::cancel);
            cursor.fieldsMeta(select.meta());
            cursor.partitionResult(select.twoStepQuery() != null ? select.twoStepQuery().derivedPartitions() : null);
            List<RegisteredQueryCursor<List<?>>> list = Collections.singletonList(cursor);
            return list;
        }
        catch (Exception e) {
            this.runningQueryManager().unregister(qryId, (Throwable)e);
            if (e instanceof IgniteCheckedException) {
                throw U.convertException((IgniteCheckedException)((IgniteCheckedException)((Object)e)));
            }
            if (!(e instanceof RuntimeException)) throw new IgniteSQLException("Failed to execute SELECT statement: " + qryDesc.sql(), (Throwable)e);
            throw (RuntimeException)e;
        }
    }

    private QueryCursorImpl<List<?>> executeSelectForDml(long qryId, String schema, SqlFieldsQuery selectQry, MvccQueryTracker mvccTracker, GridQueryCancel cancel, int timeout) {
        QueryParserResult parseRes = this.parser.parse(schema, selectQry, false);
        QueryParserResultSelect select = parseRes.select();
        assert (select != null);
        Iterable<List<?>> iter = this.executeSelect0(qryId, parseRes.queryDescriptor(), parseRes.queryParameters(), select, true, mvccTracker, cancel, false, timeout);
        QueryCursorImpl cursor = new QueryCursorImpl(iter, cancel, true, parseRes.queryParameters().lazy());
        cursor.fieldsMeta(select.meta());
        cursor.partitionResult(select.twoStepQuery() != null ? select.twoStepQuery().derivedPartitions() : null);
        return cursor;
    }

    private Iterable<List<?>> executeSelect0(long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultSelect select, boolean keepBinary, MvccQueryTracker mvccTracker, GridQueryCancel cancel, boolean inTx, int timeout) {
        Iterable<List<Object>> iter;
        assert (!select.mvccEnabled() || mvccTracker != null);
        if (this.ctx.security().enabled()) {
            this.checkSecurity(select.cacheIds());
        }
        if (select.splitNeeded()) {
            GridCacheTwoStepQuery twoStepQry;
            GridCacheTwoStepQuery gridCacheTwoStepQuery = twoStepQry = select.forUpdate() && inTx ? select.forUpdateTwoStepQuery() : select.twoStepQuery();
            assert (twoStepQry != null);
            iter = this.executeSelectDistributed(qryId, qryDesc, qryParams, twoStepQry, keepBinary, mvccTracker, cancel, timeout);
        } else {
            IndexingQueryFilter filter = qryDesc.local() ? this.backupFilter(null, qryParams.partitions()) : null;
            GridQueryFieldsResult res = this.executeSelectLocal(qryId, qryDesc, qryParams, select, filter, mvccTracker, cancel, inTx, timeout);
            iter = () -> {
                try {
                    return new GridQueryCacheObjectsIterator((Iterator)res.iterator(), this.objectContext(), keepBinary);
                }
                catch (IgniteCheckedException | IgniteSQLException e) {
                    throw new CacheException(e);
                }
            };
        }
        return iter;
    }

    private Iterable<List<?>> lockSelectedRows(final Iterable<List<?>> cur, final GridCacheContext cctx, int pageSize, long timeout) {
        assert (cctx != null && cctx.mvccEnabled());
        GridNearTxLocal tx = MvccUtils.tx((GridKernalContext)this.ctx);
        if (tx == null) {
            throw new IgniteSQLException("Failed to perform SELECT FOR UPDATE operation: transaction has already finished.");
        }
        final ArrayList rowsCache = new ArrayList();
        UpdateSourceIterator<KeyCacheObject> srcIt = new UpdateSourceIterator<KeyCacheObject>(){
            private Iterator<List<?>> it;
            {
                this.it = cur.iterator();
            }

            public EnlistOperation operation() {
                return EnlistOperation.LOCK;
            }

            public boolean hasNextX() throws IgniteCheckedException {
                return this.it.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public KeyCacheObject nextX() throws IgniteCheckedException {
                List<?> res = this.it.next();
                Collection collection = rowsCache;
                synchronized (collection) {
                    rowsCache.add(res.subList(0, res.size() - 1));
                    if (rowsCache.size() > MvccCachingManager.TX_SIZE_THRESHOLD) {
                        throw new IgniteCheckedException("Too many rows are locked by SELECT FOR UPDATE statement. Consider locking fewer keys or increase the limit by setting a IGNITE_MVCC_TX_SIZE_CACHING_THRESHOLD system property. Current value is " + MvccCachingManager.TX_SIZE_THRESHOLD + " rows.");
                    }
                }
                return cctx.toCacheKeyObject(res.get(res.size() - 1));
            }
        };
        IgniteInternalFuture fut = tx.updateAsync(cctx, (UpdateSourceIterator)srcIt, pageSize, timeout, true);
        try {
            fut.get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
        return rowsCache;
    }

    private long registerRunningQuery(QueryDescriptor qryDesc, QueryParameters qryParams, GridQueryCancel cancel, @Nullable GridSqlStatement stmnt) {
        String qry = QueryUtils.INCLUDE_SENSITIVE || stmnt == null ? qryDesc.sql() : this.sqlWithoutConst(stmnt);
        long res = this.runningQueryManager().register(qry, GridCacheQueryType.SQL_FIELDS, qryDesc.schemaName(), qryDesc.local(), cancel, qryDesc.queryInitiatorId(), qryDesc.enforceJoinOrder(), qryParams.lazy(), qryDesc.distributedJoins());
        if (this.ctx.event().isRecordable(160)) {
            this.ctx.event().record((Event)new SqlQueryExecutionEvent(this.ctx.discovery().localNode(), GridCacheQueryType.SQL_FIELDS.name() + " query execution.", qry, qryParams.arguments(), this.ctx.security().enabled() ? this.ctx.security().securityContext().subject().id() : null));
        }
        return res;
    }

    private String sqlWithoutConst(GridSqlStatement stmnt) {
        QueryUtils.INCLUDE_SENSITIVE_TL.set(false);
        try {
            String string = stmnt.getSQL();
            return string;
        }
        finally {
            QueryUtils.INCLUDE_SENSITIVE_TL.set(true);
        }
    }

    private void checkSecurity(Collection<Integer> cacheIds) {
        if (F.isEmpty(cacheIds)) {
            return;
        }
        for (Integer cacheId : cacheIds) {
            DynamicCacheDescriptor desc = this.ctx.cache().cacheDescriptor(cacheId.intValue());
            if (desc == null) continue;
            this.ctx.security().authorize(desc.cacheName(), SecurityPermission.CACHE_READ);
        }
    }

    public void registerQueryStartedListener(Consumer<GridQueryStartedInfo> lsnr) {
        this.runningQueryManager().registerQueryStartedListener(lsnr);
    }

    public boolean unregisterQueryStartedListener(Object lsnr) {
        return this.runningQueryManager().unregisterQueryStartedListener(lsnr);
    }

    public void registerQueryFinishedListener(Consumer<GridQueryFinishedInfo> lsnr) {
        this.runningQueryManager().registerQueryFinishedListener(lsnr);
    }

    public boolean unregisterQueryFinishedListener(Object lsnr) {
        return this.runningQueryManager().unregisterQueryFinishedListener(lsnr);
    }

    public UpdateSourceIterator<?> executeUpdateOnDataNodeTransactional(GridCacheContext<?, ?> cctx, int[] ids, int[] parts, String schema, String qry, Object[] params, int flags, int pageSize, int timeout, AffinityTopologyVersion topVer, MvccSnapshot mvccSnapshot, GridQueryCancel cancel) {
        QueryCursorImpl cur;
        GridCacheContext cctx0;
        SqlFieldsQuery fldsQry = QueryUtils.withQueryTimeout((SqlFieldsQuery)new SqlFieldsQuery(qry), (int)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        if (params != null) {
            fldsQry.setArgs(params);
        }
        fldsQry.setEnforceJoinOrder(U.isFlagSet((int)flags, (int)2));
        fldsQry.setTimeout(timeout, TimeUnit.MILLISECONDS);
        fldsQry.setPageSize(pageSize);
        fldsQry.setLocal(true);
        fldsQry.setLazy(U.isFlagSet((int)flags, (int)32));
        boolean loc = true;
        boolean replicated = U.isFlagSet((int)flags, (int)16);
        if (!replicated && !F.isEmpty((int[])ids) && (cctx0 = CU.firstPartitioned((GridCacheSharedContext)cctx.shared(), (int[])ids)) != null && cctx0.config().getQueryParallelism() > 1) {
            fldsQry.setDistributedJoins(true);
            loc = false;
        }
        QueryParserResult parseRes = this.parser.parse(schema, fldsQry, false);
        assert (parseRes.remainingQuery() == null);
        QueryParserResultDml dml = parseRes.dml();
        assert (dml != null);
        IndexingQueryFilter filter = this.backupFilter(topVer, parts);
        UpdatePlan plan = dml.plan();
        GridCacheContext planCctx = plan.cacheContext();
        DmlUtils.setKeepBinaryContext(planCctx);
        SqlFieldsQuery selectFieldsQry = QueryUtils.withQueryTimeout((SqlFieldsQuery)new SqlFieldsQuery(plan.selectQuery(), fldsQry.isCollocated()), (int)fldsQry.getTimeout(), (TimeUnit)TimeUnit.MILLISECONDS).setArgs(fldsQry.getArgs()).setDistributedJoins(fldsQry.isDistributedJoins()).setEnforceJoinOrder(fldsQry.isEnforceJoinOrder()).setLocal(fldsQry.isLocal()).setPageSize(fldsQry.getPageSize()).setTimeout(fldsQry.getTimeout(), TimeUnit.MILLISECONDS).setLazy(fldsQry.isLazy());
        if (!loc && !plan.isLocalSubquery()) {
            cur = this.executeSelectForDml(0L, schema, selectFieldsQry, (MvccQueryTracker)new StaticMvccQueryTracker(planCctx, mvccSnapshot), cancel, timeout);
        } else {
            selectFieldsQry.setLocal(true);
            QueryParserResult selectParseRes = this.parser.parse(schema, selectFieldsQry, false);
            final GridQueryFieldsResult res = this.executeSelectLocal(0L, selectParseRes.queryDescriptor(), selectParseRes.queryParameters(), selectParseRes.select(), filter, (MvccQueryTracker)new StaticMvccQueryTracker(planCctx, mvccSnapshot), cancel, true, timeout);
            cur = new QueryCursorImpl(new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    try {
                        return res.iterator();
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                }
            }, cancel, true, selectParseRes.queryParameters().lazy());
        }
        return plan.iteratorForTransaction(this.connMgr, (QueryCursor<List<?>>)cur);
    }

    private Iterable<List<?>> executeSelectDistributed(final long qryId, final QueryDescriptor qryDesc, final QueryParameters qryParams, final GridCacheTwoStepQuery twoStepQry, final boolean keepBinary, final MvccQueryTracker mvccTracker, final GridQueryCancel cancel, final int timeout) {
        Iterable<List<?>> iter;
        PartitionResult derivedParts = twoStepQry.derivedPartitions();
        final int[] parts = PartitionResult.calculatePartitions((int[])qryParams.partitions(), (PartitionResult)derivedParts, (Object[])qryParams.arguments());
        if (parts != null && parts.length == 0) {
            iter = new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    return new Iterator<List<?>>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public List<?> next() {
                            return null;
                        }
                    };
                }
            };
        } else {
            assert (!twoStepQry.mvccEnabled() || !F.isEmpty(twoStepQry.cacheIds()));
            assert (twoStepQry.mvccEnabled() == (mvccTracker != null));
            iter = new Iterable<List<?>>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Iterator<List<?>> iterator() {
                    try (MTC.TraceSurroundings ignored = MTC.support((Span)IgniteH2Indexing.this.ctx.tracing().create(SpanType.SQL_ITER_OPEN, MTC.span()));){
                        Iterator<List<?>> iterator = IgniteH2Indexing.this.rdcQryExec.query(qryId, qryDesc.schemaName(), twoStepQry, keepBinary, qryDesc.enforceJoinOrder(), timeout, cancel, qryParams.arguments(), parts, qryParams.lazy(), mvccTracker, qryParams.dataPageScanEnabled(), qryParams.pageSize());
                        return iterator;
                    }
                    catch (Throwable e) {
                        if (mvccTracker == null) throw e;
                        mvccTracker.onDone();
                        throw e;
                    }
                }
            };
        }
        return iter;
    }

    public UpdateResult executeUpdateOnDataNode(String schemaName, SqlFieldsQuery qry, IndexingQueryFilter filter, GridQueryCancel cancel, boolean loc) throws IgniteCheckedException {
        QueryParserResult parseRes = this.parser.parse(schemaName, qry, false);
        assert (parseRes.remainingQuery() == null);
        QueryParserResultDml dml = parseRes.dml();
        assert (dml != null);
        return this.executeUpdate(0L, parseRes.queryDescriptor(), parseRes.queryParameters(), dml, loc, filter, cancel);
    }

    public boolean isConvertibleToColumnType(String schemaName, String tblName, String colName, Class<?> cls) {
        GridH2Table table = this.schemaMgr.dataTable(schemaName, tblName);
        if (table == null) {
            throw new IgniteSQLException("Table was not found [schemaName=" + schemaName + ", tableName=" + tblName + ']');
        }
        try {
            return H2Utils.isConvertableToColumnType(cls, table.getColumn(colName).getType());
        }
        catch (DbException e) {
            throw new IgniteSQLException("Colum with specified name was not found for the table [schemaName=" + schemaName + ", tableName=" + tblName + ", colName=" + colName + ']', (Throwable)e);
        }
    }

    public boolean isStreamableInsertStatement(String schemaName, SqlFieldsQuery qry) throws SQLException {
        QueryParserResult parsed = this.parser.parse(schemaName, qry, true);
        return parsed.isDml() && parsed.dml().streamable() && parsed.remainingQuery() == null;
    }

    public GridSpinBusyLock busyLock() {
        return this.busyLock;
    }

    public GridMapQueryExecutor mapQueryExecutor() {
        return this.mapQryExec;
    }

    public GridReduceQueryExecutor reduceQueryExecutor() {
        return this.rdcQryExec;
    }

    public RunningQueryManager runningQueryManager() {
        return this.ctx.query().runningQueryManager();
    }

    public void start(GridKernalContext ctx, GridSpinBusyLock busyLock) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting cache query index...");
        }
        if (H2Utils.checkSpatialIndexEnabled() && this.log.isDebugEnabled()) {
            this.log.debug("Spatial indexes are enabled.");
        }
        this.busyLock = busyLock;
        if (SysProperties.serializeJavaObject) {
            U.warn((IgniteLogger)this.log, (Object)"Serialization of Java objects in H2 was enabled.");
            SysProperties.serializeJavaObject = false;
        }
        this.ctx = ctx;
        this.partReservationMgr = new PartitionReservationManager(ctx);
        this.connMgr = new ConnectionManager(ctx);
        this.longRunningQryMgr = new LongRunningQueryManager(ctx);
        this.parser = new QueryParser(this, this.connMgr, cmd -> this.cmdProc.isCommandSupported((SqlCommand)cmd));
        this.schemaMgr = new H2SchemaManager(ctx, this, this.connMgr);
        this.schemaMgr.start();
        this.nodeId = ctx.localNodeId();
        this.marshaller = ctx.config().getMarshaller();
        this.mapQryExec = new GridMapQueryExecutor();
        this.rdcQryExec = new GridReduceQueryExecutor();
        this.mapQryExec.start(ctx, this);
        this.rdcQryExec.start(ctx, this);
        this.discoLsnr = evt -> {
            this.mapQryExec.onNodeLeft((DiscoveryEvent)evt);
            this.rdcQryExec.onNodeLeft((DiscoveryEvent)evt);
        };
        ctx.event().addLocalEventListener(this.discoLsnr, 12, new int[]{11});
        this.qryLsnr = (nodeId, msg, plc) -> this.onMessage(nodeId, msg);
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, this.qryLsnr);
        this.partExtractor = new PartitionExtractor(new H2PartitionResolver(this), ctx);
        this.cmdProc = new CommandProcessor(ctx, this.schemaMgr, this);
        if (JdbcUtils.serializer != null) {
            U.warn((IgniteLogger)this.log, (Object)"Custom H2 serialization is already configured, will override.");
        }
        JdbcUtils.serializer = this.h2Serializer();
        this.distrCfg = new DistributedSqlConfiguration(ctx, this.log);
        this.funcMgr = new FunctionsManager(this.distrCfg);
        CompareMode compareMode = this.connMgr.dataHandler().getCompareMode();
        ctx.indexProcessor().keyTypeSettings().stringOptimizedCompare("OFF".equals(compareMode.getName())).binaryUnsigned(compareMode.isBinaryUnsigned());
        ctx.internalSubscriptionProcessor().registerSchemaChangeListener((SchemaChangeListener)new AbstractSchemaChangeListener(){

            public void onColumnsAdded(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, List<QueryField> cols) {
                IgniteH2Indexing.this.clearPlanCache();
            }

            public void onColumnsDropped(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, List<String> cols) {
                IgniteH2Indexing.this.clearPlanCache();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(UUID nodeId, Object msg) {
        assert (msg != null);
        ClusterNode node = this.ctx.discovery().node(nodeId);
        if (node == null) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            if (msg instanceof GridCacheQueryMarshallable) {
                ((GridCacheQueryMarshallable)msg).unmarshall(this.ctx.config().getMarshaller(), this.ctx);
            }
            try {
                boolean processed = true;
                boolean tracebleMsg = false;
                if (msg instanceof GridQueryNextPageRequest) {
                    this.mapQueryExecutor().onNextPageRequest(node, (GridQueryNextPageRequest)msg);
                    tracebleMsg = true;
                } else if (msg instanceof GridQueryNextPageResponse) {
                    this.reduceQueryExecutor().onNextPage(node, (GridQueryNextPageResponse)msg);
                    tracebleMsg = true;
                } else if (msg instanceof GridH2QueryRequest) {
                    this.mapQueryExecutor().onQueryRequest(node, (GridH2QueryRequest)msg);
                } else if (msg instanceof GridH2DmlRequest) {
                    this.mapQueryExecutor().onDmlRequest(node, (GridH2DmlRequest)msg);
                } else if (msg instanceof GridH2DmlResponse) {
                    this.reduceQueryExecutor().onDmlResponse(node, (GridH2DmlResponse)msg);
                } else if (msg instanceof GridQueryFailResponse) {
                    this.reduceQueryExecutor().onFail(node, (GridQueryFailResponse)msg);
                } else if (msg instanceof GridQueryCancelRequest) {
                    this.mapQueryExecutor().onCancel(node, (GridQueryCancelRequest)msg);
                } else {
                    processed = false;
                }
                if (processed && this.log.isDebugEnabled() && (!tracebleMsg || this.log.isTraceEnabled())) {
                    this.log.debug("Processed message: [srcNodeId=" + nodeId + ", msg=" + msg + ']');
                }
            }
            catch (Throwable th) {
                U.error((IgniteLogger)this.log, (Object)("Failed to process message: [srcNodeId=" + nodeId + ", msg=" + msg + ']'), (Throwable)th);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CacheObjectValueContext objectContext() {
        return this.ctx.query().objectContext();
    }

    public boolean send(Object topic, int topicOrd, Collection<ClusterNode> nodes, Message msg, @Nullable IgniteBiClosure<ClusterNode, Message, Message> specialize, final @Nullable IgniteInClosure2X<ClusterNode, Message> locNodeHnd, byte plc, boolean runLocParallel) {
        boolean ok = true;
        if (specialize == null && msg instanceof GridCacheQueryMarshallable) {
            ((GridCacheQueryMarshallable)msg).marshall(this.marshaller);
        }
        ClusterNode locNode = null;
        for (ClusterNode node : nodes) {
            if (node.isLocal()) {
                if (locNode != null) {
                    throw new IllegalStateException();
                }
                locNode = node;
                continue;
            }
            try {
                if (specialize != null && (msg = (Message)specialize.apply((Object)node, (Object)msg)) instanceof GridCacheQueryMarshallable) {
                    ((GridCacheQueryMarshallable)msg).marshall(this.marshaller);
                }
                this.ctx.io().sendGeneric(node, topic, topicOrd, msg, plc);
            }
            catch (IgniteCheckedException e) {
                ok = false;
                U.warn((IgniteLogger)this.log, (Object)("Failed to send message [node=" + node + ", msg=" + msg + ", errMsg=" + e.getMessage() + "]"));
            }
        }
        if (locNode != null) {
            assert (locNodeHnd != null);
            if (specialize != null && (msg = (Message)specialize.apply(locNode, (Object)msg)) instanceof GridCacheQueryMarshallable) {
                ((GridCacheQueryMarshallable)msg).marshall(this.marshaller);
            }
            if (runLocParallel) {
                final ClusterNode finalLocNode = locNode;
                final Message finalMsg = msg;
                try {
                    this.ctx.closure().runLocal((Runnable)new GridPlainRunnable(){

                        public void run() {
                            if (!IgniteH2Indexing.this.busyLock.enterBusy()) {
                                return;
                            }
                            try {
                                locNodeHnd.apply((Object)finalLocNode, (Object)finalMsg);
                            }
                            finally {
                                IgniteH2Indexing.this.busyLock.leaveBusy();
                            }
                        }
                    }, plc).listen(this.logger);
                }
                catch (IgniteCheckedException e) {
                    ok = false;
                    U.error((IgniteLogger)this.log, (Object)"Failed to execute query locally.", (Throwable)e);
                }
            } else {
                locNodeHnd.apply((Object)locNode, (Object)msg);
            }
        }
        return ok;
    }

    private JavaObjectSerializer h2Serializer() {
        return new H2JavaObjectSerializer();
    }

    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping cache query index...");
        }
        this.mapQryExec.stop();
        this.qryCtxRegistry.clearSharedOnLocalNodeStop();
        this.longRunningQryMgr.stop();
        this.connMgr.stop();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cache query index stopped.");
        }
    }

    public void onClientDisconnect() throws IgniteCheckedException {
        if (!MvccUtils.mvccEnabled((GridKernalContext)this.ctx)) {
            return;
        }
        GridNearTxLocal tx = MvccUtils.tx((GridKernalContext)this.ctx);
        if (tx != null) {
            this.cmdProc.doRollback(tx);
        }
    }

    public void registerCache(String cacheName, String schemaName, GridCacheContextInfo<?, ?> cacheInfo) {
    }

    public void unregisterCache(GridCacheContextInfo<?, ?> cacheInfo) {
        String cacheName = cacheInfo.name();
        this.partReservationMgr.onCacheStop(cacheName);
        this.connMgr.onCacheDestroyed();
        this.clearPlanCache();
    }

    private void clearPlanCache() {
        this.parser.clearCache();
    }

    public IndexingQueryFilter backupFilter(@Nullable AffinityTopologyVersion topVer, @Nullable int[] parts) {
        return this.backupFilter(topVer, parts, false);
    }

    public IndexingQueryFilter backupFilter(@Nullable AffinityTopologyVersion topVer, @Nullable int[] parts, boolean treatReplicatedAsPartitioned) {
        return new IndexingQueryFilterImpl(this.ctx, topVer, parts, treatReplicatedAsPartitioned);
    }

    public AffinityTopologyVersion readyTopologyVersion() {
        return this.ctx.cache().context().exchange().readyAffinityVersion();
    }

    public boolean serverTopologyChanged(AffinityTopologyVersion readyVer) {
        GridDhtPartitionsExchangeFuture fut = this.ctx.cache().context().exchange().lastTopologyFuture();
        if (fut.isDone()) {
            return false;
        }
        AffinityTopologyVersion initVer = fut.initialVersion();
        return initVer.compareTo(readyVer) > 0 && !fut.firstEvent().node().isClient();
    }

    public void awaitForReadyTopologyVersion(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        this.ctx.cache().context().exchange().affinityReadyFuture(topVer).get();
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        this.rdcQryExec.onDisconnected(reconnectFut);
    }

    public void onKernalStop() {
        this.connMgr.onKernalStop();
        this.ctx.io().removeMessageListener(GridTopic.TOPIC_QUERY, this.qryLsnr);
        this.ctx.event().removeLocalEventListener(this.discoLsnr, new int[0]);
    }

    public QueryContextRegistry queryContextRegistry() {
        return this.qryCtxRegistry;
    }

    public ConnectionManager connections() {
        return this.connMgr;
    }

    public QueryParser parser() {
        return this.parser;
    }

    public H2SchemaManager schemaManager() {
        return this.schemaMgr;
    }

    public PartitionExtractor partitionExtractor() {
        return this.partExtractor;
    }

    public PartitionReservationManager partitionReservationManager() {
        return this.partReservationMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryCursorImpl<List<?>>> executeUpdateDistributed(long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, GridQueryCancel cancel) throws IgniteCheckedException {
        if (qryDesc.batched()) {
            List<Object> ress;
            List<Object[]> argss = qryParams.batchedArguments();
            UpdatePlan plan = dml.plan();
            GridCacheContext cctx = plan.cacheContext();
            if (plan.hasRows() && plan.mode() == UpdateMode.INSERT && !cctx.mvccEnabled()) {
                CacheOperationContext opCtx = DmlUtils.setKeepBinaryContext(cctx);
                try {
                    List<List<List<?>>> cur = plan.createRows(argss);
                    ress = DmlUtils.processSelectResultBatched(plan, cur, qryParams.updateBatchSize());
                }
                finally {
                    DmlUtils.restoreKeepBinaryContext(cctx, opCtx);
                }
            } else {
                ress = new ArrayList(argss.size());
                Throwable batchException = null;
                int[] cntPerRow = new int[argss.size()];
                boolean bl = false;
                for (Object[] args : argss) {
                    try {
                        UpdateResult res = this.executeUpdate(qryId, qryDesc, qryParams.toSingleBatchedArguments(args), dml, false, null, cancel);
                        cntPerRow[var13_16++] = (int)res.counter();
                        ress.add(res);
                    }
                    catch (Exception e) {
                        SQLException sqlEx = QueryUtils.toSqlException((Exception)e);
                        batchException = DmlUtils.chainException((SQLException)batchException, sqlEx);
                        cntPerRow[var13_16++] = -3;
                    }
                }
                if (batchException != null) {
                    BatchUpdateException e = new BatchUpdateException(batchException.getMessage(), ((SQLException)batchException).getSQLState(), ((SQLException)batchException).getErrorCode(), cntPerRow, batchException);
                    throw new IgniteCheckedException((Throwable)e);
                }
            }
            ArrayList resCurs = new ArrayList(ress.size());
            for (UpdateResult updateResult : ress) {
                updateResult.throwIfError();
                QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(updateResult.counter())), cancel, false, false);
                resCur.fieldsMeta(H2Utils.UPDATE_RESULT_META);
                resCurs.add(resCur);
            }
            return resCurs;
        }
        UpdateResult res = this.executeUpdate(qryId, qryDesc, qryParams, dml, false, null, cancel);
        res.throwIfError();
        QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(res.counter())), cancel, false, false);
        resCur.fieldsMeta(H2Utils.UPDATE_RESULT_META);
        resCur.partitionResult(res.partitionResult());
        return Collections.singletonList(resCur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult executeUpdate(long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        Object[] errKeys = null;
        long items = 0L;
        PartitionResult partRes = null;
        GridCacheContext cctx = dml.plan().cacheContext();
        boolean transactional = cctx != null && cctx.mvccEnabled();
        int maxRetryCnt = transactional ? 1 : 4;
        for (int i = 0; i < maxRetryCnt; ++i) {
            UpdateResult r;
            CacheOperationContext opCtx = cctx != null ? DmlUtils.setKeepBinaryContext(cctx) : null;
            try {
                r = transactional ? this.executeUpdateTransactional(qryId, qryDesc, qryParams, dml, loc, cancel) : this.executeUpdateNonTransactional(qryId, qryDesc, qryParams, dml, loc, filters, cancel);
            }
            finally {
                if (opCtx != null) {
                    DmlUtils.restoreKeepBinaryContext(cctx, opCtx);
                }
            }
            items += r.counter();
            errKeys = r.errorKeys();
            partRes = r.partitionResult();
            if (F.isEmpty((Object[])errKeys)) break;
        }
        if (F.isEmpty(errKeys) && partRes == null) {
            if (items == 1L) {
                return UpdateResult.ONE;
            }
            if (items == 0L) {
                return UpdateResult.ZERO;
            }
        }
        return new UpdateResult(items, errKeys, partRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult executeUpdateNonTransactional(long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, boolean loc, IndexingQueryFilter filters, GridQueryCancel cancel) throws IgniteCheckedException {
        QueryCursorImpl cur;
        GridQueryCancel selectCancel;
        DmlDistributedPlanInfo distributedPlan;
        UpdatePlan plan = dml.plan();
        UpdateResult fastUpdateRes = plan.processFast(qryParams.arguments());
        if (fastUpdateRes != null) {
            return fastUpdateRes;
        }
        DmlDistributedPlanInfo dmlDistributedPlanInfo = distributedPlan = loc ? null : plan.distributedPlan();
        if (distributedPlan != null) {
            UpdateResult result;
            if (cancel == null) {
                cancel = new GridQueryCancel();
            }
            if ((result = this.rdcQryExec.update(qryDesc.schemaName(), distributedPlan.getCacheIds(), qryDesc.sql(), qryParams.arguments(), qryDesc.enforceJoinOrder(), qryParams.pageSize(), qryParams.timeout(), qryParams.partitions(), distributedPlan.isReplicatedOnly(), cancel)) != null) {
                return result;
            }
        }
        GridQueryCancel gridQueryCancel = selectCancel = cancel != null ? new GridQueryCancel() : null;
        if (cancel != null) {
            cancel.add(() -> ((GridQueryCancel)selectCancel).cancel());
        }
        SqlFieldsQuery selectFieldsQry = new SqlFieldsQuery(plan.selectQuery(), qryDesc.collocated()).setArgs(qryParams.arguments()).setDistributedJoins(qryDesc.distributedJoins()).setEnforceJoinOrder(qryDesc.enforceJoinOrder()).setLocal(qryDesc.local()).setPageSize(qryParams.pageSize()).setTimeout(qryParams.timeout(), TimeUnit.MILLISECONDS).setLazy(qryParams.lazy() && plan.canSelectBeLazy());
        if (!loc && !plan.isLocalSubquery()) {
            assert (!F.isEmpty((String)plan.selectQuery()));
            cur = this.executeSelectForDml(qryId, qryDesc.schemaName(), selectFieldsQry, null, selectCancel, qryParams.timeout());
        } else if (plan.hasRows()) {
            cur = plan.createRows(qryParams.arguments());
        } else {
            selectFieldsQry.setLocal(true);
            QueryParserResult selectParseRes = this.parser.parse(qryDesc.schemaName(), selectFieldsQry, false);
            final GridQueryFieldsResult res = this.executeSelectLocal(qryId, selectParseRes.queryDescriptor(), selectParseRes.queryParameters(), selectParseRes.select(), filters, null, selectCancel, false, qryParams.timeout());
            cur = new QueryCursorImpl(new Iterable<List<?>>(){

                @Override
                public Iterator<List<?>> iterator() {
                    try {
                        return new GridQueryCacheObjectsIterator((Iterator)res.iterator(), IgniteH2Indexing.this.objectContext(), true);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                }
            }, cancel, true, qryParams.lazy());
        }
        int pageSize = qryParams.updateBatchSize();
        try {
            UpdateResult updateResult = DmlUtils.processSelectResult(plan, cur, pageSize);
            return updateResult;
        }
        finally {
            if (cur instanceof AutoCloseable) {
                U.closeQuiet((AutoCloseable)((AutoCloseable)cur));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private UpdateResult executeUpdateTransactional(long qryId, QueryDescriptor qryDesc, QueryParameters qryParams, QueryParserResultDml dml, boolean loc, GridQueryCancel cancel) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void registerMxBeans(IgniteMBeansManager mbMgr) throws IgniteCheckedException {
        SqlQueryMXBeanImpl qryMXBean = new SqlQueryMXBeanImpl(this.ctx);
        mbMgr.registerMBean("SQL Query", qryMXBean.getClass().getSimpleName(), (Object)qryMXBean, SqlQueryMXBean.class);
    }

    public LongRunningQueryManager longRunningQueries() {
        return this.longRunningQryMgr;
    }

    public DistributedSqlConfiguration distributedConfiguration() {
        return this.distrCfg;
    }

    private static /* synthetic */ String lambda$executeSqlQueryWithTimer$1(String sql) {
        return sql;
    }
}

