/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.IgniteClusterReadOnlyException;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.query.h2.dml.DmlPageProcessingErrorResult;
import org.apache.ignite.internal.processors.query.h2.dml.DmlPageProcessingResult;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;

public class DmlBatchSender {
    private static final BatchEntryComparator COMP = new BatchEntryComparator();
    private final GridCacheContext cctx;
    private final int size;
    private final Map<UUID, Batch> batches = new HashMap<UUID, Batch>();
    private long updateCnt;
    private List<Object> failedKeys;
    private SQLException err;
    private int[] cntPerRow;

    public DmlBatchSender(GridCacheContext cctx, int size, int qryNum) {
        this.cctx = cctx;
        this.size = size;
        this.cntPerRow = new int[qryNum];
    }

    public void add(Object key, EntryProcessor<Object, Object, Boolean> proc, int rowNum) throws IgniteCheckedException {
        assert (key != null);
        assert (proc != null);
        assert (rowNum < this.cntPerRow.length);
        ClusterNode node = this.primaryNodeByKey(key);
        UUID nodeId = node.id();
        Batch batch = this.batches.get(nodeId);
        if (batch == null) {
            batch = new Batch();
            this.batches.put(nodeId, batch);
        }
        if (batch.containsKey(key)) {
            this.sendBatch(batch);
        }
        batch.put(key, rowNum, proc);
        if (batch.size() >= this.size) {
            this.sendBatch(batch);
        }
    }

    public ClusterNode primaryNodeByKey(Object key) throws IgniteCheckedException {
        ClusterNode node = this.cctx.affinity().primaryByKey(key, AffinityTopologyVersion.NONE);
        if (node == null) {
            throw new IgniteCheckedException("Failed to map key to node.");
        }
        return node;
    }

    public void flush() {
        for (Batch batch : this.batches.values()) {
            if (batch.isEmpty()) continue;
            this.sendBatch(batch);
        }
    }

    public long updateCount() {
        return this.updateCnt;
    }

    public List<Object> failedKeys() {
        return this.failedKeys != null ? this.failedKeys : Collections.emptyList();
    }

    public SQLException error() {
        return this.err;
    }

    public int[] perRowCounterAsArray() {
        return this.cntPerRow;
    }

    public void setFailed(int rowNum) {
        this.cntPerRow[rowNum] = -3;
    }

    private void sendBatch(Batch batch) {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.cctx.kernalContext().tracing().create(SpanType.SQL_CACHE_UPDATE, MTC.span()).addTag("sql.cache.updates", () -> Integer.toString(batch.size())));){
            DmlPageProcessingResult pageRes = this.processPage(this.cctx, batch);
            batch.clear();
            this.updateCnt += pageRes.count();
            if (this.failedKeys == null) {
                this.failedKeys = new ArrayList<Object>();
            }
            this.failedKeys.addAll(F.asList((Object[])pageRes.errorKeys()));
            if (pageRes.error() != null) {
                MTC.span().addTag("error", pageRes.error()::getMessage);
                if (this.err == null) {
                    this.err = pageRes.error();
                } else {
                    this.err.setNextException(pageRes.error());
                }
            }
        }
    }

    private DmlPageProcessingResult processPage(GridCacheContext cctx, Batch batch) {
        Map res;
        try {
            res = cctx.cache().invokeAll(batch.rowProcessors(), new Object[0]);
        }
        catch (IgniteCheckedException e) {
            for (Integer rowNum : batch.rowNumbers().values()) {
                assert (rowNum != null);
                this.cntPerRow[rowNum.intValue()] = -3;
            }
            if (X.hasCause((Throwable)e, (Class[])new Class[]{IgniteClusterReadOnlyException.class})) {
                SQLException sqlEx = new SQLException(e.getMessage(), "90097", 4011, e);
                return new DmlPageProcessingResult(0L, null, sqlEx);
            }
            return new DmlPageProcessingResult(0L, null, new SQLException(e.getMessage(), "50000", 1, e));
        }
        if (F.isEmpty((Map)res)) {
            this.countAllRows(batch.rowNumbers().values());
            return new DmlPageProcessingResult(batch.size(), null, null);
        }
        DmlPageProcessingErrorResult splitRes = this.splitErrors(res, batch);
        int keysCnt = splitRes.errorKeys().length;
        return new DmlPageProcessingResult(batch.size() - keysCnt - splitRes.errorCount(), splitRes.errorKeys(), splitRes.error());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DmlPageProcessingErrorResult splitErrors(Map<Object, EntryProcessorResult<Boolean>> res, Batch batch) {
        LinkedHashSet<Object> errKeys = new LinkedHashSet<Object>(res.keySet());
        this.countAllRows(batch.rowNumbers().values());
        SQLException currSqlEx = null;
        SQLException firstSqlEx = null;
        int errors = 0;
        for (Map.Entry<Object, EntryProcessorResult<Boolean>> e : res.entrySet()) {
            block8: {
                Integer rowNum;
                Object key;
                try {
                    e.getValue().get();
                    key = e.getKey();
                    rowNum = batch.rowNumbers().get(key);
                    if ($assertionsDisabled || rowNum != null) break block8;
                }
                catch (EntryProcessorException ex) {
                    block9: {
                        try {
                            SQLException next = IgniteQueryErrorCode.createJdbcSqlException((String)("Failed to process key '" + e.getKey() + '\''), (int)4005);
                            next.initCause(ex);
                            if (currSqlEx != null) {
                                currSqlEx.setNextException(next);
                            } else {
                                firstSqlEx = next;
                            }
                            currSqlEx = next;
                            errKeys.remove(e.getKey());
                            ++errors;
                            key = e.getKey();
                            rowNum = batch.rowNumbers().get(key);
                            if ($assertionsDisabled || rowNum != null) break block9;
                        }
                        catch (Throwable throwable) {
                            Object key2 = e.getKey();
                            Integer rowNum2 = batch.rowNumbers().get(key2);
                            assert (rowNum2 != null);
                            this.cntPerRow[rowNum2.intValue()] = -3;
                            throw throwable;
                        }
                        throw new AssertionError();
                    }
                    this.cntPerRow[rowNum.intValue()] = -3;
                    continue;
                }
                throw new AssertionError();
            }
            this.cntPerRow[rowNum.intValue()] = -3;
        }
        return new DmlPageProcessingErrorResult(errKeys.toArray(), firstSqlEx, errors);
    }

    private void countAllRows(Collection<Integer> rowNums) {
        for (Integer rowNum : rowNums) {
            assert (rowNum != null);
            if (this.cntPerRow[rowNum] <= -1) continue;
            int n = rowNum;
            this.cntPerRow[n] = this.cntPerRow[n] + 1;
        }
    }

    static /* synthetic */ BatchEntryComparator access$200() {
        return COMP;
    }

    private static final class BatchEntryComparator
    implements Comparator<Object> {
        private BatchEntryComparator() {
        }

        @Override
        public int compare(Object first, Object second) {
            return BinaryObjectImpl.compareForDml((Object)first, (Object)second);
        }
    }

    private static class Batch {
        private Map<Object, Integer> rowNums = new HashMap<Object, Integer>();
        private Map<Object, EntryProcessor<Object, Object, Boolean>> rowProcs = new TreeMap<Object, EntryProcessor<Object, Object, Boolean>>(DmlBatchSender.access$200());

        private Batch() {
        }

        public boolean containsKey(Object key) {
            boolean res = this.rowNums.containsKey(key);
            assert (res == this.rowProcs.containsKey(key));
            return res;
        }

        public int size() {
            int res = this.rowNums.size();
            assert (res == this.rowProcs.size());
            return res;
        }

        public boolean put(Object key, Integer rowNum, EntryProcessor<Object, Object, Boolean> proc) {
            Integer prevNum = this.rowNums.put(key, rowNum);
            EntryProcessor<Object, Object, Boolean> prevProc = this.rowProcs.put(key, proc);
            assert (prevNum == null == (prevProc == null));
            return prevNum != null;
        }

        public void clear() {
            assert (this.rowNums.size() == this.rowProcs.size());
            this.rowNums.clear();
            this.rowProcs.clear();
        }

        public boolean isEmpty() {
            assert (this.rowNums.size() == this.rowProcs.size());
            return this.rowNums.isEmpty();
        }

        public Map<Object, Integer> rowNumbers() {
            return this.rowNums;
        }

        public Map<Object, EntryProcessor<Object, Object, Boolean>> rowProcessors() {
            return this.rowProcs;
        }
    }
}

