/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tools.surefire.testsuites;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.tools.surefire.testsuites.OrphanedTestCollection;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;

public class CheckAllTestsInSuites {
    static Iterable<Class<?>> testClasses;

    @Test
    public void check() {
        HashSet<String> suitedTestClasses = new HashSet<String>();
        HashSet<String> allTestClasses = new HashSet<String>();
        HashSet<String> suites = new HashSet<String>();
        HashSet<String> superClasses = new HashSet<String>();
        for (Class<?> clazz : testClasses) {
            if (Modifier.isAbstract(clazz.getModifiers()) || clazz.getAnnotation(Ignore.class) != null) continue;
            Description desc = Request.aClass(clazz).getRunner().getDescription();
            if (this.isTestClass(desc)) {
                allTestClasses.add(clazz.getName());
                superClasses.add(clazz.getSuperclass().getName());
                continue;
            }
            this.processSuite(desc, suitedTestClasses, suites, superClasses);
        }
        allTestClasses.removeAll(suitedTestClasses);
        allTestClasses.removeAll(superClasses);
        OrphanedTestCollection orphaned = new OrphanedTestCollection();
        try {
            Set<String> orphanedTests = orphaned.getOrphanedTests();
            orphanedTests.removeAll(suitedTestClasses);
            orphanedTests.addAll(allTestClasses);
            orphaned.persistOrphanedTests(orphanedTests, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to check orphaned tests.", e);
        }
    }

    private void processSuite(Description suite, Set<String> suitedClasses, Set<String> suites, Set<String> superClasses) {
        suites.add(suite.getTestClass().getName());
        for (Description desc : suite.getChildren()) {
            if (!this.isTestClass(desc)) {
                this.processSuite(desc, suitedClasses, suites, superClasses);
                continue;
            }
            suitedClasses.add(desc.getTestClass().getName());
            superClasses.add(desc.getTestClass().getSuperclass().getName());
        }
    }

    private boolean isTestClass(Description desc) {
        RunWith runWith = (RunWith)desc.getAnnotation(RunWith.class);
        return runWith == null || runWith.value().equals(Parameterized.class) || !Suite.class.isAssignableFrom(runWith.value()) && !"org.scalatest.Suites".equals(desc.getTestClass().getSuperclass().getName());
    }
}

