/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tools.surefire.testsuites;

import java.util.Collections;
import org.apache.ignite.tools.surefire.testsuites.CheckAllTestsInSuites;
import org.apache.maven.surefire.common.junit4.JUnit4StackTraceWriter;
import org.apache.maven.surefire.common.junit48.JUnit48TestChecker;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.report.TestSetReportEntry;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class IgniteTestsProvider
extends AbstractProvider {
    private final ClassLoader testClsLdr;
    private final ScanResult scanResult;
    private final ReporterFactory reporterFactory;

    public IgniteTestsProvider(ProviderParameters bootParams) {
        this.testClsLdr = bootParams.getTestClassLoader();
        this.scanResult = bootParams.getScanResult();
        this.reporterFactory = bootParams.getReporterFactory();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        IgniteTestFilter scannerFilter = new IgniteTestFilter(this.testClsLdr);
        CheckAllTestsInSuites.testClasses = this.scanResult.applyFilter((ScannerFilter)scannerFilter, this.testClsLdr);
        Result junitResult = JUnitCore.runClasses((Class[])new Class[]{CheckAllTestsInSuites.class});
        RunResult surefireResult = new RunResult(junitResult.getRunCount(), 0, junitResult.getFailureCount(), 0);
        if (junitResult.getFailureCount() > 0) {
            this.writeFailureToOutput((Failure)junitResult.getFailures().get(0));
        }
        return surefireResult;
    }

    private void writeFailureToOutput(Failure failure) throws TestSetFailedException {
        try {
            SimpleReportEntry report = SimpleReportEntry.withException((String)failure.getDescription().getClassName(), null, (String)failure.getDescription().getMethodName(), null, (StackTraceWriter)new JUnit4StackTraceWriter(failure));
            RunListener reporter = this.reporterFactory.createReporter();
            ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
            reporter.testFailed((ReportEntry)report);
            reporter.testSetCompleted((TestSetReportEntry)report);
        }
        catch (Exception e) {
            throw new TestSetFailedException("Failed to dump exception to stdout");
        }
    }

    public Iterable<Class<?>> getSuites() {
        return Collections.singletonList(CheckAllTestsInSuites.class);
    }

    private static class IgniteTestFilter
    extends JUnit48TestChecker {
        public IgniteTestFilter(ClassLoader testClsLdr) {
            super(testClsLdr);
        }

        public boolean accept(Class aCls) {
            boolean isValidJunitTestCls = super.accept(aCls);
            if (!isValidJunitTestCls && this.shouldCheckSuperClass(aCls)) {
                return super.accept(aCls.getSuperclass());
            }
            return isValidJunitTestCls;
        }

        private boolean shouldCheckSuperClass(Class<?> aCls) {
            Class<?> superCls = aCls.getSuperclass();
            return superCls != null && !superCls.equals(Object.class);
        }
    }
}

