/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tools.surefire.testsuites;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OrphanedTestCollection {
    private static final String FINAL_MARK = "---";
    private final Path path = OrphanedTestCollection.initPath();

    public Set<String> getOrphanedTests() throws Exception {
        if (Files.notExists(this.path, new LinkOption[0])) {
            return new HashSet<String>();
        }
        try (BufferedReader testReader = new BufferedReader(new FileReader(this.path.toFile()));){
            String testClsName = testReader.readLine();
            if (FINAL_MARK.equals(testClsName)) {
                HashSet<String> hashSet = new HashSet<String>();
                return hashSet;
            }
            HashSet<String> testClasses = new HashSet<String>();
            while (testClsName != null) {
                testClasses.add(testClsName);
                testClsName = testReader.readLine();
            }
            HashSet<String> hashSet = testClasses;
            return hashSet;
        }
    }

    public void persistOrphanedTests(Collection<String> testClasses, boolean last) throws Exception {
        try (BufferedWriter testWriter = new BufferedWriter(new FileWriter(this.path.toFile()));){
            if (last) {
                testWriter.write(FINAL_MARK);
                testWriter.newLine();
            }
            for (String cls : testClasses) {
                testWriter.write(cls);
                testWriter.newLine();
            }
        }
    }

    public Path getPath() {
        return this.path;
    }

    private static Path initPath() {
        Path curPath = Paths.get("", new String[0]).toAbsolutePath();
        while (!curPath.equals(curPath.getRoot())) {
            if (curPath.resolve("modules").toFile().exists()) {
                Path targetPath = curPath.resolve("target");
                if (!targetPath.toFile().exists()) {
                    try {
                        Files.createDirectory(targetPath, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to create target directory.", e);
                    }
                }
                return curPath.resolve("target").resolve("orphaned_tests.txt");
            }
            curPath = curPath.getParent();
        }
        throw new IllegalStateException("Can't find repository root directory.");
    }
}

