/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.fulltext.ExtractedText;
import org.apache.jackrabbit.oak.plugins.index.fulltext.PreExtractedTextProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.TextExtractionStatsMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtractedTextCache {
    private static final String EMPTY_STRING = "";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile PreExtractedTextProvider extractedTextProvider;
    private int textExtractionCount;
    private long totalBytesRead;
    private long totalTextSize;
    private long totalTime;
    private int preFetchedCount;
    private final Cache<String, String> cache;
    private final CacheStats cacheStats;
    private final boolean alwaysUsePreExtractedCache;

    public ExtractedTextCache(long maxWeight, long expiryTimeInSecs) {
        this(maxWeight, expiryTimeInSecs, false);
    }

    public ExtractedTextCache(long maxWeight, long expiryTimeInSecs, boolean alwaysUsePreExtractedCache) {
        if (maxWeight > 0L) {
            this.cache = CacheBuilder.newBuilder().weigher((Weigher)EmpiricalWeigher.INSTANCE).maximumWeight(maxWeight).expireAfterAccess(expiryTimeInSecs, TimeUnit.SECONDS).recordStats().build();
            this.cacheStats = new CacheStats(this.cache, "ExtractedTextCache", EmpiricalWeigher.INSTANCE, maxWeight);
        } else {
            this.cache = null;
            this.cacheStats = null;
        }
        this.alwaysUsePreExtractedCache = alwaysUsePreExtractedCache;
    }

    @CheckForNull
    public String get(String nodePath, String propertyName, Blob blob, boolean reindexMode) {
        String result = null;
        String propertyPath = PathUtils.concat((String)nodePath, (String)propertyName);
        this.log.trace("Looking for extracted text for [{}] with blobId [{}]", (Object)propertyPath, (Object)blob.getContentIdentity());
        if ((reindexMode || this.alwaysUsePreExtractedCache) && this.extractedTextProvider != null) {
            try {
                ExtractedText text = this.extractedTextProvider.getText(propertyPath, blob);
                if (text != null) {
                    ++this.preFetchedCount;
                    switch (text.getExtractionResult()) {
                        case SUCCESS: {
                            result = text.getExtractedText().toString();
                            break;
                        }
                        case ERROR: {
                            result = "TextExtractionError";
                            break;
                        }
                        case EMPTY: {
                            result = EMPTY_STRING;
                        }
                    }
                }
            }
            catch (IOException e) {
                this.log.warn("Error occurred while fetching pre extracted text for {}", (Object)propertyPath, (Object)e);
            }
        }
        String id = blob.getContentIdentity();
        if (this.cache != null && id != null && result == null) {
            result = (String)this.cache.getIfPresent((Object)id);
        }
        return result;
    }

    public void put(@Nonnull Blob blob, @Nonnull ExtractedText extractedText) {
        String id = blob.getContentIdentity();
        if (extractedText.getExtractionResult() == ExtractedText.ExtractionResult.SUCCESS && this.cache != null && id != null) {
            this.cache.put((Object)id, (Object)extractedText.getExtractedText().toString());
        }
    }

    public void addStats(int count, long timeInMillis, long bytesRead, long textLength) {
        this.textExtractionCount += count;
        this.totalTime += timeInMillis;
        this.totalBytesRead += bytesRead;
        this.totalTextSize += textLength;
    }

    public TextExtractionStatsMBean getStatsMBean() {
        return new TextExtractionStatsMBean(){

            @Override
            public boolean isPreExtractedTextProviderConfigured() {
                return ExtractedTextCache.this.extractedTextProvider != null;
            }

            @Override
            public int getTextExtractionCount() {
                return ExtractedTextCache.this.textExtractionCount;
            }

            @Override
            public long getTotalTime() {
                return ExtractedTextCache.this.totalTime;
            }

            @Override
            public int getPreFetchedCount() {
                return ExtractedTextCache.this.preFetchedCount;
            }

            @Override
            public String getExtractedTextSize() {
                return IOUtils.humanReadableByteCount((long)ExtractedTextCache.this.totalTextSize);
            }

            @Override
            public String getBytesRead() {
                return IOUtils.humanReadableByteCount((long)ExtractedTextCache.this.totalBytesRead);
            }

            @Override
            public boolean isAlwaysUsePreExtractedCache() {
                return ExtractedTextCache.this.alwaysUsePreExtractedCache;
            }
        };
    }

    @CheckForNull
    public CacheStats getCacheStats() {
        return this.cacheStats;
    }

    public void setExtractedTextProvider(PreExtractedTextProvider extractedTextProvider) {
        this.extractedTextProvider = extractedTextProvider;
    }

    public PreExtractedTextProvider getExtractedTextProvider() {
        return this.extractedTextProvider;
    }

    void resetCache() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
    }

    boolean isAlwaysUsePreExtractedCache() {
        return this.alwaysUsePreExtractedCache;
    }

    private static class EmpiricalWeigher
    implements Weigher<String, String> {
        public static final EmpiricalWeigher INSTANCE = new EmpiricalWeigher();

        private EmpiricalWeigher() {
        }

        private static int getMemory(@Nonnull String s) {
            return 56 + s.length() * 2;
        }

        public int weigh(String key, String value) {
            int size = 168;
            size += EmpiricalWeigher.getMemory(key);
            return size += EmpiricalWeigher.getMemory(value);
        }
    }
}

