/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SuggestHelper;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.shingle.ShingleAnalyzerWrapper;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexEditorContext {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexEditorContext.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(LuceneIndexEditorContext.class.getName() + ".perf")));
    private final FacetsConfig facetsConfig;
    private static final Parser defaultParser = LuceneIndexEditorContext.createDefaultParser();
    private IndexDefinition definition;
    private final NodeBuilder definitionBuilder;
    private IndexWriter writer = null;
    private long indexedNodes;
    private final IndexUpdateCallback updateCallback;
    private boolean reindex;
    private Parser parser;
    @Nullable
    private final IndexCopier indexCopier;
    private Directory directory;
    private final TextExtractionStats textExtractionStats = new TextExtractionStats();
    private final ExtractedTextCache extractedTextCache;
    private final IndexAugmentorFactory augmentorFactory;
    private final NodeState root;
    private Set<MediaType> supportedMediaTypes;
    private static Clock clock = Clock.SIMPLE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IndexWriterConfig getIndexWriterConfig(IndexDefinition definition, boolean remoteDir) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(IndexWriterConfig.class.getClassLoader());
        try {
            Analyzer definitionAnalyzer = definition.getAnalyzer();
            HashMap<String, Analyzer> analyzers = new HashMap<String, Analyzer>();
            analyzers.put(":spellcheck", new ShingleAnalyzerWrapper(LuceneIndexConstants.ANALYZER, 3));
            if (!definition.isSuggestAnalyzed()) {
                analyzers.put(":suggest", SuggestHelper.getAnalyzer());
            }
            PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper(definitionAnalyzer, analyzers);
            IndexWriterConfig config = new IndexWriterConfig(LuceneIndexConstants.VERSION, analyzer);
            if (remoteDir) {
                config.setMergeScheduler(new SerialMergeScheduler());
            }
            if (definition.getCodec() != null) {
                config.setCodec(definition.getCodec());
            }
            IndexWriterConfig indexWriterConfig = config;
            return indexWriterConfig;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    static Directory newIndexDirectory(IndexDefinition indexDefinition, NodeBuilder definition) throws IOException {
        String path = definition.getString("path");
        if (path == null) {
            return new OakDirectory(definition, indexDefinition, false);
        }
        File file = new File(path);
        file.mkdirs();
        return FSDirectory.open(file, NoLockFactory.getNoLockFactory());
    }

    LuceneIndexEditorContext(NodeState root, NodeBuilder definition, IndexUpdateCallback updateCallback, @Nullable IndexCopier indexCopier, ExtractedTextCache extractedTextCache, IndexAugmentorFactory augmentorFactory) {
        this.root = root;
        this.definitionBuilder = definition;
        this.indexCopier = indexCopier;
        this.definition = new IndexDefinition(root, definition);
        this.indexedNodes = 0L;
        this.updateCallback = updateCallback;
        this.extractedTextCache = extractedTextCache;
        this.augmentorFactory = augmentorFactory;
        if (this.definition.isOfOldFormat()) {
            IndexDefinition.updateDefinition(definition);
        }
        this.facetsConfig = FacetHelper.getFacetsConfig(definition);
    }

    Parser getParser() {
        if (this.parser == null) {
            this.parser = LuceneIndexEditorContext.initializeTikaParser(this.definition);
        }
        return this.parser;
    }

    IndexWriter getWriter() throws IOException {
        if (this.writer == null) {
            IndexWriterConfig config;
            long start = PERF_LOGGER.start();
            this.directory = LuceneIndexEditorContext.newIndexDirectory(this.definition, this.definitionBuilder);
            if (this.indexCopier != null) {
                this.directory = this.indexCopier.wrapForWrite(this.definition, this.directory, this.reindex);
                config = LuceneIndexEditorContext.getIndexWriterConfig(this.definition, false);
            } else {
                config = LuceneIndexEditorContext.getIndexWriterConfig(this.definition, true);
            }
            this.writer = new IndexWriter(this.directory, config);
            PERF_LOGGER.end(start, -1L, "Created IndexWriter for directory {}", (Object)this.definition);
        }
        return this.writer;
    }

    private static void trackIndexSizeInfo(@Nonnull IndexWriter writer, @Nonnull IndexDefinition definition, @Nonnull Directory directory) throws IOException {
        Preconditions.checkNotNull((Object)writer);
        Preconditions.checkNotNull((Object)definition);
        Preconditions.checkNotNull((Object)directory);
        int docs = writer.numDocs();
        int ram = writer.numRamDocs();
        log.trace("Writer for direcory {} - docs: {}, ramDocs: {}", new Object[]{definition, docs, ram});
        String[] files = directory.listAll();
        long overallSize = 0L;
        StringBuilder sb = new StringBuilder();
        for (String f : files) {
            sb.append(f).append(":");
            if (directory.fileExists(f)) {
                long size = directory.fileLength(f);
                overallSize += size;
                sb.append(size);
            } else {
                sb.append("--");
            }
            sb.append(", ");
        }
        log.trace("Directory overall size: {}, files: {}", (Object)IOUtils.humanReadableByteCount((long)overallSize), (Object)sb.toString());
    }

    void closeWriter() throws IOException {
        if (this.reindex && this.writer == null) {
            this.getWriter();
        }
        boolean updateSuggestions = this.shouldUpdateSuggestions();
        if (this.writer == null && updateSuggestions) {
            log.debug("Would update suggester dictionary although no index changes were detected in current cycle");
            this.getWriter();
        }
        if (this.writer != null) {
            if (log.isTraceEnabled()) {
                LuceneIndexEditorContext.trackIndexSizeInfo(this.writer, this.definition, this.directory);
            }
            long start = PERF_LOGGER.start();
            Calendar lastUpdated = null;
            if (updateSuggestions) {
                lastUpdated = this.updateSuggester(this.writer.getAnalyzer());
                PERF_LOGGER.end(start, -1L, "Completed suggester for directory {}", (Object)this.definition);
            }
            if (lastUpdated == null) {
                lastUpdated = LuceneIndexEditorContext.getCalendar();
            }
            this.writer.close();
            PERF_LOGGER.end(start, -1L, "Closed writer for directory {}", (Object)this.definition);
            this.directory.close();
            PERF_LOGGER.end(start, -1L, "Closed directory for directory {}", (Object)this.definition);
            NodeBuilder status = this.definitionBuilder.child(":status");
            status.setProperty("lastUpdated", (Object)ISO8601.format((Calendar)lastUpdated), Type.DATE);
            status.setProperty("indexedNodes", (Object)this.indexedNodes);
            PERF_LOGGER.end(start, -1L, "Overall Closed IndexWriter for directory {}", (Object)this.definition);
            this.textExtractionStats.log(this.reindex);
            this.textExtractionStats.collectStats(this.extractedTextCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Calendar updateSuggester(Analyzer analyzer) throws IOException {
        Calendar ret = null;
        NodeBuilder suggesterStatus = this.definitionBuilder.child(":suggesterStatus");
        DirectoryReader reader = DirectoryReader.open(this.writer, false);
        OakDirectory suggestDirectory = new OakDirectory(this.definitionBuilder, ":suggest-data", this.definition, false);
        try {
            SuggestHelper.updateSuggester(suggestDirectory, analyzer, reader);
            ret = LuceneIndexEditorContext.getCalendar();
            suggesterStatus.setProperty("lastUpdated", (Object)ISO8601.format((Calendar)ret), Type.DATE);
        }
        catch (Throwable e) {
            log.warn("could not update suggester", e);
        }
        finally {
            suggestDirectory.close();
            reader.close();
        }
        return ret;
    }

    private boolean shouldUpdateSuggestions() {
        boolean updateSuggestions = false;
        if (this.definition.isSuggestEnabled()) {
            NodeBuilder suggesterStatus = this.definitionBuilder.child(":suggesterStatus");
            PropertyState suggesterLastUpdatedValue = suggesterStatus.getProperty("lastUpdated");
            if (suggesterLastUpdatedValue != null) {
                Calendar suggesterLastUpdatedTime = ISO8601.parse((String)((String)suggesterLastUpdatedValue.getValue(Type.DATE)));
                int updateFrequency = this.definition.getSuggesterUpdateFrequencyMinutes();
                Calendar nextSuggestUpdateTime = (Calendar)suggesterLastUpdatedTime.clone();
                nextSuggestUpdateTime.add(12, updateFrequency);
                if (LuceneIndexEditorContext.getCalendar().after(nextSuggestUpdateTime)) {
                    updateSuggestions = this.writer != null || this.isIndexUpdatedAfter(suggesterLastUpdatedTime);
                }
            } else {
                updateSuggestions = true;
            }
        }
        return updateSuggestions;
    }

    private boolean isIndexUpdatedAfter(Calendar calendar) {
        NodeBuilder indexStats = this.definitionBuilder.child(":status");
        PropertyState indexLastUpdatedValue = indexStats.getProperty("lastUpdated");
        if (indexLastUpdatedValue != null) {
            Calendar indexLastUpdatedTime = ISO8601.parse((String)((String)indexLastUpdatedValue.getValue(Type.DATE)));
            return indexLastUpdatedTime.after(calendar);
        }
        return true;
    }

    static void setClock(Clock c) {
        Preconditions.checkNotNull((Object)c);
        clock = c;
    }

    private static Calendar getCalendar() {
        Calendar ret = Calendar.getInstance();
        ret.setTime(clock.getDate());
        return ret;
    }

    public void enableReindexMode() {
        this.reindex = true;
        IndexFormatVersion version = IndexDefinition.determineVersionForFreshIndex(this.definitionBuilder);
        this.definitionBuilder.setProperty(":version", (Object)version.getVersion());
        this.definition = new IndexDefinition(this.root, this.definitionBuilder);
    }

    public long incIndexedNodes() {
        ++this.indexedNodes;
        return this.indexedNodes;
    }

    public long getIndexedNodes() {
        return this.indexedNodes;
    }

    public boolean isSupportedMediaType(String type) {
        if (this.supportedMediaTypes == null) {
            this.supportedMediaTypes = this.getParser().getSupportedTypes(new ParseContext());
        }
        return this.supportedMediaTypes.contains(MediaType.parse((String)type));
    }

    void indexUpdate() throws CommitFailedException {
        this.updateCallback.indexUpdate();
    }

    public IndexDefinition getDefinition() {
        return this.definition;
    }

    FacetsConfig getFacetsConfig() {
        return this.facetsConfig;
    }

    @Deprecated
    public void recordTextExtractionStats(long timeInMillis, long bytesRead) {
        this.recordTextExtractionStats(timeInMillis, bytesRead, 0);
    }

    public void recordTextExtractionStats(long timeInMillis, long bytesRead, int textLength) {
        this.textExtractionStats.addStats(timeInMillis, bytesRead, textLength);
    }

    ExtractedTextCache getExtractedTextCache() {
        return this.extractedTextCache;
    }

    IndexAugmentorFactory getAugmentorFactory() {
        return this.augmentorFactory;
    }

    public boolean isReindex() {
        return this.reindex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Parser initializeTikaParser(IndexDefinition definition) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            if (definition.hasCustomTikaConfig()) {
                AutoDetectParser autoDetectParser;
                Thread.currentThread().setContextClassLoader(LuceneIndexEditorContext.class.getClassLoader());
                InputStream is = definition.getTikaConfig();
                try {
                    autoDetectParser = new AutoDetectParser(LuceneIndexEditorContext.getTikaConfig(is, definition));
                }
                catch (Throwable throwable) {
                    org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                    throw throwable;
                }
                org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                return autoDetectParser;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
        return defaultParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AutoDetectParser createDefaultParser() {
        block5: {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            URL configUrl = LuceneIndexEditorContext.class.getResource("tika-config.xml");
            InputStream is = null;
            if (configUrl != null) {
                AutoDetectParser autoDetectParser;
                try {
                    Thread.currentThread().setContextClassLoader(LuceneIndexEditorContext.class.getClassLoader());
                    is = configUrl.openStream();
                    TikaConfig config = new TikaConfig(is);
                    log.info("Loaded default Tika Config from classpath {}", (Object)configUrl);
                    autoDetectParser = new AutoDetectParser(config);
                }
                catch (Exception e) {
                    try {
                        log.warn("Tika configuration not available : " + configUrl, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        org.apache.commons.io.IOUtils.closeQuietly(is);
                        Thread.currentThread().setContextClassLoader(current);
                        throw throwable;
                    }
                    org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                    Thread.currentThread().setContextClassLoader(current);
                    break block5;
                }
                org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                Thread.currentThread().setContextClassLoader(current);
                return autoDetectParser;
            }
            log.warn("Default Tika configuration not found from {}", (Object)configUrl);
        }
        return new AutoDetectParser();
    }

    private static TikaConfig getTikaConfig(InputStream configStream, Object source) {
        try {
            return new TikaConfig(configStream);
        }
        catch (Exception e) {
            log.warn("Tika configuration not available : " + source, (Throwable)e);
            return TikaConfig.getDefaultConfig();
        }
    }

    static class TextExtractionStats {
        private static final long LOGGING_THRESHOLD = TimeUnit.MINUTES.toMillis(1L);
        private int count;
        private long totalBytesRead;
        private long totalTime;
        private long totalTextLength;

        TextExtractionStats() {
        }

        public void addStats(long timeInMillis, long bytesRead, int textLength) {
            ++this.count;
            this.totalBytesRead += bytesRead;
            this.totalTime += timeInMillis;
            this.totalTextLength += (long)textLength;
        }

        public void log(boolean reindex) {
            if (log.isDebugEnabled()) {
                log.debug("Text extraction stats {}", (Object)this);
            } else if (this.anyParsingDone() && (reindex || this.isTakingLotsOfTime())) {
                log.info("Text extraction stats {}", (Object)this);
            }
        }

        public void collectStats(ExtractedTextCache cache) {
            cache.addStats(this.count, this.totalTime, this.totalBytesRead, this.totalTextLength);
        }

        private boolean isTakingLotsOfTime() {
            return this.totalTime > LOGGING_THRESHOLD;
        }

        private boolean anyParsingDone() {
            return this.count > 0;
        }

        public String toString() {
            return String.format(" %d (Time Taken %s, Bytes Read %s, Extracted text size %s)", this.count, TextExtractionStats.timeInWords(this.totalTime), IOUtils.humanReadableByteCount((long)this.totalBytesRead), IOUtils.humanReadableByteCount((long)this.totalTextLength));
        }

        private static String timeInWords(long millis) {
            return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        }
    }
}

