/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class LuceneIndexEditorProvider
implements IndexEditorProvider {
    private final IndexCopier indexCopier;
    private final ExtractedTextCache extractedTextCache;
    private final IndexAugmentorFactory augmentorFactory;

    public LuceneIndexEditorProvider() {
        this(null);
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier) {
        this(indexCopier, new ExtractedTextCache(0L, 0L));
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier, ExtractedTextCache extractedTextCache) {
        this(indexCopier, extractedTextCache, null);
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier, ExtractedTextCache extractedTextCache, IndexAugmentorFactory augmentorFactory) {
        this.indexCopier = indexCopier;
        this.extractedTextCache = extractedTextCache;
        this.augmentorFactory = augmentorFactory;
    }

    public Editor getIndexEditor(@Nonnull String type, @Nonnull NodeBuilder definition, @Nonnull NodeState root, @Nonnull IndexUpdateCallback callback) throws CommitFailedException {
        if ("lucene".equals(type)) {
            return new LuceneIndexEditor(root, definition, callback, this.indexCopier, this.extractedTextCache, this.augmentorFactory);
        }
        return null;
    }

    IndexCopier getIndexCopier() {
        return this.indexCopier;
    }

    ExtractedTextCache getExtractedTextCache() {
        return this.extractedTextCache;
    }
}

