/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class LuceneIndexLookup {
    private final NodeState root;

    public LuceneIndexLookup(NodeState root) {
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOldFullTextIndexPath(Filter filter, IndexTracker tracker) {
        Collection<String> indexPaths = this.collectIndexNodePaths(filter, false);
        IndexNode indexNode = null;
        for (String path : indexPaths) {
            try {
                indexNode = tracker.acquireIndexNode(path);
                if (indexNode == null || !indexNode.getDefinition().isFullTextEnabled() || indexNode.getDefinition().getVersion() != IndexFormatVersion.V1) continue;
                String string = path;
                return string;
            }
            finally {
                if (indexNode == null) continue;
                indexNode.release();
            }
        }
        return null;
    }

    public Collection<String> collectIndexNodePaths(Filter filter) {
        return this.collectIndexNodePaths(filter, true);
    }

    private Collection<String> collectIndexNodePaths(Filter filter, boolean recurse) {
        HashSet paths = Sets.newHashSet();
        LuceneIndexLookup.collectIndexNodePaths(this.root, "/", paths);
        if (recurse) {
            StringBuilder sb = new StringBuilder();
            NodeState nodeState = this.root;
            for (String element : PathUtils.elements((String)filter.getPath())) {
                nodeState = nodeState.getChildNode(element);
                LuceneIndexLookup.collectIndexNodePaths(nodeState, sb.append("/").append(element).toString(), paths);
            }
        }
        return paths;
    }

    private static void collectIndexNodePaths(NodeState nodeState, String parentPath, Collection<String> paths) {
        NodeState state = nodeState.getChildNode("oak:index");
        for (ChildNodeEntry entry : state.getChildNodeEntries()) {
            if (!LuceneIndexHelper.isLuceneIndexNode(entry.getNodeState())) continue;
            paths.add(LuceneIndexLookup.createIndexNodePath(parentPath, entry.getName()));
        }
    }

    private static String createIndexNodePath(String parentPath, String name) {
        return PathUtils.concat((String)parentPath, (String[])new String[]{"oak:index", name});
    }
}

