/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.remote.RemoteResult;
import org.apache.jackrabbit.oak.remote.RemoteValue;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteBinaries;
import org.apache.jackrabbit.util.ISO8601;

class ContentRemoteResult
implements RemoteResult {
    private final ContentRemoteBinaries binaries;
    private final ResultRow row;

    public ContentRemoteResult(ContentRemoteBinaries binaries, ResultRow row) {
        this.binaries = binaries;
        this.row = row;
    }

    @Override
    public RemoteValue getColumnValue(String column) {
        return this.toRemoteValue(this.row.getValue(column));
    }

    private RemoteValue toRemoteValue(PropertyValue value) {
        if (value == null) {
            return null;
        }
        Type type = value.getType();
        if (type.isArray()) {
            return this.toMultiRemoteValue(value);
        }
        return this.toSingleRemoteValue(value);
    }

    private RemoteValue toSingleRemoteValue(PropertyValue value) {
        Type type = value.getType();
        switch (type.tag()) {
            case 1: {
                return RemoteValue.toText((String)value.getValue(Type.STRING));
            }
            case 2: {
                return RemoteValue.toBinaryId(this.binaries.put((Blob)value.getValue(Type.BINARY)));
            }
            case 3: {
                return RemoteValue.toLong((Long)value.getValue(Type.LONG));
            }
            case 4: {
                return RemoteValue.toDouble((Double)value.getValue(Type.DOUBLE));
            }
            case 5: {
                return RemoteValue.toDate(ISO8601.parse((String)((String)value.getValue(Type.DATE))).getTimeInMillis());
            }
            case 6: {
                return RemoteValue.toBoolean((Boolean)value.getValue(Type.BOOLEAN));
            }
            case 7: {
                return RemoteValue.toName((String)value.getValue(Type.NAME));
            }
            case 8: {
                return RemoteValue.toPath((String)value.getValue(Type.PATH));
            }
            case 9: {
                return RemoteValue.toReference((String)value.getValue(Type.REFERENCE));
            }
            case 10: {
                return RemoteValue.toWeakReference((String)value.getValue(Type.WEAKREFERENCE));
            }
            case 11: {
                return RemoteValue.toUri((String)value.getValue(Type.URI));
            }
            case 12: {
                return RemoteValue.toDecimal((BigDecimal)value.getValue(Type.DECIMAL));
            }
        }
        throw new IllegalStateException("type not supported");
    }

    private RemoteValue toMultiRemoteValue(PropertyValue value) {
        Type type = value.getType();
        switch (type.tag()) {
            case 1: {
                return RemoteValue.toMultiText((Iterable)value.getValue(Type.STRINGS));
            }
            case 2: {
                return RemoteValue.toMultiBinaryId(this.readBinaryValues(value));
            }
            case 3: {
                return RemoteValue.toMultiLong((Iterable)value.getValue(Type.LONGS));
            }
            case 4: {
                return RemoteValue.toMultiDouble((Iterable)value.getValue(Type.DOUBLES));
            }
            case 5: {
                return RemoteValue.toMultiDate(this.readDateValues(value));
            }
            case 6: {
                return RemoteValue.toMultiBoolean((Iterable)value.getValue(Type.BOOLEANS));
            }
            case 7: {
                return RemoteValue.toMultiName((Iterable)value.getValue(Type.NAMES));
            }
            case 8: {
                return RemoteValue.toMultiPath((Iterable)value.getValue(Type.PATHS));
            }
            case 9: {
                return RemoteValue.toMultiReference((Iterable)value.getValue(Type.REFERENCES));
            }
            case 10: {
                return RemoteValue.toMultiWeakReference((Iterable)value.getValue(Type.WEAKREFERENCES));
            }
            case 11: {
                return RemoteValue.toMultiUri((Iterable)value.getValue(Type.URIS));
            }
            case 12: {
                return RemoteValue.toMultiDecimal((Iterable)value.getValue(Type.DECIMALS));
            }
        }
        throw new IllegalStateException("type not supported");
    }

    private Iterable<String> readBinaryValues(PropertyValue value) {
        ArrayList result = Lists.newArrayList();
        for (Blob blob : (Iterable)value.getValue(Type.BINARIES)) {
            result.add(this.binaries.put(blob));
        }
        return result;
    }

    private Iterable<Long> readDateValues(PropertyValue value) {
        ArrayList result = Lists.newArrayList();
        for (String string : (Iterable)value.getValue(Type.DATES)) {
            result.add(ISO8601.parse((String)string).getTimeInMillis());
        }
        return result;
    }

    @Override
    public String getSelectorPath(String selector) {
        return this.row.getPath(selector);
    }
}

