/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.Root;

class ContentRemoteRevisions {
    private Map<Key, Root> roots = Maps.newHashMap();

    private Key key(AuthInfo authInfo, String revisionId) {
        return new Key(authInfo, revisionId);
    }

    public Root get(AuthInfo authInfo, String revisionId) {
        return this.roots.get(this.key(authInfo, revisionId));
    }

    public String put(AuthInfo authInfo, Root root) {
        String revisionId = UUID.randomUUID().toString();
        this.roots.put(this.key(authInfo, revisionId), root);
        return revisionId;
    }

    private class Key {
        private final String revisionId;
        private final Set<Principal> principals;
        private final String user;

        private Key(AuthInfo authInfo, String revisionId) {
            this.user = authInfo.getUserID();
            this.principals = authInfo.getPrincipals();
            this.revisionId = revisionId;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Key other = (Key)object;
            if (!Objects.equal((Object)this.revisionId, (Object)other.revisionId)) {
                return false;
            }
            if (!Objects.equal((Object)this.user, (Object)other.user)) {
                return false;
            }
            return Objects.equal(this.principals, other.principals);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.revisionId, this.user, this.principals});
        }
    }
}

