/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.remote.RemoteCommitException;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MoveContentRemoteOperation
implements ContentRemoteOperation {
    private static final Logger logger = LoggerFactory.getLogger(MoveContentRemoteOperation.class);
    private final String source;
    private final String target;

    public MoveContentRemoteOperation(String source, String target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public void apply(Root root) throws RemoteCommitException {
        logger.debug("performing 'move' operation on source={}, target={}", (Object)this.source, (Object)this.target);
        boolean success = root.move(this.source, this.target);
        if (success) {
            return;
        }
        throw new RemoteCommitException("unable to move the tree");
    }
}

