/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.remote.RemoteCommitException;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoveContentRemoteOperation
implements ContentRemoteOperation {
    private static final Logger logger = LoggerFactory.getLogger(RemoveContentRemoteOperation.class);
    private final String path;

    public RemoveContentRemoteOperation(String path) {
        this.path = path;
    }

    @Override
    public void apply(Root root) throws RemoteCommitException {
        logger.debug("performing 'remove' operation on path={}", (Object)this.path);
        Tree tree = root.getTree(this.path);
        if (!tree.exists()) {
            throw new RemoteCommitException("tree does not exists");
        }
        if (!tree.remove()) {
            throw new RemoteCommitException("unable to remove the tree");
        }
    }
}

