/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.remote.RemoteRepository;
import org.apache.jackrabbit.oak.remote.http.RemoteHandler;
import org.apache.jackrabbit.oak.remote.http.handler.Handler;
import org.apache.jackrabbit.oak.remote.http.handler.Handlers;
import org.apache.jackrabbit.oak.remote.http.matcher.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(RemoteServlet.class);
    private final RemoteRepository repository;

    public RemoteServlet(RemoteRepository repository) {
        this.repository = repository;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("repository", (Object)this.repository);
        try {
            this.firstMatching(this.readHandlers(), request, Handlers.createNotFoundHandler()).handle(request, response);
        }
        catch (ServletException e) {
            logger.error("unable to serve the current request", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error("I/O error while serving the current request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("unexpected error while serving the current request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private Handler firstMatching(Iterable<RemoteHandler> handlers, HttpServletRequest request, Handler otherwise) {
        for (RemoteHandler handler : handlers) {
            if (!handler.match(request)) continue;
            return handler;
        }
        return otherwise;
    }

    private Iterable<RemoteHandler> readHandlers() {
        return this.handlers(this.handler("get", "/revisions/last", Handlers.createGetLastRevisionHandler()), this.handler("get", "/revisions/last/tree/.*", Handlers.createGetLastTreeHandler()), this.handler("head", "/revisions/last/tree/.*", Handlers.createHeadLastTreeHandler()), this.handler("get", "/revisions/[^/]+/tree/.*", Handlers.createGetRevisionTreeHandler()), this.handler("head", "/revisions/[^/]+/tree/.*", Handlers.createHeadRevisionTreeHandler()), this.handler("head", "/binaries/.*", Handlers.createHeadBinaryHandler()), this.handler("get", "/binaries/.*", Handlers.createGetBinaryHandler()), this.handler("post", "/binaries", Handlers.createPostBinaryHandler()), this.handler("patch", "/revisions/last/tree", Handlers.createPatchLastRevisionHandler()), this.handler("patch", "/revisions/[^/]+/tree", Handlers.createPatchSpecificRevisionHandler()), this.handler("get", "/revisions/last/tree", Handlers.createSearchLastRevisionHandler()), this.handler("get", "/revisions/[^/]+/tree", Handlers.createSearchSpecificRevisionHandler()));
    }

    private Iterable<RemoteHandler> handlers(RemoteHandler ... handlers) {
        return Arrays.asList(handlers);
    }

    private RemoteHandler handler(String method, String path, Handler handler) {
        return new RemoteHandler(Matchers.matchesRequest(method, path), handler);
    }
}

