/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.remote.RemoteCredentials;
import org.apache.jackrabbit.oak.remote.RemoteLoginException;
import org.apache.jackrabbit.oak.remote.RemoteRepository;
import org.apache.jackrabbit.oak.remote.RemoteSession;
import org.apache.jackrabbit.oak.remote.http.handler.Handler;
import org.apache.jackrabbit.oak.remote.http.handler.ResponseUtils;
import org.apache.jackrabbit.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthenticationWrapperHandler
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationWrapperHandler.class);
    private final Handler authenticated;
    private final Handler notAuthenticated;

    public AuthenticationWrapperHandler(Handler authenticated, Handler notAuthenticated) {
        this.authenticated = authenticated;
        this.notAuthenticated = notAuthenticated;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RemoteSession session = (RemoteSession)request.getAttribute("session");
        if (session != null) {
            this.authenticated.handle(request, response);
            return;
        }
        RemoteRepository repository = (RemoteRepository)request.getAttribute("repository");
        if (repository == null) {
            ResponseUtils.sendInternalServerError(response, "repository not found");
            return;
        }
        RemoteCredentials credentials = this.extractCredentials(request, repository);
        if (credentials == null) {
            this.notAuthenticated.handle(request, response);
            return;
        }
        try {
            session = repository.login(credentials);
        }
        catch (RemoteLoginException e) {
            logger.warn("unable to authenticate to the repository", (Throwable)e);
            this.notAuthenticated.handle(request, response);
            return;
        }
        request.setAttribute("session", (Object)session);
        this.authenticated.handle(request, response);
    }

    private RemoteCredentials extractCredentials(HttpServletRequest request, RemoteRepository repository) {
        String decoded;
        String authorization = request.getHeader("Authorization");
        if (authorization == null) {
            return null;
        }
        String scheme = this.getScheme(authorization);
        if (!scheme.equalsIgnoreCase("basic")) {
            return null;
        }
        String token = this.getToken(authorization);
        if (token == null) {
            return null;
        }
        try {
            decoded = Base64.decode((String)token);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        String user = this.getUser(decoded);
        if (user == null) {
            return null;
        }
        String password = this.getPassword(decoded);
        if (password == null) {
            return null;
        }
        return repository.createBasicCredentials(user, password.toCharArray());
    }

    private String getScheme(String authorization) {
        int index = authorization.indexOf(32);
        if (index < 0) {
            return authorization;
        }
        return authorization.substring(0, index);
    }

    private String getToken(String authorization) {
        int index = authorization.indexOf(32);
        if (index < 0) {
            return null;
        }
        while (index < authorization.length() && authorization.charAt(index) == ' ') {
            ++index;
        }
        if (index < authorization.length()) {
            return authorization.substring(index);
        }
        return null;
    }

    private String getUser(String both) {
        int index = both.indexOf(58);
        if (index < 0) {
            return null;
        }
        return both.substring(0, index);
    }

    private String getPassword(String both) {
        int index = both.indexOf(58);
        if (index < 0) {
            return null;
        }
        if (index + 1 < both.length()) {
            return both.substring(index + 1);
        }
        return null;
    }
}

