/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import org.apache.jackrabbit.oak.remote.http.handler.AuthenticationWrapperHandler;
import org.apache.jackrabbit.oak.remote.http.handler.GetBinaryHandler;
import org.apache.jackrabbit.oak.remote.http.handler.GetLastRevisionHandler;
import org.apache.jackrabbit.oak.remote.http.handler.GetLastTreeHandler;
import org.apache.jackrabbit.oak.remote.http.handler.GetRevisionTreeHandler;
import org.apache.jackrabbit.oak.remote.http.handler.Handler;
import org.apache.jackrabbit.oak.remote.http.handler.HeadBinaryHandler;
import org.apache.jackrabbit.oak.remote.http.handler.HeadLastTreeHandler;
import org.apache.jackrabbit.oak.remote.http.handler.HeadRevisionTreeHandler;
import org.apache.jackrabbit.oak.remote.http.handler.NotFoundHandler;
import org.apache.jackrabbit.oak.remote.http.handler.PatchLastRevisionHandler;
import org.apache.jackrabbit.oak.remote.http.handler.PatchSpecificRevisionHandler;
import org.apache.jackrabbit.oak.remote.http.handler.PostBinaryHandler;
import org.apache.jackrabbit.oak.remote.http.handler.SearchLastRevisionHandler;
import org.apache.jackrabbit.oak.remote.http.handler.SearchSpecificRevisionHandler;
import org.apache.jackrabbit.oak.remote.http.handler.UnauthorizedHandler;

public class Handlers {
    private Handlers() {
    }

    public static Handler createGetLastRevisionHandler() {
        return Handlers.withAuthentication(new GetLastRevisionHandler());
    }

    public static Handler createGetRevisionTreeHandler() {
        return Handlers.withAuthentication(new GetRevisionTreeHandler());
    }

    public static Handler createGetLastTreeHandler() {
        return Handlers.withAuthentication(new GetLastTreeHandler());
    }

    public static Handler createNotFoundHandler() {
        return new NotFoundHandler();
    }

    public static Handler createGetBinaryHandler() {
        return Handlers.withAuthentication(new GetBinaryHandler());
    }

    public static Handler createHeadBinaryHandler() {
        return Handlers.withAuthentication(new HeadBinaryHandler());
    }

    public static Handler createPostBinaryHandler() {
        return Handlers.withAuthentication(new PostBinaryHandler());
    }

    public static Handler createPatchSpecificRevisionHandler() {
        return Handlers.withAuthentication(new PatchSpecificRevisionHandler());
    }

    public static Handler createPatchLastRevisionHandler() {
        return Handlers.withAuthentication(new PatchLastRevisionHandler());
    }

    public static Handler createHeadLastTreeHandler() {
        return Handlers.withAuthentication(new HeadLastTreeHandler());
    }

    public static Handler createHeadRevisionTreeHandler() {
        return Handlers.withAuthentication(new HeadRevisionTreeHandler());
    }

    public static Handler createSearchLastRevisionHandler() {
        return Handlers.withAuthentication(new SearchLastRevisionHandler());
    }

    public static Handler createSearchSpecificRevisionHandler() {
        return Handlers.withAuthentication(new SearchSpecificRevisionHandler());
    }

    private static Handler withAuthentication(Handler authenticated) {
        return new AuthenticationWrapperHandler(authenticated, Handlers.createForbiddenHandler());
    }

    private static Handler createForbiddenHandler() {
        return new UnauthorizedHandler();
    }
}

