/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.remote.RemoteBinaryId;
import org.apache.jackrabbit.oak.remote.RemoteSession;
import org.apache.jackrabbit.oak.remote.http.handler.Handler;
import org.apache.jackrabbit.oak.remote.http.handler.ResponseUtils;

class HeadBinaryHandler
implements Handler {
    private static final Pattern REQUEST_PATTERN = Pattern.compile("^/binaries/(.*)$");

    HeadBinaryHandler() {
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RemoteSession session = (RemoteSession)request.getAttribute("session");
        if (session == null) {
            ResponseUtils.sendInternalServerError(response, "session not found");
            return;
        }
        String providedBinaryId = this.readBinaryId(request);
        if (providedBinaryId == null) {
            ResponseUtils.sendBadRequest(response, "unable to read the provided binary ID");
            return;
        }
        RemoteBinaryId binaryId = session.readBinaryId(providedBinaryId);
        if (binaryId == null) {
            ResponseUtils.sendNotFound(response, "binary ID not found");
            return;
        }
        response.setStatus(200);
        response.setHeader("Accept-Ranges", "bytes");
    }

    private String readBinaryId(HttpServletRequest request) {
        Matcher matcher = REQUEST_PATTERN.matcher(request.getPathInfo());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalStateException("handler bound at the wrong path");
    }
}

