/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

class ResponseUtils {
    private ResponseUtils() {
    }

    private static void send(HttpServletResponse response, int code, String message) throws IOException {
        ResponseUtils.send(response, code, new HashMap<String, String>(), message);
    }

    private static void send(HttpServletResponse response, int code, Map<String, String> headers, String message) throws IOException {
        response.setStatus(code);
        response.setContentType("application/json");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
        ServletOutputStream stream = response.getOutputStream();
        JsonGenerator generator = new JsonFactory().createJsonGenerator((OutputStream)stream, JsonEncoding.UTF8);
        generator.writeStartObject();
        generator.writeStringField("error", message);
        generator.writeEndObject();
        generator.flush();
        stream.close();
    }

    public static void sendBadRequest(HttpServletResponse response, String message) throws IOException {
        ResponseUtils.send(response, 400, message);
    }

    public static void sendInternalServerError(HttpServletResponse response, String message) throws IOException {
        ResponseUtils.send(response, 500, message);
    }

    public static void sendGone(HttpServletResponse response, String message) throws IOException {
        ResponseUtils.send(response, 410, message);
    }

    public static void sendNotFound(HttpServletResponse response, String message) throws IOException {
        ResponseUtils.send(response, 404, message);
    }

    public static void sendNotFound(HttpServletResponse response, Map<String, String> headers, String message) throws IOException {
        ResponseUtils.send(response, 404, headers, message);
    }

    public static void sendUnauthorized(HttpServletResponse response, String message) throws IOException {
        ResponseUtils.send(response, 401, message);
    }

    public static void sendUnauthorized(HttpServletResponse response, Map<String, String> headers, String message) throws IOException {
        ResponseUtils.send(response, 401, headers, message);
    }
}

