/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.matcher;

import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.remote.http.matcher.AllMatcher;
import org.apache.jackrabbit.oak.remote.http.matcher.Matcher;
import org.apache.jackrabbit.oak.remote.http.matcher.MethodMatcher;
import org.apache.jackrabbit.oak.remote.http.matcher.PathMatcher;

public class Matchers {
    private Matchers() {
    }

    public static Matcher matchesMethod(String method) {
        if (method == null) {
            throw new IllegalArgumentException("method not provided");
        }
        return new MethodMatcher(method);
    }

    public static Matcher matchesPath(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern not provided");
        }
        return new PathMatcher(Pattern.compile(pattern));
    }

    public static Matcher matchesAll(Matcher ... matchers) {
        if (matchers == null) {
            throw new IllegalArgumentException("matchers not provided");
        }
        for (Matcher matcher : matchers) {
            if (matcher != null) continue;
            throw new IllegalArgumentException("invalid matcher");
        }
        return new AllMatcher(matchers);
    }

    public static Matcher matchesRequest(String method, String path) {
        return Matchers.matchesAll(Matchers.matchesMethod(method), Matchers.matchesPath(path));
    }
}

