/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.store;

import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.standby.store.RemoteSegmentLoader;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandbyStore
implements SegmentStore {
    private static final Logger log = LoggerFactory.getLogger(StandbyStore.class);
    private final SegmentTracker tracker = new SegmentTracker((SegmentStore)this);
    private final SegmentStore delegate;
    private RemoteSegmentLoader loader;
    private long callId = 0L;
    private Map<Long, String> cacheStats;

    public StandbyStore(SegmentStore delegate) {
        this.delegate = delegate;
    }

    public SegmentTracker getTracker() {
        return this.tracker;
    }

    public SegmentNodeState getHead() {
        return this.delegate.getHead();
    }

    public boolean setHead(SegmentNodeState base, SegmentNodeState head) {
        return this.delegate.setHead(base, head);
    }

    public boolean containsSegment(SegmentId id) {
        return this.delegate.containsSegment(id);
    }

    public Segment readSegment(SegmentId sid) {
        ++this.callId;
        ArrayDeque<SegmentId> ids = new ArrayDeque<SegmentId>();
        ids.offer(sid);
        int err = 0;
        HashSet<SegmentId> persisted = new HashSet<SegmentId>();
        HashMap<SegmentId, Segment> cache = new HashMap<SegmentId, Segment>();
        long cacheOps = 0L;
        long cacheWeight = 0L;
        long maxWeight = 0L;
        long maxKeys = 0L;
        HashSet visited = Sets.newHashSet();
        while (!ids.isEmpty()) {
            SegmentId id = (SegmentId)ids.remove();
            visited.add(id);
            if (!persisted.contains(id) && !this.delegate.containsSegment(id)) {
                Segment s;
                boolean logRefs = true;
                if (cache.containsKey(id)) {
                    s = (Segment)cache.remove(id);
                    cacheWeight -= (long)s.size();
                    ++cacheOps;
                    logRefs = false;
                } else {
                    log.debug("transferring segment {}", (Object)id);
                    s = this.loader.readSegment(id.toString());
                }
                if (s != null) {
                    log.debug("processing segment {} with size {}", (Object)id, (Object)s.size());
                    if (id.isDataSegmentId()) {
                        boolean hasPendingRefs = false;
                        List refs = s.getReferencedIds();
                        if (logRefs) {
                            log.debug("{} -> {}", (Object)id, (Object)refs);
                        }
                        for (SegmentId nr : refs) {
                            if (persisted.contains(nr) || id.equals((Object)nr) || visited.contains(nr)) continue;
                            hasPendingRefs = true;
                            if (ids.contains(nr)) continue;
                            if (nr.isBulkSegmentId()) {
                                ids.addFirst(nr);
                                continue;
                            }
                            ids.add(nr);
                        }
                        if (!hasPendingRefs) {
                            persisted.add(id);
                            this.persist(id, s);
                        } else {
                            ids.add(id);
                            cache.put(id, s);
                            ++cacheOps;
                            maxWeight = Math.max(maxWeight, cacheWeight += (long)s.size());
                            maxKeys = Math.max(maxKeys, (long)cache.size());
                        }
                    } else {
                        persisted.add(id);
                        this.persist(id, s);
                    }
                    ids.removeAll(persisted);
                    err = 0;
                    continue;
                }
                log.error("could NOT read segment {}", (Object)id);
                if (this.loader.isClosed() || err == 4) {
                    this.loader.close();
                    throw new IllegalStateException("Unable to load remote segment " + id);
                }
                ++err;
                ids.addFirst(id);
                continue;
            }
            persisted.add(id);
        }
        this.cacheStats.put(this.callId, "W: " + IOUtils.humanReadableByteCount((long)maxWeight) + ", Keys: " + maxKeys + ", Ops: " + cacheOps);
        return this.delegate.readSegment(sid);
    }

    public void persist(SegmentId in, Segment s) {
        SegmentId id = this.delegate.getTracker().getSegmentId(in.getMostSignificantBits(), in.getLeastSignificantBits());
        log.debug("persisting segment {} with size {}", (Object)id, (Object)s.size());
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(s.size());
            s.writeTo((OutputStream)bout);
            this.writeSegment(id, bout.toByteArray(), 0, s.size());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write remote segment " + id, e);
        }
    }

    public void preSync(RemoteSegmentLoader loader) {
        this.loader = loader;
        this.cacheStats = new HashMap<Long, String>();
    }

    public void postSync() {
        this.loader = null;
        if (log.isDebugEnabled() && !this.cacheStats.isEmpty()) {
            log.debug("sync cache stats {}", this.cacheStats);
        }
        this.cacheStats = null;
    }

    public void writeSegment(SegmentId id, byte[] bytes, int offset, int length) throws IOException {
        this.delegate.writeSegment(id, bytes, offset, length);
    }

    public void close() {
        this.delegate.close();
    }

    public Blob readBlob(String reference) {
        return this.delegate.readBlob(reference);
    }

    public BlobStore getBlobStore() {
        return this.delegate.getBlobStore();
    }

    public void gc() {
        this.delegate.gc();
    }

    public long size() {
        if (this.delegate instanceof FileStore) {
            return ((FileStore)this.delegate).size();
        }
        return -1L;
    }

    public void cleanup() {
        if (this.delegate instanceof FileStore) {
            try {
                this.delegate.getTracker().getWriter().dropCache();
                ((FileStore)this.delegate).flush(true);
            }
            catch (IOException e) {
                log.error("Error running cleanup", (Throwable)e);
            }
        } else {
            log.warn("Delegate is not a FileStore, ignoring cleanup call");
        }
    }
}

