/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class ConfigurationEntry
implements Comparable<ConfigurationEntry> {
    private final String category;
    private final String description;
    private final String name;
    private final String value;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromConfigurationEntry(this);
    }

    @ConstructorProperties(value={"category", "description", "name", "value"})
    protected ConfigurationEntry(@Nullable String category, @Nullable String description, String name, @Nullable String value) {
        this.category = category;
        this.description = description;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.value = value;
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.category, this.description, this.name, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationEntry that = (ConfigurationEntry)ConfigurationEntry.class.cast(obj);
        return Objects.equal((Object)this.category, (Object)that.category) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.value, (Object)that.value);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("category", (Object)this.category).add("description", (Object)this.description).add("name", (Object)this.name).add("value", (Object)this.value);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(ConfigurationEntry other) {
        return this.name.compareTo(other.getName());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String category;
        protected String description;
        protected String name;
        protected String value;

        protected abstract T self();

        public T category(String category) {
            this.category = category;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T value(String value) {
            this.value = value;
            return this.self();
        }

        public ConfigurationEntry build() {
            return new ConfigurationEntry(this.category, this.description, this.name, this.value);
        }

        public T fromConfigurationEntry(ConfigurationEntry in) {
            return ((Builder)((Builder)((Builder)this.category(in.getCategory())).description(in.getDescription())).name(in.getName())).value(in.getValue());
        }
    }
}

