/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.javax.annotation.Nullable;

public class PortForwardingRule
implements Comparable<PortForwardingRule> {
    private final String id;
    private final String IPAddress;
    private final String IPAddressId;
    private final int privatePort;
    private final Protocol protocol;
    private final int publicPort;
    private final State state;
    private final String virtualMachineDisplayName;
    private final String virtualMachineId;
    private final String virtualMachineName;
    private final Set<String> CIDRs;
    private final int privateEndPort;
    private final int publicEndPort;
    private final Set<Tag> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromPortForwardingRule(this);
    }

    @ConstructorProperties(value={"id", "ipaddress", "ipaddressid", "privateport", "protocol", "publicport", "state", "virtualmachinedisplayname", "virtualmachineid", "virtualmachinename", "cidrlist", "privateendport", "publicendport", "tags"})
    private PortForwardingRule(String id, @Nullable String IPAddress, @Nullable String IPAddressId, int privatePort, @Nullable Protocol protocol, int publicPort, @Nullable State state, @Nullable String virtualMachineDisplayName, @Nullable String virtualMachineId, @Nullable String virtualMachineName, @Nullable String CIDRs, int privateEndPort, int publicEndPort, @Nullable Set<Tag> tags) {
        this(id, IPAddress, IPAddressId, privatePort, protocol, publicPort, state, virtualMachineDisplayName, virtualMachineId, virtualMachineName, PortForwardingRule.splitStringOnCommas(CIDRs), privateEndPort, publicEndPort, tags);
    }

    private static Set<String> splitStringOnCommas(String in) {
        return in == null ? ImmutableSet.of() : ImmutableSet.copyOf((Object[])in.split(","));
    }

    protected PortForwardingRule(String id, @Nullable String IPAddress, @Nullable String IPAddressId, int privatePort, @Nullable Protocol protocol, int publicPort, @Nullable State state, @Nullable String virtualMachineDisplayName, @Nullable String virtualMachineId, @Nullable String virtualMachineName, @Nullable Set<String> CIDRs, int privateEndPort, int publicEndPort, @Nullable Set<Tag> tags) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.IPAddress = IPAddress;
        this.IPAddressId = IPAddressId;
        this.privatePort = privatePort;
        this.protocol = protocol;
        this.publicPort = publicPort;
        this.state = state;
        this.virtualMachineDisplayName = virtualMachineDisplayName;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.CIDRs = CIDRs == null ? ImmutableSet.of() : ImmutableSet.copyOf(CIDRs);
        this.privateEndPort = privateEndPort;
        this.publicEndPort = publicEndPort;
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getIPAddress() {
        return this.IPAddress;
    }

    @Nullable
    public String getIPAddressId() {
        return this.IPAddressId;
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    @Nullable
    public Protocol getProtocol() {
        return this.protocol;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public String getVirtualMachineDisplayName() {
        return this.virtualMachineDisplayName;
    }

    @Nullable
    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    @Nullable
    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public Set<String> getCIDRs() {
        return this.CIDRs;
    }

    public int getPrivateEndPort() {
        return this.privateEndPort;
    }

    public int getPublicEndPort() {
        return this.publicEndPort;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.IPAddress, this.IPAddressId, this.privatePort, this.protocol, this.publicPort, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.CIDRs, this.privateEndPort, this.publicEndPort, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PortForwardingRule that = (PortForwardingRule)PortForwardingRule.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.IPAddress, (Object)that.IPAddress) && Objects.equal((Object)this.IPAddressId, (Object)that.IPAddressId) && Objects.equal((Object)this.privatePort, (Object)that.privatePort) && Objects.equal((Object)((Object)this.protocol), (Object)((Object)that.protocol)) && Objects.equal((Object)this.publicPort, (Object)that.publicPort) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.virtualMachineDisplayName, (Object)that.virtualMachineDisplayName) && Objects.equal((Object)this.virtualMachineId, (Object)that.virtualMachineId) && Objects.equal((Object)this.virtualMachineName, (Object)that.virtualMachineName) && Objects.equal(this.CIDRs, that.CIDRs) && Objects.equal((Object)this.privateEndPort, (Object)that.privateEndPort) && Objects.equal((Object)this.publicEndPort, (Object)that.publicEndPort) && Objects.equal(this.tags, that.tags);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("IPAddress", (Object)this.IPAddress).add("IPAddressId", (Object)this.IPAddressId).add("privatePort", this.privatePort).add("protocol", (Object)this.protocol).add("publicPort", this.publicPort).add("state", (Object)this.state).add("virtualMachineDisplayName", (Object)this.virtualMachineDisplayName).add("virtualMachineId", (Object)this.virtualMachineId).add("virtualMachineName", (Object)this.virtualMachineName).add("CIDRs", this.CIDRs).add("privateEndPort", this.privateEndPort).add("publicEndPort", this.publicEndPort).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(PortForwardingRule o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String IPAddress;
        protected String IPAddressId;
        protected int privatePort;
        protected Protocol protocol;
        protected int publicPort;
        protected State state;
        protected String virtualMachineDisplayName;
        protected String virtualMachineId;
        protected String virtualMachineName;
        protected Set<String> CIDRs = ImmutableSet.of();
        protected int privateEndPort;
        protected int publicEndPort;
        protected Set<Tag> tags = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this.self();
        }

        public T IPAddressId(String IPAddressId) {
            this.IPAddressId = IPAddressId;
            return this.self();
        }

        public T privatePort(int privatePort) {
            this.privatePort = privatePort;
            return this.self();
        }

        public T protocol(Protocol protocol) {
            this.protocol = protocol;
            return this.self();
        }

        public T publicPort(int publicPort) {
            this.publicPort = publicPort;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T virtualMachineDisplayName(String virtualMachineDisplayName) {
            this.virtualMachineDisplayName = virtualMachineDisplayName;
            return this.self();
        }

        public T virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this.self();
        }

        public T virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this.self();
        }

        public T CIDRs(Set<String> CIDRs) {
            this.CIDRs = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(CIDRs, (Object)"CIDRs")));
            return this.self();
        }

        public T CIDRs(String ... in) {
            return this.CIDRs((Set<String>)ImmutableSet.copyOf((Object[])in));
        }

        public T privateEndPort(int privateEndPort) {
            this.privateEndPort = privateEndPort;
            return this.self();
        }

        public T publicEndPort(int publicEndPort) {
            this.publicEndPort = publicEndPort;
            return this.self();
        }

        public T tags(Set<Tag> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this.self();
        }

        public T tags(Tag ... in) {
            return this.tags((Set<Tag>)ImmutableSet.copyOf((Object[])in));
        }

        public PortForwardingRule build() {
            return new PortForwardingRule(this.id, this.IPAddress, this.IPAddressId, this.privatePort, this.protocol, this.publicPort, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.CIDRs, this.privateEndPort, this.publicEndPort, this.tags);
        }

        public T fromPortForwardingRule(PortForwardingRule in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).IPAddress(in.getIPAddress())).IPAddressId(in.getIPAddressId())).privatePort(in.getPrivatePort())).protocol(in.getProtocol())).publicPort(in.getPublicPort())).state(in.getState())).virtualMachineDisplayName(in.getVirtualMachineDisplayName())).virtualMachineId(in.getVirtualMachineId())).virtualMachineName(in.getVirtualMachineName())).CIDRs(in.getCIDRs())).privateEndPort(in.getPrivateEndPort())).publicEndPort(in.getPublicEndPort())).tags(in.getTags());
        }
    }

    public static enum State {
        STAGED,
        ADD,
        ACTIVE,
        DELETING,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum Protocol {
        TCP,
        UDP,
        ICMP,
        UNKNOWN;


        public static Protocol fromValue(String value) {
            try {
                return Protocol.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

