/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.cloudwatch.domain.ComparisonOperator;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.cloudwatch.xml.DimensionHandler;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Beta
public class MetricAlarmHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Alarm> {
    protected final DateService dateService;
    protected final DimensionHandler dimensionHandler;
    private StringBuilder currentText = new StringBuilder();
    private Set<String> alarmActions = Sets.newLinkedHashSet();
    private Set<Dimension> dimensions = Sets.newLinkedHashSet();
    private Set<String> insufficientDataActions = Sets.newLinkedHashSet();
    private Set<String> okActions = Sets.newLinkedHashSet();
    private boolean inAlarmActions = false;
    private boolean inDimensions = false;
    private boolean inInsufficientDataActions = false;
    private boolean inOkActions = false;
    private boolean actionsEnabled;
    private String alarmARN;
    private Date alarmConfigurationUpdatedTimestamp;
    private String alarmDescription;
    private String alarmName;
    private ComparisonOperator comparisonOperator;
    private int evaluationPeriods;
    private String metricName;
    private String namespace;
    private int period;
    private String stateReason;
    private String stateReasonData;
    private Date stateUpdatedTimestamp;
    private Alarm.State state;
    private Statistics statistic;
    private double threshold;
    private Unit unit;

    @Inject
    public MetricAlarmHandler(DateService dateService, DimensionHandler dimensionHandler) {
        this.dateService = dateService;
        this.dimensionHandler = dimensionHandler;
    }

    public boolean shouldHandleMemberTag() {
        return this.inAlarmActions || this.inDimensions || this.inInsufficientDataActions || this.inOkActions;
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"AlarmActions")) {
            this.inAlarmActions = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Dimensions")) {
            this.inDimensions = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"InsufficientDataActions") || SaxUtils.equalsOrSuffix((String)qName, (String)"UnknownActions")) {
            this.inInsufficientDataActions = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"OKActions")) {
            this.inOkActions = true;
        }
        if (this.inDimensions) {
            this.dimensionHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (this.inAlarmActions) {
            if (qName.equals("AlarmActions")) {
                this.inAlarmActions = false;
            } else if (qName.equals("member")) {
                this.alarmActions.add(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            }
        } else if (this.inDimensions) {
            if (qName.equals("Dimensions")) {
                this.inDimensions = false;
            } else if (qName.equals("member")) {
                this.dimensions.add(this.dimensionHandler.getResult());
            } else {
                this.dimensionHandler.endElement(uri, name, qName);
            }
        } else if (this.inInsufficientDataActions) {
            if (qName.equals("InsufficientDataActions") || qName.equals("UnknownActions")) {
                this.inInsufficientDataActions = false;
            } else if (qName.equals("member")) {
                this.insufficientDataActions.add(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            }
        } else if (this.inOkActions) {
            if (qName.equals("OKActions")) {
                this.inOkActions = false;
            } else if (qName.equals("member")) {
                this.okActions.add(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            }
        } else if (qName.equals("ActionsEnabled")) {
            this.actionsEnabled = Boolean.valueOf(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("AlarmArn")) {
            this.alarmARN = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("AlarmConfigurationUpdatedTimestamp")) {
            this.alarmConfigurationUpdatedTimestamp = this.dateService.iso8601DateParse(this.currentText.toString().trim());
        } else if (qName.equals("AlarmDescription")) {
            this.alarmDescription = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("AlarmName")) {
            this.alarmName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("ComparisonOperator")) {
            this.comparisonOperator = ComparisonOperator.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("EvaluationPeriods")) {
            this.evaluationPeriods = Integer.parseInt(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("MetricName")) {
            this.metricName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Namespace")) {
            this.namespace = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Period")) {
            this.period = Integer.parseInt(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("StateReason")) {
            this.stateReason = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("StateReasonData")) {
            String rawJson = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (rawJson != null) {
                this.stateReasonData = rawJson.trim();
            }
        } else if (qName.equals("StateUpdatedTimestamp")) {
            this.stateUpdatedTimestamp = this.dateService.iso8601DateParse(this.currentText.toString().trim());
        } else if (qName.equals("StateValue")) {
            this.state = Alarm.State.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Statistic")) {
            this.statistic = Statistics.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Threshold")) {
            this.threshold = Double.valueOf(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Unit")) {
            this.unit = Unit.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inDimensions) {
            this.dimensionHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }

    public Alarm getResult() {
        Alarm result = new Alarm(this.actionsEnabled, this.alarmActions, this.alarmARN, this.alarmConfigurationUpdatedTimestamp, this.alarmDescription, this.alarmName, this.comparisonOperator, this.dimensions, this.evaluationPeriods, this.insufficientDataActions, this.metricName, this.namespace, this.okActions, this.period, this.stateReason, (Optional<String>)Optional.fromNullable((Object)this.stateReasonData), this.stateUpdatedTimestamp, this.state, this.statistic, this.threshold, (Optional<Unit>)Optional.fromNullable((Object)((Object)this.unit)));
        this.actionsEnabled = false;
        this.alarmActions = Sets.newLinkedHashSet();
        this.alarmARN = null;
        this.alarmConfigurationUpdatedTimestamp = null;
        this.alarmDescription = null;
        this.alarmName = null;
        this.comparisonOperator = null;
        this.dimensions = Sets.newLinkedHashSet();
        this.evaluationPeriods = 0;
        this.insufficientDataActions = Sets.newLinkedHashSet();
        this.metricName = null;
        this.namespace = null;
        this.okActions = Sets.newLinkedHashSet();
        this.period = 0;
        this.stateReason = null;
        this.stateReasonData = null;
        this.stateUpdatedTimestamp = null;
        this.state = null;
        this.statistic = null;
        this.threshold = 0.0;
        this.unit = null;
        return result;
    }
}

