/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.glacier.domain.PartMetadata;
import org.jclouds.glacier.options.PaginationOptions;
import org.jclouds.javax.annotation.Nullable;

public class MultipartUploadMetadata
extends IterableWithMarker<PartMetadata>
implements Comparable<MultipartUploadMetadata> {
    @SerializedName(value="ArchiveDescription")
    private final String archiveDescription;
    @SerializedName(value="CreationDate")
    private final Date creationDate;
    @SerializedName(value="MultipartUploadId")
    private final String multipartUploadId;
    @SerializedName(value="PartSizeInBytes")
    private final long partSizeInBytes;
    @SerializedName(value="VaultARN")
    private final String vaultARN;
    @SerializedName(value="Parts")
    private final Iterable<PartMetadata> parts;
    @SerializedName(value="Marker")
    private final String marker;

    @ConstructorProperties(value={"ArchiveDescription", "CreationDate", "MultipartUploadId", "PartSizeInBytes", "VaultARN", "Parts", "Marker"})
    public MultipartUploadMetadata(@Nullable String archiveDescription, Date creationDate, String multipartUploadId, long partSizeInBytes, String vaultARN, @Nullable Iterable<PartMetadata> parts, @Nullable String marker) {
        this.archiveDescription = archiveDescription;
        this.creationDate = (Date)((Date)Preconditions.checkNotNull((Object)creationDate, (Object)"creationDate")).clone();
        this.multipartUploadId = (String)Preconditions.checkNotNull((Object)multipartUploadId, (Object)"multipartUploadId");
        this.partSizeInBytes = partSizeInBytes;
        this.vaultARN = (String)Preconditions.checkNotNull((Object)vaultARN, (Object)"vaultARN");
        this.parts = parts;
        this.marker = marker;
    }

    public String getArchiveDescription() {
        return this.archiveDescription;
    }

    public Date getCreationDate() {
        return (Date)this.creationDate.clone();
    }

    public String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    public long getPartSizeInBytes() {
        return this.partSizeInBytes;
    }

    public long getPartSizeInMB() {
        return this.partSizeInBytes >> 20;
    }

    public String getVaultARN() {
        return this.vaultARN;
    }

    public Iterator<PartMetadata> iterator() {
        return this.parts == null ? null : this.parts.iterator();
    }

    public Optional<Object> nextMarker() {
        return Optional.fromNullable((Object)this.marker);
    }

    public PaginationOptions nextPaginationOptions() {
        return (PaginationOptions)((Object)PaginationOptions.class.cast(this.nextMarker().get()));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.archiveDescription, this.creationDate, this.multipartUploadId, this.partSizeInBytes, this.vaultARN, this.marker, this.parts});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultipartUploadMetadata other = (MultipartUploadMetadata)obj;
        return Objects.equal((Object)this.archiveDescription, (Object)other.archiveDescription) && Objects.equal((Object)this.creationDate, (Object)other.creationDate) && Objects.equal((Object)this.multipartUploadId, (Object)other.multipartUploadId) && Objects.equal((Object)this.partSizeInBytes, (Object)other.partSizeInBytes) && Objects.equal((Object)this.vaultARN, (Object)other.vaultARN) && Objects.equal((Object)this.marker, (Object)other.marker) && Objects.equal(this.parts, other.parts);
    }

    public String toString() {
        return "MultipartUploadMetadata [archiveDescription=" + this.archiveDescription + ", creationDate=" + this.creationDate + ", multipartUploadId=" + this.multipartUploadId + ", partSizeInBytes=" + this.partSizeInBytes + ", vaultARN=" + this.vaultARN + ", marker=" + this.marker + ", parts=" + this.parts + "]";
    }

    @Override
    public int compareTo(MultipartUploadMetadata o) {
        return ComparisonChain.start().compare((Comparable)this.creationDate, (Comparable)o.creationDate).result();
    }
}

