/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.glacier.domain.JobMetadata;
import org.jclouds.glacier.options.PaginationOptions;

public class PaginatedJobCollection
extends IterableWithMarker<JobMetadata> {
    @SerializedName(value="JobList")
    private final Iterable<JobMetadata> jobs;
    @SerializedName(value="Marker")
    private final String marker;

    @ConstructorProperties(value={"JobList", "Marker"})
    public PaginatedJobCollection(Iterable<JobMetadata> jobs, String marker) {
        this.jobs = (Iterable)Preconditions.checkNotNull(jobs, (Object)"jobs");
        this.marker = marker;
    }

    public Iterator<JobMetadata> iterator() {
        return this.jobs.iterator();
    }

    public Optional<Object> nextMarker() {
        return Optional.fromNullable((Object)this.marker);
    }

    public PaginationOptions nextPaginationOptions() {
        return (PaginationOptions)((Object)PaginationOptions.class.cast(this.nextMarker().get()));
    }
}

