/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;

@Extension(of="identity", namespace="http://docs.openstack.org/identity/api/ext/OS-KSADM/v1.0", name="OpenStack Keystone Admin", alias="OS-KSADM")
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="OS-KSADM/roles")
@Beta
public interface RoleAdminApi {
    @Named(value="role:list")
    @GET
    @SelectJson(value={"roles"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<? extends Role> list();

    @Named(value="role:create")
    @POST
    @SelectJson(value={"role"})
    @Produces(value={"application/json"})
    @WrapWith(value="role")
    @Nullable
    public Role create(@PayloadParam(value="name") String var1);

    @Named(value="role:get")
    @GET
    @SelectJson(value={"role"})
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Role get(@PathParam(value="id") String var1);

    @Named(value="role:delete")
    @DELETE
    @Path(value="/{id}")
    @Consumes
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

