/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.openstack.v2_0.domain.Limit;

public final class RateLimit {
    private final String uri;
    private final String regex;
    @Named(value="limit")
    private final Iterable<Limit> limits;

    @ConstructorProperties(value={"uri", "regex", "limit"})
    private RateLimit(String uri, String regex, Iterable<Limit> limits) {
        this.uri = (String)Preconditions.checkNotNull((Object)uri, (Object)"uri");
        this.regex = (String)Preconditions.checkNotNull((Object)regex, (Object)"regex");
        this.limits = (Iterable)Preconditions.checkNotNull(limits, (Object)"limit");
    }

    public String getUri() {
        return this.uri;
    }

    public String getRegex() {
        return this.regex;
    }

    public Iterable<Limit> getLimits() {
        return this.limits;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uri});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RateLimit that = (RateLimit)RateLimit.class.cast(obj);
        return Objects.equal((Object)this.uri, (Object)that.uri);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("uri", (Object)this.uri).add("regex", (Object)this.regex).add("limits", this.limits).toString();
    }
}

