/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.handlers;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.fallbacks.HeaderToRetryAfterException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.functions.OverLimitParser;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class NovaErrorHandler
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final HeaderToRetryAfterException retryAfterParser;
    protected final OverLimitParser overLimitParser;

    protected NovaErrorHandler(HeaderToRetryAfterException retryAfterParser, OverLimitParser overLimitParser) {
        this.retryAfterParser = (HeaderToRetryAfterException)Preconditions.checkNotNull((Object)retryAfterParser, (Object)"retryAfterParser");
        this.overLimitParser = (OverLimitParser)Preconditions.checkNotNull((Object)overLimitParser, (Object)"overLimitParser");
    }

    @Inject
    public NovaErrorHandler(DateCodecFactory factory, OverLimitParser overLimitParser) {
        this(HeaderToRetryAfterException.create((Ticker)Ticker.systemTicker(), (DateCodec)factory.iso8601Seconds()), overLimitParser);
    }

    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
        String content = data != null ? Strings.emptyToNull((String)new String(data)) : null;
        Object exception = content != null ? new HttpResponseException(command, response, content) : new HttpResponseException(command, response);
        String requestLine = command.getCurrentRequest().getRequestLine();
        String message = content != null ? content : String.format("%s -> %s", requestLine, response.getStatusLine());
        switch (response.getStatusCode()) {
            case 400: {
                if (message.indexOf("quota exceeded") != -1) {
                    exception = new InsufficientResourcesException(message, (Throwable)exception);
                    break;
                }
                if (message.indexOf("has no fixed_ips") != -1) {
                    exception = new IllegalStateException(message, (Throwable)exception);
                    break;
                }
                if (message.indexOf("already exists") == -1) break;
                exception = new IllegalStateException(message, (Throwable)exception);
                break;
            }
            case 401: 
            case 403: {
                exception = new AuthorizationException(message, (Throwable)exception);
                break;
            }
            case 404: {
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                exception = new ResourceNotFoundException(message, (Throwable)exception);
                break;
            }
            case 500: {
                if (!command.getCurrentRequest().getMethod().equals("POST") || message.indexOf("The server has either erred or is incapable of performing the requested operation.") == -1 || command.getCurrentRequest().getEndpoint().getPath().indexOf("os-floating-ips") == -1) break;
                exception = new InsufficientResourcesException(message, (Throwable)exception);
                break;
            }
            case 413: {
                exception = content == null ? new InsufficientResourcesException(message, (Throwable)exception) : this.parseAndBuildRetryException(content, message, (Exception)exception);
            }
        }
        command.setException((Exception)exception);
    }

    private Exception parseAndBuildRetryException(String json, String message, Exception exception) {
        ImmutableSet retryFields = ImmutableSet.of((Object)"retryAfter", (Object)"retryAt");
        for (String value : Maps.filterKeys(this.overLimitParser.apply(json), (Predicate)Predicates.in((Collection)retryFields)).values()) {
            Optional retryException = this.retryAfterParser.tryCreateRetryAfterException((Throwable)exception, value);
            if (!retryException.isPresent()) continue;
            return (Exception)retryException.get();
        }
        return new InsufficientResourcesException(message, (Throwable)exception);
    }
}

