/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore.config;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingObject;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import javax.inject.Inject;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedBlobStoreContext;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedSwiftBlobStore;

public class SwiftBlobStoreContextModule
extends AbstractModule {
    protected void configure() {
        this.bind(ConsistencyModel.class).toInstance((Object)ConsistencyModel.EVENTUAL);
        this.bind(BlobStoreContext.class).to(RegionScopedBlobStoreContext.class);
        this.install(new FactoryModuleBuilder().build(Factory.class));
    }

    @Provides
    final Function<String, BlobStore> blobStore(FactoryFunction in) {
        return in;
    }

    static class FactoryFunction
    extends ForwardingObject
    implements Function<String, BlobStore> {
        @Inject
        Factory delegate;

        FactoryFunction() {
        }

        protected Factory delegate() {
            return this.delegate;
        }

        public BlobStore apply(String in) {
            return this.delegate.create(in);
        }
    }

    static interface Factory {
        public RegionScopedSwiftBlobStore create(String var1);
    }
}

